/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.partnercentralchannel.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Configuration for resold business support plans.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ResoldBusiness implements SdkPojo, Serializable, ToCopyableBuilder<ResoldBusiness.Builder, ResoldBusiness> {
    private static final SdkField<String> COVERAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("coverage").getter(getter(ResoldBusiness::coverageAsString)).setter(setter(Builder::coverage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("coverage").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COVERAGE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String coverage;

    private ResoldBusiness(BuilderImpl builder) {
        this.coverage = builder.coverage;
    }

    /**
     * <p>
     * The coverage level for resold business support.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #coverage} will
     * return {@link Coverage#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #coverageAsString}.
     * </p>
     * 
     * @return The coverage level for resold business support.
     * @see Coverage
     */
    public final Coverage coverage() {
        return Coverage.fromValue(coverage);
    }

    /**
     * <p>
     * The coverage level for resold business support.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #coverage} will
     * return {@link Coverage#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #coverageAsString}.
     * </p>
     * 
     * @return The coverage level for resold business support.
     * @see Coverage
     */
    public final String coverageAsString() {
        return coverage;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(coverageAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResoldBusiness)) {
            return false;
        }
        ResoldBusiness other = (ResoldBusiness) obj;
        return Objects.equals(coverageAsString(), other.coverageAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ResoldBusiness").add("Coverage", coverageAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "coverage":
            return Optional.ofNullable(clazz.cast(coverageAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("coverage", COVERAGE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ResoldBusiness, T> g) {
        return obj -> g.apply((ResoldBusiness) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ResoldBusiness> {
        /**
         * <p>
         * The coverage level for resold business support.
         * </p>
         * 
         * @param coverage
         *        The coverage level for resold business support.
         * @see Coverage
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Coverage
         */
        Builder coverage(String coverage);

        /**
         * <p>
         * The coverage level for resold business support.
         * </p>
         * 
         * @param coverage
         *        The coverage level for resold business support.
         * @see Coverage
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Coverage
         */
        Builder coverage(Coverage coverage);
    }

    static final class BuilderImpl implements Builder {
        private String coverage;

        private BuilderImpl() {
        }

        private BuilderImpl(ResoldBusiness model) {
            coverage(model.coverage);
        }

        public final String getCoverage() {
            return coverage;
        }

        public final void setCoverage(String coverage) {
            this.coverage = coverage;
        }

        @Override
        public final Builder coverage(String coverage) {
            this.coverage = coverage;
            return this;
        }

        @Override
        public final Builder coverage(Coverage coverage) {
            this.coverage(coverage == null ? null : coverage.toString());
            return this;
        }

        @Override
        public ResoldBusiness build() {
            return new ResoldBusiness(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
