/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.partnercentralchannel.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Summary information about a program management account.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ProgramManagementAccountSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<ProgramManagementAccountSummary.Builder, ProgramManagementAccountSummary> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(ProgramManagementAccountSummary::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<String> REVISION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("revision").getter(getter(ProgramManagementAccountSummary::revision)).setter(setter(Builder::revision))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("revision").build()).build();

    private static final SdkField<String> CATALOG_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("catalog")
            .getter(getter(ProgramManagementAccountSummary::catalog)).setter(setter(Builder::catalog))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("catalog").build()).build();

    private static final SdkField<String> PROGRAM_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("program")
            .getter(getter(ProgramManagementAccountSummary::programAsString)).setter(setter(Builder::program))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("program").build()).build();

    private static final SdkField<String> DISPLAY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("displayName").getter(getter(ProgramManagementAccountSummary::displayName))
            .setter(setter(Builder::displayName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("displayName").build()).build();

    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("accountId").getter(getter(ProgramManagementAccountSummary::accountId))
            .setter(setter(Builder::accountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accountId").build()).build();

    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("arn")
            .getter(getter(ProgramManagementAccountSummary::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdAt")
            .getter(getter(ProgramManagementAccountSummary::createdAt))
            .setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("updatedAt")
            .getter(getter(ProgramManagementAccountSummary::updatedAt))
            .setter(setter(Builder::updatedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<Instant> START_DATE_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("startDate")
            .getter(getter(ProgramManagementAccountSummary::startDate))
            .setter(setter(Builder::startDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startDate").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(ProgramManagementAccountSummary::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, REVISION_FIELD,
            CATALOG_FIELD, PROGRAM_FIELD, DISPLAY_NAME_FIELD, ACCOUNT_ID_FIELD, ARN_FIELD, CREATED_AT_FIELD, UPDATED_AT_FIELD,
            START_DATE_FIELD, STATUS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String id;

    private final String revision;

    private final String catalog;

    private final String program;

    private final String displayName;

    private final String accountId;

    private final String arn;

    private final Instant createdAt;

    private final Instant updatedAt;

    private final Instant startDate;

    private final String status;

    private ProgramManagementAccountSummary(BuilderImpl builder) {
        this.id = builder.id;
        this.revision = builder.revision;
        this.catalog = builder.catalog;
        this.program = builder.program;
        this.displayName = builder.displayName;
        this.accountId = builder.accountId;
        this.arn = builder.arn;
        this.createdAt = builder.createdAt;
        this.updatedAt = builder.updatedAt;
        this.startDate = builder.startDate;
        this.status = builder.status;
    }

    /**
     * <p>
     * The unique identifier of the program management account.
     * </p>
     * 
     * @return The unique identifier of the program management account.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The current revision number of the program management account.
     * </p>
     * 
     * @return The current revision number of the program management account.
     */
    public final String revision() {
        return revision;
    }

    /**
     * <p>
     * The catalog identifier associated with the account.
     * </p>
     * 
     * @return The catalog identifier associated with the account.
     */
    public final String catalog() {
        return catalog;
    }

    /**
     * <p>
     * The program type for the management account.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #program} will
     * return {@link Program#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #programAsString}.
     * </p>
     * 
     * @return The program type for the management account.
     * @see Program
     */
    public final Program program() {
        return Program.fromValue(program);
    }

    /**
     * <p>
     * The program type for the management account.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #program} will
     * return {@link Program#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #programAsString}.
     * </p>
     * 
     * @return The program type for the management account.
     * @see Program
     */
    public final String programAsString() {
        return program;
    }

    /**
     * <p>
     * The display name of the program management account.
     * </p>
     * 
     * @return The display name of the program management account.
     */
    public final String displayName() {
        return displayName;
    }

    /**
     * <p>
     * The AWS account ID associated with the program management account.
     * </p>
     * 
     * @return The AWS account ID associated with the program management account.
     */
    public final String accountId() {
        return accountId;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the program management account.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the program management account.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The timestamp when the account was created.
     * </p>
     * 
     * @return The timestamp when the account was created.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * The timestamp when the account was last updated.
     * </p>
     * 
     * @return The timestamp when the account was last updated.
     */
    public final Instant updatedAt() {
        return updatedAt;
    }

    /**
     * <p>
     * The start date of the program management account.
     * </p>
     * 
     * @return The start date of the program management account.
     */
    public final Instant startDate() {
        return startDate;
    }

    /**
     * <p>
     * The current status of the program management account.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ProgramManagementAccountStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of the program management account.
     * @see ProgramManagementAccountStatus
     */
    public final ProgramManagementAccountStatus status() {
        return ProgramManagementAccountStatus.fromValue(status);
    }

    /**
     * <p>
     * The current status of the program management account.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ProgramManagementAccountStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of the program management account.
     * @see ProgramManagementAccountStatus
     */
    public final String statusAsString() {
        return status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(revision());
        hashCode = 31 * hashCode + Objects.hashCode(catalog());
        hashCode = 31 * hashCode + Objects.hashCode(programAsString());
        hashCode = 31 * hashCode + Objects.hashCode(displayName());
        hashCode = 31 * hashCode + Objects.hashCode(accountId());
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(updatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(startDate());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProgramManagementAccountSummary)) {
            return false;
        }
        ProgramManagementAccountSummary other = (ProgramManagementAccountSummary) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(revision(), other.revision())
                && Objects.equals(catalog(), other.catalog()) && Objects.equals(programAsString(), other.programAsString())
                && Objects.equals(displayName(), other.displayName()) && Objects.equals(accountId(), other.accountId())
                && Objects.equals(arn(), other.arn()) && Objects.equals(createdAt(), other.createdAt())
                && Objects.equals(updatedAt(), other.updatedAt()) && Objects.equals(startDate(), other.startDate())
                && Objects.equals(statusAsString(), other.statusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ProgramManagementAccountSummary").add("Id", id()).add("Revision", revision())
                .add("Catalog", catalog()).add("Program", programAsString()).add("DisplayName", displayName())
                .add("AccountId", accountId()).add("Arn", arn()).add("CreatedAt", createdAt()).add("UpdatedAt", updatedAt())
                .add("StartDate", startDate()).add("Status", statusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "revision":
            return Optional.ofNullable(clazz.cast(revision()));
        case "catalog":
            return Optional.ofNullable(clazz.cast(catalog()));
        case "program":
            return Optional.ofNullable(clazz.cast(programAsString()));
        case "displayName":
            return Optional.ofNullable(clazz.cast(displayName()));
        case "accountId":
            return Optional.ofNullable(clazz.cast(accountId()));
        case "arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "createdAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "updatedAt":
            return Optional.ofNullable(clazz.cast(updatedAt()));
        case "startDate":
            return Optional.ofNullable(clazz.cast(startDate()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("id", ID_FIELD);
        map.put("revision", REVISION_FIELD);
        map.put("catalog", CATALOG_FIELD);
        map.put("program", PROGRAM_FIELD);
        map.put("displayName", DISPLAY_NAME_FIELD);
        map.put("accountId", ACCOUNT_ID_FIELD);
        map.put("arn", ARN_FIELD);
        map.put("createdAt", CREATED_AT_FIELD);
        map.put("updatedAt", UPDATED_AT_FIELD);
        map.put("startDate", START_DATE_FIELD);
        map.put("status", STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ProgramManagementAccountSummary, T> g) {
        return obj -> g.apply((ProgramManagementAccountSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ProgramManagementAccountSummary> {
        /**
         * <p>
         * The unique identifier of the program management account.
         * </p>
         * 
         * @param id
         *        The unique identifier of the program management account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The current revision number of the program management account.
         * </p>
         * 
         * @param revision
         *        The current revision number of the program management account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder revision(String revision);

        /**
         * <p>
         * The catalog identifier associated with the account.
         * </p>
         * 
         * @param catalog
         *        The catalog identifier associated with the account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder catalog(String catalog);

        /**
         * <p>
         * The program type for the management account.
         * </p>
         * 
         * @param program
         *        The program type for the management account.
         * @see Program
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Program
         */
        Builder program(String program);

        /**
         * <p>
         * The program type for the management account.
         * </p>
         * 
         * @param program
         *        The program type for the management account.
         * @see Program
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Program
         */
        Builder program(Program program);

        /**
         * <p>
         * The display name of the program management account.
         * </p>
         * 
         * @param displayName
         *        The display name of the program management account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder displayName(String displayName);

        /**
         * <p>
         * The AWS account ID associated with the program management account.
         * </p>
         * 
         * @param accountId
         *        The AWS account ID associated with the program management account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountId(String accountId);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the program management account.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) of the program management account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The timestamp when the account was created.
         * </p>
         * 
         * @param createdAt
         *        The timestamp when the account was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * The timestamp when the account was last updated.
         * </p>
         * 
         * @param updatedAt
         *        The timestamp when the account was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updatedAt(Instant updatedAt);

        /**
         * <p>
         * The start date of the program management account.
         * </p>
         * 
         * @param startDate
         *        The start date of the program management account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startDate(Instant startDate);

        /**
         * <p>
         * The current status of the program management account.
         * </p>
         * 
         * @param status
         *        The current status of the program management account.
         * @see ProgramManagementAccountStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ProgramManagementAccountStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The current status of the program management account.
         * </p>
         * 
         * @param status
         *        The current status of the program management account.
         * @see ProgramManagementAccountStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ProgramManagementAccountStatus
         */
        Builder status(ProgramManagementAccountStatus status);
    }

    static final class BuilderImpl implements Builder {
        private String id;

        private String revision;

        private String catalog;

        private String program;

        private String displayName;

        private String accountId;

        private String arn;

        private Instant createdAt;

        private Instant updatedAt;

        private Instant startDate;

        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(ProgramManagementAccountSummary model) {
            id(model.id);
            revision(model.revision);
            catalog(model.catalog);
            program(model.program);
            displayName(model.displayName);
            accountId(model.accountId);
            arn(model.arn);
            createdAt(model.createdAt);
            updatedAt(model.updatedAt);
            startDate(model.startDate);
            status(model.status);
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getRevision() {
            return revision;
        }

        public final void setRevision(String revision) {
            this.revision = revision;
        }

        @Override
        public final Builder revision(String revision) {
            this.revision = revision;
            return this;
        }

        public final String getCatalog() {
            return catalog;
        }

        public final void setCatalog(String catalog) {
            this.catalog = catalog;
        }

        @Override
        public final Builder catalog(String catalog) {
            this.catalog = catalog;
            return this;
        }

        public final String getProgram() {
            return program;
        }

        public final void setProgram(String program) {
            this.program = program;
        }

        @Override
        public final Builder program(String program) {
            this.program = program;
            return this;
        }

        @Override
        public final Builder program(Program program) {
            this.program(program == null ? null : program.toString());
            return this;
        }

        public final String getDisplayName() {
            return displayName;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        @Override
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public final String getAccountId() {
            return accountId;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Instant getUpdatedAt() {
            return updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public final Instant getStartDate() {
            return startDate;
        }

        public final void setStartDate(Instant startDate) {
            this.startDate = startDate;
        }

        @Override
        public final Builder startDate(Instant startDate) {
            this.startDate = startDate;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ProgramManagementAccountStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        @Override
        public ProgramManagementAccountSummary build() {
            return new ProgramManagementAccountSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
