/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.partnercentralchannel.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Details specific to program management account handshakes.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ProgramManagementAccountHandshakeDetail implements SdkPojo, Serializable,
        ToCopyableBuilder<ProgramManagementAccountHandshakeDetail.Builder, ProgramManagementAccountHandshakeDetail> {
    private static final SdkField<String> PROGRAM_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("program")
            .getter(getter(ProgramManagementAccountHandshakeDetail::programAsString)).setter(setter(Builder::program))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("program").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROGRAM_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String program;

    private ProgramManagementAccountHandshakeDetail(BuilderImpl builder) {
        this.program = builder.program;
    }

    /**
     * <p>
     * The program associated with the handshake.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #program} will
     * return {@link Program#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #programAsString}.
     * </p>
     * 
     * @return The program associated with the handshake.
     * @see Program
     */
    public final Program program() {
        return Program.fromValue(program);
    }

    /**
     * <p>
     * The program associated with the handshake.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #program} will
     * return {@link Program#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #programAsString}.
     * </p>
     * 
     * @return The program associated with the handshake.
     * @see Program
     */
    public final String programAsString() {
        return program;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(programAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProgramManagementAccountHandshakeDetail)) {
            return false;
        }
        ProgramManagementAccountHandshakeDetail other = (ProgramManagementAccountHandshakeDetail) obj;
        return Objects.equals(programAsString(), other.programAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ProgramManagementAccountHandshakeDetail").add("Program", programAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "program":
            return Optional.ofNullable(clazz.cast(programAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("program", PROGRAM_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ProgramManagementAccountHandshakeDetail, T> g) {
        return obj -> g.apply((ProgramManagementAccountHandshakeDetail) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ProgramManagementAccountHandshakeDetail> {
        /**
         * <p>
         * The program associated with the handshake.
         * </p>
         * 
         * @param program
         *        The program associated with the handshake.
         * @see Program
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Program
         */
        Builder program(String program);

        /**
         * <p>
         * The program associated with the handshake.
         * </p>
         * 
         * @param program
         *        The program associated with the handshake.
         * @see Program
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Program
         */
        Builder program(Program program);
    }

    static final class BuilderImpl implements Builder {
        private String program;

        private BuilderImpl() {
        }

        private BuilderImpl(ProgramManagementAccountHandshakeDetail model) {
            program(model.program);
        }

        public final String getProgram() {
            return program;
        }

        public final void setProgram(String program) {
            this.program = program;
        }

        @Override
        public final Builder program(String program) {
            this.program = program;
            return this;
        }

        @Override
        public final Builder program(Program program) {
            this.program(program == null ? null : program.toString());
            return this;
        }

        @Override
        public ProgramManagementAccountHandshakeDetail build() {
            return new ProgramManagementAccountHandshakeDetail(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
