/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.partnercentralchannel.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListRelationshipsRequest extends PartnerCentralChannelRequest implements
        ToCopyableBuilder<ListRelationshipsRequest.Builder, ListRelationshipsRequest> {
    private static final SdkField<String> CATALOG_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("catalog")
            .getter(getter(ListRelationshipsRequest::catalog)).setter(setter(Builder::catalog))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("catalog").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxResults").getter(getter(ListRelationshipsRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxResults").build()).build();

    private static final SdkField<List<String>> ASSOCIATED_ACCOUNT_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("associatedAccountIds")
            .getter(getter(ListRelationshipsRequest::associatedAccountIds))
            .setter(setter(Builder::associatedAccountIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("associatedAccountIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> ASSOCIATION_TYPES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("associationTypes")
            .getter(getter(ListRelationshipsRequest::associationTypesAsStrings))
            .setter(setter(Builder::associationTypesWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("associationTypes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> DISPLAY_NAMES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("displayNames")
            .getter(getter(ListRelationshipsRequest::displayNames))
            .setter(setter(Builder::displayNames))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("displayNames").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> PROGRAM_MANAGEMENT_ACCOUNT_IDENTIFIERS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("programManagementAccountIdentifiers")
            .getter(getter(ListRelationshipsRequest::programManagementAccountIdentifiers))
            .setter(setter(Builder::programManagementAccountIdentifiers))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("programManagementAccountIdentifiers").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<ListRelationshipsSortBase> SORT_FIELD = SdkField
            .<ListRelationshipsSortBase> builder(MarshallingType.SDK_POJO).memberName("sort")
            .getter(getter(ListRelationshipsRequest::sort)).setter(setter(Builder::sort))
            .constructor(ListRelationshipsSortBase::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sort").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListRelationshipsRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CATALOG_FIELD,
            MAX_RESULTS_FIELD, ASSOCIATED_ACCOUNT_IDS_FIELD, ASSOCIATION_TYPES_FIELD, DISPLAY_NAMES_FIELD,
            PROGRAM_MANAGEMENT_ACCOUNT_IDENTIFIERS_FIELD, SORT_FIELD, NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String catalog;

    private final Integer maxResults;

    private final List<String> associatedAccountIds;

    private final List<String> associationTypes;

    private final List<String> displayNames;

    private final List<String> programManagementAccountIdentifiers;

    private final ListRelationshipsSortBase sort;

    private final String nextToken;

    private ListRelationshipsRequest(BuilderImpl builder) {
        super(builder);
        this.catalog = builder.catalog;
        this.maxResults = builder.maxResults;
        this.associatedAccountIds = builder.associatedAccountIds;
        this.associationTypes = builder.associationTypes;
        this.displayNames = builder.displayNames;
        this.programManagementAccountIdentifiers = builder.programManagementAccountIdentifiers;
        this.sort = builder.sort;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * The catalog identifier to filter relationships.
     * </p>
     * 
     * @return The catalog identifier to filter relationships.
     */
    public final String catalog() {
        return catalog;
    }

    /**
     * <p>
     * The maximum number of results to return in a single call.
     * </p>
     * 
     * @return The maximum number of results to return in a single call.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * For responses, this returns true if the service returned a value for the AssociatedAccountIds property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAssociatedAccountIds() {
        return associatedAccountIds != null && !(associatedAccountIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Filter by associated AWS account IDs.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAssociatedAccountIds} method.
     * </p>
     * 
     * @return Filter by associated AWS account IDs.
     */
    public final List<String> associatedAccountIds() {
        return associatedAccountIds;
    }

    /**
     * <p>
     * Filter by association types.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAssociationTypes} method.
     * </p>
     * 
     * @return Filter by association types.
     */
    public final List<AssociationType> associationTypes() {
        return AssociationTypeListCopier.copyStringToEnum(associationTypes);
    }

    /**
     * For responses, this returns true if the service returned a value for the AssociationTypes property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAssociationTypes() {
        return associationTypes != null && !(associationTypes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Filter by association types.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAssociationTypes} method.
     * </p>
     * 
     * @return Filter by association types.
     */
    public final List<String> associationTypesAsStrings() {
        return associationTypes;
    }

    /**
     * For responses, this returns true if the service returned a value for the DisplayNames property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasDisplayNames() {
        return displayNames != null && !(displayNames instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Filter by display names.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDisplayNames} method.
     * </p>
     * 
     * @return Filter by display names.
     */
    public final List<String> displayNames() {
        return displayNames;
    }

    /**
     * For responses, this returns true if the service returned a value for the ProgramManagementAccountIdentifiers
     * property. This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()}
     * method on the property). This is useful because the SDK will never return a null collection or map, but you may
     * need to differentiate between the service returning nothing (or null) and the service returning an empty
     * collection or map. For requests, this returns true if a value for the property was specified in the request
     * builder, and false if a value was not specified.
     */
    public final boolean hasProgramManagementAccountIdentifiers() {
        return programManagementAccountIdentifiers != null
                && !(programManagementAccountIdentifiers instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Filter by program management account identifiers.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasProgramManagementAccountIdentifiers}
     * method.
     * </p>
     * 
     * @return Filter by program management account identifiers.
     */
    public final List<String> programManagementAccountIdentifiers() {
        return programManagementAccountIdentifiers;
    }

    /**
     * <p>
     * Sorting options for the results.
     * </p>
     * 
     * @return Sorting options for the results.
     */
    public final ListRelationshipsSortBase sort() {
        return sort;
    }

    /**
     * <p>
     * Token for retrieving the next page of results.
     * </p>
     * 
     * @return Token for retrieving the next page of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(catalog());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(hasAssociatedAccountIds() ? associatedAccountIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasAssociationTypes() ? associationTypesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasDisplayNames() ? displayNames() : null);
        hashCode = 31 * hashCode
                + Objects.hashCode(hasProgramManagementAccountIdentifiers() ? programManagementAccountIdentifiers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(sort());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListRelationshipsRequest)) {
            return false;
        }
        ListRelationshipsRequest other = (ListRelationshipsRequest) obj;
        return Objects.equals(catalog(), other.catalog()) && Objects.equals(maxResults(), other.maxResults())
                && hasAssociatedAccountIds() == other.hasAssociatedAccountIds()
                && Objects.equals(associatedAccountIds(), other.associatedAccountIds())
                && hasAssociationTypes() == other.hasAssociationTypes()
                && Objects.equals(associationTypesAsStrings(), other.associationTypesAsStrings())
                && hasDisplayNames() == other.hasDisplayNames() && Objects.equals(displayNames(), other.displayNames())
                && hasProgramManagementAccountIdentifiers() == other.hasProgramManagementAccountIdentifiers()
                && Objects.equals(programManagementAccountIdentifiers(), other.programManagementAccountIdentifiers())
                && Objects.equals(sort(), other.sort()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("ListRelationshipsRequest")
                .add("Catalog", catalog())
                .add("MaxResults", maxResults())
                .add("AssociatedAccountIds", hasAssociatedAccountIds() ? associatedAccountIds() : null)
                .add("AssociationTypes", hasAssociationTypes() ? associationTypesAsStrings() : null)
                .add("DisplayNames", hasDisplayNames() ? displayNames() : null)
                .add("ProgramManagementAccountIdentifiers",
                        hasProgramManagementAccountIdentifiers() ? programManagementAccountIdentifiers() : null)
                .add("Sort", sort()).add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "catalog":
            return Optional.ofNullable(clazz.cast(catalog()));
        case "maxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "associatedAccountIds":
            return Optional.ofNullable(clazz.cast(associatedAccountIds()));
        case "associationTypes":
            return Optional.ofNullable(clazz.cast(associationTypesAsStrings()));
        case "displayNames":
            return Optional.ofNullable(clazz.cast(displayNames()));
        case "programManagementAccountIdentifiers":
            return Optional.ofNullable(clazz.cast(programManagementAccountIdentifiers()));
        case "sort":
            return Optional.ofNullable(clazz.cast(sort()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("catalog", CATALOG_FIELD);
        map.put("maxResults", MAX_RESULTS_FIELD);
        map.put("associatedAccountIds", ASSOCIATED_ACCOUNT_IDS_FIELD);
        map.put("associationTypes", ASSOCIATION_TYPES_FIELD);
        map.put("displayNames", DISPLAY_NAMES_FIELD);
        map.put("programManagementAccountIdentifiers", PROGRAM_MANAGEMENT_ACCOUNT_IDENTIFIERS_FIELD);
        map.put("sort", SORT_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListRelationshipsRequest, T> g) {
        return obj -> g.apply((ListRelationshipsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends PartnerCentralChannelRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, ListRelationshipsRequest> {
        /**
         * <p>
         * The catalog identifier to filter relationships.
         * </p>
         * 
         * @param catalog
         *        The catalog identifier to filter relationships.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder catalog(String catalog);

        /**
         * <p>
         * The maximum number of results to return in a single call.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of results to return in a single call.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * Filter by associated AWS account IDs.
         * </p>
         * 
         * @param associatedAccountIds
         *        Filter by associated AWS account IDs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder associatedAccountIds(Collection<String> associatedAccountIds);

        /**
         * <p>
         * Filter by associated AWS account IDs.
         * </p>
         * 
         * @param associatedAccountIds
         *        Filter by associated AWS account IDs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder associatedAccountIds(String... associatedAccountIds);

        /**
         * <p>
         * Filter by association types.
         * </p>
         * 
         * @param associationTypes
         *        Filter by association types.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder associationTypesWithStrings(Collection<String> associationTypes);

        /**
         * <p>
         * Filter by association types.
         * </p>
         * 
         * @param associationTypes
         *        Filter by association types.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder associationTypesWithStrings(String... associationTypes);

        /**
         * <p>
         * Filter by association types.
         * </p>
         * 
         * @param associationTypes
         *        Filter by association types.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder associationTypes(Collection<AssociationType> associationTypes);

        /**
         * <p>
         * Filter by association types.
         * </p>
         * 
         * @param associationTypes
         *        Filter by association types.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder associationTypes(AssociationType... associationTypes);

        /**
         * <p>
         * Filter by display names.
         * </p>
         * 
         * @param displayNames
         *        Filter by display names.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder displayNames(Collection<String> displayNames);

        /**
         * <p>
         * Filter by display names.
         * </p>
         * 
         * @param displayNames
         *        Filter by display names.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder displayNames(String... displayNames);

        /**
         * <p>
         * Filter by program management account identifiers.
         * </p>
         * 
         * @param programManagementAccountIdentifiers
         *        Filter by program management account identifiers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder programManagementAccountIdentifiers(Collection<String> programManagementAccountIdentifiers);

        /**
         * <p>
         * Filter by program management account identifiers.
         * </p>
         * 
         * @param programManagementAccountIdentifiers
         *        Filter by program management account identifiers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder programManagementAccountIdentifiers(String... programManagementAccountIdentifiers);

        /**
         * <p>
         * Sorting options for the results.
         * </p>
         * 
         * @param sort
         *        Sorting options for the results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sort(ListRelationshipsSortBase sort);

        /**
         * <p>
         * Sorting options for the results.
         * </p>
         * This is a convenience method that creates an instance of the {@link ListRelationshipsSortBase.Builder}
         * avoiding the need to create one manually via {@link ListRelationshipsSortBase#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ListRelationshipsSortBase.Builder#build()} is called immediately
         * and its result is passed to {@link #sort(ListRelationshipsSortBase)}.
         * 
         * @param sort
         *        a consumer that will call methods on {@link ListRelationshipsSortBase.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sort(ListRelationshipsSortBase)
         */
        default Builder sort(Consumer<ListRelationshipsSortBase.Builder> sort) {
            return sort(ListRelationshipsSortBase.builder().applyMutation(sort).build());
        }

        /**
         * <p>
         * Token for retrieving the next page of results.
         * </p>
         * 
         * @param nextToken
         *        Token for retrieving the next page of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends PartnerCentralChannelRequest.BuilderImpl implements Builder {
        private String catalog;

        private Integer maxResults;

        private List<String> associatedAccountIds = DefaultSdkAutoConstructList.getInstance();

        private List<String> associationTypes = DefaultSdkAutoConstructList.getInstance();

        private List<String> displayNames = DefaultSdkAutoConstructList.getInstance();

        private List<String> programManagementAccountIdentifiers = DefaultSdkAutoConstructList.getInstance();

        private ListRelationshipsSortBase sort;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListRelationshipsRequest model) {
            super(model);
            catalog(model.catalog);
            maxResults(model.maxResults);
            associatedAccountIds(model.associatedAccountIds);
            associationTypesWithStrings(model.associationTypes);
            displayNames(model.displayNames);
            programManagementAccountIdentifiers(model.programManagementAccountIdentifiers);
            sort(model.sort);
            nextToken(model.nextToken);
        }

        public final String getCatalog() {
            return catalog;
        }

        public final void setCatalog(String catalog) {
            this.catalog = catalog;
        }

        @Override
        public final Builder catalog(String catalog) {
            this.catalog = catalog;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final Collection<String> getAssociatedAccountIds() {
            if (associatedAccountIds instanceof SdkAutoConstructList) {
                return null;
            }
            return associatedAccountIds;
        }

        public final void setAssociatedAccountIds(Collection<String> associatedAccountIds) {
            this.associatedAccountIds = AccountIdListCopier.copy(associatedAccountIds);
        }

        @Override
        public final Builder associatedAccountIds(Collection<String> associatedAccountIds) {
            this.associatedAccountIds = AccountIdListCopier.copy(associatedAccountIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder associatedAccountIds(String... associatedAccountIds) {
            associatedAccountIds(Arrays.asList(associatedAccountIds));
            return this;
        }

        public final Collection<String> getAssociationTypes() {
            if (associationTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return associationTypes;
        }

        public final void setAssociationTypes(Collection<String> associationTypes) {
            this.associationTypes = AssociationTypeListCopier.copy(associationTypes);
        }

        @Override
        public final Builder associationTypesWithStrings(Collection<String> associationTypes) {
            this.associationTypes = AssociationTypeListCopier.copy(associationTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder associationTypesWithStrings(String... associationTypes) {
            associationTypesWithStrings(Arrays.asList(associationTypes));
            return this;
        }

        @Override
        public final Builder associationTypes(Collection<AssociationType> associationTypes) {
            this.associationTypes = AssociationTypeListCopier.copyEnumToString(associationTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder associationTypes(AssociationType... associationTypes) {
            associationTypes(Arrays.asList(associationTypes));
            return this;
        }

        public final Collection<String> getDisplayNames() {
            if (displayNames instanceof SdkAutoConstructList) {
                return null;
            }
            return displayNames;
        }

        public final void setDisplayNames(Collection<String> displayNames) {
            this.displayNames = RelationshipDisplayNameListCopier.copy(displayNames);
        }

        @Override
        public final Builder displayNames(Collection<String> displayNames) {
            this.displayNames = RelationshipDisplayNameListCopier.copy(displayNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder displayNames(String... displayNames) {
            displayNames(Arrays.asList(displayNames));
            return this;
        }

        public final Collection<String> getProgramManagementAccountIdentifiers() {
            if (programManagementAccountIdentifiers instanceof SdkAutoConstructList) {
                return null;
            }
            return programManagementAccountIdentifiers;
        }

        public final void setProgramManagementAccountIdentifiers(Collection<String> programManagementAccountIdentifiers) {
            this.programManagementAccountIdentifiers = ProgramManagementAccountIdentifierListCopier
                    .copy(programManagementAccountIdentifiers);
        }

        @Override
        public final Builder programManagementAccountIdentifiers(Collection<String> programManagementAccountIdentifiers) {
            this.programManagementAccountIdentifiers = ProgramManagementAccountIdentifierListCopier
                    .copy(programManagementAccountIdentifiers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder programManagementAccountIdentifiers(String... programManagementAccountIdentifiers) {
            programManagementAccountIdentifiers(Arrays.asList(programManagementAccountIdentifiers));
            return this;
        }

        public final ListRelationshipsSortBase.Builder getSort() {
            return sort != null ? sort.toBuilder() : null;
        }

        public final void setSort(ListRelationshipsSortBase.BuilderImpl sort) {
            this.sort = sort != null ? sort.build() : null;
        }

        @Override
        public final Builder sort(ListRelationshipsSortBase sort) {
            this.sort = sort;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListRelationshipsRequest build() {
            return new ListRelationshipsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
