/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.partnercentralchannel.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListProgramManagementAccountsRequest extends PartnerCentralChannelRequest implements
        ToCopyableBuilder<ListProgramManagementAccountsRequest.Builder, ListProgramManagementAccountsRequest> {
    private static final SdkField<String> CATALOG_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("catalog")
            .getter(getter(ListProgramManagementAccountsRequest::catalog)).setter(setter(Builder::catalog))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("catalog").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxResults").getter(getter(ListProgramManagementAccountsRequest::maxResults))
            .setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxResults").build()).build();

    private static final SdkField<List<String>> DISPLAY_NAMES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("displayNames")
            .getter(getter(ListProgramManagementAccountsRequest::displayNames))
            .setter(setter(Builder::displayNames))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("displayNames").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> PROGRAMS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("programs")
            .getter(getter(ListProgramManagementAccountsRequest::programsAsStrings))
            .setter(setter(Builder::programsWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("programs").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> ACCOUNT_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("accountIds")
            .getter(getter(ListProgramManagementAccountsRequest::accountIds))
            .setter(setter(Builder::accountIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accountIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> STATUSES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("statuses")
            .getter(getter(ListProgramManagementAccountsRequest::statusesAsStrings))
            .setter(setter(Builder::statusesWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statuses").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<ListProgramManagementAccountsSortBase> SORT_FIELD = SdkField
            .<ListProgramManagementAccountsSortBase> builder(MarshallingType.SDK_POJO).memberName("sort")
            .getter(getter(ListProgramManagementAccountsRequest::sort)).setter(setter(Builder::sort))
            .constructor(ListProgramManagementAccountsSortBase::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sort").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListProgramManagementAccountsRequest::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CATALOG_FIELD,
            MAX_RESULTS_FIELD, DISPLAY_NAMES_FIELD, PROGRAMS_FIELD, ACCOUNT_IDS_FIELD, STATUSES_FIELD, SORT_FIELD,
            NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String catalog;

    private final Integer maxResults;

    private final List<String> displayNames;

    private final List<String> programs;

    private final List<String> accountIds;

    private final List<String> statuses;

    private final ListProgramManagementAccountsSortBase sort;

    private final String nextToken;

    private ListProgramManagementAccountsRequest(BuilderImpl builder) {
        super(builder);
        this.catalog = builder.catalog;
        this.maxResults = builder.maxResults;
        this.displayNames = builder.displayNames;
        this.programs = builder.programs;
        this.accountIds = builder.accountIds;
        this.statuses = builder.statuses;
        this.sort = builder.sort;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * The catalog identifier to filter accounts.
     * </p>
     * 
     * @return The catalog identifier to filter accounts.
     */
    public final String catalog() {
        return catalog;
    }

    /**
     * <p>
     * The maximum number of results to return in a single call.
     * </p>
     * 
     * @return The maximum number of results to return in a single call.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * For responses, this returns true if the service returned a value for the DisplayNames property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasDisplayNames() {
        return displayNames != null && !(displayNames instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Filter by display names.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDisplayNames} method.
     * </p>
     * 
     * @return Filter by display names.
     */
    public final List<String> displayNames() {
        return displayNames;
    }

    /**
     * <p>
     * Filter by program types.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPrograms} method.
     * </p>
     * 
     * @return Filter by program types.
     */
    public final List<Program> programs() {
        return ProgramListCopier.copyStringToEnum(programs);
    }

    /**
     * For responses, this returns true if the service returned a value for the Programs property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasPrograms() {
        return programs != null && !(programs instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Filter by program types.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPrograms} method.
     * </p>
     * 
     * @return Filter by program types.
     */
    public final List<String> programsAsStrings() {
        return programs;
    }

    /**
     * For responses, this returns true if the service returned a value for the AccountIds property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasAccountIds() {
        return accountIds != null && !(accountIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Filter by AWS account IDs.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAccountIds} method.
     * </p>
     * 
     * @return Filter by AWS account IDs.
     */
    public final List<String> accountIds() {
        return accountIds;
    }

    /**
     * <p>
     * Filter by program management account statuses.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasStatuses} method.
     * </p>
     * 
     * @return Filter by program management account statuses.
     */
    public final List<ProgramManagementAccountStatus> statuses() {
        return ProgramManagementAccountStatusListCopier.copyStringToEnum(statuses);
    }

    /**
     * For responses, this returns true if the service returned a value for the Statuses property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasStatuses() {
        return statuses != null && !(statuses instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Filter by program management account statuses.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasStatuses} method.
     * </p>
     * 
     * @return Filter by program management account statuses.
     */
    public final List<String> statusesAsStrings() {
        return statuses;
    }

    /**
     * <p>
     * Sorting options for the results.
     * </p>
     * 
     * @return Sorting options for the results.
     */
    public final ListProgramManagementAccountsSortBase sort() {
        return sort;
    }

    /**
     * <p>
     * Token for retrieving the next page of results.
     * </p>
     * 
     * @return Token for retrieving the next page of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(catalog());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(hasDisplayNames() ? displayNames() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasPrograms() ? programsAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasAccountIds() ? accountIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasStatuses() ? statusesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(sort());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListProgramManagementAccountsRequest)) {
            return false;
        }
        ListProgramManagementAccountsRequest other = (ListProgramManagementAccountsRequest) obj;
        return Objects.equals(catalog(), other.catalog()) && Objects.equals(maxResults(), other.maxResults())
                && hasDisplayNames() == other.hasDisplayNames() && Objects.equals(displayNames(), other.displayNames())
                && hasPrograms() == other.hasPrograms() && Objects.equals(programsAsStrings(), other.programsAsStrings())
                && hasAccountIds() == other.hasAccountIds() && Objects.equals(accountIds(), other.accountIds())
                && hasStatuses() == other.hasStatuses() && Objects.equals(statusesAsStrings(), other.statusesAsStrings())
                && Objects.equals(sort(), other.sort()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListProgramManagementAccountsRequest").add("Catalog", catalog()).add("MaxResults", maxResults())
                .add("DisplayNames", hasDisplayNames() ? displayNames() : null)
                .add("Programs", hasPrograms() ? programsAsStrings() : null)
                .add("AccountIds", hasAccountIds() ? accountIds() : null)
                .add("Statuses", hasStatuses() ? statusesAsStrings() : null).add("Sort", sort()).add("NextToken", nextToken())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "catalog":
            return Optional.ofNullable(clazz.cast(catalog()));
        case "maxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "displayNames":
            return Optional.ofNullable(clazz.cast(displayNames()));
        case "programs":
            return Optional.ofNullable(clazz.cast(programsAsStrings()));
        case "accountIds":
            return Optional.ofNullable(clazz.cast(accountIds()));
        case "statuses":
            return Optional.ofNullable(clazz.cast(statusesAsStrings()));
        case "sort":
            return Optional.ofNullable(clazz.cast(sort()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("catalog", CATALOG_FIELD);
        map.put("maxResults", MAX_RESULTS_FIELD);
        map.put("displayNames", DISPLAY_NAMES_FIELD);
        map.put("programs", PROGRAMS_FIELD);
        map.put("accountIds", ACCOUNT_IDS_FIELD);
        map.put("statuses", STATUSES_FIELD);
        map.put("sort", SORT_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListProgramManagementAccountsRequest, T> g) {
        return obj -> g.apply((ListProgramManagementAccountsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends PartnerCentralChannelRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, ListProgramManagementAccountsRequest> {
        /**
         * <p>
         * The catalog identifier to filter accounts.
         * </p>
         * 
         * @param catalog
         *        The catalog identifier to filter accounts.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder catalog(String catalog);

        /**
         * <p>
         * The maximum number of results to return in a single call.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of results to return in a single call.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * Filter by display names.
         * </p>
         * 
         * @param displayNames
         *        Filter by display names.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder displayNames(Collection<String> displayNames);

        /**
         * <p>
         * Filter by display names.
         * </p>
         * 
         * @param displayNames
         *        Filter by display names.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder displayNames(String... displayNames);

        /**
         * <p>
         * Filter by program types.
         * </p>
         * 
         * @param programs
         *        Filter by program types.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder programsWithStrings(Collection<String> programs);

        /**
         * <p>
         * Filter by program types.
         * </p>
         * 
         * @param programs
         *        Filter by program types.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder programsWithStrings(String... programs);

        /**
         * <p>
         * Filter by program types.
         * </p>
         * 
         * @param programs
         *        Filter by program types.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder programs(Collection<Program> programs);

        /**
         * <p>
         * Filter by program types.
         * </p>
         * 
         * @param programs
         *        Filter by program types.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder programs(Program... programs);

        /**
         * <p>
         * Filter by AWS account IDs.
         * </p>
         * 
         * @param accountIds
         *        Filter by AWS account IDs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountIds(Collection<String> accountIds);

        /**
         * <p>
         * Filter by AWS account IDs.
         * </p>
         * 
         * @param accountIds
         *        Filter by AWS account IDs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountIds(String... accountIds);

        /**
         * <p>
         * Filter by program management account statuses.
         * </p>
         * 
         * @param statuses
         *        Filter by program management account statuses.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusesWithStrings(Collection<String> statuses);

        /**
         * <p>
         * Filter by program management account statuses.
         * </p>
         * 
         * @param statuses
         *        Filter by program management account statuses.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusesWithStrings(String... statuses);

        /**
         * <p>
         * Filter by program management account statuses.
         * </p>
         * 
         * @param statuses
         *        Filter by program management account statuses.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statuses(Collection<ProgramManagementAccountStatus> statuses);

        /**
         * <p>
         * Filter by program management account statuses.
         * </p>
         * 
         * @param statuses
         *        Filter by program management account statuses.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statuses(ProgramManagementAccountStatus... statuses);

        /**
         * <p>
         * Sorting options for the results.
         * </p>
         * 
         * @param sort
         *        Sorting options for the results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sort(ListProgramManagementAccountsSortBase sort);

        /**
         * <p>
         * Sorting options for the results.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link ListProgramManagementAccountsSortBase.Builder} avoiding the need to create one manually via
         * {@link ListProgramManagementAccountsSortBase#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ListProgramManagementAccountsSortBase.Builder#build()} is called
         * immediately and its result is passed to {@link #sort(ListProgramManagementAccountsSortBase)}.
         * 
         * @param sort
         *        a consumer that will call methods on {@link ListProgramManagementAccountsSortBase.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sort(ListProgramManagementAccountsSortBase)
         */
        default Builder sort(Consumer<ListProgramManagementAccountsSortBase.Builder> sort) {
            return sort(ListProgramManagementAccountsSortBase.builder().applyMutation(sort).build());
        }

        /**
         * <p>
         * Token for retrieving the next page of results.
         * </p>
         * 
         * @param nextToken
         *        Token for retrieving the next page of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends PartnerCentralChannelRequest.BuilderImpl implements Builder {
        private String catalog;

        private Integer maxResults;

        private List<String> displayNames = DefaultSdkAutoConstructList.getInstance();

        private List<String> programs = DefaultSdkAutoConstructList.getInstance();

        private List<String> accountIds = DefaultSdkAutoConstructList.getInstance();

        private List<String> statuses = DefaultSdkAutoConstructList.getInstance();

        private ListProgramManagementAccountsSortBase sort;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListProgramManagementAccountsRequest model) {
            super(model);
            catalog(model.catalog);
            maxResults(model.maxResults);
            displayNames(model.displayNames);
            programsWithStrings(model.programs);
            accountIds(model.accountIds);
            statusesWithStrings(model.statuses);
            sort(model.sort);
            nextToken(model.nextToken);
        }

        public final String getCatalog() {
            return catalog;
        }

        public final void setCatalog(String catalog) {
            this.catalog = catalog;
        }

        @Override
        public final Builder catalog(String catalog) {
            this.catalog = catalog;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final Collection<String> getDisplayNames() {
            if (displayNames instanceof SdkAutoConstructList) {
                return null;
            }
            return displayNames;
        }

        public final void setDisplayNames(Collection<String> displayNames) {
            this.displayNames = ProgramManagementAccountDisplayNameListCopier.copy(displayNames);
        }

        @Override
        public final Builder displayNames(Collection<String> displayNames) {
            this.displayNames = ProgramManagementAccountDisplayNameListCopier.copy(displayNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder displayNames(String... displayNames) {
            displayNames(Arrays.asList(displayNames));
            return this;
        }

        public final Collection<String> getPrograms() {
            if (programs instanceof SdkAutoConstructList) {
                return null;
            }
            return programs;
        }

        public final void setPrograms(Collection<String> programs) {
            this.programs = ProgramListCopier.copy(programs);
        }

        @Override
        public final Builder programsWithStrings(Collection<String> programs) {
            this.programs = ProgramListCopier.copy(programs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder programsWithStrings(String... programs) {
            programsWithStrings(Arrays.asList(programs));
            return this;
        }

        @Override
        public final Builder programs(Collection<Program> programs) {
            this.programs = ProgramListCopier.copyEnumToString(programs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder programs(Program... programs) {
            programs(Arrays.asList(programs));
            return this;
        }

        public final Collection<String> getAccountIds() {
            if (accountIds instanceof SdkAutoConstructList) {
                return null;
            }
            return accountIds;
        }

        public final void setAccountIds(Collection<String> accountIds) {
            this.accountIds = AccountIdListCopier.copy(accountIds);
        }

        @Override
        public final Builder accountIds(Collection<String> accountIds) {
            this.accountIds = AccountIdListCopier.copy(accountIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accountIds(String... accountIds) {
            accountIds(Arrays.asList(accountIds));
            return this;
        }

        public final Collection<String> getStatuses() {
            if (statuses instanceof SdkAutoConstructList) {
                return null;
            }
            return statuses;
        }

        public final void setStatuses(Collection<String> statuses) {
            this.statuses = ProgramManagementAccountStatusListCopier.copy(statuses);
        }

        @Override
        public final Builder statusesWithStrings(Collection<String> statuses) {
            this.statuses = ProgramManagementAccountStatusListCopier.copy(statuses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder statusesWithStrings(String... statuses) {
            statusesWithStrings(Arrays.asList(statuses));
            return this;
        }

        @Override
        public final Builder statuses(Collection<ProgramManagementAccountStatus> statuses) {
            this.statuses = ProgramManagementAccountStatusListCopier.copyEnumToString(statuses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder statuses(ProgramManagementAccountStatus... statuses) {
            statuses(Arrays.asList(statuses));
            return this;
        }

        public final ListProgramManagementAccountsSortBase.Builder getSort() {
            return sort != null ? sort.toBuilder() : null;
        }

        public final void setSort(ListProgramManagementAccountsSortBase.BuilderImpl sort) {
            this.sort = sort != null ? sort.build() : null;
        }

        @Override
        public final Builder sort(ListProgramManagementAccountsSortBase sort) {
            this.sort = sort;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListProgramManagementAccountsRequest build() {
            return new ListProgramManagementAccountsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
