/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.partnercentralchannel.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Type-specific sorting options for listing channel handshakes.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListChannelHandshakesTypeSort implements SdkPojo, Serializable,
        ToCopyableBuilder<ListChannelHandshakesTypeSort.Builder, ListChannelHandshakesTypeSort> {
    private static final SdkField<StartServicePeriodTypeSort> START_SERVICE_PERIOD_TYPE_SORT_FIELD = SdkField
            .<StartServicePeriodTypeSort> builder(MarshallingType.SDK_POJO)
            .memberName("startServicePeriodTypeSort")
            .getter(getter(ListChannelHandshakesTypeSort::startServicePeriodTypeSort))
            .setter(setter(Builder::startServicePeriodTypeSort))
            .constructor(StartServicePeriodTypeSort::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startServicePeriodTypeSort").build())
            .build();

    private static final SdkField<RevokeServicePeriodTypeSort> REVOKE_SERVICE_PERIOD_TYPE_SORT_FIELD = SdkField
            .<RevokeServicePeriodTypeSort> builder(MarshallingType.SDK_POJO)
            .memberName("revokeServicePeriodTypeSort")
            .getter(getter(ListChannelHandshakesTypeSort::revokeServicePeriodTypeSort))
            .setter(setter(Builder::revokeServicePeriodTypeSort))
            .constructor(RevokeServicePeriodTypeSort::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("revokeServicePeriodTypeSort")
                    .build()).build();

    private static final SdkField<ProgramManagementAccountTypeSort> PROGRAM_MANAGEMENT_ACCOUNT_TYPE_SORT_FIELD = SdkField
            .<ProgramManagementAccountTypeSort> builder(MarshallingType.SDK_POJO)
            .memberName("programManagementAccountTypeSort")
            .getter(getter(ListChannelHandshakesTypeSort::programManagementAccountTypeSort))
            .setter(setter(Builder::programManagementAccountTypeSort))
            .constructor(ProgramManagementAccountTypeSort::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("programManagementAccountTypeSort")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            START_SERVICE_PERIOD_TYPE_SORT_FIELD, REVOKE_SERVICE_PERIOD_TYPE_SORT_FIELD,
            PROGRAM_MANAGEMENT_ACCOUNT_TYPE_SORT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final StartServicePeriodTypeSort startServicePeriodTypeSort;

    private final RevokeServicePeriodTypeSort revokeServicePeriodTypeSort;

    private final ProgramManagementAccountTypeSort programManagementAccountTypeSort;

    private final Type type;

    private ListChannelHandshakesTypeSort(BuilderImpl builder) {
        this.startServicePeriodTypeSort = builder.startServicePeriodTypeSort;
        this.revokeServicePeriodTypeSort = builder.revokeServicePeriodTypeSort;
        this.programManagementAccountTypeSort = builder.programManagementAccountTypeSort;
        this.type = builder.type;
    }

    /**
     * <p>
     * Sorting options specific to start service period handshakes.
     * </p>
     * 
     * @return Sorting options specific to start service period handshakes.
     */
    public final StartServicePeriodTypeSort startServicePeriodTypeSort() {
        return startServicePeriodTypeSort;
    }

    /**
     * <p>
     * Sorting options specific to revoke service period handshakes.
     * </p>
     * 
     * @return Sorting options specific to revoke service period handshakes.
     */
    public final RevokeServicePeriodTypeSort revokeServicePeriodTypeSort() {
        return revokeServicePeriodTypeSort;
    }

    /**
     * <p>
     * Sorting options specific to program management account handshakes.
     * </p>
     * 
     * @return Sorting options specific to program management account handshakes.
     */
    public final ProgramManagementAccountTypeSort programManagementAccountTypeSort() {
        return programManagementAccountTypeSort;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(startServicePeriodTypeSort());
        hashCode = 31 * hashCode + Objects.hashCode(revokeServicePeriodTypeSort());
        hashCode = 31 * hashCode + Objects.hashCode(programManagementAccountTypeSort());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListChannelHandshakesTypeSort)) {
            return false;
        }
        ListChannelHandshakesTypeSort other = (ListChannelHandshakesTypeSort) obj;
        return Objects.equals(startServicePeriodTypeSort(), other.startServicePeriodTypeSort())
                && Objects.equals(revokeServicePeriodTypeSort(), other.revokeServicePeriodTypeSort())
                && Objects.equals(programManagementAccountTypeSort(), other.programManagementAccountTypeSort());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListChannelHandshakesTypeSort").add("StartServicePeriodTypeSort", startServicePeriodTypeSort())
                .add("RevokeServicePeriodTypeSort", revokeServicePeriodTypeSort())
                .add("ProgramManagementAccountTypeSort", programManagementAccountTypeSort()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "startServicePeriodTypeSort":
            return Optional.ofNullable(clazz.cast(startServicePeriodTypeSort()));
        case "revokeServicePeriodTypeSort":
            return Optional.ofNullable(clazz.cast(revokeServicePeriodTypeSort()));
        case "programManagementAccountTypeSort":
            return Optional.ofNullable(clazz.cast(programManagementAccountTypeSort()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #startServicePeriodTypeSort()} initialized to the given value.
     *
     * <p>
     * Sorting options specific to start service period handshakes.
     * </p>
     * 
     * @param startServicePeriodTypeSort
     *        Sorting options specific to start service period handshakes.
     */
    public static ListChannelHandshakesTypeSort fromStartServicePeriodTypeSort(
            StartServicePeriodTypeSort startServicePeriodTypeSort) {
        return builder().startServicePeriodTypeSort(startServicePeriodTypeSort).build();
    }

    /**
     * Create an instance of this class with {@link #startServicePeriodTypeSort()} initialized to the given value.
     *
     * <p>
     * Sorting options specific to start service period handshakes.
     * </p>
     * 
     * @param startServicePeriodTypeSort
     *        Sorting options specific to start service period handshakes.
     */
    public static ListChannelHandshakesTypeSort fromStartServicePeriodTypeSort(
            Consumer<StartServicePeriodTypeSort.Builder> startServicePeriodTypeSort) {
        StartServicePeriodTypeSort.Builder builder = StartServicePeriodTypeSort.builder();
        startServicePeriodTypeSort.accept(builder);
        return fromStartServicePeriodTypeSort(builder.build());
    }

    /**
     * Create an instance of this class with {@link #revokeServicePeriodTypeSort()} initialized to the given value.
     *
     * <p>
     * Sorting options specific to revoke service period handshakes.
     * </p>
     * 
     * @param revokeServicePeriodTypeSort
     *        Sorting options specific to revoke service period handshakes.
     */
    public static ListChannelHandshakesTypeSort fromRevokeServicePeriodTypeSort(
            RevokeServicePeriodTypeSort revokeServicePeriodTypeSort) {
        return builder().revokeServicePeriodTypeSort(revokeServicePeriodTypeSort).build();
    }

    /**
     * Create an instance of this class with {@link #revokeServicePeriodTypeSort()} initialized to the given value.
     *
     * <p>
     * Sorting options specific to revoke service period handshakes.
     * </p>
     * 
     * @param revokeServicePeriodTypeSort
     *        Sorting options specific to revoke service period handshakes.
     */
    public static ListChannelHandshakesTypeSort fromRevokeServicePeriodTypeSort(
            Consumer<RevokeServicePeriodTypeSort.Builder> revokeServicePeriodTypeSort) {
        RevokeServicePeriodTypeSort.Builder builder = RevokeServicePeriodTypeSort.builder();
        revokeServicePeriodTypeSort.accept(builder);
        return fromRevokeServicePeriodTypeSort(builder.build());
    }

    /**
     * Create an instance of this class with {@link #programManagementAccountTypeSort()} initialized to the given value.
     *
     * <p>
     * Sorting options specific to program management account handshakes.
     * </p>
     * 
     * @param programManagementAccountTypeSort
     *        Sorting options specific to program management account handshakes.
     */
    public static ListChannelHandshakesTypeSort fromProgramManagementAccountTypeSort(
            ProgramManagementAccountTypeSort programManagementAccountTypeSort) {
        return builder().programManagementAccountTypeSort(programManagementAccountTypeSort).build();
    }

    /**
     * Create an instance of this class with {@link #programManagementAccountTypeSort()} initialized to the given value.
     *
     * <p>
     * Sorting options specific to program management account handshakes.
     * </p>
     * 
     * @param programManagementAccountTypeSort
     *        Sorting options specific to program management account handshakes.
     */
    public static ListChannelHandshakesTypeSort fromProgramManagementAccountTypeSort(
            Consumer<ProgramManagementAccountTypeSort.Builder> programManagementAccountTypeSort) {
        ProgramManagementAccountTypeSort.Builder builder = ProgramManagementAccountTypeSort.builder();
        programManagementAccountTypeSort.accept(builder);
        return fromProgramManagementAccountTypeSort(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("startServicePeriodTypeSort", START_SERVICE_PERIOD_TYPE_SORT_FIELD);
        map.put("revokeServicePeriodTypeSort", REVOKE_SERVICE_PERIOD_TYPE_SORT_FIELD);
        map.put("programManagementAccountTypeSort", PROGRAM_MANAGEMENT_ACCOUNT_TYPE_SORT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListChannelHandshakesTypeSort, T> g) {
        return obj -> g.apply((ListChannelHandshakesTypeSort) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ListChannelHandshakesTypeSort> {
        /**
         * <p>
         * Sorting options specific to start service period handshakes.
         * </p>
         * 
         * @param startServicePeriodTypeSort
         *        Sorting options specific to start service period handshakes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startServicePeriodTypeSort(StartServicePeriodTypeSort startServicePeriodTypeSort);

        /**
         * <p>
         * Sorting options specific to start service period handshakes.
         * </p>
         * This is a convenience method that creates an instance of the {@link StartServicePeriodTypeSort.Builder}
         * avoiding the need to create one manually via {@link StartServicePeriodTypeSort#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link StartServicePeriodTypeSort.Builder#build()} is called immediately
         * and its result is passed to {@link #startServicePeriodTypeSort(StartServicePeriodTypeSort)}.
         * 
         * @param startServicePeriodTypeSort
         *        a consumer that will call methods on {@link StartServicePeriodTypeSort.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #startServicePeriodTypeSort(StartServicePeriodTypeSort)
         */
        default Builder startServicePeriodTypeSort(Consumer<StartServicePeriodTypeSort.Builder> startServicePeriodTypeSort) {
            return startServicePeriodTypeSort(StartServicePeriodTypeSort.builder().applyMutation(startServicePeriodTypeSort)
                    .build());
        }

        /**
         * <p>
         * Sorting options specific to revoke service period handshakes.
         * </p>
         * 
         * @param revokeServicePeriodTypeSort
         *        Sorting options specific to revoke service period handshakes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder revokeServicePeriodTypeSort(RevokeServicePeriodTypeSort revokeServicePeriodTypeSort);

        /**
         * <p>
         * Sorting options specific to revoke service period handshakes.
         * </p>
         * This is a convenience method that creates an instance of the {@link RevokeServicePeriodTypeSort.Builder}
         * avoiding the need to create one manually via {@link RevokeServicePeriodTypeSort#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RevokeServicePeriodTypeSort.Builder#build()} is called
         * immediately and its result is passed to {@link #revokeServicePeriodTypeSort(RevokeServicePeriodTypeSort)}.
         * 
         * @param revokeServicePeriodTypeSort
         *        a consumer that will call methods on {@link RevokeServicePeriodTypeSort.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #revokeServicePeriodTypeSort(RevokeServicePeriodTypeSort)
         */
        default Builder revokeServicePeriodTypeSort(Consumer<RevokeServicePeriodTypeSort.Builder> revokeServicePeriodTypeSort) {
            return revokeServicePeriodTypeSort(RevokeServicePeriodTypeSort.builder().applyMutation(revokeServicePeriodTypeSort)
                    .build());
        }

        /**
         * <p>
         * Sorting options specific to program management account handshakes.
         * </p>
         * 
         * @param programManagementAccountTypeSort
         *        Sorting options specific to program management account handshakes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder programManagementAccountTypeSort(ProgramManagementAccountTypeSort programManagementAccountTypeSort);

        /**
         * <p>
         * Sorting options specific to program management account handshakes.
         * </p>
         * This is a convenience method that creates an instance of the {@link ProgramManagementAccountTypeSort.Builder}
         * avoiding the need to create one manually via {@link ProgramManagementAccountTypeSort#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ProgramManagementAccountTypeSort.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #programManagementAccountTypeSort(ProgramManagementAccountTypeSort)}.
         * 
         * @param programManagementAccountTypeSort
         *        a consumer that will call methods on {@link ProgramManagementAccountTypeSort.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #programManagementAccountTypeSort(ProgramManagementAccountTypeSort)
         */
        default Builder programManagementAccountTypeSort(
                Consumer<ProgramManagementAccountTypeSort.Builder> programManagementAccountTypeSort) {
            return programManagementAccountTypeSort(ProgramManagementAccountTypeSort.builder()
                    .applyMutation(programManagementAccountTypeSort).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private StartServicePeriodTypeSort startServicePeriodTypeSort;

        private RevokeServicePeriodTypeSort revokeServicePeriodTypeSort;

        private ProgramManagementAccountTypeSort programManagementAccountTypeSort;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(ListChannelHandshakesTypeSort model) {
            startServicePeriodTypeSort(model.startServicePeriodTypeSort);
            revokeServicePeriodTypeSort(model.revokeServicePeriodTypeSort);
            programManagementAccountTypeSort(model.programManagementAccountTypeSort);
        }

        public final StartServicePeriodTypeSort.Builder getStartServicePeriodTypeSort() {
            return startServicePeriodTypeSort != null ? startServicePeriodTypeSort.toBuilder() : null;
        }

        public final void setStartServicePeriodTypeSort(StartServicePeriodTypeSort.BuilderImpl startServicePeriodTypeSort) {
            Object oldValue = this.startServicePeriodTypeSort;
            this.startServicePeriodTypeSort = startServicePeriodTypeSort != null ? startServicePeriodTypeSort.build() : null;
            handleUnionValueChange(Type.START_SERVICE_PERIOD_TYPE_SORT, oldValue, this.startServicePeriodTypeSort);
        }

        @Override
        public final Builder startServicePeriodTypeSort(StartServicePeriodTypeSort startServicePeriodTypeSort) {
            Object oldValue = this.startServicePeriodTypeSort;
            this.startServicePeriodTypeSort = startServicePeriodTypeSort;
            handleUnionValueChange(Type.START_SERVICE_PERIOD_TYPE_SORT, oldValue, this.startServicePeriodTypeSort);
            return this;
        }

        public final RevokeServicePeriodTypeSort.Builder getRevokeServicePeriodTypeSort() {
            return revokeServicePeriodTypeSort != null ? revokeServicePeriodTypeSort.toBuilder() : null;
        }

        public final void setRevokeServicePeriodTypeSort(RevokeServicePeriodTypeSort.BuilderImpl revokeServicePeriodTypeSort) {
            Object oldValue = this.revokeServicePeriodTypeSort;
            this.revokeServicePeriodTypeSort = revokeServicePeriodTypeSort != null ? revokeServicePeriodTypeSort.build() : null;
            handleUnionValueChange(Type.REVOKE_SERVICE_PERIOD_TYPE_SORT, oldValue, this.revokeServicePeriodTypeSort);
        }

        @Override
        public final Builder revokeServicePeriodTypeSort(RevokeServicePeriodTypeSort revokeServicePeriodTypeSort) {
            Object oldValue = this.revokeServicePeriodTypeSort;
            this.revokeServicePeriodTypeSort = revokeServicePeriodTypeSort;
            handleUnionValueChange(Type.REVOKE_SERVICE_PERIOD_TYPE_SORT, oldValue, this.revokeServicePeriodTypeSort);
            return this;
        }

        public final ProgramManagementAccountTypeSort.Builder getProgramManagementAccountTypeSort() {
            return programManagementAccountTypeSort != null ? programManagementAccountTypeSort.toBuilder() : null;
        }

        public final void setProgramManagementAccountTypeSort(
                ProgramManagementAccountTypeSort.BuilderImpl programManagementAccountTypeSort) {
            Object oldValue = this.programManagementAccountTypeSort;
            this.programManagementAccountTypeSort = programManagementAccountTypeSort != null ? programManagementAccountTypeSort
                    .build() : null;
            handleUnionValueChange(Type.PROGRAM_MANAGEMENT_ACCOUNT_TYPE_SORT, oldValue, this.programManagementAccountTypeSort);
        }

        @Override
        public final Builder programManagementAccountTypeSort(ProgramManagementAccountTypeSort programManagementAccountTypeSort) {
            Object oldValue = this.programManagementAccountTypeSort;
            this.programManagementAccountTypeSort = programManagementAccountTypeSort;
            handleUnionValueChange(Type.PROGRAM_MANAGEMENT_ACCOUNT_TYPE_SORT, oldValue, this.programManagementAccountTypeSort);
            return this;
        }

        @Override
        public ListChannelHandshakesTypeSort build() {
            return new ListChannelHandshakesTypeSort(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see ListChannelHandshakesTypeSort#type()
     */
    public enum Type {
        START_SERVICE_PERIOD_TYPE_SORT,

        REVOKE_SERVICE_PERIOD_TYPE_SORT,

        PROGRAM_MANAGEMENT_ACCOUNT_TYPE_SORT,

        UNKNOWN_TO_SDK_VERSION
    }
}
