/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.partnercentralchannel.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Type-specific filters for listing channel handshakes.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListChannelHandshakesTypeFilters implements SdkPojo, Serializable,
        ToCopyableBuilder<ListChannelHandshakesTypeFilters.Builder, ListChannelHandshakesTypeFilters> {
    private static final SdkField<StartServicePeriodTypeFilters> START_SERVICE_PERIOD_TYPE_FILTERS_FIELD = SdkField
            .<StartServicePeriodTypeFilters> builder(MarshallingType.SDK_POJO)
            .memberName("startServicePeriodTypeFilters")
            .getter(getter(ListChannelHandshakesTypeFilters::startServicePeriodTypeFilters))
            .setter(setter(Builder::startServicePeriodTypeFilters))
            .constructor(StartServicePeriodTypeFilters::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startServicePeriodTypeFilters")
                    .build()).build();

    private static final SdkField<RevokeServicePeriodTypeFilters> REVOKE_SERVICE_PERIOD_TYPE_FILTERS_FIELD = SdkField
            .<RevokeServicePeriodTypeFilters> builder(MarshallingType.SDK_POJO)
            .memberName("revokeServicePeriodTypeFilters")
            .getter(getter(ListChannelHandshakesTypeFilters::revokeServicePeriodTypeFilters))
            .setter(setter(Builder::revokeServicePeriodTypeFilters))
            .constructor(RevokeServicePeriodTypeFilters::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("revokeServicePeriodTypeFilters")
                    .build()).build();

    private static final SdkField<ProgramManagementAccountTypeFilters> PROGRAM_MANAGEMENT_ACCOUNT_TYPE_FILTERS_FIELD = SdkField
            .<ProgramManagementAccountTypeFilters> builder(MarshallingType.SDK_POJO)
            .memberName("programManagementAccountTypeFilters")
            .getter(getter(ListChannelHandshakesTypeFilters::programManagementAccountTypeFilters))
            .setter(setter(Builder::programManagementAccountTypeFilters))
            .constructor(ProgramManagementAccountTypeFilters::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("programManagementAccountTypeFilters").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            START_SERVICE_PERIOD_TYPE_FILTERS_FIELD, REVOKE_SERVICE_PERIOD_TYPE_FILTERS_FIELD,
            PROGRAM_MANAGEMENT_ACCOUNT_TYPE_FILTERS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final StartServicePeriodTypeFilters startServicePeriodTypeFilters;

    private final RevokeServicePeriodTypeFilters revokeServicePeriodTypeFilters;

    private final ProgramManagementAccountTypeFilters programManagementAccountTypeFilters;

    private final Type type;

    private ListChannelHandshakesTypeFilters(BuilderImpl builder) {
        this.startServicePeriodTypeFilters = builder.startServicePeriodTypeFilters;
        this.revokeServicePeriodTypeFilters = builder.revokeServicePeriodTypeFilters;
        this.programManagementAccountTypeFilters = builder.programManagementAccountTypeFilters;
        this.type = builder.type;
    }

    /**
     * <p>
     * Filters specific to start service period handshakes.
     * </p>
     * 
     * @return Filters specific to start service period handshakes.
     */
    public final StartServicePeriodTypeFilters startServicePeriodTypeFilters() {
        return startServicePeriodTypeFilters;
    }

    /**
     * <p>
     * Filters specific to revoke service period handshakes.
     * </p>
     * 
     * @return Filters specific to revoke service period handshakes.
     */
    public final RevokeServicePeriodTypeFilters revokeServicePeriodTypeFilters() {
        return revokeServicePeriodTypeFilters;
    }

    /**
     * <p>
     * Filters specific to program management account handshakes.
     * </p>
     * 
     * @return Filters specific to program management account handshakes.
     */
    public final ProgramManagementAccountTypeFilters programManagementAccountTypeFilters() {
        return programManagementAccountTypeFilters;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(startServicePeriodTypeFilters());
        hashCode = 31 * hashCode + Objects.hashCode(revokeServicePeriodTypeFilters());
        hashCode = 31 * hashCode + Objects.hashCode(programManagementAccountTypeFilters());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListChannelHandshakesTypeFilters)) {
            return false;
        }
        ListChannelHandshakesTypeFilters other = (ListChannelHandshakesTypeFilters) obj;
        return Objects.equals(startServicePeriodTypeFilters(), other.startServicePeriodTypeFilters())
                && Objects.equals(revokeServicePeriodTypeFilters(), other.revokeServicePeriodTypeFilters())
                && Objects.equals(programManagementAccountTypeFilters(), other.programManagementAccountTypeFilters());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListChannelHandshakesTypeFilters")
                .add("StartServicePeriodTypeFilters", startServicePeriodTypeFilters())
                .add("RevokeServicePeriodTypeFilters", revokeServicePeriodTypeFilters())
                .add("ProgramManagementAccountTypeFilters", programManagementAccountTypeFilters()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "startServicePeriodTypeFilters":
            return Optional.ofNullable(clazz.cast(startServicePeriodTypeFilters()));
        case "revokeServicePeriodTypeFilters":
            return Optional.ofNullable(clazz.cast(revokeServicePeriodTypeFilters()));
        case "programManagementAccountTypeFilters":
            return Optional.ofNullable(clazz.cast(programManagementAccountTypeFilters()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #startServicePeriodTypeFilters()} initialized to the given value.
     *
     * <p>
     * Filters specific to start service period handshakes.
     * </p>
     * 
     * @param startServicePeriodTypeFilters
     *        Filters specific to start service period handshakes.
     */
    public static ListChannelHandshakesTypeFilters fromStartServicePeriodTypeFilters(
            StartServicePeriodTypeFilters startServicePeriodTypeFilters) {
        return builder().startServicePeriodTypeFilters(startServicePeriodTypeFilters).build();
    }

    /**
     * Create an instance of this class with {@link #startServicePeriodTypeFilters()} initialized to the given value.
     *
     * <p>
     * Filters specific to start service period handshakes.
     * </p>
     * 
     * @param startServicePeriodTypeFilters
     *        Filters specific to start service period handshakes.
     */
    public static ListChannelHandshakesTypeFilters fromStartServicePeriodTypeFilters(
            Consumer<StartServicePeriodTypeFilters.Builder> startServicePeriodTypeFilters) {
        StartServicePeriodTypeFilters.Builder builder = StartServicePeriodTypeFilters.builder();
        startServicePeriodTypeFilters.accept(builder);
        return fromStartServicePeriodTypeFilters(builder.build());
    }

    /**
     * Create an instance of this class with {@link #revokeServicePeriodTypeFilters()} initialized to the given value.
     *
     * <p>
     * Filters specific to revoke service period handshakes.
     * </p>
     * 
     * @param revokeServicePeriodTypeFilters
     *        Filters specific to revoke service period handshakes.
     */
    public static ListChannelHandshakesTypeFilters fromRevokeServicePeriodTypeFilters(
            RevokeServicePeriodTypeFilters revokeServicePeriodTypeFilters) {
        return builder().revokeServicePeriodTypeFilters(revokeServicePeriodTypeFilters).build();
    }

    /**
     * Create an instance of this class with {@link #revokeServicePeriodTypeFilters()} initialized to the given value.
     *
     * <p>
     * Filters specific to revoke service period handshakes.
     * </p>
     * 
     * @param revokeServicePeriodTypeFilters
     *        Filters specific to revoke service period handshakes.
     */
    public static ListChannelHandshakesTypeFilters fromRevokeServicePeriodTypeFilters(
            Consumer<RevokeServicePeriodTypeFilters.Builder> revokeServicePeriodTypeFilters) {
        RevokeServicePeriodTypeFilters.Builder builder = RevokeServicePeriodTypeFilters.builder();
        revokeServicePeriodTypeFilters.accept(builder);
        return fromRevokeServicePeriodTypeFilters(builder.build());
    }

    /**
     * Create an instance of this class with {@link #programManagementAccountTypeFilters()} initialized to the given
     * value.
     *
     * <p>
     * Filters specific to program management account handshakes.
     * </p>
     * 
     * @param programManagementAccountTypeFilters
     *        Filters specific to program management account handshakes.
     */
    public static ListChannelHandshakesTypeFilters fromProgramManagementAccountTypeFilters(
            ProgramManagementAccountTypeFilters programManagementAccountTypeFilters) {
        return builder().programManagementAccountTypeFilters(programManagementAccountTypeFilters).build();
    }

    /**
     * Create an instance of this class with {@link #programManagementAccountTypeFilters()} initialized to the given
     * value.
     *
     * <p>
     * Filters specific to program management account handshakes.
     * </p>
     * 
     * @param programManagementAccountTypeFilters
     *        Filters specific to program management account handshakes.
     */
    public static ListChannelHandshakesTypeFilters fromProgramManagementAccountTypeFilters(
            Consumer<ProgramManagementAccountTypeFilters.Builder> programManagementAccountTypeFilters) {
        ProgramManagementAccountTypeFilters.Builder builder = ProgramManagementAccountTypeFilters.builder();
        programManagementAccountTypeFilters.accept(builder);
        return fromProgramManagementAccountTypeFilters(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("startServicePeriodTypeFilters", START_SERVICE_PERIOD_TYPE_FILTERS_FIELD);
        map.put("revokeServicePeriodTypeFilters", REVOKE_SERVICE_PERIOD_TYPE_FILTERS_FIELD);
        map.put("programManagementAccountTypeFilters", PROGRAM_MANAGEMENT_ACCOUNT_TYPE_FILTERS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListChannelHandshakesTypeFilters, T> g) {
        return obj -> g.apply((ListChannelHandshakesTypeFilters) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ListChannelHandshakesTypeFilters> {
        /**
         * <p>
         * Filters specific to start service period handshakes.
         * </p>
         * 
         * @param startServicePeriodTypeFilters
         *        Filters specific to start service period handshakes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startServicePeriodTypeFilters(StartServicePeriodTypeFilters startServicePeriodTypeFilters);

        /**
         * <p>
         * Filters specific to start service period handshakes.
         * </p>
         * This is a convenience method that creates an instance of the {@link StartServicePeriodTypeFilters.Builder}
         * avoiding the need to create one manually via {@link StartServicePeriodTypeFilters#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link StartServicePeriodTypeFilters.Builder#build()} is called
         * immediately and its result is passed to {@link #startServicePeriodTypeFilters(StartServicePeriodTypeFilters)}.
         * 
         * @param startServicePeriodTypeFilters
         *        a consumer that will call methods on {@link StartServicePeriodTypeFilters.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #startServicePeriodTypeFilters(StartServicePeriodTypeFilters)
         */
        default Builder startServicePeriodTypeFilters(
                Consumer<StartServicePeriodTypeFilters.Builder> startServicePeriodTypeFilters) {
            return startServicePeriodTypeFilters(StartServicePeriodTypeFilters.builder()
                    .applyMutation(startServicePeriodTypeFilters).build());
        }

        /**
         * <p>
         * Filters specific to revoke service period handshakes.
         * </p>
         * 
         * @param revokeServicePeriodTypeFilters
         *        Filters specific to revoke service period handshakes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder revokeServicePeriodTypeFilters(RevokeServicePeriodTypeFilters revokeServicePeriodTypeFilters);

        /**
         * <p>
         * Filters specific to revoke service period handshakes.
         * </p>
         * This is a convenience method that creates an instance of the {@link RevokeServicePeriodTypeFilters.Builder}
         * avoiding the need to create one manually via {@link RevokeServicePeriodTypeFilters#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RevokeServicePeriodTypeFilters.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #revokeServicePeriodTypeFilters(RevokeServicePeriodTypeFilters)}.
         * 
         * @param revokeServicePeriodTypeFilters
         *        a consumer that will call methods on {@link RevokeServicePeriodTypeFilters.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #revokeServicePeriodTypeFilters(RevokeServicePeriodTypeFilters)
         */
        default Builder revokeServicePeriodTypeFilters(
                Consumer<RevokeServicePeriodTypeFilters.Builder> revokeServicePeriodTypeFilters) {
            return revokeServicePeriodTypeFilters(RevokeServicePeriodTypeFilters.builder()
                    .applyMutation(revokeServicePeriodTypeFilters).build());
        }

        /**
         * <p>
         * Filters specific to program management account handshakes.
         * </p>
         * 
         * @param programManagementAccountTypeFilters
         *        Filters specific to program management account handshakes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder programManagementAccountTypeFilters(ProgramManagementAccountTypeFilters programManagementAccountTypeFilters);

        /**
         * <p>
         * Filters specific to program management account handshakes.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link ProgramManagementAccountTypeFilters.Builder} avoiding the need to create one manually via
         * {@link ProgramManagementAccountTypeFilters#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ProgramManagementAccountTypeFilters.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #programManagementAccountTypeFilters(ProgramManagementAccountTypeFilters)}.
         * 
         * @param programManagementAccountTypeFilters
         *        a consumer that will call methods on {@link ProgramManagementAccountTypeFilters.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #programManagementAccountTypeFilters(ProgramManagementAccountTypeFilters)
         */
        default Builder programManagementAccountTypeFilters(
                Consumer<ProgramManagementAccountTypeFilters.Builder> programManagementAccountTypeFilters) {
            return programManagementAccountTypeFilters(ProgramManagementAccountTypeFilters.builder()
                    .applyMutation(programManagementAccountTypeFilters).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private StartServicePeriodTypeFilters startServicePeriodTypeFilters;

        private RevokeServicePeriodTypeFilters revokeServicePeriodTypeFilters;

        private ProgramManagementAccountTypeFilters programManagementAccountTypeFilters;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(ListChannelHandshakesTypeFilters model) {
            startServicePeriodTypeFilters(model.startServicePeriodTypeFilters);
            revokeServicePeriodTypeFilters(model.revokeServicePeriodTypeFilters);
            programManagementAccountTypeFilters(model.programManagementAccountTypeFilters);
        }

        public final StartServicePeriodTypeFilters.Builder getStartServicePeriodTypeFilters() {
            return startServicePeriodTypeFilters != null ? startServicePeriodTypeFilters.toBuilder() : null;
        }

        public final void setStartServicePeriodTypeFilters(StartServicePeriodTypeFilters.BuilderImpl startServicePeriodTypeFilters) {
            Object oldValue = this.startServicePeriodTypeFilters;
            this.startServicePeriodTypeFilters = startServicePeriodTypeFilters != null ? startServicePeriodTypeFilters.build()
                    : null;
            handleUnionValueChange(Type.START_SERVICE_PERIOD_TYPE_FILTERS, oldValue, this.startServicePeriodTypeFilters);
        }

        @Override
        public final Builder startServicePeriodTypeFilters(StartServicePeriodTypeFilters startServicePeriodTypeFilters) {
            Object oldValue = this.startServicePeriodTypeFilters;
            this.startServicePeriodTypeFilters = startServicePeriodTypeFilters;
            handleUnionValueChange(Type.START_SERVICE_PERIOD_TYPE_FILTERS, oldValue, this.startServicePeriodTypeFilters);
            return this;
        }

        public final RevokeServicePeriodTypeFilters.Builder getRevokeServicePeriodTypeFilters() {
            return revokeServicePeriodTypeFilters != null ? revokeServicePeriodTypeFilters.toBuilder() : null;
        }

        public final void setRevokeServicePeriodTypeFilters(
                RevokeServicePeriodTypeFilters.BuilderImpl revokeServicePeriodTypeFilters) {
            Object oldValue = this.revokeServicePeriodTypeFilters;
            this.revokeServicePeriodTypeFilters = revokeServicePeriodTypeFilters != null ? revokeServicePeriodTypeFilters.build()
                    : null;
            handleUnionValueChange(Type.REVOKE_SERVICE_PERIOD_TYPE_FILTERS, oldValue, this.revokeServicePeriodTypeFilters);
        }

        @Override
        public final Builder revokeServicePeriodTypeFilters(RevokeServicePeriodTypeFilters revokeServicePeriodTypeFilters) {
            Object oldValue = this.revokeServicePeriodTypeFilters;
            this.revokeServicePeriodTypeFilters = revokeServicePeriodTypeFilters;
            handleUnionValueChange(Type.REVOKE_SERVICE_PERIOD_TYPE_FILTERS, oldValue, this.revokeServicePeriodTypeFilters);
            return this;
        }

        public final ProgramManagementAccountTypeFilters.Builder getProgramManagementAccountTypeFilters() {
            return programManagementAccountTypeFilters != null ? programManagementAccountTypeFilters.toBuilder() : null;
        }

        public final void setProgramManagementAccountTypeFilters(
                ProgramManagementAccountTypeFilters.BuilderImpl programManagementAccountTypeFilters) {
            Object oldValue = this.programManagementAccountTypeFilters;
            this.programManagementAccountTypeFilters = programManagementAccountTypeFilters != null ? programManagementAccountTypeFilters
                    .build() : null;
            handleUnionValueChange(Type.PROGRAM_MANAGEMENT_ACCOUNT_TYPE_FILTERS, oldValue,
                    this.programManagementAccountTypeFilters);
        }

        @Override
        public final Builder programManagementAccountTypeFilters(
                ProgramManagementAccountTypeFilters programManagementAccountTypeFilters) {
            Object oldValue = this.programManagementAccountTypeFilters;
            this.programManagementAccountTypeFilters = programManagementAccountTypeFilters;
            handleUnionValueChange(Type.PROGRAM_MANAGEMENT_ACCOUNT_TYPE_FILTERS, oldValue,
                    this.programManagementAccountTypeFilters);
            return this;
        }

        @Override
        public ListChannelHandshakesTypeFilters build() {
            return new ListChannelHandshakesTypeFilters(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see ListChannelHandshakesTypeFilters#type()
     */
    public enum Type {
        START_SERVICE_PERIOD_TYPE_FILTERS,

        REVOKE_SERVICE_PERIOD_TYPE_FILTERS,

        PROGRAM_MANAGEMENT_ACCOUNT_TYPE_FILTERS,

        UNKNOWN_TO_SDK_VERSION
    }
}
