/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.partnercentralchannel.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateProgramManagementAccountRequest extends PartnerCentralChannelRequest implements
        ToCopyableBuilder<CreateProgramManagementAccountRequest.Builder, CreateProgramManagementAccountRequest> {
    private static final SdkField<String> CATALOG_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("catalog")
            .getter(getter(CreateProgramManagementAccountRequest::catalog)).setter(setter(Builder::catalog))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("catalog").build()).build();

    private static final SdkField<String> PROGRAM_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("program")
            .getter(getter(CreateProgramManagementAccountRequest::programAsString)).setter(setter(Builder::program))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("program").build()).build();

    private static final SdkField<String> DISPLAY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("displayName").getter(getter(CreateProgramManagementAccountRequest::displayName))
            .setter(setter(Builder::displayName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("displayName").build()).build();

    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("accountId").getter(getter(CreateProgramManagementAccountRequest::accountId))
            .setter(setter(Builder::accountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accountId").build()).build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("clientToken")
            .getter(getter(CreateProgramManagementAccountRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("tags")
            .getter(getter(CreateProgramManagementAccountRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CATALOG_FIELD, PROGRAM_FIELD,
            DISPLAY_NAME_FIELD, ACCOUNT_ID_FIELD, CLIENT_TOKEN_FIELD, TAGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String catalog;

    private final String program;

    private final String displayName;

    private final String accountId;

    private final String clientToken;

    private final List<Tag> tags;

    private CreateProgramManagementAccountRequest(BuilderImpl builder) {
        super(builder);
        this.catalog = builder.catalog;
        this.program = builder.program;
        this.displayName = builder.displayName;
        this.accountId = builder.accountId;
        this.clientToken = builder.clientToken;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The catalog identifier for the program management account.
     * </p>
     * 
     * @return The catalog identifier for the program management account.
     */
    public final String catalog() {
        return catalog;
    }

    /**
     * <p>
     * The program type for the management account.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #program} will
     * return {@link Program#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #programAsString}.
     * </p>
     * 
     * @return The program type for the management account.
     * @see Program
     */
    public final Program program() {
        return Program.fromValue(program);
    }

    /**
     * <p>
     * The program type for the management account.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #program} will
     * return {@link Program#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #programAsString}.
     * </p>
     * 
     * @return The program type for the management account.
     * @see Program
     */
    public final String programAsString() {
        return program;
    }

    /**
     * <p>
     * A human-readable name for the program management account.
     * </p>
     * 
     * @return A human-readable name for the program management account.
     */
    public final String displayName() {
        return displayName;
    }

    /**
     * <p>
     * The AWS account ID to associate with the program management account.
     * </p>
     * 
     * @return The AWS account ID to associate with the program management account.
     */
    public final String accountId() {
        return accountId;
    }

    /**
     * <p>
     * A unique, case-sensitive identifier to ensure idempotency of the request.
     * </p>
     * 
     * @return A unique, case-sensitive identifier to ensure idempotency of the request.
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Key-value pairs to associate with the program management account.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return Key-value pairs to associate with the program management account.
     */
    public final List<Tag> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(catalog());
        hashCode = 31 * hashCode + Objects.hashCode(programAsString());
        hashCode = 31 * hashCode + Objects.hashCode(displayName());
        hashCode = 31 * hashCode + Objects.hashCode(accountId());
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateProgramManagementAccountRequest)) {
            return false;
        }
        CreateProgramManagementAccountRequest other = (CreateProgramManagementAccountRequest) obj;
        return Objects.equals(catalog(), other.catalog()) && Objects.equals(programAsString(), other.programAsString())
                && Objects.equals(displayName(), other.displayName()) && Objects.equals(accountId(), other.accountId())
                && Objects.equals(clientToken(), other.clientToken()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateProgramManagementAccountRequest").add("Catalog", catalog())
                .add("Program", programAsString()).add("DisplayName", displayName()).add("AccountId", accountId())
                .add("ClientToken", clientToken()).add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "catalog":
            return Optional.ofNullable(clazz.cast(catalog()));
        case "program":
            return Optional.ofNullable(clazz.cast(programAsString()));
        case "displayName":
            return Optional.ofNullable(clazz.cast(displayName()));
        case "accountId":
            return Optional.ofNullable(clazz.cast(accountId()));
        case "clientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("catalog", CATALOG_FIELD);
        map.put("program", PROGRAM_FIELD);
        map.put("displayName", DISPLAY_NAME_FIELD);
        map.put("accountId", ACCOUNT_ID_FIELD);
        map.put("clientToken", CLIENT_TOKEN_FIELD);
        map.put("tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateProgramManagementAccountRequest, T> g) {
        return obj -> g.apply((CreateProgramManagementAccountRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends PartnerCentralChannelRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateProgramManagementAccountRequest> {
        /**
         * <p>
         * The catalog identifier for the program management account.
         * </p>
         * 
         * @param catalog
         *        The catalog identifier for the program management account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder catalog(String catalog);

        /**
         * <p>
         * The program type for the management account.
         * </p>
         * 
         * @param program
         *        The program type for the management account.
         * @see Program
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Program
         */
        Builder program(String program);

        /**
         * <p>
         * The program type for the management account.
         * </p>
         * 
         * @param program
         *        The program type for the management account.
         * @see Program
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Program
         */
        Builder program(Program program);

        /**
         * <p>
         * A human-readable name for the program management account.
         * </p>
         * 
         * @param displayName
         *        A human-readable name for the program management account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder displayName(String displayName);

        /**
         * <p>
         * The AWS account ID to associate with the program management account.
         * </p>
         * 
         * @param accountId
         *        The AWS account ID to associate with the program management account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountId(String accountId);

        /**
         * <p>
         * A unique, case-sensitive identifier to ensure idempotency of the request.
         * </p>
         * 
         * @param clientToken
         *        A unique, case-sensitive identifier to ensure idempotency of the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * Key-value pairs to associate with the program management account.
         * </p>
         * 
         * @param tags
         *        Key-value pairs to associate with the program management account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * Key-value pairs to associate with the program management account.
         * </p>
         * 
         * @param tags
         *        Key-value pairs to associate with the program management account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * Key-value pairs to associate with the program management account.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.partnercentralchannel.model.Tag.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.partnercentralchannel.model.Tag#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.partnercentralchannel.model.Tag.Builder#build()} is called immediately
         * and its result is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.partnercentralchannel.model.Tag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(java.util.Collection<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends PartnerCentralChannelRequest.BuilderImpl implements Builder {
        private String catalog;

        private String program;

        private String displayName;

        private String accountId;

        private String clientToken;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateProgramManagementAccountRequest model) {
            super(model);
            catalog(model.catalog);
            program(model.program);
            displayName(model.displayName);
            accountId(model.accountId);
            clientToken(model.clientToken);
            tags(model.tags);
        }

        public final String getCatalog() {
            return catalog;
        }

        public final void setCatalog(String catalog) {
            this.catalog = catalog;
        }

        @Override
        public final Builder catalog(String catalog) {
            this.catalog = catalog;
            return this;
        }

        public final String getProgram() {
            return program;
        }

        public final void setProgram(String program) {
            this.program = program;
        }

        @Override
        public final Builder program(String program) {
            this.program = program;
            return this;
        }

        @Override
        public final Builder program(Program program) {
            this.program(program == null ? null : program.toString());
            return this;
        }

        public final String getDisplayName() {
            return displayName;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        @Override
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public final String getAccountId() {
            return accountId;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateProgramManagementAccountRequest build() {
            return new CreateProgramManagementAccountRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
