/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.partnercentralchannel.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Summary information about a channel handshake.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ChannelHandshakeSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<ChannelHandshakeSummary.Builder, ChannelHandshakeSummary> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(ChannelHandshakeSummary::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("arn")
            .getter(getter(ChannelHandshakeSummary::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<String> CATALOG_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("catalog")
            .getter(getter(ChannelHandshakeSummary::catalog)).setter(setter(Builder::catalog))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("catalog").build()).build();

    private static final SdkField<String> HANDSHAKE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("handshakeType").getter(getter(ChannelHandshakeSummary::handshakeTypeAsString))
            .setter(setter(Builder::handshakeType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("handshakeType").build()).build();

    private static final SdkField<String> OWNER_ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ownerAccountId").getter(getter(ChannelHandshakeSummary::ownerAccountId))
            .setter(setter(Builder::ownerAccountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ownerAccountId").build()).build();

    private static final SdkField<String> SENDER_ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("senderAccountId").getter(getter(ChannelHandshakeSummary::senderAccountId))
            .setter(setter(Builder::senderAccountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("senderAccountId").build()).build();

    private static final SdkField<String> SENDER_DISPLAY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("senderDisplayName").getter(getter(ChannelHandshakeSummary::senderDisplayName))
            .setter(setter(Builder::senderDisplayName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("senderDisplayName").build()).build();

    private static final SdkField<String> RECEIVER_ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("receiverAccountId").getter(getter(ChannelHandshakeSummary::receiverAccountId))
            .setter(setter(Builder::receiverAccountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("receiverAccountId").build()).build();

    private static final SdkField<String> ASSOCIATED_RESOURCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("associatedResourceId").getter(getter(ChannelHandshakeSummary::associatedResourceId))
            .setter(setter(Builder::associatedResourceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("associatedResourceId").build())
            .build();

    private static final SdkField<HandshakeDetail> DETAIL_FIELD = SdkField.<HandshakeDetail> builder(MarshallingType.SDK_POJO)
            .memberName("detail").getter(getter(ChannelHandshakeSummary::detail)).setter(setter(Builder::detail))
            .constructor(HandshakeDetail::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("detail").build()).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdAt")
            .getter(getter(ChannelHandshakeSummary::createdAt))
            .setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("updatedAt")
            .getter(getter(ChannelHandshakeSummary::updatedAt))
            .setter(setter(Builder::updatedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(ChannelHandshakeSummary::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, ARN_FIELD,
            CATALOG_FIELD, HANDSHAKE_TYPE_FIELD, OWNER_ACCOUNT_ID_FIELD, SENDER_ACCOUNT_ID_FIELD, SENDER_DISPLAY_NAME_FIELD,
            RECEIVER_ACCOUNT_ID_FIELD, ASSOCIATED_RESOURCE_ID_FIELD, DETAIL_FIELD, CREATED_AT_FIELD, UPDATED_AT_FIELD,
            STATUS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String id;

    private final String arn;

    private final String catalog;

    private final String handshakeType;

    private final String ownerAccountId;

    private final String senderAccountId;

    private final String senderDisplayName;

    private final String receiverAccountId;

    private final String associatedResourceId;

    private final HandshakeDetail detail;

    private final Instant createdAt;

    private final Instant updatedAt;

    private final String status;

    private ChannelHandshakeSummary(BuilderImpl builder) {
        this.id = builder.id;
        this.arn = builder.arn;
        this.catalog = builder.catalog;
        this.handshakeType = builder.handshakeType;
        this.ownerAccountId = builder.ownerAccountId;
        this.senderAccountId = builder.senderAccountId;
        this.senderDisplayName = builder.senderDisplayName;
        this.receiverAccountId = builder.receiverAccountId;
        this.associatedResourceId = builder.associatedResourceId;
        this.detail = builder.detail;
        this.createdAt = builder.createdAt;
        this.updatedAt = builder.updatedAt;
        this.status = builder.status;
    }

    /**
     * <p>
     * The unique identifier of the handshake.
     * </p>
     * 
     * @return The unique identifier of the handshake.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the handshake.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the handshake.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The catalog identifier associated with the handshake.
     * </p>
     * 
     * @return The catalog identifier associated with the handshake.
     */
    public final String catalog() {
        return catalog;
    }

    /**
     * <p>
     * The type of the handshake.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #handshakeType}
     * will return {@link HandshakeType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #handshakeTypeAsString}.
     * </p>
     * 
     * @return The type of the handshake.
     * @see HandshakeType
     */
    public final HandshakeType handshakeType() {
        return HandshakeType.fromValue(handshakeType);
    }

    /**
     * <p>
     * The type of the handshake.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #handshakeType}
     * will return {@link HandshakeType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #handshakeTypeAsString}.
     * </p>
     * 
     * @return The type of the handshake.
     * @see HandshakeType
     */
    public final String handshakeTypeAsString() {
        return handshakeType;
    }

    /**
     * <p>
     * The AWS account ID of the handshake owner.
     * </p>
     * 
     * @return The AWS account ID of the handshake owner.
     */
    public final String ownerAccountId() {
        return ownerAccountId;
    }

    /**
     * <p>
     * The AWS account ID of the handshake sender.
     * </p>
     * 
     * @return The AWS account ID of the handshake sender.
     */
    public final String senderAccountId() {
        return senderAccountId;
    }

    /**
     * <p>
     * The display name of the handshake sender.
     * </p>
     * 
     * @return The display name of the handshake sender.
     */
    public final String senderDisplayName() {
        return senderDisplayName;
    }

    /**
     * <p>
     * The AWS account ID of the handshake receiver.
     * </p>
     * 
     * @return The AWS account ID of the handshake receiver.
     */
    public final String receiverAccountId() {
        return receiverAccountId;
    }

    /**
     * <p>
     * The identifier of the resource associated with the handshake.
     * </p>
     * 
     * @return The identifier of the resource associated with the handshake.
     */
    public final String associatedResourceId() {
        return associatedResourceId;
    }

    /**
     * <p>
     * Detailed information about the handshake.
     * </p>
     * 
     * @return Detailed information about the handshake.
     */
    public final HandshakeDetail detail() {
        return detail;
    }

    /**
     * <p>
     * The timestamp when the handshake was created.
     * </p>
     * 
     * @return The timestamp when the handshake was created.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * The timestamp when the handshake was last updated.
     * </p>
     * 
     * @return The timestamp when the handshake was last updated.
     */
    public final Instant updatedAt() {
        return updatedAt;
    }

    /**
     * <p>
     * The current status of the handshake.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link HandshakeStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of the handshake.
     * @see HandshakeStatus
     */
    public final HandshakeStatus status() {
        return HandshakeStatus.fromValue(status);
    }

    /**
     * <p>
     * The current status of the handshake.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link HandshakeStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of the handshake.
     * @see HandshakeStatus
     */
    public final String statusAsString() {
        return status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(catalog());
        hashCode = 31 * hashCode + Objects.hashCode(handshakeTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(ownerAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(senderAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(senderDisplayName());
        hashCode = 31 * hashCode + Objects.hashCode(receiverAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(associatedResourceId());
        hashCode = 31 * hashCode + Objects.hashCode(detail());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(updatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ChannelHandshakeSummary)) {
            return false;
        }
        ChannelHandshakeSummary other = (ChannelHandshakeSummary) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(arn(), other.arn())
                && Objects.equals(catalog(), other.catalog())
                && Objects.equals(handshakeTypeAsString(), other.handshakeTypeAsString())
                && Objects.equals(ownerAccountId(), other.ownerAccountId())
                && Objects.equals(senderAccountId(), other.senderAccountId())
                && Objects.equals(senderDisplayName(), other.senderDisplayName())
                && Objects.equals(receiverAccountId(), other.receiverAccountId())
                && Objects.equals(associatedResourceId(), other.associatedResourceId())
                && Objects.equals(detail(), other.detail()) && Objects.equals(createdAt(), other.createdAt())
                && Objects.equals(updatedAt(), other.updatedAt()) && Objects.equals(statusAsString(), other.statusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ChannelHandshakeSummary").add("Id", id()).add("Arn", arn()).add("Catalog", catalog())
                .add("HandshakeType", handshakeTypeAsString()).add("OwnerAccountId", ownerAccountId())
                .add("SenderAccountId", senderAccountId()).add("SenderDisplayName", senderDisplayName())
                .add("ReceiverAccountId", receiverAccountId()).add("AssociatedResourceId", associatedResourceId())
                .add("Detail", detail()).add("CreatedAt", createdAt()).add("UpdatedAt", updatedAt())
                .add("Status", statusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "catalog":
            return Optional.ofNullable(clazz.cast(catalog()));
        case "handshakeType":
            return Optional.ofNullable(clazz.cast(handshakeTypeAsString()));
        case "ownerAccountId":
            return Optional.ofNullable(clazz.cast(ownerAccountId()));
        case "senderAccountId":
            return Optional.ofNullable(clazz.cast(senderAccountId()));
        case "senderDisplayName":
            return Optional.ofNullable(clazz.cast(senderDisplayName()));
        case "receiverAccountId":
            return Optional.ofNullable(clazz.cast(receiverAccountId()));
        case "associatedResourceId":
            return Optional.ofNullable(clazz.cast(associatedResourceId()));
        case "detail":
            return Optional.ofNullable(clazz.cast(detail()));
        case "createdAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "updatedAt":
            return Optional.ofNullable(clazz.cast(updatedAt()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("id", ID_FIELD);
        map.put("arn", ARN_FIELD);
        map.put("catalog", CATALOG_FIELD);
        map.put("handshakeType", HANDSHAKE_TYPE_FIELD);
        map.put("ownerAccountId", OWNER_ACCOUNT_ID_FIELD);
        map.put("senderAccountId", SENDER_ACCOUNT_ID_FIELD);
        map.put("senderDisplayName", SENDER_DISPLAY_NAME_FIELD);
        map.put("receiverAccountId", RECEIVER_ACCOUNT_ID_FIELD);
        map.put("associatedResourceId", ASSOCIATED_RESOURCE_ID_FIELD);
        map.put("detail", DETAIL_FIELD);
        map.put("createdAt", CREATED_AT_FIELD);
        map.put("updatedAt", UPDATED_AT_FIELD);
        map.put("status", STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ChannelHandshakeSummary, T> g) {
        return obj -> g.apply((ChannelHandshakeSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ChannelHandshakeSummary> {
        /**
         * <p>
         * The unique identifier of the handshake.
         * </p>
         * 
         * @param id
         *        The unique identifier of the handshake.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the handshake.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) of the handshake.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The catalog identifier associated with the handshake.
         * </p>
         * 
         * @param catalog
         *        The catalog identifier associated with the handshake.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder catalog(String catalog);

        /**
         * <p>
         * The type of the handshake.
         * </p>
         * 
         * @param handshakeType
         *        The type of the handshake.
         * @see HandshakeType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HandshakeType
         */
        Builder handshakeType(String handshakeType);

        /**
         * <p>
         * The type of the handshake.
         * </p>
         * 
         * @param handshakeType
         *        The type of the handshake.
         * @see HandshakeType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HandshakeType
         */
        Builder handshakeType(HandshakeType handshakeType);

        /**
         * <p>
         * The AWS account ID of the handshake owner.
         * </p>
         * 
         * @param ownerAccountId
         *        The AWS account ID of the handshake owner.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ownerAccountId(String ownerAccountId);

        /**
         * <p>
         * The AWS account ID of the handshake sender.
         * </p>
         * 
         * @param senderAccountId
         *        The AWS account ID of the handshake sender.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder senderAccountId(String senderAccountId);

        /**
         * <p>
         * The display name of the handshake sender.
         * </p>
         * 
         * @param senderDisplayName
         *        The display name of the handshake sender.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder senderDisplayName(String senderDisplayName);

        /**
         * <p>
         * The AWS account ID of the handshake receiver.
         * </p>
         * 
         * @param receiverAccountId
         *        The AWS account ID of the handshake receiver.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder receiverAccountId(String receiverAccountId);

        /**
         * <p>
         * The identifier of the resource associated with the handshake.
         * </p>
         * 
         * @param associatedResourceId
         *        The identifier of the resource associated with the handshake.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder associatedResourceId(String associatedResourceId);

        /**
         * <p>
         * Detailed information about the handshake.
         * </p>
         * 
         * @param detail
         *        Detailed information about the handshake.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder detail(HandshakeDetail detail);

        /**
         * <p>
         * Detailed information about the handshake.
         * </p>
         * This is a convenience method that creates an instance of the {@link HandshakeDetail.Builder} avoiding the
         * need to create one manually via {@link HandshakeDetail#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link HandshakeDetail.Builder#build()} is called immediately and its
         * result is passed to {@link #detail(HandshakeDetail)}.
         * 
         * @param detail
         *        a consumer that will call methods on {@link HandshakeDetail.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #detail(HandshakeDetail)
         */
        default Builder detail(Consumer<HandshakeDetail.Builder> detail) {
            return detail(HandshakeDetail.builder().applyMutation(detail).build());
        }

        /**
         * <p>
         * The timestamp when the handshake was created.
         * </p>
         * 
         * @param createdAt
         *        The timestamp when the handshake was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * The timestamp when the handshake was last updated.
         * </p>
         * 
         * @param updatedAt
         *        The timestamp when the handshake was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updatedAt(Instant updatedAt);

        /**
         * <p>
         * The current status of the handshake.
         * </p>
         * 
         * @param status
         *        The current status of the handshake.
         * @see HandshakeStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HandshakeStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The current status of the handshake.
         * </p>
         * 
         * @param status
         *        The current status of the handshake.
         * @see HandshakeStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HandshakeStatus
         */
        Builder status(HandshakeStatus status);
    }

    static final class BuilderImpl implements Builder {
        private String id;

        private String arn;

        private String catalog;

        private String handshakeType;

        private String ownerAccountId;

        private String senderAccountId;

        private String senderDisplayName;

        private String receiverAccountId;

        private String associatedResourceId;

        private HandshakeDetail detail;

        private Instant createdAt;

        private Instant updatedAt;

        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(ChannelHandshakeSummary model) {
            id(model.id);
            arn(model.arn);
            catalog(model.catalog);
            handshakeType(model.handshakeType);
            ownerAccountId(model.ownerAccountId);
            senderAccountId(model.senderAccountId);
            senderDisplayName(model.senderDisplayName);
            receiverAccountId(model.receiverAccountId);
            associatedResourceId(model.associatedResourceId);
            detail(model.detail);
            createdAt(model.createdAt);
            updatedAt(model.updatedAt);
            status(model.status);
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getCatalog() {
            return catalog;
        }

        public final void setCatalog(String catalog) {
            this.catalog = catalog;
        }

        @Override
        public final Builder catalog(String catalog) {
            this.catalog = catalog;
            return this;
        }

        public final String getHandshakeType() {
            return handshakeType;
        }

        public final void setHandshakeType(String handshakeType) {
            this.handshakeType = handshakeType;
        }

        @Override
        public final Builder handshakeType(String handshakeType) {
            this.handshakeType = handshakeType;
            return this;
        }

        @Override
        public final Builder handshakeType(HandshakeType handshakeType) {
            this.handshakeType(handshakeType == null ? null : handshakeType.toString());
            return this;
        }

        public final String getOwnerAccountId() {
            return ownerAccountId;
        }

        public final void setOwnerAccountId(String ownerAccountId) {
            this.ownerAccountId = ownerAccountId;
        }

        @Override
        public final Builder ownerAccountId(String ownerAccountId) {
            this.ownerAccountId = ownerAccountId;
            return this;
        }

        public final String getSenderAccountId() {
            return senderAccountId;
        }

        public final void setSenderAccountId(String senderAccountId) {
            this.senderAccountId = senderAccountId;
        }

        @Override
        public final Builder senderAccountId(String senderAccountId) {
            this.senderAccountId = senderAccountId;
            return this;
        }

        public final String getSenderDisplayName() {
            return senderDisplayName;
        }

        public final void setSenderDisplayName(String senderDisplayName) {
            this.senderDisplayName = senderDisplayName;
        }

        @Override
        public final Builder senderDisplayName(String senderDisplayName) {
            this.senderDisplayName = senderDisplayName;
            return this;
        }

        public final String getReceiverAccountId() {
            return receiverAccountId;
        }

        public final void setReceiverAccountId(String receiverAccountId) {
            this.receiverAccountId = receiverAccountId;
        }

        @Override
        public final Builder receiverAccountId(String receiverAccountId) {
            this.receiverAccountId = receiverAccountId;
            return this;
        }

        public final String getAssociatedResourceId() {
            return associatedResourceId;
        }

        public final void setAssociatedResourceId(String associatedResourceId) {
            this.associatedResourceId = associatedResourceId;
        }

        @Override
        public final Builder associatedResourceId(String associatedResourceId) {
            this.associatedResourceId = associatedResourceId;
            return this;
        }

        public final HandshakeDetail.Builder getDetail() {
            return detail != null ? detail.toBuilder() : null;
        }

        public final void setDetail(HandshakeDetail.BuilderImpl detail) {
            this.detail = detail != null ? detail.build() : null;
        }

        @Override
        public final Builder detail(HandshakeDetail detail) {
            this.detail = detail;
            return this;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Instant getUpdatedAt() {
            return updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(HandshakeStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        @Override
        public ChannelHandshakeSummary build() {
            return new ChannelHandshakeSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
