/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.partnercentralchannel.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class AcceptChannelHandshakeResponse extends PartnerCentralChannelResponse implements
        ToCopyableBuilder<AcceptChannelHandshakeResponse.Builder, AcceptChannelHandshakeResponse> {
    private static final SdkField<AcceptChannelHandshakeDetail> CHANNEL_HANDSHAKE_DETAIL_FIELD = SdkField
            .<AcceptChannelHandshakeDetail> builder(MarshallingType.SDK_POJO).memberName("channelHandshakeDetail")
            .getter(getter(AcceptChannelHandshakeResponse::channelHandshakeDetail))
            .setter(setter(Builder::channelHandshakeDetail)).constructor(AcceptChannelHandshakeDetail::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("channelHandshakeDetail").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(CHANNEL_HANDSHAKE_DETAIL_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final AcceptChannelHandshakeDetail channelHandshakeDetail;

    private AcceptChannelHandshakeResponse(BuilderImpl builder) {
        super(builder);
        this.channelHandshakeDetail = builder.channelHandshakeDetail;
    }

    /**
     * <p>
     * Details of the accepted channel handshake.
     * </p>
     * 
     * @return Details of the accepted channel handshake.
     */
    public final AcceptChannelHandshakeDetail channelHandshakeDetail() {
        return channelHandshakeDetail;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(channelHandshakeDetail());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AcceptChannelHandshakeResponse)) {
            return false;
        }
        AcceptChannelHandshakeResponse other = (AcceptChannelHandshakeResponse) obj;
        return Objects.equals(channelHandshakeDetail(), other.channelHandshakeDetail());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AcceptChannelHandshakeResponse").add("ChannelHandshakeDetail", channelHandshakeDetail()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "channelHandshakeDetail":
            return Optional.ofNullable(clazz.cast(channelHandshakeDetail()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("channelHandshakeDetail", CHANNEL_HANDSHAKE_DETAIL_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AcceptChannelHandshakeResponse, T> g) {
        return obj -> g.apply((AcceptChannelHandshakeResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends PartnerCentralChannelResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, AcceptChannelHandshakeResponse> {
        /**
         * <p>
         * Details of the accepted channel handshake.
         * </p>
         * 
         * @param channelHandshakeDetail
         *        Details of the accepted channel handshake.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder channelHandshakeDetail(AcceptChannelHandshakeDetail channelHandshakeDetail);

        /**
         * <p>
         * Details of the accepted channel handshake.
         * </p>
         * This is a convenience method that creates an instance of the {@link AcceptChannelHandshakeDetail.Builder}
         * avoiding the need to create one manually via {@link AcceptChannelHandshakeDetail#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AcceptChannelHandshakeDetail.Builder#build()} is called
         * immediately and its result is passed to {@link #channelHandshakeDetail(AcceptChannelHandshakeDetail)}.
         * 
         * @param channelHandshakeDetail
         *        a consumer that will call methods on {@link AcceptChannelHandshakeDetail.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #channelHandshakeDetail(AcceptChannelHandshakeDetail)
         */
        default Builder channelHandshakeDetail(Consumer<AcceptChannelHandshakeDetail.Builder> channelHandshakeDetail) {
            return channelHandshakeDetail(AcceptChannelHandshakeDetail.builder().applyMutation(channelHandshakeDetail).build());
        }
    }

    static final class BuilderImpl extends PartnerCentralChannelResponse.BuilderImpl implements Builder {
        private AcceptChannelHandshakeDetail channelHandshakeDetail;

        private BuilderImpl() {
        }

        private BuilderImpl(AcceptChannelHandshakeResponse model) {
            super(model);
            channelHandshakeDetail(model.channelHandshakeDetail);
        }

        public final AcceptChannelHandshakeDetail.Builder getChannelHandshakeDetail() {
            return channelHandshakeDetail != null ? channelHandshakeDetail.toBuilder() : null;
        }

        public final void setChannelHandshakeDetail(AcceptChannelHandshakeDetail.BuilderImpl channelHandshakeDetail) {
            this.channelHandshakeDetail = channelHandshakeDetail != null ? channelHandshakeDetail.build() : null;
        }

        @Override
        public final Builder channelHandshakeDetail(AcceptChannelHandshakeDetail channelHandshakeDetail) {
            this.channelHandshakeDetail = channelHandshakeDetail;
            return this;
        }

        @Override
        public AcceptChannelHandshakeResponse build() {
            return new AcceptChannelHandshakeResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
