/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.partnercentralchannel;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.services.partnercentralchannel.model.AcceptChannelHandshakeRequest;
import software.amazon.awssdk.services.partnercentralchannel.model.AcceptChannelHandshakeResponse;
import software.amazon.awssdk.services.partnercentralchannel.model.AccessDeniedException;
import software.amazon.awssdk.services.partnercentralchannel.model.CancelChannelHandshakeRequest;
import software.amazon.awssdk.services.partnercentralchannel.model.CancelChannelHandshakeResponse;
import software.amazon.awssdk.services.partnercentralchannel.model.ConflictException;
import software.amazon.awssdk.services.partnercentralchannel.model.CreateChannelHandshakeRequest;
import software.amazon.awssdk.services.partnercentralchannel.model.CreateChannelHandshakeResponse;
import software.amazon.awssdk.services.partnercentralchannel.model.CreateProgramManagementAccountRequest;
import software.amazon.awssdk.services.partnercentralchannel.model.CreateProgramManagementAccountResponse;
import software.amazon.awssdk.services.partnercentralchannel.model.CreateRelationshipRequest;
import software.amazon.awssdk.services.partnercentralchannel.model.CreateRelationshipResponse;
import software.amazon.awssdk.services.partnercentralchannel.model.DeleteProgramManagementAccountRequest;
import software.amazon.awssdk.services.partnercentralchannel.model.DeleteProgramManagementAccountResponse;
import software.amazon.awssdk.services.partnercentralchannel.model.DeleteRelationshipRequest;
import software.amazon.awssdk.services.partnercentralchannel.model.DeleteRelationshipResponse;
import software.amazon.awssdk.services.partnercentralchannel.model.GetRelationshipRequest;
import software.amazon.awssdk.services.partnercentralchannel.model.GetRelationshipResponse;
import software.amazon.awssdk.services.partnercentralchannel.model.InternalServerException;
import software.amazon.awssdk.services.partnercentralchannel.model.ListChannelHandshakesRequest;
import software.amazon.awssdk.services.partnercentralchannel.model.ListChannelHandshakesResponse;
import software.amazon.awssdk.services.partnercentralchannel.model.ListProgramManagementAccountsRequest;
import software.amazon.awssdk.services.partnercentralchannel.model.ListProgramManagementAccountsResponse;
import software.amazon.awssdk.services.partnercentralchannel.model.ListRelationshipsRequest;
import software.amazon.awssdk.services.partnercentralchannel.model.ListRelationshipsResponse;
import software.amazon.awssdk.services.partnercentralchannel.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.partnercentralchannel.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.partnercentralchannel.model.PartnerCentralChannelException;
import software.amazon.awssdk.services.partnercentralchannel.model.RejectChannelHandshakeRequest;
import software.amazon.awssdk.services.partnercentralchannel.model.RejectChannelHandshakeResponse;
import software.amazon.awssdk.services.partnercentralchannel.model.ResourceNotFoundException;
import software.amazon.awssdk.services.partnercentralchannel.model.ServiceQuotaExceededException;
import software.amazon.awssdk.services.partnercentralchannel.model.TagResourceRequest;
import software.amazon.awssdk.services.partnercentralchannel.model.TagResourceResponse;
import software.amazon.awssdk.services.partnercentralchannel.model.ThrottlingException;
import software.amazon.awssdk.services.partnercentralchannel.model.UntagResourceRequest;
import software.amazon.awssdk.services.partnercentralchannel.model.UntagResourceResponse;
import software.amazon.awssdk.services.partnercentralchannel.model.UpdateProgramManagementAccountRequest;
import software.amazon.awssdk.services.partnercentralchannel.model.UpdateProgramManagementAccountResponse;
import software.amazon.awssdk.services.partnercentralchannel.model.UpdateRelationshipRequest;
import software.amazon.awssdk.services.partnercentralchannel.model.UpdateRelationshipResponse;
import software.amazon.awssdk.services.partnercentralchannel.model.ValidationException;
import software.amazon.awssdk.services.partnercentralchannel.paginators.ListChannelHandshakesIterable;
import software.amazon.awssdk.services.partnercentralchannel.paginators.ListProgramManagementAccountsIterable;
import software.amazon.awssdk.services.partnercentralchannel.paginators.ListRelationshipsIterable;

/**
 * Service client for accessing Partner Central Channel API. This can be created using the static {@link #builder()}
 * method.
 *
 * <p>
 * AWS Partner Central Channel service for managing partner relationships, handshakes, and program management accounts.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface PartnerCentralChannelClient extends AwsClient {
    String SERVICE_NAME = "partnercentral-channel";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "partnercentral-channel";

    /**
     * <p>
     * Accepts a pending channel handshake request from another AWS account.
     * </p>
     *
     * @param acceptChannelHandshakeRequest
     * @return Result of the AcceptChannelHandshake operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InternalServerException
     *         An internal server error occurred while processing the request.
     * @throws ValidationException
     *         The request failed validation due to invalid input parameters.
     * @throws ThrottlingException
     *         The request was throttled due to too many requests being sent in a short period.
     * @throws AccessDeniedException
     *         The request was denied due to insufficient permissions.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PartnerCentralChannelException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PartnerCentralChannelClient.AcceptChannelHandshake
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/partnercentral-channel-2024-03-18/AcceptChannelHandshake"
     *      target="_top">AWS API Documentation</a>
     */
    default AcceptChannelHandshakeResponse acceptChannelHandshake(AcceptChannelHandshakeRequest acceptChannelHandshakeRequest)
            throws ResourceNotFoundException, InternalServerException, ValidationException, ThrottlingException,
            AccessDeniedException, AwsServiceException, SdkClientException, PartnerCentralChannelException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Accepts a pending channel handshake request from another AWS account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AcceptChannelHandshakeRequest.Builder} avoiding the
     * need to create one manually via {@link AcceptChannelHandshakeRequest#builder()}
     * </p>
     *
     * @param acceptChannelHandshakeRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.partnercentralchannel.model.AcceptChannelHandshakeRequest.Builder}
     *        to create a request.
     * @return Result of the AcceptChannelHandshake operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InternalServerException
     *         An internal server error occurred while processing the request.
     * @throws ValidationException
     *         The request failed validation due to invalid input parameters.
     * @throws ThrottlingException
     *         The request was throttled due to too many requests being sent in a short period.
     * @throws AccessDeniedException
     *         The request was denied due to insufficient permissions.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PartnerCentralChannelException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PartnerCentralChannelClient.AcceptChannelHandshake
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/partnercentral-channel-2024-03-18/AcceptChannelHandshake"
     *      target="_top">AWS API Documentation</a>
     */
    default AcceptChannelHandshakeResponse acceptChannelHandshake(
            Consumer<AcceptChannelHandshakeRequest.Builder> acceptChannelHandshakeRequest) throws ResourceNotFoundException,
            InternalServerException, ValidationException, ThrottlingException, AccessDeniedException, AwsServiceException,
            SdkClientException, PartnerCentralChannelException {
        return acceptChannelHandshake(AcceptChannelHandshakeRequest.builder().applyMutation(acceptChannelHandshakeRequest)
                .build());
    }

    /**
     * <p>
     * Cancels a pending channel handshake request.
     * </p>
     *
     * @param cancelChannelHandshakeRequest
     * @return Result of the CancelChannelHandshake operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InternalServerException
     *         An internal server error occurred while processing the request.
     * @throws ValidationException
     *         The request failed validation due to invalid input parameters.
     * @throws ThrottlingException
     *         The request was throttled due to too many requests being sent in a short period.
     * @throws AccessDeniedException
     *         The request was denied due to insufficient permissions.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PartnerCentralChannelException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PartnerCentralChannelClient.CancelChannelHandshake
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/partnercentral-channel-2024-03-18/CancelChannelHandshake"
     *      target="_top">AWS API Documentation</a>
     */
    default CancelChannelHandshakeResponse cancelChannelHandshake(CancelChannelHandshakeRequest cancelChannelHandshakeRequest)
            throws ResourceNotFoundException, InternalServerException, ValidationException, ThrottlingException,
            AccessDeniedException, AwsServiceException, SdkClientException, PartnerCentralChannelException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Cancels a pending channel handshake request.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CancelChannelHandshakeRequest.Builder} avoiding the
     * need to create one manually via {@link CancelChannelHandshakeRequest#builder()}
     * </p>
     *
     * @param cancelChannelHandshakeRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.partnercentralchannel.model.CancelChannelHandshakeRequest.Builder}
     *        to create a request.
     * @return Result of the CancelChannelHandshake operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InternalServerException
     *         An internal server error occurred while processing the request.
     * @throws ValidationException
     *         The request failed validation due to invalid input parameters.
     * @throws ThrottlingException
     *         The request was throttled due to too many requests being sent in a short period.
     * @throws AccessDeniedException
     *         The request was denied due to insufficient permissions.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PartnerCentralChannelException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PartnerCentralChannelClient.CancelChannelHandshake
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/partnercentral-channel-2024-03-18/CancelChannelHandshake"
     *      target="_top">AWS API Documentation</a>
     */
    default CancelChannelHandshakeResponse cancelChannelHandshake(
            Consumer<CancelChannelHandshakeRequest.Builder> cancelChannelHandshakeRequest) throws ResourceNotFoundException,
            InternalServerException, ValidationException, ThrottlingException, AccessDeniedException, AwsServiceException,
            SdkClientException, PartnerCentralChannelException {
        return cancelChannelHandshake(CancelChannelHandshakeRequest.builder().applyMutation(cancelChannelHandshakeRequest)
                .build());
    }

    /**
     * <p>
     * Creates a new channel handshake request to establish a partnership with another AWS account.
     * </p>
     *
     * @param createChannelHandshakeRequest
     * @return Result of the CreateChannelHandshake operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InternalServerException
     *         An internal server error occurred while processing the request.
     * @throws ValidationException
     *         The request failed validation due to invalid input parameters.
     * @throws ThrottlingException
     *         The request was throttled due to too many requests being sent in a short period.
     * @throws AccessDeniedException
     *         The request was denied due to insufficient permissions.
     * @throws ConflictException
     *         The request could not be completed due to a conflict with the current state of the resource.
     * @throws ServiceQuotaExceededException
     *         The request would exceed a service quota limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PartnerCentralChannelException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PartnerCentralChannelClient.CreateChannelHandshake
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/partnercentral-channel-2024-03-18/CreateChannelHandshake"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateChannelHandshakeResponse createChannelHandshake(CreateChannelHandshakeRequest createChannelHandshakeRequest)
            throws ResourceNotFoundException, InternalServerException, ValidationException, ThrottlingException,
            AccessDeniedException, ConflictException, ServiceQuotaExceededException, AwsServiceException, SdkClientException,
            PartnerCentralChannelException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new channel handshake request to establish a partnership with another AWS account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateChannelHandshakeRequest.Builder} avoiding the
     * need to create one manually via {@link CreateChannelHandshakeRequest#builder()}
     * </p>
     *
     * @param createChannelHandshakeRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.partnercentralchannel.model.CreateChannelHandshakeRequest.Builder}
     *        to create a request.
     * @return Result of the CreateChannelHandshake operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InternalServerException
     *         An internal server error occurred while processing the request.
     * @throws ValidationException
     *         The request failed validation due to invalid input parameters.
     * @throws ThrottlingException
     *         The request was throttled due to too many requests being sent in a short period.
     * @throws AccessDeniedException
     *         The request was denied due to insufficient permissions.
     * @throws ConflictException
     *         The request could not be completed due to a conflict with the current state of the resource.
     * @throws ServiceQuotaExceededException
     *         The request would exceed a service quota limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PartnerCentralChannelException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PartnerCentralChannelClient.CreateChannelHandshake
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/partnercentral-channel-2024-03-18/CreateChannelHandshake"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateChannelHandshakeResponse createChannelHandshake(
            Consumer<CreateChannelHandshakeRequest.Builder> createChannelHandshakeRequest) throws ResourceNotFoundException,
            InternalServerException, ValidationException, ThrottlingException, AccessDeniedException, ConflictException,
            ServiceQuotaExceededException, AwsServiceException, SdkClientException, PartnerCentralChannelException {
        return createChannelHandshake(CreateChannelHandshakeRequest.builder().applyMutation(createChannelHandshakeRequest)
                .build());
    }

    /**
     * <p>
     * Creates a new program management account for managing partner relationships.
     * </p>
     *
     * @param createProgramManagementAccountRequest
     * @return Result of the CreateProgramManagementAccount operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InternalServerException
     *         An internal server error occurred while processing the request.
     * @throws ValidationException
     *         The request failed validation due to invalid input parameters.
     * @throws ThrottlingException
     *         The request was throttled due to too many requests being sent in a short period.
     * @throws AccessDeniedException
     *         The request was denied due to insufficient permissions.
     * @throws ConflictException
     *         The request could not be completed due to a conflict with the current state of the resource.
     * @throws ServiceQuotaExceededException
     *         The request would exceed a service quota limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PartnerCentralChannelException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PartnerCentralChannelClient.CreateProgramManagementAccount
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/partnercentral-channel-2024-03-18/CreateProgramManagementAccount"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateProgramManagementAccountResponse createProgramManagementAccount(
            CreateProgramManagementAccountRequest createProgramManagementAccountRequest) throws ResourceNotFoundException,
            InternalServerException, ValidationException, ThrottlingException, AccessDeniedException, ConflictException,
            ServiceQuotaExceededException, AwsServiceException, SdkClientException, PartnerCentralChannelException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new program management account for managing partner relationships.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateProgramManagementAccountRequest.Builder}
     * avoiding the need to create one manually via {@link CreateProgramManagementAccountRequest#builder()}
     * </p>
     *
     * @param createProgramManagementAccountRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.partnercentralchannel.model.CreateProgramManagementAccountRequest.Builder}
     *        to create a request.
     * @return Result of the CreateProgramManagementAccount operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InternalServerException
     *         An internal server error occurred while processing the request.
     * @throws ValidationException
     *         The request failed validation due to invalid input parameters.
     * @throws ThrottlingException
     *         The request was throttled due to too many requests being sent in a short period.
     * @throws AccessDeniedException
     *         The request was denied due to insufficient permissions.
     * @throws ConflictException
     *         The request could not be completed due to a conflict with the current state of the resource.
     * @throws ServiceQuotaExceededException
     *         The request would exceed a service quota limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PartnerCentralChannelException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PartnerCentralChannelClient.CreateProgramManagementAccount
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/partnercentral-channel-2024-03-18/CreateProgramManagementAccount"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateProgramManagementAccountResponse createProgramManagementAccount(
            Consumer<CreateProgramManagementAccountRequest.Builder> createProgramManagementAccountRequest)
            throws ResourceNotFoundException, InternalServerException, ValidationException, ThrottlingException,
            AccessDeniedException, ConflictException, ServiceQuotaExceededException, AwsServiceException, SdkClientException,
            PartnerCentralChannelException {
        return createProgramManagementAccount(CreateProgramManagementAccountRequest.builder()
                .applyMutation(createProgramManagementAccountRequest).build());
    }

    /**
     * <p>
     * Creates a new partner relationship between accounts.
     * </p>
     *
     * @param createRelationshipRequest
     * @return Result of the CreateRelationship operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InternalServerException
     *         An internal server error occurred while processing the request.
     * @throws ValidationException
     *         The request failed validation due to invalid input parameters.
     * @throws ThrottlingException
     *         The request was throttled due to too many requests being sent in a short period.
     * @throws AccessDeniedException
     *         The request was denied due to insufficient permissions.
     * @throws ConflictException
     *         The request could not be completed due to a conflict with the current state of the resource.
     * @throws ServiceQuotaExceededException
     *         The request would exceed a service quota limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PartnerCentralChannelException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PartnerCentralChannelClient.CreateRelationship
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/partnercentral-channel-2024-03-18/CreateRelationship"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateRelationshipResponse createRelationship(CreateRelationshipRequest createRelationshipRequest)
            throws ResourceNotFoundException, InternalServerException, ValidationException, ThrottlingException,
            AccessDeniedException, ConflictException, ServiceQuotaExceededException, AwsServiceException, SdkClientException,
            PartnerCentralChannelException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new partner relationship between accounts.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateRelationshipRequest.Builder} avoiding the
     * need to create one manually via {@link CreateRelationshipRequest#builder()}
     * </p>
     *
     * @param createRelationshipRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.partnercentralchannel.model.CreateRelationshipRequest.Builder} to
     *        create a request.
     * @return Result of the CreateRelationship operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InternalServerException
     *         An internal server error occurred while processing the request.
     * @throws ValidationException
     *         The request failed validation due to invalid input parameters.
     * @throws ThrottlingException
     *         The request was throttled due to too many requests being sent in a short period.
     * @throws AccessDeniedException
     *         The request was denied due to insufficient permissions.
     * @throws ConflictException
     *         The request could not be completed due to a conflict with the current state of the resource.
     * @throws ServiceQuotaExceededException
     *         The request would exceed a service quota limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PartnerCentralChannelException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PartnerCentralChannelClient.CreateRelationship
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/partnercentral-channel-2024-03-18/CreateRelationship"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateRelationshipResponse createRelationship(Consumer<CreateRelationshipRequest.Builder> createRelationshipRequest)
            throws ResourceNotFoundException, InternalServerException, ValidationException, ThrottlingException,
            AccessDeniedException, ConflictException, ServiceQuotaExceededException, AwsServiceException, SdkClientException,
            PartnerCentralChannelException {
        return createRelationship(CreateRelationshipRequest.builder().applyMutation(createRelationshipRequest).build());
    }

    /**
     * <p>
     * Deletes a program management account.
     * </p>
     *
     * @param deleteProgramManagementAccountRequest
     * @return Result of the DeleteProgramManagementAccount operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InternalServerException
     *         An internal server error occurred while processing the request.
     * @throws ValidationException
     *         The request failed validation due to invalid input parameters.
     * @throws ThrottlingException
     *         The request was throttled due to too many requests being sent in a short period.
     * @throws AccessDeniedException
     *         The request was denied due to insufficient permissions.
     * @throws ConflictException
     *         The request could not be completed due to a conflict with the current state of the resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PartnerCentralChannelException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PartnerCentralChannelClient.DeleteProgramManagementAccount
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/partnercentral-channel-2024-03-18/DeleteProgramManagementAccount"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteProgramManagementAccountResponse deleteProgramManagementAccount(
            DeleteProgramManagementAccountRequest deleteProgramManagementAccountRequest) throws ResourceNotFoundException,
            InternalServerException, ValidationException, ThrottlingException, AccessDeniedException, ConflictException,
            AwsServiceException, SdkClientException, PartnerCentralChannelException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a program management account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteProgramManagementAccountRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteProgramManagementAccountRequest#builder()}
     * </p>
     *
     * @param deleteProgramManagementAccountRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.partnercentralchannel.model.DeleteProgramManagementAccountRequest.Builder}
     *        to create a request.
     * @return Result of the DeleteProgramManagementAccount operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InternalServerException
     *         An internal server error occurred while processing the request.
     * @throws ValidationException
     *         The request failed validation due to invalid input parameters.
     * @throws ThrottlingException
     *         The request was throttled due to too many requests being sent in a short period.
     * @throws AccessDeniedException
     *         The request was denied due to insufficient permissions.
     * @throws ConflictException
     *         The request could not be completed due to a conflict with the current state of the resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PartnerCentralChannelException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PartnerCentralChannelClient.DeleteProgramManagementAccount
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/partnercentral-channel-2024-03-18/DeleteProgramManagementAccount"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteProgramManagementAccountResponse deleteProgramManagementAccount(
            Consumer<DeleteProgramManagementAccountRequest.Builder> deleteProgramManagementAccountRequest)
            throws ResourceNotFoundException, InternalServerException, ValidationException, ThrottlingException,
            AccessDeniedException, ConflictException, AwsServiceException, SdkClientException, PartnerCentralChannelException {
        return deleteProgramManagementAccount(DeleteProgramManagementAccountRequest.builder()
                .applyMutation(deleteProgramManagementAccountRequest).build());
    }

    /**
     * <p>
     * Deletes a partner relationship.
     * </p>
     *
     * @param deleteRelationshipRequest
     * @return Result of the DeleteRelationship operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InternalServerException
     *         An internal server error occurred while processing the request.
     * @throws ValidationException
     *         The request failed validation due to invalid input parameters.
     * @throws ThrottlingException
     *         The request was throttled due to too many requests being sent in a short period.
     * @throws AccessDeniedException
     *         The request was denied due to insufficient permissions.
     * @throws ConflictException
     *         The request could not be completed due to a conflict with the current state of the resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PartnerCentralChannelException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PartnerCentralChannelClient.DeleteRelationship
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/partnercentral-channel-2024-03-18/DeleteRelationship"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteRelationshipResponse deleteRelationship(DeleteRelationshipRequest deleteRelationshipRequest)
            throws ResourceNotFoundException, InternalServerException, ValidationException, ThrottlingException,
            AccessDeniedException, ConflictException, AwsServiceException, SdkClientException, PartnerCentralChannelException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a partner relationship.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteRelationshipRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteRelationshipRequest#builder()}
     * </p>
     *
     * @param deleteRelationshipRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.partnercentralchannel.model.DeleteRelationshipRequest.Builder} to
     *        create a request.
     * @return Result of the DeleteRelationship operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InternalServerException
     *         An internal server error occurred while processing the request.
     * @throws ValidationException
     *         The request failed validation due to invalid input parameters.
     * @throws ThrottlingException
     *         The request was throttled due to too many requests being sent in a short period.
     * @throws AccessDeniedException
     *         The request was denied due to insufficient permissions.
     * @throws ConflictException
     *         The request could not be completed due to a conflict with the current state of the resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PartnerCentralChannelException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PartnerCentralChannelClient.DeleteRelationship
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/partnercentral-channel-2024-03-18/DeleteRelationship"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteRelationshipResponse deleteRelationship(Consumer<DeleteRelationshipRequest.Builder> deleteRelationshipRequest)
            throws ResourceNotFoundException, InternalServerException, ValidationException, ThrottlingException,
            AccessDeniedException, ConflictException, AwsServiceException, SdkClientException, PartnerCentralChannelException {
        return deleteRelationship(DeleteRelationshipRequest.builder().applyMutation(deleteRelationshipRequest).build());
    }

    /**
     * <p>
     * Retrieves details of a specific partner relationship.
     * </p>
     *
     * @param getRelationshipRequest
     * @return Result of the GetRelationship operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InternalServerException
     *         An internal server error occurred while processing the request.
     * @throws ValidationException
     *         The request failed validation due to invalid input parameters.
     * @throws ThrottlingException
     *         The request was throttled due to too many requests being sent in a short period.
     * @throws AccessDeniedException
     *         The request was denied due to insufficient permissions.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PartnerCentralChannelException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PartnerCentralChannelClient.GetRelationship
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/partnercentral-channel-2024-03-18/GetRelationship"
     *      target="_top">AWS API Documentation</a>
     */
    default GetRelationshipResponse getRelationship(GetRelationshipRequest getRelationshipRequest)
            throws ResourceNotFoundException, InternalServerException, ValidationException, ThrottlingException,
            AccessDeniedException, AwsServiceException, SdkClientException, PartnerCentralChannelException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves details of a specific partner relationship.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetRelationshipRequest.Builder} avoiding the need
     * to create one manually via {@link GetRelationshipRequest#builder()}
     * </p>
     *
     * @param getRelationshipRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.partnercentralchannel.model.GetRelationshipRequest.Builder} to
     *        create a request.
     * @return Result of the GetRelationship operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InternalServerException
     *         An internal server error occurred while processing the request.
     * @throws ValidationException
     *         The request failed validation due to invalid input parameters.
     * @throws ThrottlingException
     *         The request was throttled due to too many requests being sent in a short period.
     * @throws AccessDeniedException
     *         The request was denied due to insufficient permissions.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PartnerCentralChannelException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PartnerCentralChannelClient.GetRelationship
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/partnercentral-channel-2024-03-18/GetRelationship"
     *      target="_top">AWS API Documentation</a>
     */
    default GetRelationshipResponse getRelationship(Consumer<GetRelationshipRequest.Builder> getRelationshipRequest)
            throws ResourceNotFoundException, InternalServerException, ValidationException, ThrottlingException,
            AccessDeniedException, AwsServiceException, SdkClientException, PartnerCentralChannelException {
        return getRelationship(GetRelationshipRequest.builder().applyMutation(getRelationshipRequest).build());
    }

    /**
     * <p>
     * Lists channel handshakes based on specified criteria.
     * </p>
     *
     * @param listChannelHandshakesRequest
     * @return Result of the ListChannelHandshakes operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InternalServerException
     *         An internal server error occurred while processing the request.
     * @throws ValidationException
     *         The request failed validation due to invalid input parameters.
     * @throws ThrottlingException
     *         The request was throttled due to too many requests being sent in a short period.
     * @throws AccessDeniedException
     *         The request was denied due to insufficient permissions.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PartnerCentralChannelException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PartnerCentralChannelClient.ListChannelHandshakes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/partnercentral-channel-2024-03-18/ListChannelHandshakes"
     *      target="_top">AWS API Documentation</a>
     */
    default ListChannelHandshakesResponse listChannelHandshakes(ListChannelHandshakesRequest listChannelHandshakesRequest)
            throws ResourceNotFoundException, InternalServerException, ValidationException, ThrottlingException,
            AccessDeniedException, AwsServiceException, SdkClientException, PartnerCentralChannelException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists channel handshakes based on specified criteria.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListChannelHandshakesRequest.Builder} avoiding the
     * need to create one manually via {@link ListChannelHandshakesRequest#builder()}
     * </p>
     *
     * @param listChannelHandshakesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.partnercentralchannel.model.ListChannelHandshakesRequest.Builder}
     *        to create a request.
     * @return Result of the ListChannelHandshakes operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InternalServerException
     *         An internal server error occurred while processing the request.
     * @throws ValidationException
     *         The request failed validation due to invalid input parameters.
     * @throws ThrottlingException
     *         The request was throttled due to too many requests being sent in a short period.
     * @throws AccessDeniedException
     *         The request was denied due to insufficient permissions.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PartnerCentralChannelException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PartnerCentralChannelClient.ListChannelHandshakes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/partnercentral-channel-2024-03-18/ListChannelHandshakes"
     *      target="_top">AWS API Documentation</a>
     */
    default ListChannelHandshakesResponse listChannelHandshakes(
            Consumer<ListChannelHandshakesRequest.Builder> listChannelHandshakesRequest) throws ResourceNotFoundException,
            InternalServerException, ValidationException, ThrottlingException, AccessDeniedException, AwsServiceException,
            SdkClientException, PartnerCentralChannelException {
        return listChannelHandshakes(ListChannelHandshakesRequest.builder().applyMutation(listChannelHandshakesRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listChannelHandshakes(software.amazon.awssdk.services.partnercentralchannel.model.ListChannelHandshakesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.partnercentralchannel.paginators.ListChannelHandshakesIterable responses = client.listChannelHandshakesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.partnercentralchannel.paginators.ListChannelHandshakesIterable responses = client
     *             .listChannelHandshakesPaginator(request);
     *     for (software.amazon.awssdk.services.partnercentralchannel.model.ListChannelHandshakesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.partnercentralchannel.paginators.ListChannelHandshakesIterable responses = client.listChannelHandshakesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listChannelHandshakes(software.amazon.awssdk.services.partnercentralchannel.model.ListChannelHandshakesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listChannelHandshakesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InternalServerException
     *         An internal server error occurred while processing the request.
     * @throws ValidationException
     *         The request failed validation due to invalid input parameters.
     * @throws ThrottlingException
     *         The request was throttled due to too many requests being sent in a short period.
     * @throws AccessDeniedException
     *         The request was denied due to insufficient permissions.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PartnerCentralChannelException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PartnerCentralChannelClient.ListChannelHandshakes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/partnercentral-channel-2024-03-18/ListChannelHandshakes"
     *      target="_top">AWS API Documentation</a>
     */
    default ListChannelHandshakesIterable listChannelHandshakesPaginator(ListChannelHandshakesRequest listChannelHandshakesRequest)
            throws ResourceNotFoundException, InternalServerException, ValidationException, ThrottlingException,
            AccessDeniedException, AwsServiceException, SdkClientException, PartnerCentralChannelException {
        return new ListChannelHandshakesIterable(this, listChannelHandshakesRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listChannelHandshakes(software.amazon.awssdk.services.partnercentralchannel.model.ListChannelHandshakesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.partnercentralchannel.paginators.ListChannelHandshakesIterable responses = client.listChannelHandshakesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.partnercentralchannel.paginators.ListChannelHandshakesIterable responses = client
     *             .listChannelHandshakesPaginator(request);
     *     for (software.amazon.awssdk.services.partnercentralchannel.model.ListChannelHandshakesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.partnercentralchannel.paginators.ListChannelHandshakesIterable responses = client.listChannelHandshakesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listChannelHandshakes(software.amazon.awssdk.services.partnercentralchannel.model.ListChannelHandshakesRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListChannelHandshakesRequest.Builder} avoiding the
     * need to create one manually via {@link ListChannelHandshakesRequest#builder()}
     * </p>
     *
     * @param listChannelHandshakesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.partnercentralchannel.model.ListChannelHandshakesRequest.Builder}
     *        to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InternalServerException
     *         An internal server error occurred while processing the request.
     * @throws ValidationException
     *         The request failed validation due to invalid input parameters.
     * @throws ThrottlingException
     *         The request was throttled due to too many requests being sent in a short period.
     * @throws AccessDeniedException
     *         The request was denied due to insufficient permissions.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PartnerCentralChannelException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PartnerCentralChannelClient.ListChannelHandshakes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/partnercentral-channel-2024-03-18/ListChannelHandshakes"
     *      target="_top">AWS API Documentation</a>
     */
    default ListChannelHandshakesIterable listChannelHandshakesPaginator(
            Consumer<ListChannelHandshakesRequest.Builder> listChannelHandshakesRequest) throws ResourceNotFoundException,
            InternalServerException, ValidationException, ThrottlingException, AccessDeniedException, AwsServiceException,
            SdkClientException, PartnerCentralChannelException {
        return listChannelHandshakesPaginator(ListChannelHandshakesRequest.builder().applyMutation(listChannelHandshakesRequest)
                .build());
    }

    /**
     * <p>
     * Lists program management accounts based on specified criteria.
     * </p>
     *
     * @param listProgramManagementAccountsRequest
     * @return Result of the ListProgramManagementAccounts operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InternalServerException
     *         An internal server error occurred while processing the request.
     * @throws ValidationException
     *         The request failed validation due to invalid input parameters.
     * @throws ThrottlingException
     *         The request was throttled due to too many requests being sent in a short period.
     * @throws AccessDeniedException
     *         The request was denied due to insufficient permissions.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PartnerCentralChannelException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PartnerCentralChannelClient.ListProgramManagementAccounts
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/partnercentral-channel-2024-03-18/ListProgramManagementAccounts"
     *      target="_top">AWS API Documentation</a>
     */
    default ListProgramManagementAccountsResponse listProgramManagementAccounts(
            ListProgramManagementAccountsRequest listProgramManagementAccountsRequest) throws ResourceNotFoundException,
            InternalServerException, ValidationException, ThrottlingException, AccessDeniedException, AwsServiceException,
            SdkClientException, PartnerCentralChannelException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists program management accounts based on specified criteria.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListProgramManagementAccountsRequest.Builder}
     * avoiding the need to create one manually via {@link ListProgramManagementAccountsRequest#builder()}
     * </p>
     *
     * @param listProgramManagementAccountsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.partnercentralchannel.model.ListProgramManagementAccountsRequest.Builder}
     *        to create a request.
     * @return Result of the ListProgramManagementAccounts operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InternalServerException
     *         An internal server error occurred while processing the request.
     * @throws ValidationException
     *         The request failed validation due to invalid input parameters.
     * @throws ThrottlingException
     *         The request was throttled due to too many requests being sent in a short period.
     * @throws AccessDeniedException
     *         The request was denied due to insufficient permissions.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PartnerCentralChannelException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PartnerCentralChannelClient.ListProgramManagementAccounts
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/partnercentral-channel-2024-03-18/ListProgramManagementAccounts"
     *      target="_top">AWS API Documentation</a>
     */
    default ListProgramManagementAccountsResponse listProgramManagementAccounts(
            Consumer<ListProgramManagementAccountsRequest.Builder> listProgramManagementAccountsRequest)
            throws ResourceNotFoundException, InternalServerException, ValidationException, ThrottlingException,
            AccessDeniedException, AwsServiceException, SdkClientException, PartnerCentralChannelException {
        return listProgramManagementAccounts(ListProgramManagementAccountsRequest.builder()
                .applyMutation(listProgramManagementAccountsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listProgramManagementAccounts(software.amazon.awssdk.services.partnercentralchannel.model.ListProgramManagementAccountsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.partnercentralchannel.paginators.ListProgramManagementAccountsIterable responses = client.listProgramManagementAccountsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.partnercentralchannel.paginators.ListProgramManagementAccountsIterable responses = client
     *             .listProgramManagementAccountsPaginator(request);
     *     for (software.amazon.awssdk.services.partnercentralchannel.model.ListProgramManagementAccountsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.partnercentralchannel.paginators.ListProgramManagementAccountsIterable responses = client.listProgramManagementAccountsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listProgramManagementAccounts(software.amazon.awssdk.services.partnercentralchannel.model.ListProgramManagementAccountsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listProgramManagementAccountsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InternalServerException
     *         An internal server error occurred while processing the request.
     * @throws ValidationException
     *         The request failed validation due to invalid input parameters.
     * @throws ThrottlingException
     *         The request was throttled due to too many requests being sent in a short period.
     * @throws AccessDeniedException
     *         The request was denied due to insufficient permissions.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PartnerCentralChannelException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PartnerCentralChannelClient.ListProgramManagementAccounts
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/partnercentral-channel-2024-03-18/ListProgramManagementAccounts"
     *      target="_top">AWS API Documentation</a>
     */
    default ListProgramManagementAccountsIterable listProgramManagementAccountsPaginator(
            ListProgramManagementAccountsRequest listProgramManagementAccountsRequest) throws ResourceNotFoundException,
            InternalServerException, ValidationException, ThrottlingException, AccessDeniedException, AwsServiceException,
            SdkClientException, PartnerCentralChannelException {
        return new ListProgramManagementAccountsIterable(this, listProgramManagementAccountsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listProgramManagementAccounts(software.amazon.awssdk.services.partnercentralchannel.model.ListProgramManagementAccountsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.partnercentralchannel.paginators.ListProgramManagementAccountsIterable responses = client.listProgramManagementAccountsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.partnercentralchannel.paginators.ListProgramManagementAccountsIterable responses = client
     *             .listProgramManagementAccountsPaginator(request);
     *     for (software.amazon.awssdk.services.partnercentralchannel.model.ListProgramManagementAccountsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.partnercentralchannel.paginators.ListProgramManagementAccountsIterable responses = client.listProgramManagementAccountsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listProgramManagementAccounts(software.amazon.awssdk.services.partnercentralchannel.model.ListProgramManagementAccountsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListProgramManagementAccountsRequest.Builder}
     * avoiding the need to create one manually via {@link ListProgramManagementAccountsRequest#builder()}
     * </p>
     *
     * @param listProgramManagementAccountsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.partnercentralchannel.model.ListProgramManagementAccountsRequest.Builder}
     *        to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InternalServerException
     *         An internal server error occurred while processing the request.
     * @throws ValidationException
     *         The request failed validation due to invalid input parameters.
     * @throws ThrottlingException
     *         The request was throttled due to too many requests being sent in a short period.
     * @throws AccessDeniedException
     *         The request was denied due to insufficient permissions.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PartnerCentralChannelException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PartnerCentralChannelClient.ListProgramManagementAccounts
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/partnercentral-channel-2024-03-18/ListProgramManagementAccounts"
     *      target="_top">AWS API Documentation</a>
     */
    default ListProgramManagementAccountsIterable listProgramManagementAccountsPaginator(
            Consumer<ListProgramManagementAccountsRequest.Builder> listProgramManagementAccountsRequest)
            throws ResourceNotFoundException, InternalServerException, ValidationException, ThrottlingException,
            AccessDeniedException, AwsServiceException, SdkClientException, PartnerCentralChannelException {
        return listProgramManagementAccountsPaginator(ListProgramManagementAccountsRequest.builder()
                .applyMutation(listProgramManagementAccountsRequest).build());
    }

    /**
     * <p>
     * Lists partner relationships based on specified criteria.
     * </p>
     *
     * @param listRelationshipsRequest
     * @return Result of the ListRelationships operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InternalServerException
     *         An internal server error occurred while processing the request.
     * @throws ValidationException
     *         The request failed validation due to invalid input parameters.
     * @throws ThrottlingException
     *         The request was throttled due to too many requests being sent in a short period.
     * @throws AccessDeniedException
     *         The request was denied due to insufficient permissions.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PartnerCentralChannelException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PartnerCentralChannelClient.ListRelationships
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/partnercentral-channel-2024-03-18/ListRelationships"
     *      target="_top">AWS API Documentation</a>
     */
    default ListRelationshipsResponse listRelationships(ListRelationshipsRequest listRelationshipsRequest)
            throws ResourceNotFoundException, InternalServerException, ValidationException, ThrottlingException,
            AccessDeniedException, AwsServiceException, SdkClientException, PartnerCentralChannelException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists partner relationships based on specified criteria.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListRelationshipsRequest.Builder} avoiding the need
     * to create one manually via {@link ListRelationshipsRequest#builder()}
     * </p>
     *
     * @param listRelationshipsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.partnercentralchannel.model.ListRelationshipsRequest.Builder} to
     *        create a request.
     * @return Result of the ListRelationships operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InternalServerException
     *         An internal server error occurred while processing the request.
     * @throws ValidationException
     *         The request failed validation due to invalid input parameters.
     * @throws ThrottlingException
     *         The request was throttled due to too many requests being sent in a short period.
     * @throws AccessDeniedException
     *         The request was denied due to insufficient permissions.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PartnerCentralChannelException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PartnerCentralChannelClient.ListRelationships
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/partnercentral-channel-2024-03-18/ListRelationships"
     *      target="_top">AWS API Documentation</a>
     */
    default ListRelationshipsResponse listRelationships(Consumer<ListRelationshipsRequest.Builder> listRelationshipsRequest)
            throws ResourceNotFoundException, InternalServerException, ValidationException, ThrottlingException,
            AccessDeniedException, AwsServiceException, SdkClientException, PartnerCentralChannelException {
        return listRelationships(ListRelationshipsRequest.builder().applyMutation(listRelationshipsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listRelationships(software.amazon.awssdk.services.partnercentralchannel.model.ListRelationshipsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.partnercentralchannel.paginators.ListRelationshipsIterable responses = client.listRelationshipsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.partnercentralchannel.paginators.ListRelationshipsIterable responses = client
     *             .listRelationshipsPaginator(request);
     *     for (software.amazon.awssdk.services.partnercentralchannel.model.ListRelationshipsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.partnercentralchannel.paginators.ListRelationshipsIterable responses = client.listRelationshipsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listRelationships(software.amazon.awssdk.services.partnercentralchannel.model.ListRelationshipsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listRelationshipsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InternalServerException
     *         An internal server error occurred while processing the request.
     * @throws ValidationException
     *         The request failed validation due to invalid input parameters.
     * @throws ThrottlingException
     *         The request was throttled due to too many requests being sent in a short period.
     * @throws AccessDeniedException
     *         The request was denied due to insufficient permissions.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PartnerCentralChannelException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PartnerCentralChannelClient.ListRelationships
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/partnercentral-channel-2024-03-18/ListRelationships"
     *      target="_top">AWS API Documentation</a>
     */
    default ListRelationshipsIterable listRelationshipsPaginator(ListRelationshipsRequest listRelationshipsRequest)
            throws ResourceNotFoundException, InternalServerException, ValidationException, ThrottlingException,
            AccessDeniedException, AwsServiceException, SdkClientException, PartnerCentralChannelException {
        return new ListRelationshipsIterable(this, listRelationshipsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listRelationships(software.amazon.awssdk.services.partnercentralchannel.model.ListRelationshipsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.partnercentralchannel.paginators.ListRelationshipsIterable responses = client.listRelationshipsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.partnercentralchannel.paginators.ListRelationshipsIterable responses = client
     *             .listRelationshipsPaginator(request);
     *     for (software.amazon.awssdk.services.partnercentralchannel.model.ListRelationshipsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.partnercentralchannel.paginators.ListRelationshipsIterable responses = client.listRelationshipsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listRelationships(software.amazon.awssdk.services.partnercentralchannel.model.ListRelationshipsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListRelationshipsRequest.Builder} avoiding the need
     * to create one manually via {@link ListRelationshipsRequest#builder()}
     * </p>
     *
     * @param listRelationshipsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.partnercentralchannel.model.ListRelationshipsRequest.Builder} to
     *        create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InternalServerException
     *         An internal server error occurred while processing the request.
     * @throws ValidationException
     *         The request failed validation due to invalid input parameters.
     * @throws ThrottlingException
     *         The request was throttled due to too many requests being sent in a short period.
     * @throws AccessDeniedException
     *         The request was denied due to insufficient permissions.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PartnerCentralChannelException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PartnerCentralChannelClient.ListRelationships
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/partnercentral-channel-2024-03-18/ListRelationships"
     *      target="_top">AWS API Documentation</a>
     */
    default ListRelationshipsIterable listRelationshipsPaginator(
            Consumer<ListRelationshipsRequest.Builder> listRelationshipsRequest) throws ResourceNotFoundException,
            InternalServerException, ValidationException, ThrottlingException, AccessDeniedException, AwsServiceException,
            SdkClientException, PartnerCentralChannelException {
        return listRelationshipsPaginator(ListRelationshipsRequest.builder().applyMutation(listRelationshipsRequest).build());
    }

    /**
     * <p>
     * Lists tags associated with a specific resource.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InternalServerException
     *         An internal server error occurred while processing the request.
     * @throws ValidationException
     *         The request failed validation due to invalid input parameters.
     * @throws ThrottlingException
     *         The request was throttled due to too many requests being sent in a short period.
     * @throws AccessDeniedException
     *         The request was denied due to insufficient permissions.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PartnerCentralChannelException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PartnerCentralChannelClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/partnercentral-channel-2024-03-18/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest)
            throws ResourceNotFoundException, InternalServerException, ValidationException, ThrottlingException,
            AccessDeniedException, AwsServiceException, SdkClientException, PartnerCentralChannelException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists tags associated with a specific resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.partnercentralchannel.model.ListTagsForResourceRequest.Builder} to
     *        create a request.
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InternalServerException
     *         An internal server error occurred while processing the request.
     * @throws ValidationException
     *         The request failed validation due to invalid input parameters.
     * @throws ThrottlingException
     *         The request was throttled due to too many requests being sent in a short period.
     * @throws AccessDeniedException
     *         The request was denied due to insufficient permissions.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PartnerCentralChannelException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PartnerCentralChannelClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/partnercentral-channel-2024-03-18/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTagsForResourceResponse listTagsForResource(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) throws ResourceNotFoundException,
            InternalServerException, ValidationException, ThrottlingException, AccessDeniedException, AwsServiceException,
            SdkClientException, PartnerCentralChannelException {
        return listTagsForResource(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest).build());
    }

    /**
     * <p>
     * Rejects a pending channel handshake request.
     * </p>
     *
     * @param rejectChannelHandshakeRequest
     * @return Result of the RejectChannelHandshake operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InternalServerException
     *         An internal server error occurred while processing the request.
     * @throws ValidationException
     *         The request failed validation due to invalid input parameters.
     * @throws ThrottlingException
     *         The request was throttled due to too many requests being sent in a short period.
     * @throws AccessDeniedException
     *         The request was denied due to insufficient permissions.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PartnerCentralChannelException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PartnerCentralChannelClient.RejectChannelHandshake
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/partnercentral-channel-2024-03-18/RejectChannelHandshake"
     *      target="_top">AWS API Documentation</a>
     */
    default RejectChannelHandshakeResponse rejectChannelHandshake(RejectChannelHandshakeRequest rejectChannelHandshakeRequest)
            throws ResourceNotFoundException, InternalServerException, ValidationException, ThrottlingException,
            AccessDeniedException, AwsServiceException, SdkClientException, PartnerCentralChannelException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Rejects a pending channel handshake request.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RejectChannelHandshakeRequest.Builder} avoiding the
     * need to create one manually via {@link RejectChannelHandshakeRequest#builder()}
     * </p>
     *
     * @param rejectChannelHandshakeRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.partnercentralchannel.model.RejectChannelHandshakeRequest.Builder}
     *        to create a request.
     * @return Result of the RejectChannelHandshake operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InternalServerException
     *         An internal server error occurred while processing the request.
     * @throws ValidationException
     *         The request failed validation due to invalid input parameters.
     * @throws ThrottlingException
     *         The request was throttled due to too many requests being sent in a short period.
     * @throws AccessDeniedException
     *         The request was denied due to insufficient permissions.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PartnerCentralChannelException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PartnerCentralChannelClient.RejectChannelHandshake
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/partnercentral-channel-2024-03-18/RejectChannelHandshake"
     *      target="_top">AWS API Documentation</a>
     */
    default RejectChannelHandshakeResponse rejectChannelHandshake(
            Consumer<RejectChannelHandshakeRequest.Builder> rejectChannelHandshakeRequest) throws ResourceNotFoundException,
            InternalServerException, ValidationException, ThrottlingException, AccessDeniedException, AwsServiceException,
            SdkClientException, PartnerCentralChannelException {
        return rejectChannelHandshake(RejectChannelHandshakeRequest.builder().applyMutation(rejectChannelHandshakeRequest)
                .build());
    }

    /**
     * <p>
     * Adds or updates tags for a specified resource.
     * </p>
     *
     * @param tagResourceRequest
     * @return Result of the TagResource operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InternalServerException
     *         An internal server error occurred while processing the request.
     * @throws ValidationException
     *         The request failed validation due to invalid input parameters.
     * @throws ThrottlingException
     *         The request was throttled due to too many requests being sent in a short period.
     * @throws AccessDeniedException
     *         The request was denied due to insufficient permissions.
     * @throws ConflictException
     *         The request could not be completed due to a conflict with the current state of the resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PartnerCentralChannelException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PartnerCentralChannelClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/partnercentral-channel-2024-03-18/TagResource"
     *      target="_top">AWS API Documentation</a>
     */
    default TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws ResourceNotFoundException,
            InternalServerException, ValidationException, ThrottlingException, AccessDeniedException, ConflictException,
            AwsServiceException, SdkClientException, PartnerCentralChannelException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds or updates tags for a specified resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link TagResourceRequest#builder()}
     * </p>
     *
     * @param tagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.partnercentralchannel.model.TagResourceRequest.Builder} to create a
     *        request.
     * @return Result of the TagResource operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InternalServerException
     *         An internal server error occurred while processing the request.
     * @throws ValidationException
     *         The request failed validation due to invalid input parameters.
     * @throws ThrottlingException
     *         The request was throttled due to too many requests being sent in a short period.
     * @throws AccessDeniedException
     *         The request was denied due to insufficient permissions.
     * @throws ConflictException
     *         The request could not be completed due to a conflict with the current state of the resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PartnerCentralChannelException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PartnerCentralChannelClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/partnercentral-channel-2024-03-18/TagResource"
     *      target="_top">AWS API Documentation</a>
     */
    default TagResourceResponse tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest)
            throws ResourceNotFoundException, InternalServerException, ValidationException, ThrottlingException,
            AccessDeniedException, ConflictException, AwsServiceException, SdkClientException, PartnerCentralChannelException {
        return tagResource(TagResourceRequest.builder().applyMutation(tagResourceRequest).build());
    }

    /**
     * <p>
     * Removes tags from a specified resource.
     * </p>
     *
     * @param untagResourceRequest
     * @return Result of the UntagResource operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InternalServerException
     *         An internal server error occurred while processing the request.
     * @throws ValidationException
     *         The request failed validation due to invalid input parameters.
     * @throws ThrottlingException
     *         The request was throttled due to too many requests being sent in a short period.
     * @throws AccessDeniedException
     *         The request was denied due to insufficient permissions.
     * @throws ConflictException
     *         The request could not be completed due to a conflict with the current state of the resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PartnerCentralChannelException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PartnerCentralChannelClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/partnercentral-channel-2024-03-18/UntagResource"
     *      target="_top">AWS API Documentation</a>
     */
    default UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws ResourceNotFoundException,
            InternalServerException, ValidationException, ThrottlingException, AccessDeniedException, ConflictException,
            AwsServiceException, SdkClientException, PartnerCentralChannelException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes tags from a specified resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UntagResourceRequest#builder()}
     * </p>
     *
     * @param untagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.partnercentralchannel.model.UntagResourceRequest.Builder} to create
     *        a request.
     * @return Result of the UntagResource operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InternalServerException
     *         An internal server error occurred while processing the request.
     * @throws ValidationException
     *         The request failed validation due to invalid input parameters.
     * @throws ThrottlingException
     *         The request was throttled due to too many requests being sent in a short period.
     * @throws AccessDeniedException
     *         The request was denied due to insufficient permissions.
     * @throws ConflictException
     *         The request could not be completed due to a conflict with the current state of the resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PartnerCentralChannelException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PartnerCentralChannelClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/partnercentral-channel-2024-03-18/UntagResource"
     *      target="_top">AWS API Documentation</a>
     */
    default UntagResourceResponse untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest)
            throws ResourceNotFoundException, InternalServerException, ValidationException, ThrottlingException,
            AccessDeniedException, ConflictException, AwsServiceException, SdkClientException, PartnerCentralChannelException {
        return untagResource(UntagResourceRequest.builder().applyMutation(untagResourceRequest).build());
    }

    /**
     * <p>
     * Updates the properties of a program management account.
     * </p>
     *
     * @param updateProgramManagementAccountRequest
     * @return Result of the UpdateProgramManagementAccount operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InternalServerException
     *         An internal server error occurred while processing the request.
     * @throws ValidationException
     *         The request failed validation due to invalid input parameters.
     * @throws ThrottlingException
     *         The request was throttled due to too many requests being sent in a short period.
     * @throws AccessDeniedException
     *         The request was denied due to insufficient permissions.
     * @throws ConflictException
     *         The request could not be completed due to a conflict with the current state of the resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PartnerCentralChannelException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PartnerCentralChannelClient.UpdateProgramManagementAccount
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/partnercentral-channel-2024-03-18/UpdateProgramManagementAccount"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateProgramManagementAccountResponse updateProgramManagementAccount(
            UpdateProgramManagementAccountRequest updateProgramManagementAccountRequest) throws ResourceNotFoundException,
            InternalServerException, ValidationException, ThrottlingException, AccessDeniedException, ConflictException,
            AwsServiceException, SdkClientException, PartnerCentralChannelException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the properties of a program management account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateProgramManagementAccountRequest.Builder}
     * avoiding the need to create one manually via {@link UpdateProgramManagementAccountRequest#builder()}
     * </p>
     *
     * @param updateProgramManagementAccountRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.partnercentralchannel.model.UpdateProgramManagementAccountRequest.Builder}
     *        to create a request.
     * @return Result of the UpdateProgramManagementAccount operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InternalServerException
     *         An internal server error occurred while processing the request.
     * @throws ValidationException
     *         The request failed validation due to invalid input parameters.
     * @throws ThrottlingException
     *         The request was throttled due to too many requests being sent in a short period.
     * @throws AccessDeniedException
     *         The request was denied due to insufficient permissions.
     * @throws ConflictException
     *         The request could not be completed due to a conflict with the current state of the resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PartnerCentralChannelException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PartnerCentralChannelClient.UpdateProgramManagementAccount
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/partnercentral-channel-2024-03-18/UpdateProgramManagementAccount"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateProgramManagementAccountResponse updateProgramManagementAccount(
            Consumer<UpdateProgramManagementAccountRequest.Builder> updateProgramManagementAccountRequest)
            throws ResourceNotFoundException, InternalServerException, ValidationException, ThrottlingException,
            AccessDeniedException, ConflictException, AwsServiceException, SdkClientException, PartnerCentralChannelException {
        return updateProgramManagementAccount(UpdateProgramManagementAccountRequest.builder()
                .applyMutation(updateProgramManagementAccountRequest).build());
    }

    /**
     * <p>
     * Updates the properties of a partner relationship.
     * </p>
     *
     * @param updateRelationshipRequest
     * @return Result of the UpdateRelationship operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InternalServerException
     *         An internal server error occurred while processing the request.
     * @throws ValidationException
     *         The request failed validation due to invalid input parameters.
     * @throws ThrottlingException
     *         The request was throttled due to too many requests being sent in a short period.
     * @throws AccessDeniedException
     *         The request was denied due to insufficient permissions.
     * @throws ConflictException
     *         The request could not be completed due to a conflict with the current state of the resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PartnerCentralChannelException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PartnerCentralChannelClient.UpdateRelationship
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/partnercentral-channel-2024-03-18/UpdateRelationship"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateRelationshipResponse updateRelationship(UpdateRelationshipRequest updateRelationshipRequest)
            throws ResourceNotFoundException, InternalServerException, ValidationException, ThrottlingException,
            AccessDeniedException, ConflictException, AwsServiceException, SdkClientException, PartnerCentralChannelException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the properties of a partner relationship.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateRelationshipRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateRelationshipRequest#builder()}
     * </p>
     *
     * @param updateRelationshipRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.partnercentralchannel.model.UpdateRelationshipRequest.Builder} to
     *        create a request.
     * @return Result of the UpdateRelationship operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InternalServerException
     *         An internal server error occurred while processing the request.
     * @throws ValidationException
     *         The request failed validation due to invalid input parameters.
     * @throws ThrottlingException
     *         The request was throttled due to too many requests being sent in a short period.
     * @throws AccessDeniedException
     *         The request was denied due to insufficient permissions.
     * @throws ConflictException
     *         The request could not be completed due to a conflict with the current state of the resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PartnerCentralChannelException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PartnerCentralChannelClient.UpdateRelationship
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/partnercentral-channel-2024-03-18/UpdateRelationship"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateRelationshipResponse updateRelationship(Consumer<UpdateRelationshipRequest.Builder> updateRelationshipRequest)
            throws ResourceNotFoundException, InternalServerException, ValidationException, ThrottlingException,
            AccessDeniedException, ConflictException, AwsServiceException, SdkClientException, PartnerCentralChannelException {
        return updateRelationship(UpdateRelationshipRequest.builder().applyMutation(updateRelationshipRequest).build());
    }

    /**
     * Create a {@link PartnerCentralChannelClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static PartnerCentralChannelClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link PartnerCentralChannelClient}.
     */
    static PartnerCentralChannelClientBuilder builder() {
        return new DefaultPartnerCentralChannelClientBuilder();
    }

    static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of(SERVICE_METADATA_ID);
    }

    @Override
    default PartnerCentralChannelServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }
}
