/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.partnercentralchannel.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum Program {
    SOLUTION_PROVIDER("SOLUTION_PROVIDER"),
    DISTRIBUTION("DISTRIBUTION"),
    DISTRIBUTION_SELLER("DISTRIBUTION_SELLER"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, Program> VALUE_MAP;
    private final String value;

    private Program(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static Program fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<Program> knownValues() {
        EnumSet<Program> knownValues = EnumSet.allOf(Program.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(Program.class, Program::toString);
    }
}

