/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.partnercentralchannel.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ResaleAccountModel {
    DISTRIBUTOR("DISTRIBUTOR"),
    END_CUSTOMER("END_CUSTOMER"),
    SOLUTION_PROVIDER("SOLUTION_PROVIDER"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ResaleAccountModel> VALUE_MAP;
    private final String value;

    private ResaleAccountModel(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ResaleAccountModel fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ResaleAccountModel> knownValues() {
        EnumSet<ResaleAccountModel> knownValues = EnumSet.allOf(ResaleAccountModel.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ResaleAccountModel.class, ResaleAccountModel::toString);
    }
}

