/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.partnercentralchannel.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum HandshakeStatus {
    PENDING("PENDING"),
    ACCEPTED("ACCEPTED"),
    REJECTED("REJECTED"),
    CANCELED("CANCELED"),
    EXPIRED("EXPIRED"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, HandshakeStatus> VALUE_MAP;
    private final String value;

    private HandshakeStatus(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static HandshakeStatus fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<HandshakeStatus> knownValues() {
        EnumSet<HandshakeStatus> knownValues = EnumSet.allOf(HandshakeStatus.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(HandshakeStatus.class, HandshakeStatus::toString);
    }
}

