/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.partnercentralchannel.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum Coverage {
    ENTIRE_ORGANIZATION("ENTIRE_ORGANIZATION"),
    MANAGEMENT_ACCOUNT_ONLY("MANAGEMENT_ACCOUNT_ONLY"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, Coverage> VALUE_MAP;
    private final String value;

    private Coverage(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static Coverage fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<Coverage> knownValues() {
        EnumSet<Coverage> knownValues = EnumSet.allOf(Coverage.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(Coverage.class, Coverage::toString);
    }
}

