/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.partnercentralbenefits.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.partnercentralbenefits.PartnerCentralBenefitsClient;
import software.amazon.awssdk.services.partnercentralbenefits.internal.UserAgentUtils;
import software.amazon.awssdk.services.partnercentralbenefits.model.BenefitApplicationSummary;
import software.amazon.awssdk.services.partnercentralbenefits.model.ListBenefitApplicationsRequest;
import software.amazon.awssdk.services.partnercentralbenefits.model.ListBenefitApplicationsResponse;

public class ListBenefitApplicationsIterable
implements SdkIterable<ListBenefitApplicationsResponse> {
    private final PartnerCentralBenefitsClient client;
    private final ListBenefitApplicationsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListBenefitApplicationsIterable(PartnerCentralBenefitsClient client, ListBenefitApplicationsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListBenefitApplicationsResponseFetcher();
    }

    public Iterator<ListBenefitApplicationsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<BenefitApplicationSummary> benefitApplicationSummaries() {
        Function<ListBenefitApplicationsResponse, Iterator> getIterator = response -> {
            if (response != null && response.benefitApplicationSummaries() != null) {
                return response.benefitApplicationSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListBenefitApplicationsResponseFetcher
    implements SyncPageFetcher<ListBenefitApplicationsResponse> {
        private ListBenefitApplicationsResponseFetcher() {
        }

        public boolean hasNextPage(ListBenefitApplicationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListBenefitApplicationsResponse nextPage(ListBenefitApplicationsResponse previousPage) {
            if (previousPage == null) {
                return ListBenefitApplicationsIterable.this.client.listBenefitApplications(ListBenefitApplicationsIterable.this.firstRequest);
            }
            return ListBenefitApplicationsIterable.this.client.listBenefitApplications((ListBenefitApplicationsRequest)((Object)ListBenefitApplicationsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

