/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.partnercentralbenefits.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.partnercentralbenefits.PartnerCentralBenefitsClient;
import software.amazon.awssdk.services.partnercentralbenefits.internal.UserAgentUtils;
import software.amazon.awssdk.services.partnercentralbenefits.model.BenefitSummary;
import software.amazon.awssdk.services.partnercentralbenefits.model.ListBenefitsRequest;
import software.amazon.awssdk.services.partnercentralbenefits.model.ListBenefitsResponse;

public class ListBenefitsIterable
implements SdkIterable<ListBenefitsResponse> {
    private final PartnerCentralBenefitsClient client;
    private final ListBenefitsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListBenefitsIterable(PartnerCentralBenefitsClient client, ListBenefitsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListBenefitsResponseFetcher();
    }

    public Iterator<ListBenefitsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<BenefitSummary> benefitSummaries() {
        Function<ListBenefitsResponse, Iterator> getIterator = response -> {
            if (response != null && response.benefitSummaries() != null) {
                return response.benefitSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListBenefitsResponseFetcher
    implements SyncPageFetcher<ListBenefitsResponse> {
        private ListBenefitsResponseFetcher() {
        }

        public boolean hasNextPage(ListBenefitsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListBenefitsResponse nextPage(ListBenefitsResponse previousPage) {
            if (previousPage == null) {
                return ListBenefitsIterable.this.client.listBenefits(ListBenefitsIterable.this.firstRequest);
            }
            return ListBenefitsIterable.this.client.listBenefits((ListBenefitsRequest)((Object)ListBenefitsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

