/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.partnercentralbenefits.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.partnercentralbenefits.model.ArnsCopier;
import software.amazon.awssdk.services.partnercentralbenefits.model.AssociatedResource;
import software.amazon.awssdk.services.partnercentralbenefits.model.AssociatedResourcesCopier;
import software.amazon.awssdk.services.partnercentralbenefits.model.BenefitApplicationStatus;
import software.amazon.awssdk.services.partnercentralbenefits.model.FulfillmentType;
import software.amazon.awssdk.services.partnercentralbenefits.model.ListBenefitApplicationsInputBenefitIdentifiersListCopier;
import software.amazon.awssdk.services.partnercentralbenefits.model.ListBenefitApplicationsInputFulfillmentTypesListCopier;
import software.amazon.awssdk.services.partnercentralbenefits.model.ListBenefitApplicationsInputProgramsListCopier;
import software.amazon.awssdk.services.partnercentralbenefits.model.ListBenefitApplicationsInputStagesListCopier;
import software.amazon.awssdk.services.partnercentralbenefits.model.ListBenefitApplicationsInputStatusListCopier;
import software.amazon.awssdk.services.partnercentralbenefits.model.PartnerCentralBenefitsRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListBenefitApplicationsRequest
extends PartnerCentralBenefitsRequest
implements ToCopyableBuilder<Builder, ListBenefitApplicationsRequest> {
    private static final SdkField<String> CATALOG_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Catalog").getter(ListBenefitApplicationsRequest.getter(ListBenefitApplicationsRequest::catalog)).setter(ListBenefitApplicationsRequest.setter(Builder::catalog)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Catalog").build()}).build();
    private static final SdkField<List<String>> PROGRAMS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Programs").getter(ListBenefitApplicationsRequest.getter(ListBenefitApplicationsRequest::programs)).setter(ListBenefitApplicationsRequest.setter(Builder::programs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Programs").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> FULFILLMENT_TYPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("FulfillmentTypes").getter(ListBenefitApplicationsRequest.getter(ListBenefitApplicationsRequest::fulfillmentTypesAsStrings)).setter(ListBenefitApplicationsRequest.setter(Builder::fulfillmentTypesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FulfillmentTypes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> BENEFIT_IDENTIFIERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("BenefitIdentifiers").getter(ListBenefitApplicationsRequest.getter(ListBenefitApplicationsRequest::benefitIdentifiers)).setter(ListBenefitApplicationsRequest.setter(Builder::benefitIdentifiers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BenefitIdentifiers").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Status").getter(ListBenefitApplicationsRequest.getter(ListBenefitApplicationsRequest::statusAsStrings)).setter(ListBenefitApplicationsRequest.setter(Builder::statusWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> STAGES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Stages").getter(ListBenefitApplicationsRequest.getter(ListBenefitApplicationsRequest::stages)).setter(ListBenefitApplicationsRequest.setter(Builder::stages)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Stages").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<AssociatedResource>> ASSOCIATED_RESOURCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AssociatedResources").getter(ListBenefitApplicationsRequest.getter(ListBenefitApplicationsRequest::associatedResources)).setter(ListBenefitApplicationsRequest.setter(Builder::associatedResources)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssociatedResources").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AssociatedResource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> ASSOCIATED_RESOURCE_ARNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AssociatedResourceArns").getter(ListBenefitApplicationsRequest.getter(ListBenefitApplicationsRequest::associatedResourceArns)).setter(ListBenefitApplicationsRequest.setter(Builder::associatedResourceArns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssociatedResourceArns").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxResults").getter(ListBenefitApplicationsRequest.getter(ListBenefitApplicationsRequest::maxResults)).setter(ListBenefitApplicationsRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListBenefitApplicationsRequest.getter(ListBenefitApplicationsRequest::nextToken)).setter(ListBenefitApplicationsRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CATALOG_FIELD, PROGRAMS_FIELD, FULFILLMENT_TYPES_FIELD, BENEFIT_IDENTIFIERS_FIELD, STATUS_FIELD, STAGES_FIELD, ASSOCIATED_RESOURCES_FIELD, ASSOCIATED_RESOURCE_ARNS_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListBenefitApplicationsRequest.memberNameToFieldInitializer();
    private final String catalog;
    private final List<String> programs;
    private final List<String> fulfillmentTypes;
    private final List<String> benefitIdentifiers;
    private final List<String> status;
    private final List<String> stages;
    private final List<AssociatedResource> associatedResources;
    private final List<String> associatedResourceArns;
    private final Integer maxResults;
    private final String nextToken;

    private ListBenefitApplicationsRequest(BuilderImpl builder) {
        super(builder);
        this.catalog = builder.catalog;
        this.programs = builder.programs;
        this.fulfillmentTypes = builder.fulfillmentTypes;
        this.benefitIdentifiers = builder.benefitIdentifiers;
        this.status = builder.status;
        this.stages = builder.stages;
        this.associatedResources = builder.associatedResources;
        this.associatedResourceArns = builder.associatedResourceArns;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    public final String catalog() {
        return this.catalog;
    }

    public final boolean hasPrograms() {
        return this.programs != null && !(this.programs instanceof SdkAutoConstructList);
    }

    public final List<String> programs() {
        return this.programs;
    }

    public final List<FulfillmentType> fulfillmentTypes() {
        return ListBenefitApplicationsInputFulfillmentTypesListCopier.copyStringToEnum(this.fulfillmentTypes);
    }

    public final boolean hasFulfillmentTypes() {
        return this.fulfillmentTypes != null && !(this.fulfillmentTypes instanceof SdkAutoConstructList);
    }

    public final List<String> fulfillmentTypesAsStrings() {
        return this.fulfillmentTypes;
    }

    public final boolean hasBenefitIdentifiers() {
        return this.benefitIdentifiers != null && !(this.benefitIdentifiers instanceof SdkAutoConstructList);
    }

    public final List<String> benefitIdentifiers() {
        return this.benefitIdentifiers;
    }

    public final List<BenefitApplicationStatus> status() {
        return ListBenefitApplicationsInputStatusListCopier.copyStringToEnum(this.status);
    }

    public final boolean hasStatus() {
        return this.status != null && !(this.status instanceof SdkAutoConstructList);
    }

    public final List<String> statusAsStrings() {
        return this.status;
    }

    public final boolean hasStages() {
        return this.stages != null && !(this.stages instanceof SdkAutoConstructList);
    }

    public final List<String> stages() {
        return this.stages;
    }

    @Deprecated
    public final boolean hasAssociatedResources() {
        return this.associatedResources != null && !(this.associatedResources instanceof SdkAutoConstructList);
    }

    @Deprecated
    public final List<AssociatedResource> associatedResources() {
        return this.associatedResources;
    }

    public final boolean hasAssociatedResourceArns() {
        return this.associatedResourceArns != null && !(this.associatedResourceArns instanceof SdkAutoConstructList);
    }

    public final List<String> associatedResourceArns() {
        return this.associatedResourceArns;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.catalog());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPrograms() ? this.programs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFulfillmentTypes() ? this.fulfillmentTypesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasBenefitIdentifiers() ? this.benefitIdentifiers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasStatus() ? this.statusAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasStages() ? this.stages() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAssociatedResources() ? this.associatedResources() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAssociatedResourceArns() ? this.associatedResourceArns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListBenefitApplicationsRequest)) {
            return false;
        }
        ListBenefitApplicationsRequest other = (ListBenefitApplicationsRequest)((Object)obj);
        return Objects.equals(this.catalog(), other.catalog()) && this.hasPrograms() == other.hasPrograms() && Objects.equals(this.programs(), other.programs()) && this.hasFulfillmentTypes() == other.hasFulfillmentTypes() && Objects.equals(this.fulfillmentTypesAsStrings(), other.fulfillmentTypesAsStrings()) && this.hasBenefitIdentifiers() == other.hasBenefitIdentifiers() && Objects.equals(this.benefitIdentifiers(), other.benefitIdentifiers()) && this.hasStatus() == other.hasStatus() && Objects.equals(this.statusAsStrings(), other.statusAsStrings()) && this.hasStages() == other.hasStages() && Objects.equals(this.stages(), other.stages()) && this.hasAssociatedResources() == other.hasAssociatedResources() && Objects.equals(this.associatedResources(), other.associatedResources()) && this.hasAssociatedResourceArns() == other.hasAssociatedResourceArns() && Objects.equals(this.associatedResourceArns(), other.associatedResourceArns()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListBenefitApplicationsRequest").add("Catalog", (Object)this.catalog()).add("Programs", this.hasPrograms() ? this.programs() : null).add("FulfillmentTypes", this.hasFulfillmentTypes() ? this.fulfillmentTypesAsStrings() : null).add("BenefitIdentifiers", this.hasBenefitIdentifiers() ? this.benefitIdentifiers() : null).add("Status", this.hasStatus() ? this.statusAsStrings() : null).add("Stages", this.hasStages() ? this.stages() : null).add("AssociatedResources", this.hasAssociatedResources() ? this.associatedResources() : null).add("AssociatedResourceArns", this.hasAssociatedResourceArns() ? this.associatedResourceArns() : null).add("MaxResults", (Object)this.maxResults()).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Catalog": {
                return Optional.ofNullable(clazz.cast(this.catalog()));
            }
            case "Programs": {
                return Optional.ofNullable(clazz.cast(this.programs()));
            }
            case "FulfillmentTypes": {
                return Optional.ofNullable(clazz.cast(this.fulfillmentTypesAsStrings()));
            }
            case "BenefitIdentifiers": {
                return Optional.ofNullable(clazz.cast(this.benefitIdentifiers()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsStrings()));
            }
            case "Stages": {
                return Optional.ofNullable(clazz.cast(this.stages()));
            }
            case "AssociatedResources": {
                return Optional.ofNullable(clazz.cast(this.associatedResources()));
            }
            case "AssociatedResourceArns": {
                return Optional.ofNullable(clazz.cast(this.associatedResourceArns()));
            }
            case "MaxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Catalog", CATALOG_FIELD);
        map.put("Programs", PROGRAMS_FIELD);
        map.put("FulfillmentTypes", FULFILLMENT_TYPES_FIELD);
        map.put("BenefitIdentifiers", BENEFIT_IDENTIFIERS_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("Stages", STAGES_FIELD);
        map.put("AssociatedResources", ASSOCIATED_RESOURCES_FIELD);
        map.put("AssociatedResourceArns", ASSOCIATED_RESOURCE_ARNS_FIELD);
        map.put("MaxResults", MAX_RESULTS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListBenefitApplicationsRequest, T> g) {
        return obj -> g.apply((ListBenefitApplicationsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends PartnerCentralBenefitsRequest.BuilderImpl
    implements Builder {
        private String catalog;
        private List<String> programs = DefaultSdkAutoConstructList.getInstance();
        private List<String> fulfillmentTypes = DefaultSdkAutoConstructList.getInstance();
        private List<String> benefitIdentifiers = DefaultSdkAutoConstructList.getInstance();
        private List<String> status = DefaultSdkAutoConstructList.getInstance();
        private List<String> stages = DefaultSdkAutoConstructList.getInstance();
        private List<AssociatedResource> associatedResources = DefaultSdkAutoConstructList.getInstance();
        private List<String> associatedResourceArns = DefaultSdkAutoConstructList.getInstance();
        private Integer maxResults;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListBenefitApplicationsRequest model) {
            super(model);
            this.catalog(model.catalog);
            this.programs(model.programs);
            this.fulfillmentTypesWithStrings(model.fulfillmentTypes);
            this.benefitIdentifiers(model.benefitIdentifiers);
            this.statusWithStrings(model.status);
            this.stages(model.stages);
            this.associatedResources(model.associatedResources);
            this.associatedResourceArns(model.associatedResourceArns);
            this.maxResults(model.maxResults);
            this.nextToken(model.nextToken);
        }

        public final String getCatalog() {
            return this.catalog;
        }

        public final void setCatalog(String catalog) {
            this.catalog = catalog;
        }

        @Override
        public final Builder catalog(String catalog) {
            this.catalog = catalog;
            return this;
        }

        public final Collection<String> getPrograms() {
            if (this.programs instanceof SdkAutoConstructList) {
                return null;
            }
            return this.programs;
        }

        public final void setPrograms(Collection<String> programs) {
            this.programs = ListBenefitApplicationsInputProgramsListCopier.copy(programs);
        }

        @Override
        public final Builder programs(Collection<String> programs) {
            this.programs = ListBenefitApplicationsInputProgramsListCopier.copy(programs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder programs(String ... programs) {
            this.programs(Arrays.asList(programs));
            return this;
        }

        public final Collection<String> getFulfillmentTypes() {
            if (this.fulfillmentTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.fulfillmentTypes;
        }

        public final void setFulfillmentTypes(Collection<String> fulfillmentTypes) {
            this.fulfillmentTypes = ListBenefitApplicationsInputFulfillmentTypesListCopier.copy(fulfillmentTypes);
        }

        @Override
        public final Builder fulfillmentTypesWithStrings(Collection<String> fulfillmentTypes) {
            this.fulfillmentTypes = ListBenefitApplicationsInputFulfillmentTypesListCopier.copy(fulfillmentTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fulfillmentTypesWithStrings(String ... fulfillmentTypes) {
            this.fulfillmentTypesWithStrings(Arrays.asList(fulfillmentTypes));
            return this;
        }

        @Override
        public final Builder fulfillmentTypes(Collection<FulfillmentType> fulfillmentTypes) {
            this.fulfillmentTypes = ListBenefitApplicationsInputFulfillmentTypesListCopier.copyEnumToString(fulfillmentTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fulfillmentTypes(FulfillmentType ... fulfillmentTypes) {
            this.fulfillmentTypes(Arrays.asList(fulfillmentTypes));
            return this;
        }

        public final Collection<String> getBenefitIdentifiers() {
            if (this.benefitIdentifiers instanceof SdkAutoConstructList) {
                return null;
            }
            return this.benefitIdentifiers;
        }

        public final void setBenefitIdentifiers(Collection<String> benefitIdentifiers) {
            this.benefitIdentifiers = ListBenefitApplicationsInputBenefitIdentifiersListCopier.copy(benefitIdentifiers);
        }

        @Override
        public final Builder benefitIdentifiers(Collection<String> benefitIdentifiers) {
            this.benefitIdentifiers = ListBenefitApplicationsInputBenefitIdentifiersListCopier.copy(benefitIdentifiers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder benefitIdentifiers(String ... benefitIdentifiers) {
            this.benefitIdentifiers(Arrays.asList(benefitIdentifiers));
            return this;
        }

        public final Collection<String> getStatus() {
            if (this.status instanceof SdkAutoConstructList) {
                return null;
            }
            return this.status;
        }

        public final void setStatus(Collection<String> status) {
            this.status = ListBenefitApplicationsInputStatusListCopier.copy(status);
        }

        @Override
        public final Builder statusWithStrings(Collection<String> status) {
            this.status = ListBenefitApplicationsInputStatusListCopier.copy(status);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder statusWithStrings(String ... status) {
            this.statusWithStrings(Arrays.asList(status));
            return this;
        }

        @Override
        public final Builder status(Collection<BenefitApplicationStatus> status) {
            this.status = ListBenefitApplicationsInputStatusListCopier.copyEnumToString(status);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder status(BenefitApplicationStatus ... status) {
            this.status(Arrays.asList(status));
            return this;
        }

        public final Collection<String> getStages() {
            if (this.stages instanceof SdkAutoConstructList) {
                return null;
            }
            return this.stages;
        }

        public final void setStages(Collection<String> stages) {
            this.stages = ListBenefitApplicationsInputStagesListCopier.copy(stages);
        }

        @Override
        public final Builder stages(Collection<String> stages) {
            this.stages = ListBenefitApplicationsInputStagesListCopier.copy(stages);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder stages(String ... stages) {
            this.stages(Arrays.asList(stages));
            return this;
        }

        @Deprecated
        public final List<AssociatedResource.Builder> getAssociatedResources() {
            List<AssociatedResource.Builder> result = AssociatedResourcesCopier.copyToBuilder(this.associatedResources);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Deprecated
        public final void setAssociatedResources(Collection<AssociatedResource.BuilderImpl> associatedResources) {
            this.associatedResources = AssociatedResourcesCopier.copyFromBuilder(associatedResources);
        }

        @Override
        @Deprecated
        public final Builder associatedResources(Collection<AssociatedResource> associatedResources) {
            this.associatedResources = AssociatedResourcesCopier.copy(associatedResources);
            return this;
        }

        @Override
        @SafeVarargs
        @Deprecated
        public final Builder associatedResources(AssociatedResource ... associatedResources) {
            this.associatedResources(Arrays.asList(associatedResources));
            return this;
        }

        @Override
        @SafeVarargs
        @Deprecated
        public final Builder associatedResources(Consumer<AssociatedResource.Builder> ... associatedResources) {
            this.associatedResources(Stream.of(associatedResources).map(c -> (AssociatedResource)((AssociatedResource.Builder)AssociatedResource.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Collection<String> getAssociatedResourceArns() {
            if (this.associatedResourceArns instanceof SdkAutoConstructList) {
                return null;
            }
            return this.associatedResourceArns;
        }

        public final void setAssociatedResourceArns(Collection<String> associatedResourceArns) {
            this.associatedResourceArns = ArnsCopier.copy(associatedResourceArns);
        }

        @Override
        public final Builder associatedResourceArns(Collection<String> associatedResourceArns) {
            this.associatedResourceArns = ArnsCopier.copy(associatedResourceArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder associatedResourceArns(String ... associatedResourceArns) {
            this.associatedResourceArns(Arrays.asList(associatedResourceArns));
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListBenefitApplicationsRequest build() {
            return new ListBenefitApplicationsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends PartnerCentralBenefitsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListBenefitApplicationsRequest> {
        public Builder catalog(String var1);

        public Builder programs(Collection<String> var1);

        public Builder programs(String ... var1);

        public Builder fulfillmentTypesWithStrings(Collection<String> var1);

        public Builder fulfillmentTypesWithStrings(String ... var1);

        public Builder fulfillmentTypes(Collection<FulfillmentType> var1);

        public Builder fulfillmentTypes(FulfillmentType ... var1);

        public Builder benefitIdentifiers(Collection<String> var1);

        public Builder benefitIdentifiers(String ... var1);

        public Builder statusWithStrings(Collection<String> var1);

        public Builder statusWithStrings(String ... var1);

        public Builder status(Collection<BenefitApplicationStatus> var1);

        public Builder status(BenefitApplicationStatus ... var1);

        public Builder stages(Collection<String> var1);

        public Builder stages(String ... var1);

        @Deprecated
        public Builder associatedResources(Collection<AssociatedResource> var1);

        @Deprecated
        public Builder associatedResources(AssociatedResource ... var1);

        @Deprecated
        public Builder associatedResources(Consumer<AssociatedResource.Builder> ... var1);

        public Builder associatedResourceArns(Collection<String> var1);

        public Builder associatedResourceArns(String ... var1);

        public Builder maxResults(Integer var1);

        public Builder nextToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

