/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.partnercentralbenefits.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.partnercentralbenefits.model.CreditCode;
import software.amazon.awssdk.services.partnercentralbenefits.model.CreditCodesCopier;
import software.amazon.awssdk.services.partnercentralbenefits.model.MonetaryValue;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreditDetails
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CreditDetails> {
    private static final SdkField<MonetaryValue> ALLOCATED_AMOUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AllocatedAmount").getter(CreditDetails.getter(CreditDetails::allocatedAmount)).setter(CreditDetails.setter(Builder::allocatedAmount)).constructor(MonetaryValue::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllocatedAmount").build()}).build();
    private static final SdkField<MonetaryValue> ISSUED_AMOUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("IssuedAmount").getter(CreditDetails.getter(CreditDetails::issuedAmount)).setter(CreditDetails.setter(Builder::issuedAmount)).constructor(MonetaryValue::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IssuedAmount").build()}).build();
    private static final SdkField<List<CreditCode>> CODES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Codes").getter(CreditDetails.getter(CreditDetails::codes)).setter(CreditDetails.setter(Builder::codes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Codes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CreditCode::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ALLOCATED_AMOUNT_FIELD, ISSUED_AMOUNT_FIELD, CODES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreditDetails.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final MonetaryValue allocatedAmount;
    private final MonetaryValue issuedAmount;
    private final List<CreditCode> codes;

    private CreditDetails(BuilderImpl builder) {
        this.allocatedAmount = builder.allocatedAmount;
        this.issuedAmount = builder.issuedAmount;
        this.codes = builder.codes;
    }

    public final MonetaryValue allocatedAmount() {
        return this.allocatedAmount;
    }

    public final MonetaryValue issuedAmount() {
        return this.issuedAmount;
    }

    public final boolean hasCodes() {
        return this.codes != null && !(this.codes instanceof SdkAutoConstructList);
    }

    public final List<CreditCode> codes() {
        return this.codes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.allocatedAmount());
        hashCode = 31 * hashCode + Objects.hashCode(this.issuedAmount());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCodes() ? this.codes() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreditDetails)) {
            return false;
        }
        CreditDetails other = (CreditDetails)obj;
        return Objects.equals(this.allocatedAmount(), other.allocatedAmount()) && Objects.equals(this.issuedAmount(), other.issuedAmount()) && this.hasCodes() == other.hasCodes() && Objects.equals(this.codes(), other.codes());
    }

    public final String toString() {
        return ToString.builder((String)"CreditDetails").add("AllocatedAmount", (Object)this.allocatedAmount()).add("IssuedAmount", (Object)this.issuedAmount()).add("Codes", this.hasCodes() ? this.codes() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AllocatedAmount": {
                return Optional.ofNullable(clazz.cast(this.allocatedAmount()));
            }
            case "IssuedAmount": {
                return Optional.ofNullable(clazz.cast(this.issuedAmount()));
            }
            case "Codes": {
                return Optional.ofNullable(clazz.cast(this.codes()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("AllocatedAmount", ALLOCATED_AMOUNT_FIELD);
        map.put("IssuedAmount", ISSUED_AMOUNT_FIELD);
        map.put("Codes", CODES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreditDetails, T> g) {
        return obj -> g.apply((CreditDetails)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private MonetaryValue allocatedAmount;
        private MonetaryValue issuedAmount;
        private List<CreditCode> codes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreditDetails model) {
            this.allocatedAmount(model.allocatedAmount);
            this.issuedAmount(model.issuedAmount);
            this.codes(model.codes);
        }

        public final MonetaryValue.Builder getAllocatedAmount() {
            return this.allocatedAmount != null ? this.allocatedAmount.toBuilder() : null;
        }

        public final void setAllocatedAmount(MonetaryValue.BuilderImpl allocatedAmount) {
            this.allocatedAmount = allocatedAmount != null ? allocatedAmount.build() : null;
        }

        @Override
        public final Builder allocatedAmount(MonetaryValue allocatedAmount) {
            this.allocatedAmount = allocatedAmount;
            return this;
        }

        public final MonetaryValue.Builder getIssuedAmount() {
            return this.issuedAmount != null ? this.issuedAmount.toBuilder() : null;
        }

        public final void setIssuedAmount(MonetaryValue.BuilderImpl issuedAmount) {
            this.issuedAmount = issuedAmount != null ? issuedAmount.build() : null;
        }

        @Override
        public final Builder issuedAmount(MonetaryValue issuedAmount) {
            this.issuedAmount = issuedAmount;
            return this;
        }

        public final List<CreditCode.Builder> getCodes() {
            List<CreditCode.Builder> result = CreditCodesCopier.copyToBuilder(this.codes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCodes(Collection<CreditCode.BuilderImpl> codes) {
            this.codes = CreditCodesCopier.copyFromBuilder(codes);
        }

        @Override
        public final Builder codes(Collection<CreditCode> codes) {
            this.codes = CreditCodesCopier.copy(codes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder codes(CreditCode ... codes) {
            this.codes(Arrays.asList(codes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder codes(Consumer<CreditCode.Builder> ... codes) {
            this.codes(Stream.of(codes).map(c -> (CreditCode)((CreditCode.Builder)CreditCode.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public CreditDetails build() {
            return new CreditDetails(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CreditDetails> {
        public Builder allocatedAmount(MonetaryValue var1);

        default public Builder allocatedAmount(Consumer<MonetaryValue.Builder> allocatedAmount) {
            return this.allocatedAmount((MonetaryValue)((MonetaryValue.Builder)MonetaryValue.builder().applyMutation(allocatedAmount)).build());
        }

        public Builder issuedAmount(MonetaryValue var1);

        default public Builder issuedAmount(Consumer<MonetaryValue.Builder> issuedAmount) {
            return this.issuedAmount((MonetaryValue)((MonetaryValue.Builder)MonetaryValue.builder().applyMutation(issuedAmount)).build());
        }

        public Builder codes(Collection<CreditCode> var1);

        public Builder codes(CreditCode ... var1);

        public Builder codes(Consumer<CreditCode.Builder> ... var1);
    }
}

