/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.partnercentralbenefits.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.partnercentralbenefits.PartnerCentralBenefitsClient;
import software.amazon.awssdk.services.partnercentralbenefits.internal.UserAgentUtils;
import software.amazon.awssdk.services.partnercentralbenefits.model.BenefitAllocationSummary;
import software.amazon.awssdk.services.partnercentralbenefits.model.ListBenefitAllocationsRequest;
import software.amazon.awssdk.services.partnercentralbenefits.model.ListBenefitAllocationsResponse;

public class ListBenefitAllocationsIterable
implements SdkIterable<ListBenefitAllocationsResponse> {
    private final PartnerCentralBenefitsClient client;
    private final ListBenefitAllocationsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListBenefitAllocationsIterable(PartnerCentralBenefitsClient client, ListBenefitAllocationsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListBenefitAllocationsResponseFetcher();
    }

    public Iterator<ListBenefitAllocationsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<BenefitAllocationSummary> benefitAllocationSummaries() {
        Function<ListBenefitAllocationsResponse, Iterator> getIterator = response -> {
            if (response != null && response.benefitAllocationSummaries() != null) {
                return response.benefitAllocationSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListBenefitAllocationsResponseFetcher
    implements SyncPageFetcher<ListBenefitAllocationsResponse> {
        private ListBenefitAllocationsResponseFetcher() {
        }

        public boolean hasNextPage(ListBenefitAllocationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListBenefitAllocationsResponse nextPage(ListBenefitAllocationsResponse previousPage) {
            if (previousPage == null) {
                return ListBenefitAllocationsIterable.this.client.listBenefitAllocations(ListBenefitAllocationsIterable.this.firstRequest);
            }
            return ListBenefitAllocationsIterable.this.client.listBenefitAllocations((ListBenefitAllocationsRequest)((Object)ListBenefitAllocationsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

