/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.partnercentralbenefits.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.partnercentralbenefits.model.BenefitSummariesCopier;
import software.amazon.awssdk.services.partnercentralbenefits.model.BenefitSummary;
import software.amazon.awssdk.services.partnercentralbenefits.model.PartnerCentralBenefitsResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListBenefitsResponse
extends PartnerCentralBenefitsResponse
implements ToCopyableBuilder<Builder, ListBenefitsResponse> {
    private static final SdkField<List<BenefitSummary>> BENEFIT_SUMMARIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("BenefitSummaries").getter(ListBenefitsResponse.getter(ListBenefitsResponse::benefitSummaries)).setter(ListBenefitsResponse.setter(Builder::benefitSummaries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BenefitSummaries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(BenefitSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListBenefitsResponse.getter(ListBenefitsResponse::nextToken)).setter(ListBenefitsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BENEFIT_SUMMARIES_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListBenefitsResponse.memberNameToFieldInitializer();
    private final List<BenefitSummary> benefitSummaries;
    private final String nextToken;

    private ListBenefitsResponse(BuilderImpl builder) {
        super(builder);
        this.benefitSummaries = builder.benefitSummaries;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasBenefitSummaries() {
        return this.benefitSummaries != null && !(this.benefitSummaries instanceof SdkAutoConstructList);
    }

    public final List<BenefitSummary> benefitSummaries() {
        return this.benefitSummaries;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasBenefitSummaries() ? this.benefitSummaries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListBenefitsResponse)) {
            return false;
        }
        ListBenefitsResponse other = (ListBenefitsResponse)((Object)obj);
        return this.hasBenefitSummaries() == other.hasBenefitSummaries() && Objects.equals(this.benefitSummaries(), other.benefitSummaries()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListBenefitsResponse").add("BenefitSummaries", this.hasBenefitSummaries() ? this.benefitSummaries() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "BenefitSummaries": {
                return Optional.ofNullable(clazz.cast(this.benefitSummaries()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("BenefitSummaries", BENEFIT_SUMMARIES_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListBenefitsResponse, T> g) {
        return obj -> g.apply((ListBenefitsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends PartnerCentralBenefitsResponse.BuilderImpl
    implements Builder {
        private List<BenefitSummary> benefitSummaries = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListBenefitsResponse model) {
            super(model);
            this.benefitSummaries(model.benefitSummaries);
            this.nextToken(model.nextToken);
        }

        public final List<BenefitSummary.Builder> getBenefitSummaries() {
            List<BenefitSummary.Builder> result = BenefitSummariesCopier.copyToBuilder(this.benefitSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setBenefitSummaries(Collection<BenefitSummary.BuilderImpl> benefitSummaries) {
            this.benefitSummaries = BenefitSummariesCopier.copyFromBuilder(benefitSummaries);
        }

        @Override
        public final Builder benefitSummaries(Collection<BenefitSummary> benefitSummaries) {
            this.benefitSummaries = BenefitSummariesCopier.copy(benefitSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder benefitSummaries(BenefitSummary ... benefitSummaries) {
            this.benefitSummaries(Arrays.asList(benefitSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder benefitSummaries(Consumer<BenefitSummary.Builder> ... benefitSummaries) {
            this.benefitSummaries(Stream.of(benefitSummaries).map(c -> (BenefitSummary)((BenefitSummary.Builder)BenefitSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListBenefitsResponse build() {
            return new ListBenefitsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends PartnerCentralBenefitsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListBenefitsResponse> {
        public Builder benefitSummaries(Collection<BenefitSummary> var1);

        public Builder benefitSummaries(BenefitSummary ... var1);

        public Builder benefitSummaries(Consumer<BenefitSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

