/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.partnercentralbenefits.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class FileInput
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, FileInput> {
    private static final SdkField<String> FILE_URI_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FileURI").getter(FileInput.getter(FileInput::fileURI)).setter(FileInput.setter(Builder::fileURI)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FileURI").build()}).build();
    private static final SdkField<String> BUSINESS_USE_CASE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BusinessUseCase").getter(FileInput.getter(FileInput::businessUseCase)).setter(FileInput.setter(Builder::businessUseCase)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BusinessUseCase").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILE_URI_FIELD, BUSINESS_USE_CASE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = FileInput.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String fileURI;
    private final String businessUseCase;

    private FileInput(BuilderImpl builder) {
        this.fileURI = builder.fileURI;
        this.businessUseCase = builder.businessUseCase;
    }

    public final String fileURI() {
        return this.fileURI;
    }

    public final String businessUseCase() {
        return this.businessUseCase;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.fileURI());
        hashCode = 31 * hashCode + Objects.hashCode(this.businessUseCase());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FileInput)) {
            return false;
        }
        FileInput other = (FileInput)obj;
        return Objects.equals(this.fileURI(), other.fileURI()) && Objects.equals(this.businessUseCase(), other.businessUseCase());
    }

    public final String toString() {
        return ToString.builder((String)"FileInput").add("FileURI", (Object)this.fileURI()).add("BusinessUseCase", (Object)this.businessUseCase()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FileURI": {
                return Optional.ofNullable(clazz.cast(this.fileURI()));
            }
            case "BusinessUseCase": {
                return Optional.ofNullable(clazz.cast(this.businessUseCase()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("FileURI", FILE_URI_FIELD);
        map.put("BusinessUseCase", BUSINESS_USE_CASE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<FileInput, T> g) {
        return obj -> g.apply((FileInput)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String fileURI;
        private String businessUseCase;

        private BuilderImpl() {
        }

        private BuilderImpl(FileInput model) {
            this.fileURI(model.fileURI);
            this.businessUseCase(model.businessUseCase);
        }

        public final String getFileURI() {
            return this.fileURI;
        }

        public final void setFileURI(String fileURI) {
            this.fileURI = fileURI;
        }

        @Override
        public final Builder fileURI(String fileURI) {
            this.fileURI = fileURI;
            return this;
        }

        public final String getBusinessUseCase() {
            return this.businessUseCase;
        }

        public final void setBusinessUseCase(String businessUseCase) {
            this.businessUseCase = businessUseCase;
        }

        @Override
        public final Builder businessUseCase(String businessUseCase) {
            this.businessUseCase = businessUseCase;
            return this;
        }

        public FileInput build() {
            return new FileInput(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, FileInput> {
        public Builder fileURI(String var1);

        public Builder businessUseCase(String var1);
    }
}

