/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.partnercentralbenefits.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.partnercentralbenefits.model.ArnsCopier;
import software.amazon.awssdk.services.partnercentralbenefits.model.AttributesCopier;
import software.amazon.awssdk.services.partnercentralbenefits.model.BenefitApplicationStatus;
import software.amazon.awssdk.services.partnercentralbenefits.model.FulfillmentType;
import software.amazon.awssdk.services.partnercentralbenefits.model.FulfillmentTypesCopier;
import software.amazon.awssdk.services.partnercentralbenefits.model.ProgramsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BenefitApplicationSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, BenefitApplicationSummary> {
    private static final SdkField<String> CATALOG_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Catalog").getter(BenefitApplicationSummary.getter(BenefitApplicationSummary::catalog)).setter(BenefitApplicationSummary.setter(Builder::catalog)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Catalog").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(BenefitApplicationSummary.getter(BenefitApplicationSummary::name)).setter(BenefitApplicationSummary.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Id").getter(BenefitApplicationSummary.getter(BenefitApplicationSummary::id)).setter(BenefitApplicationSummary.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()}).build();
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Arn").getter(BenefitApplicationSummary.getter(BenefitApplicationSummary::arn)).setter(BenefitApplicationSummary.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()}).build();
    private static final SdkField<String> BENEFIT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BenefitId").getter(BenefitApplicationSummary.getter(BenefitApplicationSummary::benefitId)).setter(BenefitApplicationSummary.setter(Builder::benefitId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BenefitId").build()}).build();
    private static final SdkField<List<String>> PROGRAMS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Programs").getter(BenefitApplicationSummary.getter(BenefitApplicationSummary::programs)).setter(BenefitApplicationSummary.setter(Builder::programs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Programs").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> FULFILLMENT_TYPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("FulfillmentTypes").getter(BenefitApplicationSummary.getter(BenefitApplicationSummary::fulfillmentTypesAsStrings)).setter(BenefitApplicationSummary.setter(Builder::fulfillmentTypesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FulfillmentTypes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(BenefitApplicationSummary.getter(BenefitApplicationSummary::statusAsString)).setter(BenefitApplicationSummary.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<String> STAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Stage").getter(BenefitApplicationSummary.getter(BenefitApplicationSummary::stage)).setter(BenefitApplicationSummary.setter(Builder::stage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Stage").build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreatedAt").getter(BenefitApplicationSummary.getter(BenefitApplicationSummary::createdAt)).setter(BenefitApplicationSummary.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("UpdatedAt").getter(BenefitApplicationSummary.getter(BenefitApplicationSummary::updatedAt)).setter(BenefitApplicationSummary.setter(Builder::updatedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdatedAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<Map<String, String>> BENEFIT_APPLICATION_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("BenefitApplicationDetails").getter(BenefitApplicationSummary.getter(BenefitApplicationSummary::benefitApplicationDetails)).setter(BenefitApplicationSummary.setter(Builder::benefitApplicationDetails)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BenefitApplicationDetails").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<List<String>> ASSOCIATED_RESOURCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AssociatedResources").getter(BenefitApplicationSummary.getter(BenefitApplicationSummary::associatedResources)).setter(BenefitApplicationSummary.setter(Builder::associatedResources)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssociatedResources").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CATALOG_FIELD, NAME_FIELD, ID_FIELD, ARN_FIELD, BENEFIT_ID_FIELD, PROGRAMS_FIELD, FULFILLMENT_TYPES_FIELD, STATUS_FIELD, STAGE_FIELD, CREATED_AT_FIELD, UPDATED_AT_FIELD, BENEFIT_APPLICATION_DETAILS_FIELD, ASSOCIATED_RESOURCES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = BenefitApplicationSummary.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String catalog;
    private final String name;
    private final String id;
    private final String arn;
    private final String benefitId;
    private final List<String> programs;
    private final List<String> fulfillmentTypes;
    private final String status;
    private final String stage;
    private final Instant createdAt;
    private final Instant updatedAt;
    private final Map<String, String> benefitApplicationDetails;
    private final List<String> associatedResources;

    private BenefitApplicationSummary(BuilderImpl builder) {
        this.catalog = builder.catalog;
        this.name = builder.name;
        this.id = builder.id;
        this.arn = builder.arn;
        this.benefitId = builder.benefitId;
        this.programs = builder.programs;
        this.fulfillmentTypes = builder.fulfillmentTypes;
        this.status = builder.status;
        this.stage = builder.stage;
        this.createdAt = builder.createdAt;
        this.updatedAt = builder.updatedAt;
        this.benefitApplicationDetails = builder.benefitApplicationDetails;
        this.associatedResources = builder.associatedResources;
    }

    public final String catalog() {
        return this.catalog;
    }

    public final String name() {
        return this.name;
    }

    public final String id() {
        return this.id;
    }

    public final String arn() {
        return this.arn;
    }

    public final String benefitId() {
        return this.benefitId;
    }

    public final boolean hasPrograms() {
        return this.programs != null && !(this.programs instanceof SdkAutoConstructList);
    }

    public final List<String> programs() {
        return this.programs;
    }

    public final List<FulfillmentType> fulfillmentTypes() {
        return FulfillmentTypesCopier.copyStringToEnum(this.fulfillmentTypes);
    }

    public final boolean hasFulfillmentTypes() {
        return this.fulfillmentTypes != null && !(this.fulfillmentTypes instanceof SdkAutoConstructList);
    }

    public final List<String> fulfillmentTypesAsStrings() {
        return this.fulfillmentTypes;
    }

    public final BenefitApplicationStatus status() {
        return BenefitApplicationStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String stage() {
        return this.stage;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final Instant updatedAt() {
        return this.updatedAt;
    }

    public final boolean hasBenefitApplicationDetails() {
        return this.benefitApplicationDetails != null && !(this.benefitApplicationDetails instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> benefitApplicationDetails() {
        return this.benefitApplicationDetails;
    }

    public final boolean hasAssociatedResources() {
        return this.associatedResources != null && !(this.associatedResources instanceof SdkAutoConstructList);
    }

    public final List<String> associatedResources() {
        return this.associatedResources;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.catalog());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.benefitId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPrograms() ? this.programs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFulfillmentTypes() ? this.fulfillmentTypesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.stage());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.updatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasBenefitApplicationDetails() ? this.benefitApplicationDetails() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAssociatedResources() ? this.associatedResources() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BenefitApplicationSummary)) {
            return false;
        }
        BenefitApplicationSummary other = (BenefitApplicationSummary)obj;
        return Objects.equals(this.catalog(), other.catalog()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.id(), other.id()) && Objects.equals(this.arn(), other.arn()) && Objects.equals(this.benefitId(), other.benefitId()) && this.hasPrograms() == other.hasPrograms() && Objects.equals(this.programs(), other.programs()) && this.hasFulfillmentTypes() == other.hasFulfillmentTypes() && Objects.equals(this.fulfillmentTypesAsStrings(), other.fulfillmentTypesAsStrings()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.stage(), other.stage()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.updatedAt(), other.updatedAt()) && this.hasBenefitApplicationDetails() == other.hasBenefitApplicationDetails() && Objects.equals(this.benefitApplicationDetails(), other.benefitApplicationDetails()) && this.hasAssociatedResources() == other.hasAssociatedResources() && Objects.equals(this.associatedResources(), other.associatedResources());
    }

    public final String toString() {
        return ToString.builder((String)"BenefitApplicationSummary").add("Catalog", (Object)this.catalog()).add("Name", (Object)this.name()).add("Id", (Object)this.id()).add("Arn", (Object)this.arn()).add("BenefitId", (Object)this.benefitId()).add("Programs", this.hasPrograms() ? this.programs() : null).add("FulfillmentTypes", this.hasFulfillmentTypes() ? this.fulfillmentTypesAsStrings() : null).add("Status", (Object)this.statusAsString()).add("Stage", (Object)this.stage()).add("CreatedAt", (Object)this.createdAt()).add("UpdatedAt", (Object)this.updatedAt()).add("BenefitApplicationDetails", this.hasBenefitApplicationDetails() ? this.benefitApplicationDetails() : null).add("AssociatedResources", this.hasAssociatedResources() ? this.associatedResources() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Catalog": {
                return Optional.ofNullable(clazz.cast(this.catalog()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "Arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "BenefitId": {
                return Optional.ofNullable(clazz.cast(this.benefitId()));
            }
            case "Programs": {
                return Optional.ofNullable(clazz.cast(this.programs()));
            }
            case "FulfillmentTypes": {
                return Optional.ofNullable(clazz.cast(this.fulfillmentTypesAsStrings()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "Stage": {
                return Optional.ofNullable(clazz.cast(this.stage()));
            }
            case "CreatedAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "UpdatedAt": {
                return Optional.ofNullable(clazz.cast(this.updatedAt()));
            }
            case "BenefitApplicationDetails": {
                return Optional.ofNullable(clazz.cast(this.benefitApplicationDetails()));
            }
            case "AssociatedResources": {
                return Optional.ofNullable(clazz.cast(this.associatedResources()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Catalog", CATALOG_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("Id", ID_FIELD);
        map.put("Arn", ARN_FIELD);
        map.put("BenefitId", BENEFIT_ID_FIELD);
        map.put("Programs", PROGRAMS_FIELD);
        map.put("FulfillmentTypes", FULFILLMENT_TYPES_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("Stage", STAGE_FIELD);
        map.put("CreatedAt", CREATED_AT_FIELD);
        map.put("UpdatedAt", UPDATED_AT_FIELD);
        map.put("BenefitApplicationDetails", BENEFIT_APPLICATION_DETAILS_FIELD);
        map.put("AssociatedResources", ASSOCIATED_RESOURCES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BenefitApplicationSummary, T> g) {
        return obj -> g.apply((BenefitApplicationSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String catalog;
        private String name;
        private String id;
        private String arn;
        private String benefitId;
        private List<String> programs = DefaultSdkAutoConstructList.getInstance();
        private List<String> fulfillmentTypes = DefaultSdkAutoConstructList.getInstance();
        private String status;
        private String stage;
        private Instant createdAt;
        private Instant updatedAt;
        private Map<String, String> benefitApplicationDetails = DefaultSdkAutoConstructMap.getInstance();
        private List<String> associatedResources = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BenefitApplicationSummary model) {
            this.catalog(model.catalog);
            this.name(model.name);
            this.id(model.id);
            this.arn(model.arn);
            this.benefitId(model.benefitId);
            this.programs(model.programs);
            this.fulfillmentTypesWithStrings(model.fulfillmentTypes);
            this.status(model.status);
            this.stage(model.stage);
            this.createdAt(model.createdAt);
            this.updatedAt(model.updatedAt);
            this.benefitApplicationDetails(model.benefitApplicationDetails);
            this.associatedResources(model.associatedResources);
        }

        public final String getCatalog() {
            return this.catalog;
        }

        public final void setCatalog(String catalog) {
            this.catalog = catalog;
        }

        @Override
        public final Builder catalog(String catalog) {
            this.catalog = catalog;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getBenefitId() {
            return this.benefitId;
        }

        public final void setBenefitId(String benefitId) {
            this.benefitId = benefitId;
        }

        @Override
        public final Builder benefitId(String benefitId) {
            this.benefitId = benefitId;
            return this;
        }

        public final Collection<String> getPrograms() {
            if (this.programs instanceof SdkAutoConstructList) {
                return null;
            }
            return this.programs;
        }

        public final void setPrograms(Collection<String> programs) {
            this.programs = ProgramsCopier.copy(programs);
        }

        @Override
        public final Builder programs(Collection<String> programs) {
            this.programs = ProgramsCopier.copy(programs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder programs(String ... programs) {
            this.programs(Arrays.asList(programs));
            return this;
        }

        public final Collection<String> getFulfillmentTypes() {
            if (this.fulfillmentTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.fulfillmentTypes;
        }

        public final void setFulfillmentTypes(Collection<String> fulfillmentTypes) {
            this.fulfillmentTypes = FulfillmentTypesCopier.copy(fulfillmentTypes);
        }

        @Override
        public final Builder fulfillmentTypesWithStrings(Collection<String> fulfillmentTypes) {
            this.fulfillmentTypes = FulfillmentTypesCopier.copy(fulfillmentTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fulfillmentTypesWithStrings(String ... fulfillmentTypes) {
            this.fulfillmentTypesWithStrings(Arrays.asList(fulfillmentTypes));
            return this;
        }

        @Override
        public final Builder fulfillmentTypes(Collection<FulfillmentType> fulfillmentTypes) {
            this.fulfillmentTypes = FulfillmentTypesCopier.copyEnumToString(fulfillmentTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fulfillmentTypes(FulfillmentType ... fulfillmentTypes) {
            this.fulfillmentTypes(Arrays.asList(fulfillmentTypes));
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(BenefitApplicationStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getStage() {
            return this.stage;
        }

        public final void setStage(String stage) {
            this.stage = stage;
        }

        @Override
        public final Builder stage(String stage) {
            this.stage = stage;
            return this;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Instant getUpdatedAt() {
            return this.updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public final Map<String, String> getBenefitApplicationDetails() {
            if (this.benefitApplicationDetails instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.benefitApplicationDetails;
        }

        public final void setBenefitApplicationDetails(Map<String, String> benefitApplicationDetails) {
            this.benefitApplicationDetails = AttributesCopier.copy(benefitApplicationDetails);
        }

        @Override
        public final Builder benefitApplicationDetails(Map<String, String> benefitApplicationDetails) {
            this.benefitApplicationDetails = AttributesCopier.copy(benefitApplicationDetails);
            return this;
        }

        public final Collection<String> getAssociatedResources() {
            if (this.associatedResources instanceof SdkAutoConstructList) {
                return null;
            }
            return this.associatedResources;
        }

        public final void setAssociatedResources(Collection<String> associatedResources) {
            this.associatedResources = ArnsCopier.copy(associatedResources);
        }

        @Override
        public final Builder associatedResources(Collection<String> associatedResources) {
            this.associatedResources = ArnsCopier.copy(associatedResources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder associatedResources(String ... associatedResources) {
            this.associatedResources(Arrays.asList(associatedResources));
            return this;
        }

        public BenefitApplicationSummary build() {
            return new BenefitApplicationSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, BenefitApplicationSummary> {
        public Builder catalog(String var1);

        public Builder name(String var1);

        public Builder id(String var1);

        public Builder arn(String var1);

        public Builder benefitId(String var1);

        public Builder programs(Collection<String> var1);

        public Builder programs(String ... var1);

        public Builder fulfillmentTypesWithStrings(Collection<String> var1);

        public Builder fulfillmentTypesWithStrings(String ... var1);

        public Builder fulfillmentTypes(Collection<FulfillmentType> var1);

        public Builder fulfillmentTypes(FulfillmentType ... var1);

        public Builder status(String var1);

        public Builder status(BenefitApplicationStatus var1);

        public Builder stage(String var1);

        public Builder createdAt(Instant var1);

        public Builder updatedAt(Instant var1);

        public Builder benefitApplicationDetails(Map<String, String> var1);

        public Builder associatedResources(Collection<String> var1);

        public Builder associatedResources(String ... var1);
    }
}

