/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.partnercentralbenefits.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.document.Document;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.partnercentralbenefits.model.Contact;
import software.amazon.awssdk.services.partnercentralbenefits.model.FileInput;
import software.amazon.awssdk.services.partnercentralbenefits.model.PartnerCentralBenefitsRequest;
import software.amazon.awssdk.services.partnercentralbenefits.model.UpdateBenefitApplicationInputFileDetailsListCopier;
import software.amazon.awssdk.services.partnercentralbenefits.model.UpdateBenefitApplicationInputPartnerContactsListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateBenefitApplicationRequest
extends PartnerCentralBenefitsRequest
implements ToCopyableBuilder<Builder, UpdateBenefitApplicationRequest> {
    private static final SdkField<String> CATALOG_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Catalog").getter(UpdateBenefitApplicationRequest.getter(UpdateBenefitApplicationRequest::catalog)).setter(UpdateBenefitApplicationRequest.setter(Builder::catalog)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Catalog").build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientToken").getter(UpdateBenefitApplicationRequest.getter(UpdateBenefitApplicationRequest::clientToken)).setter(UpdateBenefitApplicationRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(UpdateBenefitApplicationRequest.getter(UpdateBenefitApplicationRequest::name)).setter(UpdateBenefitApplicationRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(UpdateBenefitApplicationRequest.getter(UpdateBenefitApplicationRequest::description)).setter(UpdateBenefitApplicationRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<String> IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Identifier").getter(UpdateBenefitApplicationRequest.getter(UpdateBenefitApplicationRequest::identifier)).setter(UpdateBenefitApplicationRequest.setter(Builder::identifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Identifier").build()}).build();
    private static final SdkField<String> REVISION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Revision").getter(UpdateBenefitApplicationRequest.getter(UpdateBenefitApplicationRequest::revision)).setter(UpdateBenefitApplicationRequest.setter(Builder::revision)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Revision").build()}).build();
    private static final SdkField<Document> BENEFIT_APPLICATION_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOCUMENT).memberName("BenefitApplicationDetails").getter(UpdateBenefitApplicationRequest.getter(UpdateBenefitApplicationRequest::benefitApplicationDetails)).setter(UpdateBenefitApplicationRequest.setter(Builder::benefitApplicationDetails)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BenefitApplicationDetails").build()}).build();
    private static final SdkField<List<Contact>> PARTNER_CONTACTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("PartnerContacts").getter(UpdateBenefitApplicationRequest.getter(UpdateBenefitApplicationRequest::partnerContacts)).setter(UpdateBenefitApplicationRequest.setter(Builder::partnerContacts)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PartnerContacts").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Contact::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<FileInput>> FILE_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("FileDetails").getter(UpdateBenefitApplicationRequest.getter(UpdateBenefitApplicationRequest::fileDetails)).setter(UpdateBenefitApplicationRequest.setter(Builder::fileDetails)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FileDetails").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(FileInput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CATALOG_FIELD, CLIENT_TOKEN_FIELD, NAME_FIELD, DESCRIPTION_FIELD, IDENTIFIER_FIELD, REVISION_FIELD, BENEFIT_APPLICATION_DETAILS_FIELD, PARTNER_CONTACTS_FIELD, FILE_DETAILS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateBenefitApplicationRequest.memberNameToFieldInitializer();
    private final String catalog;
    private final String clientToken;
    private final String name;
    private final String description;
    private final String identifier;
    private final String revision;
    private final Document benefitApplicationDetails;
    private final List<Contact> partnerContacts;
    private final List<FileInput> fileDetails;

    private UpdateBenefitApplicationRequest(BuilderImpl builder) {
        super(builder);
        this.catalog = builder.catalog;
        this.clientToken = builder.clientToken;
        this.name = builder.name;
        this.description = builder.description;
        this.identifier = builder.identifier;
        this.revision = builder.revision;
        this.benefitApplicationDetails = builder.benefitApplicationDetails;
        this.partnerContacts = builder.partnerContacts;
        this.fileDetails = builder.fileDetails;
    }

    public final String catalog() {
        return this.catalog;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final String name() {
        return this.name;
    }

    public final String description() {
        return this.description;
    }

    public final String identifier() {
        return this.identifier;
    }

    public final String revision() {
        return this.revision;
    }

    public final Document benefitApplicationDetails() {
        return this.benefitApplicationDetails;
    }

    public final boolean hasPartnerContacts() {
        return this.partnerContacts != null && !(this.partnerContacts instanceof SdkAutoConstructList);
    }

    public final List<Contact> partnerContacts() {
        return this.partnerContacts;
    }

    public final boolean hasFileDetails() {
        return this.fileDetails != null && !(this.fileDetails instanceof SdkAutoConstructList);
    }

    public final List<FileInput> fileDetails() {
        return this.fileDetails;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.catalog());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.identifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.revision());
        hashCode = 31 * hashCode + Objects.hashCode(this.benefitApplicationDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPartnerContacts() ? this.partnerContacts() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFileDetails() ? this.fileDetails() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateBenefitApplicationRequest)) {
            return false;
        }
        UpdateBenefitApplicationRequest other = (UpdateBenefitApplicationRequest)((Object)obj);
        return Objects.equals(this.catalog(), other.catalog()) && Objects.equals(this.clientToken(), other.clientToken()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.identifier(), other.identifier()) && Objects.equals(this.revision(), other.revision()) && Objects.equals(this.benefitApplicationDetails(), other.benefitApplicationDetails()) && this.hasPartnerContacts() == other.hasPartnerContacts() && Objects.equals(this.partnerContacts(), other.partnerContacts()) && this.hasFileDetails() == other.hasFileDetails() && Objects.equals(this.fileDetails(), other.fileDetails());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateBenefitApplicationRequest").add("Catalog", (Object)this.catalog()).add("ClientToken", (Object)this.clientToken()).add("Name", (Object)this.name()).add("Description", (Object)this.description()).add("Identifier", (Object)this.identifier()).add("Revision", (Object)this.revision()).add("BenefitApplicationDetails", (Object)this.benefitApplicationDetails()).add("PartnerContacts", this.hasPartnerContacts() ? this.partnerContacts() : null).add("FileDetails", this.hasFileDetails() ? this.fileDetails() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Catalog": {
                return Optional.ofNullable(clazz.cast(this.catalog()));
            }
            case "ClientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "Identifier": {
                return Optional.ofNullable(clazz.cast(this.identifier()));
            }
            case "Revision": {
                return Optional.ofNullable(clazz.cast(this.revision()));
            }
            case "BenefitApplicationDetails": {
                return Optional.ofNullable(clazz.cast(this.benefitApplicationDetails()));
            }
            case "PartnerContacts": {
                return Optional.ofNullable(clazz.cast(this.partnerContacts()));
            }
            case "FileDetails": {
                return Optional.ofNullable(clazz.cast(this.fileDetails()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Catalog", CATALOG_FIELD);
        map.put("ClientToken", CLIENT_TOKEN_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("Identifier", IDENTIFIER_FIELD);
        map.put("Revision", REVISION_FIELD);
        map.put("BenefitApplicationDetails", BENEFIT_APPLICATION_DETAILS_FIELD);
        map.put("PartnerContacts", PARTNER_CONTACTS_FIELD);
        map.put("FileDetails", FILE_DETAILS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateBenefitApplicationRequest, T> g) {
        return obj -> g.apply((UpdateBenefitApplicationRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends PartnerCentralBenefitsRequest.BuilderImpl
    implements Builder {
        private String catalog;
        private String clientToken;
        private String name;
        private String description;
        private String identifier;
        private String revision;
        private Document benefitApplicationDetails;
        private List<Contact> partnerContacts = DefaultSdkAutoConstructList.getInstance();
        private List<FileInput> fileDetails = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateBenefitApplicationRequest model) {
            super(model);
            this.catalog(model.catalog);
            this.clientToken(model.clientToken);
            this.name(model.name);
            this.description(model.description);
            this.identifier(model.identifier);
            this.revision(model.revision);
            this.benefitApplicationDetails(model.benefitApplicationDetails);
            this.partnerContacts(model.partnerContacts);
            this.fileDetails(model.fileDetails);
        }

        public final String getCatalog() {
            return this.catalog;
        }

        public final void setCatalog(String catalog) {
            this.catalog = catalog;
        }

        @Override
        public final Builder catalog(String catalog) {
            this.catalog = catalog;
            return this;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getIdentifier() {
            return this.identifier;
        }

        public final void setIdentifier(String identifier) {
            this.identifier = identifier;
        }

        @Override
        public final Builder identifier(String identifier) {
            this.identifier = identifier;
            return this;
        }

        public final String getRevision() {
            return this.revision;
        }

        public final void setRevision(String revision) {
            this.revision = revision;
        }

        @Override
        public final Builder revision(String revision) {
            this.revision = revision;
            return this;
        }

        public final Document getBenefitApplicationDetails() {
            return this.benefitApplicationDetails;
        }

        public final void setBenefitApplicationDetails(Document benefitApplicationDetails) {
            this.benefitApplicationDetails = benefitApplicationDetails;
        }

        @Override
        public final Builder benefitApplicationDetails(Document benefitApplicationDetails) {
            this.benefitApplicationDetails = benefitApplicationDetails;
            return this;
        }

        public final List<Contact.Builder> getPartnerContacts() {
            List<Contact.Builder> result = UpdateBenefitApplicationInputPartnerContactsListCopier.copyToBuilder(this.partnerContacts);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPartnerContacts(Collection<Contact.BuilderImpl> partnerContacts) {
            this.partnerContacts = UpdateBenefitApplicationInputPartnerContactsListCopier.copyFromBuilder(partnerContacts);
        }

        @Override
        public final Builder partnerContacts(Collection<Contact> partnerContacts) {
            this.partnerContacts = UpdateBenefitApplicationInputPartnerContactsListCopier.copy(partnerContacts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder partnerContacts(Contact ... partnerContacts) {
            this.partnerContacts(Arrays.asList(partnerContacts));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder partnerContacts(Consumer<Contact.Builder> ... partnerContacts) {
            this.partnerContacts(Stream.of(partnerContacts).map(c -> (Contact)((Contact.Builder)Contact.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<FileInput.Builder> getFileDetails() {
            List<FileInput.Builder> result = UpdateBenefitApplicationInputFileDetailsListCopier.copyToBuilder(this.fileDetails);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFileDetails(Collection<FileInput.BuilderImpl> fileDetails) {
            this.fileDetails = UpdateBenefitApplicationInputFileDetailsListCopier.copyFromBuilder(fileDetails);
        }

        @Override
        public final Builder fileDetails(Collection<FileInput> fileDetails) {
            this.fileDetails = UpdateBenefitApplicationInputFileDetailsListCopier.copy(fileDetails);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fileDetails(FileInput ... fileDetails) {
            this.fileDetails(Arrays.asList(fileDetails));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fileDetails(Consumer<FileInput.Builder> ... fileDetails) {
            this.fileDetails(Stream.of(fileDetails).map(c -> (FileInput)((FileInput.Builder)FileInput.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateBenefitApplicationRequest build() {
            return new UpdateBenefitApplicationRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends PartnerCentralBenefitsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateBenefitApplicationRequest> {
        public Builder catalog(String var1);

        public Builder clientToken(String var1);

        public Builder name(String var1);

        public Builder description(String var1);

        public Builder identifier(String var1);

        public Builder revision(String var1);

        public Builder benefitApplicationDetails(Document var1);

        public Builder partnerContacts(Collection<Contact> var1);

        public Builder partnerContacts(Contact ... var1);

        public Builder partnerContacts(Consumer<Contact.Builder> ... var1);

        public Builder fileDetails(Collection<FileInput> var1);

        public Builder fileDetails(FileInput ... var1);

        public Builder fileDetails(Consumer<FileInput.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

