/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.partnercentralbenefits.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.partnercentralbenefits.PartnerCentralBenefitsAsyncClient;
import software.amazon.awssdk.services.partnercentralbenefits.internal.UserAgentUtils;
import software.amazon.awssdk.services.partnercentralbenefits.model.BenefitApplicationSummary;
import software.amazon.awssdk.services.partnercentralbenefits.model.ListBenefitApplicationsRequest;
import software.amazon.awssdk.services.partnercentralbenefits.model.ListBenefitApplicationsResponse;

public class ListBenefitApplicationsPublisher
implements SdkPublisher<ListBenefitApplicationsResponse> {
    private final PartnerCentralBenefitsAsyncClient client;
    private final ListBenefitApplicationsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListBenefitApplicationsPublisher(PartnerCentralBenefitsAsyncClient client, ListBenefitApplicationsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListBenefitApplicationsPublisher(PartnerCentralBenefitsAsyncClient client, ListBenefitApplicationsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListBenefitApplicationsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListBenefitApplicationsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<BenefitApplicationSummary> benefitApplicationSummaries() {
        Function<ListBenefitApplicationsResponse, Iterator> getIterator = response -> {
            if (response != null && response.benefitApplicationSummaries() != null) {
                return response.benefitApplicationSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListBenefitApplicationsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListBenefitApplicationsResponseFetcher
    implements AsyncPageFetcher<ListBenefitApplicationsResponse> {
        private ListBenefitApplicationsResponseFetcher() {
        }

        public boolean hasNextPage(ListBenefitApplicationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListBenefitApplicationsResponse> nextPage(ListBenefitApplicationsResponse previousPage) {
            if (previousPage == null) {
                return ListBenefitApplicationsPublisher.this.client.listBenefitApplications(ListBenefitApplicationsPublisher.this.firstRequest);
            }
            return ListBenefitApplicationsPublisher.this.client.listBenefitApplications((ListBenefitApplicationsRequest)((Object)ListBenefitApplicationsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

