/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.partnercentralbenefits.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListBenefitAllocationsRequest extends PartnerCentralBenefitsRequest implements
        ToCopyableBuilder<ListBenefitAllocationsRequest.Builder, ListBenefitAllocationsRequest> {
    private static final SdkField<String> CATALOG_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Catalog")
            .getter(getter(ListBenefitAllocationsRequest::catalog)).setter(setter(Builder::catalog))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Catalog").build()).build();

    private static final SdkField<List<String>> FULFILLMENT_TYPES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("FulfillmentTypes")
            .getter(getter(ListBenefitAllocationsRequest::fulfillmentTypesAsStrings))
            .setter(setter(Builder::fulfillmentTypesWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FulfillmentTypes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> BENEFIT_IDENTIFIERS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("BenefitIdentifiers")
            .getter(getter(ListBenefitAllocationsRequest::benefitIdentifiers))
            .setter(setter(Builder::benefitIdentifiers))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BenefitIdentifiers").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> BENEFIT_APPLICATION_IDENTIFIERS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("BenefitApplicationIdentifiers")
            .getter(getter(ListBenefitAllocationsRequest::benefitApplicationIdentifiers))
            .setter(setter(Builder::benefitApplicationIdentifiers))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BenefitApplicationIdentifiers")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> STATUS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Status")
            .getter(getter(ListBenefitAllocationsRequest::statusAsStrings))
            .setter(setter(Builder::statusWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults").getter(getter(ListBenefitAllocationsRequest::maxResults))
            .setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListBenefitAllocationsRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CATALOG_FIELD,
            FULFILLMENT_TYPES_FIELD, BENEFIT_IDENTIFIERS_FIELD, BENEFIT_APPLICATION_IDENTIFIERS_FIELD, STATUS_FIELD,
            MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String catalog;

    private final List<String> fulfillmentTypes;

    private final List<String> benefitIdentifiers;

    private final List<String> benefitApplicationIdentifiers;

    private final List<String> status;

    private final Integer maxResults;

    private final String nextToken;

    private ListBenefitAllocationsRequest(BuilderImpl builder) {
        super(builder);
        this.catalog = builder.catalog;
        this.fulfillmentTypes = builder.fulfillmentTypes;
        this.benefitIdentifiers = builder.benefitIdentifiers;
        this.benefitApplicationIdentifiers = builder.benefitApplicationIdentifiers;
        this.status = builder.status;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * The catalog identifier to filter benefit allocations by catalog.
     * </p>
     * 
     * @return The catalog identifier to filter benefit allocations by catalog.
     */
    public final String catalog() {
        return catalog;
    }

    /**
     * <p>
     * Filter benefit allocations by specific fulfillment types.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFulfillmentTypes} method.
     * </p>
     * 
     * @return Filter benefit allocations by specific fulfillment types.
     */
    public final List<FulfillmentType> fulfillmentTypes() {
        return ListBenefitAllocationsInputFulfillmentTypesListCopier.copyStringToEnum(fulfillmentTypes);
    }

    /**
     * For responses, this returns true if the service returned a value for the FulfillmentTypes property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasFulfillmentTypes() {
        return fulfillmentTypes != null && !(fulfillmentTypes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Filter benefit allocations by specific fulfillment types.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFulfillmentTypes} method.
     * </p>
     * 
     * @return Filter benefit allocations by specific fulfillment types.
     */
    public final List<String> fulfillmentTypesAsStrings() {
        return fulfillmentTypes;
    }

    /**
     * For responses, this returns true if the service returned a value for the BenefitIdentifiers property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasBenefitIdentifiers() {
        return benefitIdentifiers != null && !(benefitIdentifiers instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Filter benefit allocations by specific benefit identifiers.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasBenefitIdentifiers} method.
     * </p>
     * 
     * @return Filter benefit allocations by specific benefit identifiers.
     */
    public final List<String> benefitIdentifiers() {
        return benefitIdentifiers;
    }

    /**
     * For responses, this returns true if the service returned a value for the BenefitApplicationIdentifiers property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasBenefitApplicationIdentifiers() {
        return benefitApplicationIdentifiers != null && !(benefitApplicationIdentifiers instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Filter benefit allocations by specific benefit application identifiers.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasBenefitApplicationIdentifiers} method.
     * </p>
     * 
     * @return Filter benefit allocations by specific benefit application identifiers.
     */
    public final List<String> benefitApplicationIdentifiers() {
        return benefitApplicationIdentifiers;
    }

    /**
     * <p>
     * Filter benefit allocations by their current status.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasStatus} method.
     * </p>
     * 
     * @return Filter benefit allocations by their current status.
     */
    public final List<BenefitAllocationStatus> status() {
        return ListBenefitAllocationsInputStatusListCopier.copyStringToEnum(status);
    }

    /**
     * For responses, this returns true if the service returned a value for the Status property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasStatus() {
        return status != null && !(status instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Filter benefit allocations by their current status.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasStatus} method.
     * </p>
     * 
     * @return Filter benefit allocations by their current status.
     */
    public final List<String> statusAsStrings() {
        return status;
    }

    /**
     * <p>
     * The maximum number of benefit allocations to return in a single response.
     * </p>
     * 
     * @return The maximum number of benefit allocations to return in a single response.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * A pagination token to retrieve the next set of results from a previous request.
     * </p>
     * 
     * @return A pagination token to retrieve the next set of results from a previous request.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(catalog());
        hashCode = 31 * hashCode + Objects.hashCode(hasFulfillmentTypes() ? fulfillmentTypesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasBenefitIdentifiers() ? benefitIdentifiers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasBenefitApplicationIdentifiers() ? benefitApplicationIdentifiers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasStatus() ? statusAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListBenefitAllocationsRequest)) {
            return false;
        }
        ListBenefitAllocationsRequest other = (ListBenefitAllocationsRequest) obj;
        return Objects.equals(catalog(), other.catalog()) && hasFulfillmentTypes() == other.hasFulfillmentTypes()
                && Objects.equals(fulfillmentTypesAsStrings(), other.fulfillmentTypesAsStrings())
                && hasBenefitIdentifiers() == other.hasBenefitIdentifiers()
                && Objects.equals(benefitIdentifiers(), other.benefitIdentifiers())
                && hasBenefitApplicationIdentifiers() == other.hasBenefitApplicationIdentifiers()
                && Objects.equals(benefitApplicationIdentifiers(), other.benefitApplicationIdentifiers())
                && hasStatus() == other.hasStatus() && Objects.equals(statusAsStrings(), other.statusAsStrings())
                && Objects.equals(maxResults(), other.maxResults()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("ListBenefitAllocationsRequest")
                .add("Catalog", catalog())
                .add("FulfillmentTypes", hasFulfillmentTypes() ? fulfillmentTypesAsStrings() : null)
                .add("BenefitIdentifiers", hasBenefitIdentifiers() ? benefitIdentifiers() : null)
                .add("BenefitApplicationIdentifiers", hasBenefitApplicationIdentifiers() ? benefitApplicationIdentifiers() : null)
                .add("Status", hasStatus() ? statusAsStrings() : null).add("MaxResults", maxResults())
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Catalog":
            return Optional.ofNullable(clazz.cast(catalog()));
        case "FulfillmentTypes":
            return Optional.ofNullable(clazz.cast(fulfillmentTypesAsStrings()));
        case "BenefitIdentifiers":
            return Optional.ofNullable(clazz.cast(benefitIdentifiers()));
        case "BenefitApplicationIdentifiers":
            return Optional.ofNullable(clazz.cast(benefitApplicationIdentifiers()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsStrings()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Catalog", CATALOG_FIELD);
        map.put("FulfillmentTypes", FULFILLMENT_TYPES_FIELD);
        map.put("BenefitIdentifiers", BENEFIT_IDENTIFIERS_FIELD);
        map.put("BenefitApplicationIdentifiers", BENEFIT_APPLICATION_IDENTIFIERS_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("MaxResults", MAX_RESULTS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListBenefitAllocationsRequest, T> g) {
        return obj -> g.apply((ListBenefitAllocationsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends PartnerCentralBenefitsRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, ListBenefitAllocationsRequest> {
        /**
         * <p>
         * The catalog identifier to filter benefit allocations by catalog.
         * </p>
         * 
         * @param catalog
         *        The catalog identifier to filter benefit allocations by catalog.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder catalog(String catalog);

        /**
         * <p>
         * Filter benefit allocations by specific fulfillment types.
         * </p>
         * 
         * @param fulfillmentTypes
         *        Filter benefit allocations by specific fulfillment types.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fulfillmentTypesWithStrings(Collection<String> fulfillmentTypes);

        /**
         * <p>
         * Filter benefit allocations by specific fulfillment types.
         * </p>
         * 
         * @param fulfillmentTypes
         *        Filter benefit allocations by specific fulfillment types.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fulfillmentTypesWithStrings(String... fulfillmentTypes);

        /**
         * <p>
         * Filter benefit allocations by specific fulfillment types.
         * </p>
         * 
         * @param fulfillmentTypes
         *        Filter benefit allocations by specific fulfillment types.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fulfillmentTypes(Collection<FulfillmentType> fulfillmentTypes);

        /**
         * <p>
         * Filter benefit allocations by specific fulfillment types.
         * </p>
         * 
         * @param fulfillmentTypes
         *        Filter benefit allocations by specific fulfillment types.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fulfillmentTypes(FulfillmentType... fulfillmentTypes);

        /**
         * <p>
         * Filter benefit allocations by specific benefit identifiers.
         * </p>
         * 
         * @param benefitIdentifiers
         *        Filter benefit allocations by specific benefit identifiers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder benefitIdentifiers(Collection<String> benefitIdentifiers);

        /**
         * <p>
         * Filter benefit allocations by specific benefit identifiers.
         * </p>
         * 
         * @param benefitIdentifiers
         *        Filter benefit allocations by specific benefit identifiers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder benefitIdentifiers(String... benefitIdentifiers);

        /**
         * <p>
         * Filter benefit allocations by specific benefit application identifiers.
         * </p>
         * 
         * @param benefitApplicationIdentifiers
         *        Filter benefit allocations by specific benefit application identifiers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder benefitApplicationIdentifiers(Collection<String> benefitApplicationIdentifiers);

        /**
         * <p>
         * Filter benefit allocations by specific benefit application identifiers.
         * </p>
         * 
         * @param benefitApplicationIdentifiers
         *        Filter benefit allocations by specific benefit application identifiers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder benefitApplicationIdentifiers(String... benefitApplicationIdentifiers);

        /**
         * <p>
         * Filter benefit allocations by their current status.
         * </p>
         * 
         * @param status
         *        Filter benefit allocations by their current status.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusWithStrings(Collection<String> status);

        /**
         * <p>
         * Filter benefit allocations by their current status.
         * </p>
         * 
         * @param status
         *        Filter benefit allocations by their current status.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusWithStrings(String... status);

        /**
         * <p>
         * Filter benefit allocations by their current status.
         * </p>
         * 
         * @param status
         *        Filter benefit allocations by their current status.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(Collection<BenefitAllocationStatus> status);

        /**
         * <p>
         * Filter benefit allocations by their current status.
         * </p>
         * 
         * @param status
         *        Filter benefit allocations by their current status.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(BenefitAllocationStatus... status);

        /**
         * <p>
         * The maximum number of benefit allocations to return in a single response.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of benefit allocations to return in a single response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * A pagination token to retrieve the next set of results from a previous request.
         * </p>
         * 
         * @param nextToken
         *        A pagination token to retrieve the next set of results from a previous request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends PartnerCentralBenefitsRequest.BuilderImpl implements Builder {
        private String catalog;

        private List<String> fulfillmentTypes = DefaultSdkAutoConstructList.getInstance();

        private List<String> benefitIdentifiers = DefaultSdkAutoConstructList.getInstance();

        private List<String> benefitApplicationIdentifiers = DefaultSdkAutoConstructList.getInstance();

        private List<String> status = DefaultSdkAutoConstructList.getInstance();

        private Integer maxResults;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListBenefitAllocationsRequest model) {
            super(model);
            catalog(model.catalog);
            fulfillmentTypesWithStrings(model.fulfillmentTypes);
            benefitIdentifiers(model.benefitIdentifiers);
            benefitApplicationIdentifiers(model.benefitApplicationIdentifiers);
            statusWithStrings(model.status);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
        }

        public final String getCatalog() {
            return catalog;
        }

        public final void setCatalog(String catalog) {
            this.catalog = catalog;
        }

        @Override
        public final Builder catalog(String catalog) {
            this.catalog = catalog;
            return this;
        }

        public final Collection<String> getFulfillmentTypes() {
            if (fulfillmentTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return fulfillmentTypes;
        }

        public final void setFulfillmentTypes(Collection<String> fulfillmentTypes) {
            this.fulfillmentTypes = ListBenefitAllocationsInputFulfillmentTypesListCopier.copy(fulfillmentTypes);
        }

        @Override
        public final Builder fulfillmentTypesWithStrings(Collection<String> fulfillmentTypes) {
            this.fulfillmentTypes = ListBenefitAllocationsInputFulfillmentTypesListCopier.copy(fulfillmentTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fulfillmentTypesWithStrings(String... fulfillmentTypes) {
            fulfillmentTypesWithStrings(Arrays.asList(fulfillmentTypes));
            return this;
        }

        @Override
        public final Builder fulfillmentTypes(Collection<FulfillmentType> fulfillmentTypes) {
            this.fulfillmentTypes = ListBenefitAllocationsInputFulfillmentTypesListCopier.copyEnumToString(fulfillmentTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fulfillmentTypes(FulfillmentType... fulfillmentTypes) {
            fulfillmentTypes(Arrays.asList(fulfillmentTypes));
            return this;
        }

        public final Collection<String> getBenefitIdentifiers() {
            if (benefitIdentifiers instanceof SdkAutoConstructList) {
                return null;
            }
            return benefitIdentifiers;
        }

        public final void setBenefitIdentifiers(Collection<String> benefitIdentifiers) {
            this.benefitIdentifiers = ListBenefitAllocationsInputBenefitIdentifiersListCopier.copy(benefitIdentifiers);
        }

        @Override
        public final Builder benefitIdentifiers(Collection<String> benefitIdentifiers) {
            this.benefitIdentifiers = ListBenefitAllocationsInputBenefitIdentifiersListCopier.copy(benefitIdentifiers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder benefitIdentifiers(String... benefitIdentifiers) {
            benefitIdentifiers(Arrays.asList(benefitIdentifiers));
            return this;
        }

        public final Collection<String> getBenefitApplicationIdentifiers() {
            if (benefitApplicationIdentifiers instanceof SdkAutoConstructList) {
                return null;
            }
            return benefitApplicationIdentifiers;
        }

        public final void setBenefitApplicationIdentifiers(Collection<String> benefitApplicationIdentifiers) {
            this.benefitApplicationIdentifiers = ListBenefitAllocationsInputBenefitApplicationIdentifiersListCopier
                    .copy(benefitApplicationIdentifiers);
        }

        @Override
        public final Builder benefitApplicationIdentifiers(Collection<String> benefitApplicationIdentifiers) {
            this.benefitApplicationIdentifiers = ListBenefitAllocationsInputBenefitApplicationIdentifiersListCopier
                    .copy(benefitApplicationIdentifiers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder benefitApplicationIdentifiers(String... benefitApplicationIdentifiers) {
            benefitApplicationIdentifiers(Arrays.asList(benefitApplicationIdentifiers));
            return this;
        }

        public final Collection<String> getStatus() {
            if (status instanceof SdkAutoConstructList) {
                return null;
            }
            return status;
        }

        public final void setStatus(Collection<String> status) {
            this.status = ListBenefitAllocationsInputStatusListCopier.copy(status);
        }

        @Override
        public final Builder statusWithStrings(Collection<String> status) {
            this.status = ListBenefitAllocationsInputStatusListCopier.copy(status);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder statusWithStrings(String... status) {
            statusWithStrings(Arrays.asList(status));
            return this;
        }

        @Override
        public final Builder status(Collection<BenefitAllocationStatus> status) {
            this.status = ListBenefitAllocationsInputStatusListCopier.copyEnumToString(status);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder status(BenefitAllocationStatus... status) {
            status(Arrays.asList(status));
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListBenefitAllocationsRequest build() {
            return new ListBenefitAllocationsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
