/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.partnercentralbenefits.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents detailed information about a specific issuance of benefit value.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class IssuanceDetail implements SdkPojo, Serializable, ToCopyableBuilder<IssuanceDetail.Builder, IssuanceDetail> {
    private static final SdkField<String> ISSUANCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IssuanceId").getter(getter(IssuanceDetail::issuanceId)).setter(setter(Builder::issuanceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IssuanceId").build()).build();

    private static final SdkField<MonetaryValue> ISSUANCE_AMOUNT_FIELD = SdkField
            .<MonetaryValue> builder(MarshallingType.SDK_POJO).memberName("IssuanceAmount")
            .getter(getter(IssuanceDetail::issuanceAmount)).setter(setter(Builder::issuanceAmount))
            .constructor(MonetaryValue::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IssuanceAmount").build()).build();

    private static final SdkField<Instant> ISSUED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("IssuedAt")
            .getter(getter(IssuanceDetail::issuedAt))
            .setter(setter(Builder::issuedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IssuedAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ISSUANCE_ID_FIELD,
            ISSUANCE_AMOUNT_FIELD, ISSUED_AT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String issuanceId;

    private final MonetaryValue issuanceAmount;

    private final Instant issuedAt;

    private IssuanceDetail(BuilderImpl builder) {
        this.issuanceId = builder.issuanceId;
        this.issuanceAmount = builder.issuanceAmount;
        this.issuedAt = builder.issuedAt;
    }

    /**
     * <p>
     * The unique identifier for this specific issuance.
     * </p>
     * 
     * @return The unique identifier for this specific issuance.
     */
    public final String issuanceId() {
        return issuanceId;
    }

    /**
     * <p>
     * The monetary amount or value that was issued in this specific issuance.
     * </p>
     * 
     * @return The monetary amount or value that was issued in this specific issuance.
     */
    public final MonetaryValue issuanceAmount() {
        return issuanceAmount;
    }

    /**
     * <p>
     * The timestamp when this specific issuance was processed.
     * </p>
     * 
     * @return The timestamp when this specific issuance was processed.
     */
    public final Instant issuedAt() {
        return issuedAt;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(issuanceId());
        hashCode = 31 * hashCode + Objects.hashCode(issuanceAmount());
        hashCode = 31 * hashCode + Objects.hashCode(issuedAt());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IssuanceDetail)) {
            return false;
        }
        IssuanceDetail other = (IssuanceDetail) obj;
        return Objects.equals(issuanceId(), other.issuanceId()) && Objects.equals(issuanceAmount(), other.issuanceAmount())
                && Objects.equals(issuedAt(), other.issuedAt());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("IssuanceDetail").add("IssuanceId", issuanceId()).add("IssuanceAmount", issuanceAmount())
                .add("IssuedAt", issuedAt()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "IssuanceId":
            return Optional.ofNullable(clazz.cast(issuanceId()));
        case "IssuanceAmount":
            return Optional.ofNullable(clazz.cast(issuanceAmount()));
        case "IssuedAt":
            return Optional.ofNullable(clazz.cast(issuedAt()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("IssuanceId", ISSUANCE_ID_FIELD);
        map.put("IssuanceAmount", ISSUANCE_AMOUNT_FIELD);
        map.put("IssuedAt", ISSUED_AT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<IssuanceDetail, T> g) {
        return obj -> g.apply((IssuanceDetail) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, IssuanceDetail> {
        /**
         * <p>
         * The unique identifier for this specific issuance.
         * </p>
         * 
         * @param issuanceId
         *        The unique identifier for this specific issuance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder issuanceId(String issuanceId);

        /**
         * <p>
         * The monetary amount or value that was issued in this specific issuance.
         * </p>
         * 
         * @param issuanceAmount
         *        The monetary amount or value that was issued in this specific issuance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder issuanceAmount(MonetaryValue issuanceAmount);

        /**
         * <p>
         * The monetary amount or value that was issued in this specific issuance.
         * </p>
         * This is a convenience method that creates an instance of the {@link MonetaryValue.Builder} avoiding the need
         * to create one manually via {@link MonetaryValue#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MonetaryValue.Builder#build()} is called immediately and its
         * result is passed to {@link #issuanceAmount(MonetaryValue)}.
         * 
         * @param issuanceAmount
         *        a consumer that will call methods on {@link MonetaryValue.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #issuanceAmount(MonetaryValue)
         */
        default Builder issuanceAmount(Consumer<MonetaryValue.Builder> issuanceAmount) {
            return issuanceAmount(MonetaryValue.builder().applyMutation(issuanceAmount).build());
        }

        /**
         * <p>
         * The timestamp when this specific issuance was processed.
         * </p>
         * 
         * @param issuedAt
         *        The timestamp when this specific issuance was processed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder issuedAt(Instant issuedAt);
    }

    static final class BuilderImpl implements Builder {
        private String issuanceId;

        private MonetaryValue issuanceAmount;

        private Instant issuedAt;

        private BuilderImpl() {
        }

        private BuilderImpl(IssuanceDetail model) {
            issuanceId(model.issuanceId);
            issuanceAmount(model.issuanceAmount);
            issuedAt(model.issuedAt);
        }

        public final String getIssuanceId() {
            return issuanceId;
        }

        public final void setIssuanceId(String issuanceId) {
            this.issuanceId = issuanceId;
        }

        @Override
        public final Builder issuanceId(String issuanceId) {
            this.issuanceId = issuanceId;
            return this;
        }

        public final MonetaryValue.Builder getIssuanceAmount() {
            return issuanceAmount != null ? issuanceAmount.toBuilder() : null;
        }

        public final void setIssuanceAmount(MonetaryValue.BuilderImpl issuanceAmount) {
            this.issuanceAmount = issuanceAmount != null ? issuanceAmount.build() : null;
        }

        @Override
        public final Builder issuanceAmount(MonetaryValue issuanceAmount) {
            this.issuanceAmount = issuanceAmount;
            return this;
        }

        public final Instant getIssuedAt() {
            return issuedAt;
        }

        public final void setIssuedAt(Instant issuedAt) {
            this.issuedAt = issuedAt;
        }

        @Override
        public final Builder issuedAt(Instant issuedAt) {
            this.issuedAt = issuedAt;
            return this;
        }

        @Override
        public IssuanceDetail build() {
            return new IssuanceDetail(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
