/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.partnercentralbenefits.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.document.Document;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetBenefitResponse extends PartnerCentralBenefitsResponse implements
        ToCopyableBuilder<GetBenefitResponse.Builder, GetBenefitResponse> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Id")
            .getter(getter(GetBenefitResponse::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()).build();

    private static final SdkField<String> CATALOG_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Catalog")
            .getter(getter(GetBenefitResponse::catalog)).setter(setter(Builder::catalog))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Catalog").build()).build();

    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Arn")
            .getter(getter(GetBenefitResponse::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(GetBenefitResponse::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(GetBenefitResponse::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<List<String>> PROGRAMS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Programs")
            .getter(getter(GetBenefitResponse::programs))
            .setter(setter(Builder::programs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Programs").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> FULFILLMENT_TYPES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("FulfillmentTypes")
            .getter(getter(GetBenefitResponse::fulfillmentTypesAsStrings))
            .setter(setter(Builder::fulfillmentTypesWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FulfillmentTypes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Document> BENEFIT_REQUEST_SCHEMA_FIELD = SdkField.<Document> builder(MarshallingType.DOCUMENT)
            .memberName("BenefitRequestSchema").getter(getter(GetBenefitResponse::benefitRequestSchema))
            .setter(setter(Builder::benefitRequestSchema))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BenefitRequestSchema").build())
            .build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(GetBenefitResponse::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, CATALOG_FIELD,
            ARN_FIELD, NAME_FIELD, DESCRIPTION_FIELD, PROGRAMS_FIELD, FULFILLMENT_TYPES_FIELD, BENEFIT_REQUEST_SCHEMA_FIELD,
            STATUS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String id;

    private final String catalog;

    private final String arn;

    private final String name;

    private final String description;

    private final List<String> programs;

    private final List<String> fulfillmentTypes;

    private final Document benefitRequestSchema;

    private final String status;

    private GetBenefitResponse(BuilderImpl builder) {
        super(builder);
        this.id = builder.id;
        this.catalog = builder.catalog;
        this.arn = builder.arn;
        this.name = builder.name;
        this.description = builder.description;
        this.programs = builder.programs;
        this.fulfillmentTypes = builder.fulfillmentTypes;
        this.benefitRequestSchema = builder.benefitRequestSchema;
        this.status = builder.status;
    }

    /**
     * <p>
     * The unique identifier of the benefit.
     * </p>
     * 
     * @return The unique identifier of the benefit.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The catalog identifier that the benefit belongs to.
     * </p>
     * 
     * @return The catalog identifier that the benefit belongs to.
     */
    public final String catalog() {
        return catalog;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the benefit.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the benefit.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The human-readable name of the benefit.
     * </p>
     * 
     * @return The human-readable name of the benefit.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * A detailed description of the benefit and its purpose.
     * </p>
     * 
     * @return A detailed description of the benefit and its purpose.
     */
    public final String description() {
        return description;
    }

    /**
     * For responses, this returns true if the service returned a value for the Programs property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasPrograms() {
        return programs != null && !(programs instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The AWS partner programs that this benefit is associated with.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPrograms} method.
     * </p>
     * 
     * @return The AWS partner programs that this benefit is associated with.
     */
    public final List<String> programs() {
        return programs;
    }

    /**
     * <p>
     * The available fulfillment types for this benefit (e.g., credits, access, disbursement).
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFulfillmentTypes} method.
     * </p>
     * 
     * @return The available fulfillment types for this benefit (e.g., credits, access, disbursement).
     */
    public final List<FulfillmentType> fulfillmentTypes() {
        return FulfillmentTypesCopier.copyStringToEnum(fulfillmentTypes);
    }

    /**
     * For responses, this returns true if the service returned a value for the FulfillmentTypes property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasFulfillmentTypes() {
        return fulfillmentTypes != null && !(fulfillmentTypes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The available fulfillment types for this benefit (e.g., credits, access, disbursement).
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFulfillmentTypes} method.
     * </p>
     * 
     * @return The available fulfillment types for this benefit (e.g., credits, access, disbursement).
     */
    public final List<String> fulfillmentTypesAsStrings() {
        return fulfillmentTypes;
    }

    /**
     * <p>
     * The schema definition that describes the required fields for requesting this benefit.
     * </p>
     * 
     * @return The schema definition that describes the required fields for requesting this benefit.
     */
    public final Document benefitRequestSchema() {
        return benefitRequestSchema;
    }

    /**
     * <p>
     * The current status of the benefit (e.g., active, inactive, deprecated).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link BenefitStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of the benefit (e.g., active, inactive, deprecated).
     * @see BenefitStatus
     */
    public final BenefitStatus status() {
        return BenefitStatus.fromValue(status);
    }

    /**
     * <p>
     * The current status of the benefit (e.g., active, inactive, deprecated).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link BenefitStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of the benefit (e.g., active, inactive, deprecated).
     * @see BenefitStatus
     */
    public final String statusAsString() {
        return status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(catalog());
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(hasPrograms() ? programs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasFulfillmentTypes() ? fulfillmentTypesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(benefitRequestSchema());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetBenefitResponse)) {
            return false;
        }
        GetBenefitResponse other = (GetBenefitResponse) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(catalog(), other.catalog())
                && Objects.equals(arn(), other.arn()) && Objects.equals(name(), other.name())
                && Objects.equals(description(), other.description()) && hasPrograms() == other.hasPrograms()
                && Objects.equals(programs(), other.programs()) && hasFulfillmentTypes() == other.hasFulfillmentTypes()
                && Objects.equals(fulfillmentTypesAsStrings(), other.fulfillmentTypesAsStrings())
                && Objects.equals(benefitRequestSchema(), other.benefitRequestSchema())
                && Objects.equals(statusAsString(), other.statusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetBenefitResponse").add("Id", id()).add("Catalog", catalog()).add("Arn", arn())
                .add("Name", name()).add("Description", description()).add("Programs", hasPrograms() ? programs() : null)
                .add("FulfillmentTypes", hasFulfillmentTypes() ? fulfillmentTypesAsStrings() : null)
                .add("BenefitRequestSchema", benefitRequestSchema()).add("Status", statusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "Catalog":
            return Optional.ofNullable(clazz.cast(catalog()));
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "Programs":
            return Optional.ofNullable(clazz.cast(programs()));
        case "FulfillmentTypes":
            return Optional.ofNullable(clazz.cast(fulfillmentTypesAsStrings()));
        case "BenefitRequestSchema":
            return Optional.ofNullable(clazz.cast(benefitRequestSchema()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Id", ID_FIELD);
        map.put("Catalog", CATALOG_FIELD);
        map.put("Arn", ARN_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("Programs", PROGRAMS_FIELD);
        map.put("FulfillmentTypes", FULFILLMENT_TYPES_FIELD);
        map.put("BenefitRequestSchema", BENEFIT_REQUEST_SCHEMA_FIELD);
        map.put("Status", STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetBenefitResponse, T> g) {
        return obj -> g.apply((GetBenefitResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends PartnerCentralBenefitsResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetBenefitResponse> {
        /**
         * <p>
         * The unique identifier of the benefit.
         * </p>
         * 
         * @param id
         *        The unique identifier of the benefit.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The catalog identifier that the benefit belongs to.
         * </p>
         * 
         * @param catalog
         *        The catalog identifier that the benefit belongs to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder catalog(String catalog);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the benefit.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) of the benefit.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The human-readable name of the benefit.
         * </p>
         * 
         * @param name
         *        The human-readable name of the benefit.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * A detailed description of the benefit and its purpose.
         * </p>
         * 
         * @param description
         *        A detailed description of the benefit and its purpose.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The AWS partner programs that this benefit is associated with.
         * </p>
         * 
         * @param programs
         *        The AWS partner programs that this benefit is associated with.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder programs(Collection<String> programs);

        /**
         * <p>
         * The AWS partner programs that this benefit is associated with.
         * </p>
         * 
         * @param programs
         *        The AWS partner programs that this benefit is associated with.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder programs(String... programs);

        /**
         * <p>
         * The available fulfillment types for this benefit (e.g., credits, access, disbursement).
         * </p>
         * 
         * @param fulfillmentTypes
         *        The available fulfillment types for this benefit (e.g., credits, access, disbursement).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fulfillmentTypesWithStrings(Collection<String> fulfillmentTypes);

        /**
         * <p>
         * The available fulfillment types for this benefit (e.g., credits, access, disbursement).
         * </p>
         * 
         * @param fulfillmentTypes
         *        The available fulfillment types for this benefit (e.g., credits, access, disbursement).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fulfillmentTypesWithStrings(String... fulfillmentTypes);

        /**
         * <p>
         * The available fulfillment types for this benefit (e.g., credits, access, disbursement).
         * </p>
         * 
         * @param fulfillmentTypes
         *        The available fulfillment types for this benefit (e.g., credits, access, disbursement).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fulfillmentTypes(Collection<FulfillmentType> fulfillmentTypes);

        /**
         * <p>
         * The available fulfillment types for this benefit (e.g., credits, access, disbursement).
         * </p>
         * 
         * @param fulfillmentTypes
         *        The available fulfillment types for this benefit (e.g., credits, access, disbursement).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fulfillmentTypes(FulfillmentType... fulfillmentTypes);

        /**
         * <p>
         * The schema definition that describes the required fields for requesting this benefit.
         * </p>
         * 
         * @param benefitRequestSchema
         *        The schema definition that describes the required fields for requesting this benefit.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder benefitRequestSchema(Document benefitRequestSchema);

        /**
         * <p>
         * The current status of the benefit (e.g., active, inactive, deprecated).
         * </p>
         * 
         * @param status
         *        The current status of the benefit (e.g., active, inactive, deprecated).
         * @see BenefitStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BenefitStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The current status of the benefit (e.g., active, inactive, deprecated).
         * </p>
         * 
         * @param status
         *        The current status of the benefit (e.g., active, inactive, deprecated).
         * @see BenefitStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BenefitStatus
         */
        Builder status(BenefitStatus status);
    }

    static final class BuilderImpl extends PartnerCentralBenefitsResponse.BuilderImpl implements Builder {
        private String id;

        private String catalog;

        private String arn;

        private String name;

        private String description;

        private List<String> programs = DefaultSdkAutoConstructList.getInstance();

        private List<String> fulfillmentTypes = DefaultSdkAutoConstructList.getInstance();

        private Document benefitRequestSchema;

        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(GetBenefitResponse model) {
            super(model);
            id(model.id);
            catalog(model.catalog);
            arn(model.arn);
            name(model.name);
            description(model.description);
            programs(model.programs);
            fulfillmentTypesWithStrings(model.fulfillmentTypes);
            benefitRequestSchema(model.benefitRequestSchema);
            status(model.status);
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getCatalog() {
            return catalog;
        }

        public final void setCatalog(String catalog) {
            this.catalog = catalog;
        }

        @Override
        public final Builder catalog(String catalog) {
            this.catalog = catalog;
            return this;
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Collection<String> getPrograms() {
            if (programs instanceof SdkAutoConstructList) {
                return null;
            }
            return programs;
        }

        public final void setPrograms(Collection<String> programs) {
            this.programs = ProgramsCopier.copy(programs);
        }

        @Override
        public final Builder programs(Collection<String> programs) {
            this.programs = ProgramsCopier.copy(programs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder programs(String... programs) {
            programs(Arrays.asList(programs));
            return this;
        }

        public final Collection<String> getFulfillmentTypes() {
            if (fulfillmentTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return fulfillmentTypes;
        }

        public final void setFulfillmentTypes(Collection<String> fulfillmentTypes) {
            this.fulfillmentTypes = FulfillmentTypesCopier.copy(fulfillmentTypes);
        }

        @Override
        public final Builder fulfillmentTypesWithStrings(Collection<String> fulfillmentTypes) {
            this.fulfillmentTypes = FulfillmentTypesCopier.copy(fulfillmentTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fulfillmentTypesWithStrings(String... fulfillmentTypes) {
            fulfillmentTypesWithStrings(Arrays.asList(fulfillmentTypes));
            return this;
        }

        @Override
        public final Builder fulfillmentTypes(Collection<FulfillmentType> fulfillmentTypes) {
            this.fulfillmentTypes = FulfillmentTypesCopier.copyEnumToString(fulfillmentTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fulfillmentTypes(FulfillmentType... fulfillmentTypes) {
            fulfillmentTypes(Arrays.asList(fulfillmentTypes));
            return this;
        }

        public final Document getBenefitRequestSchema() {
            return benefitRequestSchema;
        }

        public final void setBenefitRequestSchema(Document benefitRequestSchema) {
            this.benefitRequestSchema = benefitRequestSchema;
        }

        @Override
        public final Builder benefitRequestSchema(Document benefitRequestSchema) {
            this.benefitRequestSchema = benefitRequestSchema;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(BenefitStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        @Override
        public GetBenefitResponse build() {
            return new GetBenefitResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
