/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.partnercentralbenefits.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains comprehensive information about how a benefit allocation is fulfilled across different fulfillment types.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class FulfillmentDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<FulfillmentDetails.Builder, FulfillmentDetails> {
    private static final SdkField<DisbursementDetails> DISBURSEMENT_DETAILS_FIELD = SdkField
            .<DisbursementDetails> builder(MarshallingType.SDK_POJO).memberName("DisbursementDetails")
            .getter(getter(FulfillmentDetails::disbursementDetails)).setter(setter(Builder::disbursementDetails))
            .constructor(DisbursementDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DisbursementDetails").build())
            .build();

    private static final SdkField<ConsumableDetails> CONSUMABLE_DETAILS_FIELD = SdkField
            .<ConsumableDetails> builder(MarshallingType.SDK_POJO).memberName("ConsumableDetails")
            .getter(getter(FulfillmentDetails::consumableDetails)).setter(setter(Builder::consumableDetails))
            .constructor(ConsumableDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConsumableDetails").build()).build();

    private static final SdkField<CreditDetails> CREDIT_DETAILS_FIELD = SdkField
            .<CreditDetails> builder(MarshallingType.SDK_POJO).memberName("CreditDetails")
            .getter(getter(FulfillmentDetails::creditDetails)).setter(setter(Builder::creditDetails))
            .constructor(CreditDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreditDetails").build()).build();

    private static final SdkField<AccessDetails> ACCESS_DETAILS_FIELD = SdkField
            .<AccessDetails> builder(MarshallingType.SDK_POJO).memberName("AccessDetails")
            .getter(getter(FulfillmentDetails::accessDetails)).setter(setter(Builder::accessDetails))
            .constructor(AccessDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccessDetails").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DISBURSEMENT_DETAILS_FIELD,
            CONSUMABLE_DETAILS_FIELD, CREDIT_DETAILS_FIELD, ACCESS_DETAILS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final DisbursementDetails disbursementDetails;

    private final ConsumableDetails consumableDetails;

    private final CreditDetails creditDetails;

    private final AccessDetails accessDetails;

    private final Type type;

    private FulfillmentDetails(BuilderImpl builder) {
        this.disbursementDetails = builder.disbursementDetails;
        this.consumableDetails = builder.consumableDetails;
        this.creditDetails = builder.creditDetails;
        this.accessDetails = builder.accessDetails;
        this.type = builder.type;
    }

    /**
     * <p>
     * Details about disbursement-based fulfillment, if applicable to this benefit allocation.
     * </p>
     * 
     * @return Details about disbursement-based fulfillment, if applicable to this benefit allocation.
     */
    public final DisbursementDetails disbursementDetails() {
        return disbursementDetails;
    }

    /**
     * <p>
     * Details about consumable-based fulfillment, if applicable to this benefit allocation.
     * </p>
     * 
     * @return Details about consumable-based fulfillment, if applicable to this benefit allocation.
     */
    public final ConsumableDetails consumableDetails() {
        return consumableDetails;
    }

    /**
     * <p>
     * Details about credit-based fulfillment, if applicable to this benefit allocation.
     * </p>
     * 
     * @return Details about credit-based fulfillment, if applicable to this benefit allocation.
     */
    public final CreditDetails creditDetails() {
        return creditDetails;
    }

    /**
     * <p>
     * Details about access-based fulfillment, if applicable to this benefit allocation.
     * </p>
     * 
     * @return Details about access-based fulfillment, if applicable to this benefit allocation.
     */
    public final AccessDetails accessDetails() {
        return accessDetails;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(disbursementDetails());
        hashCode = 31 * hashCode + Objects.hashCode(consumableDetails());
        hashCode = 31 * hashCode + Objects.hashCode(creditDetails());
        hashCode = 31 * hashCode + Objects.hashCode(accessDetails());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FulfillmentDetails)) {
            return false;
        }
        FulfillmentDetails other = (FulfillmentDetails) obj;
        return Objects.equals(disbursementDetails(), other.disbursementDetails())
                && Objects.equals(consumableDetails(), other.consumableDetails())
                && Objects.equals(creditDetails(), other.creditDetails())
                && Objects.equals(accessDetails(), other.accessDetails());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("FulfillmentDetails").add("DisbursementDetails", disbursementDetails())
                .add("ConsumableDetails", consumableDetails()).add("CreditDetails", creditDetails())
                .add("AccessDetails", accessDetails()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DisbursementDetails":
            return Optional.ofNullable(clazz.cast(disbursementDetails()));
        case "ConsumableDetails":
            return Optional.ofNullable(clazz.cast(consumableDetails()));
        case "CreditDetails":
            return Optional.ofNullable(clazz.cast(creditDetails()));
        case "AccessDetails":
            return Optional.ofNullable(clazz.cast(accessDetails()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #disbursementDetails()} initialized to the given value.
     *
     * <p>
     * Details about disbursement-based fulfillment, if applicable to this benefit allocation.
     * </p>
     * 
     * @param disbursementDetails
     *        Details about disbursement-based fulfillment, if applicable to this benefit allocation.
     */
    public static FulfillmentDetails fromDisbursementDetails(DisbursementDetails disbursementDetails) {
        return builder().disbursementDetails(disbursementDetails).build();
    }

    /**
     * Create an instance of this class with {@link #disbursementDetails()} initialized to the given value.
     *
     * <p>
     * Details about disbursement-based fulfillment, if applicable to this benefit allocation.
     * </p>
     * 
     * @param disbursementDetails
     *        Details about disbursement-based fulfillment, if applicable to this benefit allocation.
     */
    public static FulfillmentDetails fromDisbursementDetails(Consumer<DisbursementDetails.Builder> disbursementDetails) {
        DisbursementDetails.Builder builder = DisbursementDetails.builder();
        disbursementDetails.accept(builder);
        return fromDisbursementDetails(builder.build());
    }

    /**
     * Create an instance of this class with {@link #consumableDetails()} initialized to the given value.
     *
     * <p>
     * Details about consumable-based fulfillment, if applicable to this benefit allocation.
     * </p>
     * 
     * @param consumableDetails
     *        Details about consumable-based fulfillment, if applicable to this benefit allocation.
     */
    public static FulfillmentDetails fromConsumableDetails(ConsumableDetails consumableDetails) {
        return builder().consumableDetails(consumableDetails).build();
    }

    /**
     * Create an instance of this class with {@link #consumableDetails()} initialized to the given value.
     *
     * <p>
     * Details about consumable-based fulfillment, if applicable to this benefit allocation.
     * </p>
     * 
     * @param consumableDetails
     *        Details about consumable-based fulfillment, if applicable to this benefit allocation.
     */
    public static FulfillmentDetails fromConsumableDetails(Consumer<ConsumableDetails.Builder> consumableDetails) {
        ConsumableDetails.Builder builder = ConsumableDetails.builder();
        consumableDetails.accept(builder);
        return fromConsumableDetails(builder.build());
    }

    /**
     * Create an instance of this class with {@link #creditDetails()} initialized to the given value.
     *
     * <p>
     * Details about credit-based fulfillment, if applicable to this benefit allocation.
     * </p>
     * 
     * @param creditDetails
     *        Details about credit-based fulfillment, if applicable to this benefit allocation.
     */
    public static FulfillmentDetails fromCreditDetails(CreditDetails creditDetails) {
        return builder().creditDetails(creditDetails).build();
    }

    /**
     * Create an instance of this class with {@link #creditDetails()} initialized to the given value.
     *
     * <p>
     * Details about credit-based fulfillment, if applicable to this benefit allocation.
     * </p>
     * 
     * @param creditDetails
     *        Details about credit-based fulfillment, if applicable to this benefit allocation.
     */
    public static FulfillmentDetails fromCreditDetails(Consumer<CreditDetails.Builder> creditDetails) {
        CreditDetails.Builder builder = CreditDetails.builder();
        creditDetails.accept(builder);
        return fromCreditDetails(builder.build());
    }

    /**
     * Create an instance of this class with {@link #accessDetails()} initialized to the given value.
     *
     * <p>
     * Details about access-based fulfillment, if applicable to this benefit allocation.
     * </p>
     * 
     * @param accessDetails
     *        Details about access-based fulfillment, if applicable to this benefit allocation.
     */
    public static FulfillmentDetails fromAccessDetails(AccessDetails accessDetails) {
        return builder().accessDetails(accessDetails).build();
    }

    /**
     * Create an instance of this class with {@link #accessDetails()} initialized to the given value.
     *
     * <p>
     * Details about access-based fulfillment, if applicable to this benefit allocation.
     * </p>
     * 
     * @param accessDetails
     *        Details about access-based fulfillment, if applicable to this benefit allocation.
     */
    public static FulfillmentDetails fromAccessDetails(Consumer<AccessDetails.Builder> accessDetails) {
        AccessDetails.Builder builder = AccessDetails.builder();
        accessDetails.accept(builder);
        return fromAccessDetails(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("DisbursementDetails", DISBURSEMENT_DETAILS_FIELD);
        map.put("ConsumableDetails", CONSUMABLE_DETAILS_FIELD);
        map.put("CreditDetails", CREDIT_DETAILS_FIELD);
        map.put("AccessDetails", ACCESS_DETAILS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<FulfillmentDetails, T> g) {
        return obj -> g.apply((FulfillmentDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FulfillmentDetails> {
        /**
         * <p>
         * Details about disbursement-based fulfillment, if applicable to this benefit allocation.
         * </p>
         * 
         * @param disbursementDetails
         *        Details about disbursement-based fulfillment, if applicable to this benefit allocation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder disbursementDetails(DisbursementDetails disbursementDetails);

        /**
         * <p>
         * Details about disbursement-based fulfillment, if applicable to this benefit allocation.
         * </p>
         * This is a convenience method that creates an instance of the {@link DisbursementDetails.Builder} avoiding the
         * need to create one manually via {@link DisbursementDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DisbursementDetails.Builder#build()} is called immediately and
         * its result is passed to {@link #disbursementDetails(DisbursementDetails)}.
         * 
         * @param disbursementDetails
         *        a consumer that will call methods on {@link DisbursementDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #disbursementDetails(DisbursementDetails)
         */
        default Builder disbursementDetails(Consumer<DisbursementDetails.Builder> disbursementDetails) {
            return disbursementDetails(DisbursementDetails.builder().applyMutation(disbursementDetails).build());
        }

        /**
         * <p>
         * Details about consumable-based fulfillment, if applicable to this benefit allocation.
         * </p>
         * 
         * @param consumableDetails
         *        Details about consumable-based fulfillment, if applicable to this benefit allocation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder consumableDetails(ConsumableDetails consumableDetails);

        /**
         * <p>
         * Details about consumable-based fulfillment, if applicable to this benefit allocation.
         * </p>
         * This is a convenience method that creates an instance of the {@link ConsumableDetails.Builder} avoiding the
         * need to create one manually via {@link ConsumableDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ConsumableDetails.Builder#build()} is called immediately and its
         * result is passed to {@link #consumableDetails(ConsumableDetails)}.
         * 
         * @param consumableDetails
         *        a consumer that will call methods on {@link ConsumableDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #consumableDetails(ConsumableDetails)
         */
        default Builder consumableDetails(Consumer<ConsumableDetails.Builder> consumableDetails) {
            return consumableDetails(ConsumableDetails.builder().applyMutation(consumableDetails).build());
        }

        /**
         * <p>
         * Details about credit-based fulfillment, if applicable to this benefit allocation.
         * </p>
         * 
         * @param creditDetails
         *        Details about credit-based fulfillment, if applicable to this benefit allocation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creditDetails(CreditDetails creditDetails);

        /**
         * <p>
         * Details about credit-based fulfillment, if applicable to this benefit allocation.
         * </p>
         * This is a convenience method that creates an instance of the {@link CreditDetails.Builder} avoiding the need
         * to create one manually via {@link CreditDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CreditDetails.Builder#build()} is called immediately and its
         * result is passed to {@link #creditDetails(CreditDetails)}.
         * 
         * @param creditDetails
         *        a consumer that will call methods on {@link CreditDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #creditDetails(CreditDetails)
         */
        default Builder creditDetails(Consumer<CreditDetails.Builder> creditDetails) {
            return creditDetails(CreditDetails.builder().applyMutation(creditDetails).build());
        }

        /**
         * <p>
         * Details about access-based fulfillment, if applicable to this benefit allocation.
         * </p>
         * 
         * @param accessDetails
         *        Details about access-based fulfillment, if applicable to this benefit allocation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accessDetails(AccessDetails accessDetails);

        /**
         * <p>
         * Details about access-based fulfillment, if applicable to this benefit allocation.
         * </p>
         * This is a convenience method that creates an instance of the {@link AccessDetails.Builder} avoiding the need
         * to create one manually via {@link AccessDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AccessDetails.Builder#build()} is called immediately and its
         * result is passed to {@link #accessDetails(AccessDetails)}.
         * 
         * @param accessDetails
         *        a consumer that will call methods on {@link AccessDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #accessDetails(AccessDetails)
         */
        default Builder accessDetails(Consumer<AccessDetails.Builder> accessDetails) {
            return accessDetails(AccessDetails.builder().applyMutation(accessDetails).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private DisbursementDetails disbursementDetails;

        private ConsumableDetails consumableDetails;

        private CreditDetails creditDetails;

        private AccessDetails accessDetails;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(FulfillmentDetails model) {
            disbursementDetails(model.disbursementDetails);
            consumableDetails(model.consumableDetails);
            creditDetails(model.creditDetails);
            accessDetails(model.accessDetails);
        }

        public final DisbursementDetails.Builder getDisbursementDetails() {
            return disbursementDetails != null ? disbursementDetails.toBuilder() : null;
        }

        public final void setDisbursementDetails(DisbursementDetails.BuilderImpl disbursementDetails) {
            Object oldValue = this.disbursementDetails;
            this.disbursementDetails = disbursementDetails != null ? disbursementDetails.build() : null;
            handleUnionValueChange(Type.DISBURSEMENT_DETAILS, oldValue, this.disbursementDetails);
        }

        @Override
        public final Builder disbursementDetails(DisbursementDetails disbursementDetails) {
            Object oldValue = this.disbursementDetails;
            this.disbursementDetails = disbursementDetails;
            handleUnionValueChange(Type.DISBURSEMENT_DETAILS, oldValue, this.disbursementDetails);
            return this;
        }

        public final ConsumableDetails.Builder getConsumableDetails() {
            return consumableDetails != null ? consumableDetails.toBuilder() : null;
        }

        public final void setConsumableDetails(ConsumableDetails.BuilderImpl consumableDetails) {
            Object oldValue = this.consumableDetails;
            this.consumableDetails = consumableDetails != null ? consumableDetails.build() : null;
            handleUnionValueChange(Type.CONSUMABLE_DETAILS, oldValue, this.consumableDetails);
        }

        @Override
        public final Builder consumableDetails(ConsumableDetails consumableDetails) {
            Object oldValue = this.consumableDetails;
            this.consumableDetails = consumableDetails;
            handleUnionValueChange(Type.CONSUMABLE_DETAILS, oldValue, this.consumableDetails);
            return this;
        }

        public final CreditDetails.Builder getCreditDetails() {
            return creditDetails != null ? creditDetails.toBuilder() : null;
        }

        public final void setCreditDetails(CreditDetails.BuilderImpl creditDetails) {
            Object oldValue = this.creditDetails;
            this.creditDetails = creditDetails != null ? creditDetails.build() : null;
            handleUnionValueChange(Type.CREDIT_DETAILS, oldValue, this.creditDetails);
        }

        @Override
        public final Builder creditDetails(CreditDetails creditDetails) {
            Object oldValue = this.creditDetails;
            this.creditDetails = creditDetails;
            handleUnionValueChange(Type.CREDIT_DETAILS, oldValue, this.creditDetails);
            return this;
        }

        public final AccessDetails.Builder getAccessDetails() {
            return accessDetails != null ? accessDetails.toBuilder() : null;
        }

        public final void setAccessDetails(AccessDetails.BuilderImpl accessDetails) {
            Object oldValue = this.accessDetails;
            this.accessDetails = accessDetails != null ? accessDetails.build() : null;
            handleUnionValueChange(Type.ACCESS_DETAILS, oldValue, this.accessDetails);
        }

        @Override
        public final Builder accessDetails(AccessDetails accessDetails) {
            Object oldValue = this.accessDetails;
            this.accessDetails = accessDetails;
            handleUnionValueChange(Type.ACCESS_DETAILS, oldValue, this.accessDetails);
            return this;
        }

        @Override
        public FulfillmentDetails build() {
            return new FulfillmentDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see FulfillmentDetails#type()
     */
    public enum Type {
        DISBURSEMENT_DETAILS,

        CONSUMABLE_DETAILS,

        CREDIT_DETAILS,

        ACCESS_DETAILS,

        UNKNOWN_TO_SDK_VERSION
    }
}
