/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.partnercentralbenefits.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about disbursement-based benefit fulfillment, such as direct payments or reimbursements.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DisbursementDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<DisbursementDetails.Builder, DisbursementDetails> {
    private static final SdkField<MonetaryValue> DISBURSED_AMOUNT_FIELD = SdkField
            .<MonetaryValue> builder(MarshallingType.SDK_POJO).memberName("DisbursedAmount")
            .getter(getter(DisbursementDetails::disbursedAmount)).setter(setter(Builder::disbursedAmount))
            .constructor(MonetaryValue::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DisbursedAmount").build()).build();

    private static final SdkField<IssuanceDetail> ISSUANCE_DETAILS_FIELD = SdkField
            .<IssuanceDetail> builder(MarshallingType.SDK_POJO).memberName("IssuanceDetails")
            .getter(getter(DisbursementDetails::issuanceDetails)).setter(setter(Builder::issuanceDetails))
            .constructor(IssuanceDetail::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IssuanceDetails").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DISBURSED_AMOUNT_FIELD,
            ISSUANCE_DETAILS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final MonetaryValue disbursedAmount;

    private final IssuanceDetail issuanceDetails;

    private DisbursementDetails(BuilderImpl builder) {
        this.disbursedAmount = builder.disbursedAmount;
        this.issuanceDetails = builder.issuanceDetails;
    }

    /**
     * <p>
     * The total amount that has been disbursed for this benefit allocation.
     * </p>
     * 
     * @return The total amount that has been disbursed for this benefit allocation.
     */
    public final MonetaryValue disbursedAmount() {
        return disbursedAmount;
    }

    /**
     * <p>
     * Detailed information about how the disbursement was issued and processed.
     * </p>
     * 
     * @return Detailed information about how the disbursement was issued and processed.
     */
    public final IssuanceDetail issuanceDetails() {
        return issuanceDetails;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(disbursedAmount());
        hashCode = 31 * hashCode + Objects.hashCode(issuanceDetails());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DisbursementDetails)) {
            return false;
        }
        DisbursementDetails other = (DisbursementDetails) obj;
        return Objects.equals(disbursedAmount(), other.disbursedAmount())
                && Objects.equals(issuanceDetails(), other.issuanceDetails());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DisbursementDetails").add("DisbursedAmount", disbursedAmount())
                .add("IssuanceDetails", issuanceDetails()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DisbursedAmount":
            return Optional.ofNullable(clazz.cast(disbursedAmount()));
        case "IssuanceDetails":
            return Optional.ofNullable(clazz.cast(issuanceDetails()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("DisbursedAmount", DISBURSED_AMOUNT_FIELD);
        map.put("IssuanceDetails", ISSUANCE_DETAILS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DisbursementDetails, T> g) {
        return obj -> g.apply((DisbursementDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DisbursementDetails> {
        /**
         * <p>
         * The total amount that has been disbursed for this benefit allocation.
         * </p>
         * 
         * @param disbursedAmount
         *        The total amount that has been disbursed for this benefit allocation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder disbursedAmount(MonetaryValue disbursedAmount);

        /**
         * <p>
         * The total amount that has been disbursed for this benefit allocation.
         * </p>
         * This is a convenience method that creates an instance of the {@link MonetaryValue.Builder} avoiding the need
         * to create one manually via {@link MonetaryValue#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MonetaryValue.Builder#build()} is called immediately and its
         * result is passed to {@link #disbursedAmount(MonetaryValue)}.
         * 
         * @param disbursedAmount
         *        a consumer that will call methods on {@link MonetaryValue.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #disbursedAmount(MonetaryValue)
         */
        default Builder disbursedAmount(Consumer<MonetaryValue.Builder> disbursedAmount) {
            return disbursedAmount(MonetaryValue.builder().applyMutation(disbursedAmount).build());
        }

        /**
         * <p>
         * Detailed information about how the disbursement was issued and processed.
         * </p>
         * 
         * @param issuanceDetails
         *        Detailed information about how the disbursement was issued and processed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder issuanceDetails(IssuanceDetail issuanceDetails);

        /**
         * <p>
         * Detailed information about how the disbursement was issued and processed.
         * </p>
         * This is a convenience method that creates an instance of the {@link IssuanceDetail.Builder} avoiding the need
         * to create one manually via {@link IssuanceDetail#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link IssuanceDetail.Builder#build()} is called immediately and its
         * result is passed to {@link #issuanceDetails(IssuanceDetail)}.
         * 
         * @param issuanceDetails
         *        a consumer that will call methods on {@link IssuanceDetail.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #issuanceDetails(IssuanceDetail)
         */
        default Builder issuanceDetails(Consumer<IssuanceDetail.Builder> issuanceDetails) {
            return issuanceDetails(IssuanceDetail.builder().applyMutation(issuanceDetails).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private MonetaryValue disbursedAmount;

        private IssuanceDetail issuanceDetails;

        private BuilderImpl() {
        }

        private BuilderImpl(DisbursementDetails model) {
            disbursedAmount(model.disbursedAmount);
            issuanceDetails(model.issuanceDetails);
        }

        public final MonetaryValue.Builder getDisbursedAmount() {
            return disbursedAmount != null ? disbursedAmount.toBuilder() : null;
        }

        public final void setDisbursedAmount(MonetaryValue.BuilderImpl disbursedAmount) {
            this.disbursedAmount = disbursedAmount != null ? disbursedAmount.build() : null;
        }

        @Override
        public final Builder disbursedAmount(MonetaryValue disbursedAmount) {
            this.disbursedAmount = disbursedAmount;
            return this;
        }

        public final IssuanceDetail.Builder getIssuanceDetails() {
            return issuanceDetails != null ? issuanceDetails.toBuilder() : null;
        }

        public final void setIssuanceDetails(IssuanceDetail.BuilderImpl issuanceDetails) {
            this.issuanceDetails = issuanceDetails != null ? issuanceDetails.build() : null;
        }

        @Override
        public final Builder issuanceDetails(IssuanceDetail issuanceDetails) {
            this.issuanceDetails = issuanceDetails;
            return this;
        }

        @Override
        public DisbursementDetails build() {
            return new DisbursementDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
