/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.partnercentralbenefits.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents a specific change to be made to a benefit application field.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Amendment implements SdkPojo, Serializable, ToCopyableBuilder<Amendment.Builder, Amendment> {
    private static final SdkField<String> FIELD_PATH_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FieldPath").getter(getter(Amendment::fieldPath)).setter(setter(Builder::fieldPath))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FieldPath").build()).build();

    private static final SdkField<String> NEW_VALUE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NewValue").getter(getter(Amendment::newValue)).setter(setter(Builder::newValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NewValue").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FIELD_PATH_FIELD,
            NEW_VALUE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String fieldPath;

    private final String newValue;

    private Amendment(BuilderImpl builder) {
        this.fieldPath = builder.fieldPath;
        this.newValue = builder.newValue;
    }

    /**
     * <p>
     * The JSON path or field identifier specifying which field in the benefit application to modify.
     * </p>
     * 
     * @return The JSON path or field identifier specifying which field in the benefit application to modify.
     */
    public final String fieldPath() {
        return fieldPath;
    }

    /**
     * <p>
     * The new value to set for the specified field in the benefit application.
     * </p>
     * 
     * @return The new value to set for the specified field in the benefit application.
     */
    public final String newValue() {
        return newValue;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(fieldPath());
        hashCode = 31 * hashCode + Objects.hashCode(newValue());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Amendment)) {
            return false;
        }
        Amendment other = (Amendment) obj;
        return Objects.equals(fieldPath(), other.fieldPath()) && Objects.equals(newValue(), other.newValue());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Amendment").add("FieldPath", fieldPath()).add("NewValue", newValue()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FieldPath":
            return Optional.ofNullable(clazz.cast(fieldPath()));
        case "NewValue":
            return Optional.ofNullable(clazz.cast(newValue()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("FieldPath", FIELD_PATH_FIELD);
        map.put("NewValue", NEW_VALUE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Amendment, T> g) {
        return obj -> g.apply((Amendment) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Amendment> {
        /**
         * <p>
         * The JSON path or field identifier specifying which field in the benefit application to modify.
         * </p>
         * 
         * @param fieldPath
         *        The JSON path or field identifier specifying which field in the benefit application to modify.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fieldPath(String fieldPath);

        /**
         * <p>
         * The new value to set for the specified field in the benefit application.
         * </p>
         * 
         * @param newValue
         *        The new value to set for the specified field in the benefit application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder newValue(String newValue);
    }

    static final class BuilderImpl implements Builder {
        private String fieldPath;

        private String newValue;

        private BuilderImpl() {
        }

        private BuilderImpl(Amendment model) {
            fieldPath(model.fieldPath);
            newValue(model.newValue);
        }

        public final String getFieldPath() {
            return fieldPath;
        }

        public final void setFieldPath(String fieldPath) {
            this.fieldPath = fieldPath;
        }

        @Override
        public final Builder fieldPath(String fieldPath) {
            this.fieldPath = fieldPath;
            return this;
        }

        public final String getNewValue() {
            return newValue;
        }

        public final void setNewValue(String newValue) {
            this.newValue = newValue;
        }

        @Override
        public final Builder newValue(String newValue) {
            this.newValue = newValue;
            return this;
        }

        @Override
        public Amendment build() {
            return new Amendment(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
