/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.partnercentralbenefits.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class AmendBenefitApplicationRequest extends PartnerCentralBenefitsRequest implements
        ToCopyableBuilder<AmendBenefitApplicationRequest.Builder, AmendBenefitApplicationRequest> {
    private static final SdkField<String> CATALOG_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Catalog")
            .getter(getter(AmendBenefitApplicationRequest::catalog)).setter(setter(Builder::catalog))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Catalog").build()).build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ClientToken").getter(getter(AmendBenefitApplicationRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").build()).build();

    private static final SdkField<String> REVISION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Revision").getter(getter(AmendBenefitApplicationRequest::revision)).setter(setter(Builder::revision))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Revision").build()).build();

    private static final SdkField<String> IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Identifier").getter(getter(AmendBenefitApplicationRequest::identifier))
            .setter(setter(Builder::identifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Identifier").build()).build();

    private static final SdkField<String> AMENDMENT_REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AmendmentReason").getter(getter(AmendBenefitApplicationRequest::amendmentReason))
            .setter(setter(Builder::amendmentReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AmendmentReason").build()).build();

    private static final SdkField<List<Amendment>> AMENDMENTS_FIELD = SdkField
            .<List<Amendment>> builder(MarshallingType.LIST)
            .memberName("Amendments")
            .getter(getter(AmendBenefitApplicationRequest::amendments))
            .setter(setter(Builder::amendments))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Amendments").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Amendment> builder(MarshallingType.SDK_POJO)
                                            .constructor(Amendment::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CATALOG_FIELD,
            CLIENT_TOKEN_FIELD, REVISION_FIELD, IDENTIFIER_FIELD, AMENDMENT_REASON_FIELD, AMENDMENTS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String catalog;

    private final String clientToken;

    private final String revision;

    private final String identifier;

    private final String amendmentReason;

    private final List<Amendment> amendments;

    private AmendBenefitApplicationRequest(BuilderImpl builder) {
        super(builder);
        this.catalog = builder.catalog;
        this.clientToken = builder.clientToken;
        this.revision = builder.revision;
        this.identifier = builder.identifier;
        this.amendmentReason = builder.amendmentReason;
        this.amendments = builder.amendments;
    }

    /**
     * <p>
     * The catalog identifier that specifies which benefit catalog the application belongs to.
     * </p>
     * 
     * @return The catalog identifier that specifies which benefit catalog the application belongs to.
     */
    public final String catalog() {
        return catalog;
    }

    /**
     * <p>
     * A unique, case-sensitive identifier to ensure idempotent processing of the amendment request.
     * </p>
     * 
     * @return A unique, case-sensitive identifier to ensure idempotent processing of the amendment request.
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * <p>
     * The current revision number of the benefit application to ensure optimistic concurrency control.
     * </p>
     * 
     * @return The current revision number of the benefit application to ensure optimistic concurrency control.
     */
    public final String revision() {
        return revision;
    }

    /**
     * <p>
     * The unique identifier of the benefit application to be amended.
     * </p>
     * 
     * @return The unique identifier of the benefit application to be amended.
     */
    public final String identifier() {
        return identifier;
    }

    /**
     * <p>
     * A descriptive reason explaining why the benefit application is being amended.
     * </p>
     * 
     * @return A descriptive reason explaining why the benefit application is being amended.
     */
    public final String amendmentReason() {
        return amendmentReason;
    }

    /**
     * For responses, this returns true if the service returned a value for the Amendments property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasAmendments() {
        return amendments != null && !(amendments instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of specific field amendments to apply to the benefit application.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAmendments} method.
     * </p>
     * 
     * @return A list of specific field amendments to apply to the benefit application.
     */
    public final List<Amendment> amendments() {
        return amendments;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(catalog());
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(revision());
        hashCode = 31 * hashCode + Objects.hashCode(identifier());
        hashCode = 31 * hashCode + Objects.hashCode(amendmentReason());
        hashCode = 31 * hashCode + Objects.hashCode(hasAmendments() ? amendments() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AmendBenefitApplicationRequest)) {
            return false;
        }
        AmendBenefitApplicationRequest other = (AmendBenefitApplicationRequest) obj;
        return Objects.equals(catalog(), other.catalog()) && Objects.equals(clientToken(), other.clientToken())
                && Objects.equals(revision(), other.revision()) && Objects.equals(identifier(), other.identifier())
                && Objects.equals(amendmentReason(), other.amendmentReason()) && hasAmendments() == other.hasAmendments()
                && Objects.equals(amendments(), other.amendments());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AmendBenefitApplicationRequest").add("Catalog", catalog()).add("ClientToken", clientToken())
                .add("Revision", revision()).add("Identifier", identifier()).add("AmendmentReason", amendmentReason())
                .add("Amendments", hasAmendments() ? amendments() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Catalog":
            return Optional.ofNullable(clazz.cast(catalog()));
        case "ClientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "Revision":
            return Optional.ofNullable(clazz.cast(revision()));
        case "Identifier":
            return Optional.ofNullable(clazz.cast(identifier()));
        case "AmendmentReason":
            return Optional.ofNullable(clazz.cast(amendmentReason()));
        case "Amendments":
            return Optional.ofNullable(clazz.cast(amendments()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Catalog", CATALOG_FIELD);
        map.put("ClientToken", CLIENT_TOKEN_FIELD);
        map.put("Revision", REVISION_FIELD);
        map.put("Identifier", IDENTIFIER_FIELD);
        map.put("AmendmentReason", AMENDMENT_REASON_FIELD);
        map.put("Amendments", AMENDMENTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AmendBenefitApplicationRequest, T> g) {
        return obj -> g.apply((AmendBenefitApplicationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends PartnerCentralBenefitsRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, AmendBenefitApplicationRequest> {
        /**
         * <p>
         * The catalog identifier that specifies which benefit catalog the application belongs to.
         * </p>
         * 
         * @param catalog
         *        The catalog identifier that specifies which benefit catalog the application belongs to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder catalog(String catalog);

        /**
         * <p>
         * A unique, case-sensitive identifier to ensure idempotent processing of the amendment request.
         * </p>
         * 
         * @param clientToken
         *        A unique, case-sensitive identifier to ensure idempotent processing of the amendment request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * The current revision number of the benefit application to ensure optimistic concurrency control.
         * </p>
         * 
         * @param revision
         *        The current revision number of the benefit application to ensure optimistic concurrency control.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder revision(String revision);

        /**
         * <p>
         * The unique identifier of the benefit application to be amended.
         * </p>
         * 
         * @param identifier
         *        The unique identifier of the benefit application to be amended.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder identifier(String identifier);

        /**
         * <p>
         * A descriptive reason explaining why the benefit application is being amended.
         * </p>
         * 
         * @param amendmentReason
         *        A descriptive reason explaining why the benefit application is being amended.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder amendmentReason(String amendmentReason);

        /**
         * <p>
         * A list of specific field amendments to apply to the benefit application.
         * </p>
         * 
         * @param amendments
         *        A list of specific field amendments to apply to the benefit application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder amendments(Collection<Amendment> amendments);

        /**
         * <p>
         * A list of specific field amendments to apply to the benefit application.
         * </p>
         * 
         * @param amendments
         *        A list of specific field amendments to apply to the benefit application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder amendments(Amendment... amendments);

        /**
         * <p>
         * A list of specific field amendments to apply to the benefit application.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.partnercentralbenefits.model.Amendment.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.partnercentralbenefits.model.Amendment#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.partnercentralbenefits.model.Amendment.Builder#build()} is called
         * immediately and its result is passed to {@link #amendments(List<Amendment>)}.
         * 
         * @param amendments
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.partnercentralbenefits.model.Amendment.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #amendments(java.util.Collection<Amendment>)
         */
        Builder amendments(Consumer<Amendment.Builder>... amendments);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends PartnerCentralBenefitsRequest.BuilderImpl implements Builder {
        private String catalog;

        private String clientToken;

        private String revision;

        private String identifier;

        private String amendmentReason;

        private List<Amendment> amendments = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AmendBenefitApplicationRequest model) {
            super(model);
            catalog(model.catalog);
            clientToken(model.clientToken);
            revision(model.revision);
            identifier(model.identifier);
            amendmentReason(model.amendmentReason);
            amendments(model.amendments);
        }

        public final String getCatalog() {
            return catalog;
        }

        public final void setCatalog(String catalog) {
            this.catalog = catalog;
        }

        @Override
        public final Builder catalog(String catalog) {
            this.catalog = catalog;
            return this;
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getRevision() {
            return revision;
        }

        public final void setRevision(String revision) {
            this.revision = revision;
        }

        @Override
        public final Builder revision(String revision) {
            this.revision = revision;
            return this;
        }

        public final String getIdentifier() {
            return identifier;
        }

        public final void setIdentifier(String identifier) {
            this.identifier = identifier;
        }

        @Override
        public final Builder identifier(String identifier) {
            this.identifier = identifier;
            return this;
        }

        public final String getAmendmentReason() {
            return amendmentReason;
        }

        public final void setAmendmentReason(String amendmentReason) {
            this.amendmentReason = amendmentReason;
        }

        @Override
        public final Builder amendmentReason(String amendmentReason) {
            this.amendmentReason = amendmentReason;
            return this;
        }

        public final List<Amendment.Builder> getAmendments() {
            List<Amendment.Builder> result = AmendmentListCopier.copyToBuilder(this.amendments);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAmendments(Collection<Amendment.BuilderImpl> amendments) {
            this.amendments = AmendmentListCopier.copyFromBuilder(amendments);
        }

        @Override
        public final Builder amendments(Collection<Amendment> amendments) {
            this.amendments = AmendmentListCopier.copy(amendments);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder amendments(Amendment... amendments) {
            amendments(Arrays.asList(amendments));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder amendments(Consumer<Amendment.Builder>... amendments) {
            amendments(Stream.of(amendments).map(c -> Amendment.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public AmendBenefitApplicationRequest build() {
            return new AmendBenefitApplicationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
