/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.partnercentralaccount.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.partnercentralaccount.PartnerCentralAccountClient;
import software.amazon.awssdk.services.partnercentralaccount.internal.UserAgentUtils;
import software.amazon.awssdk.services.partnercentralaccount.model.ConnectionSummary;
import software.amazon.awssdk.services.partnercentralaccount.model.ListConnectionsRequest;
import software.amazon.awssdk.services.partnercentralaccount.model.ListConnectionsResponse;

public class ListConnectionsIterable
implements SdkIterable<ListConnectionsResponse> {
    private final PartnerCentralAccountClient client;
    private final ListConnectionsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListConnectionsIterable(PartnerCentralAccountClient client, ListConnectionsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListConnectionsResponseFetcher();
    }

    public Iterator<ListConnectionsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ConnectionSummary> connectionSummaries() {
        Function<ListConnectionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.connectionSummaries() != null) {
                return response.connectionSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListConnectionsResponseFetcher
    implements SyncPageFetcher<ListConnectionsResponse> {
        private ListConnectionsResponseFetcher() {
        }

        public boolean hasNextPage(ListConnectionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListConnectionsResponse nextPage(ListConnectionsResponse previousPage) {
            if (previousPage == null) {
                return ListConnectionsIterable.this.client.listConnections(ListConnectionsIterable.this.firstRequest);
            }
            return ListConnectionsIterable.this.client.listConnections((ListConnectionsRequest)((Object)ListConnectionsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

