/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.partnercentralaccount.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum AccessType {
    ALLOW_ALL("ALLOW_ALL"),
    DENY_ALL("DENY_ALL"),
    ALLOW_BY_DEFAULT_DENY_SOME("ALLOW_BY_DEFAULT_DENY_SOME"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, AccessType> VALUE_MAP;
    private final String value;

    private AccessType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static AccessType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<AccessType> knownValues() {
        EnumSet<AccessType> knownValues = EnumSet.allOf(AccessType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(AccessType.class, AccessType::toString);
    }
}

