/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.partnercentralaccount.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.partnercentralaccount.model.ErrorDetail;
import software.amazon.awssdk.services.partnercentralaccount.model.ErrorDetailListCopier;
import software.amazon.awssdk.services.partnercentralaccount.model.PartnerCentralAccountResponse;
import software.amazon.awssdk.services.partnercentralaccount.model.ProfileTaskStatus;
import software.amazon.awssdk.services.partnercentralaccount.model.TaskDetails;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetProfileUpdateTaskResponse
extends PartnerCentralAccountResponse
implements ToCopyableBuilder<Builder, GetProfileUpdateTaskResponse> {
    private static final SdkField<String> CATALOG_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Catalog").getter(GetProfileUpdateTaskResponse.getter(GetProfileUpdateTaskResponse::catalog)).setter(GetProfileUpdateTaskResponse.setter(Builder::catalog)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Catalog").build()}).build();
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Arn").getter(GetProfileUpdateTaskResponse.getter(GetProfileUpdateTaskResponse::arn)).setter(GetProfileUpdateTaskResponse.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()}).build();
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Id").getter(GetProfileUpdateTaskResponse.getter(GetProfileUpdateTaskResponse::id)).setter(GetProfileUpdateTaskResponse.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()}).build();
    private static final SdkField<String> TASK_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TaskId").getter(GetProfileUpdateTaskResponse.getter(GetProfileUpdateTaskResponse::taskId)).setter(GetProfileUpdateTaskResponse.setter(Builder::taskId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TaskId").build()}).build();
    private static final SdkField<TaskDetails> TASK_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("TaskDetails").getter(GetProfileUpdateTaskResponse.getter(GetProfileUpdateTaskResponse::taskDetails)).setter(GetProfileUpdateTaskResponse.setter(Builder::taskDetails)).constructor(TaskDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TaskDetails").build()}).build();
    private static final SdkField<Instant> STARTED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("StartedAt").getter(GetProfileUpdateTaskResponse.getter(GetProfileUpdateTaskResponse::startedAt)).setter(GetProfileUpdateTaskResponse.setter(Builder::startedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartedAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(GetProfileUpdateTaskResponse.getter(GetProfileUpdateTaskResponse::statusAsString)).setter(GetProfileUpdateTaskResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<Instant> ENDED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("EndedAt").getter(GetProfileUpdateTaskResponse.getter(GetProfileUpdateTaskResponse::endedAt)).setter(GetProfileUpdateTaskResponse.setter(Builder::endedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndedAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<List<ErrorDetail>> ERROR_DETAIL_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ErrorDetailList").getter(GetProfileUpdateTaskResponse.getter(GetProfileUpdateTaskResponse::errorDetailList)).setter(GetProfileUpdateTaskResponse.setter(Builder::errorDetailList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ErrorDetailList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ErrorDetail::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CATALOG_FIELD, ARN_FIELD, ID_FIELD, TASK_ID_FIELD, TASK_DETAILS_FIELD, STARTED_AT_FIELD, STATUS_FIELD, ENDED_AT_FIELD, ERROR_DETAIL_LIST_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetProfileUpdateTaskResponse.memberNameToFieldInitializer();
    private final String catalog;
    private final String arn;
    private final String id;
    private final String taskId;
    private final TaskDetails taskDetails;
    private final Instant startedAt;
    private final String status;
    private final Instant endedAt;
    private final List<ErrorDetail> errorDetailList;

    private GetProfileUpdateTaskResponse(BuilderImpl builder) {
        super(builder);
        this.catalog = builder.catalog;
        this.arn = builder.arn;
        this.id = builder.id;
        this.taskId = builder.taskId;
        this.taskDetails = builder.taskDetails;
        this.startedAt = builder.startedAt;
        this.status = builder.status;
        this.endedAt = builder.endedAt;
        this.errorDetailList = builder.errorDetailList;
    }

    public final String catalog() {
        return this.catalog;
    }

    public final String arn() {
        return this.arn;
    }

    public final String id() {
        return this.id;
    }

    public final String taskId() {
        return this.taskId;
    }

    public final TaskDetails taskDetails() {
        return this.taskDetails;
    }

    public final Instant startedAt() {
        return this.startedAt;
    }

    public final ProfileTaskStatus status() {
        return ProfileTaskStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final Instant endedAt() {
        return this.endedAt;
    }

    public final boolean hasErrorDetailList() {
        return this.errorDetailList != null && !(this.errorDetailList instanceof SdkAutoConstructList);
    }

    public final List<ErrorDetail> errorDetailList() {
        return this.errorDetailList;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.catalog());
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.taskId());
        hashCode = 31 * hashCode + Objects.hashCode(this.taskDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.startedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.endedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasErrorDetailList() ? this.errorDetailList() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetProfileUpdateTaskResponse)) {
            return false;
        }
        GetProfileUpdateTaskResponse other = (GetProfileUpdateTaskResponse)((Object)obj);
        return Objects.equals(this.catalog(), other.catalog()) && Objects.equals(this.arn(), other.arn()) && Objects.equals(this.id(), other.id()) && Objects.equals(this.taskId(), other.taskId()) && Objects.equals(this.taskDetails(), other.taskDetails()) && Objects.equals(this.startedAt(), other.startedAt()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.endedAt(), other.endedAt()) && this.hasErrorDetailList() == other.hasErrorDetailList() && Objects.equals(this.errorDetailList(), other.errorDetailList());
    }

    public final String toString() {
        return ToString.builder((String)"GetProfileUpdateTaskResponse").add("Catalog", (Object)this.catalog()).add("Arn", (Object)this.arn()).add("Id", (Object)this.id()).add("TaskId", (Object)this.taskId()).add("TaskDetails", (Object)this.taskDetails()).add("StartedAt", (Object)this.startedAt()).add("Status", (Object)this.statusAsString()).add("EndedAt", (Object)this.endedAt()).add("ErrorDetailList", this.hasErrorDetailList() ? this.errorDetailList() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Catalog": {
                return Optional.ofNullable(clazz.cast(this.catalog()));
            }
            case "Arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "TaskId": {
                return Optional.ofNullable(clazz.cast(this.taskId()));
            }
            case "TaskDetails": {
                return Optional.ofNullable(clazz.cast(this.taskDetails()));
            }
            case "StartedAt": {
                return Optional.ofNullable(clazz.cast(this.startedAt()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "EndedAt": {
                return Optional.ofNullable(clazz.cast(this.endedAt()));
            }
            case "ErrorDetailList": {
                return Optional.ofNullable(clazz.cast(this.errorDetailList()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Catalog", CATALOG_FIELD);
        map.put("Arn", ARN_FIELD);
        map.put("Id", ID_FIELD);
        map.put("TaskId", TASK_ID_FIELD);
        map.put("TaskDetails", TASK_DETAILS_FIELD);
        map.put("StartedAt", STARTED_AT_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("EndedAt", ENDED_AT_FIELD);
        map.put("ErrorDetailList", ERROR_DETAIL_LIST_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetProfileUpdateTaskResponse, T> g) {
        return obj -> g.apply((GetProfileUpdateTaskResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends PartnerCentralAccountResponse.BuilderImpl
    implements Builder {
        private String catalog;
        private String arn;
        private String id;
        private String taskId;
        private TaskDetails taskDetails;
        private Instant startedAt;
        private String status;
        private Instant endedAt;
        private List<ErrorDetail> errorDetailList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetProfileUpdateTaskResponse model) {
            super(model);
            this.catalog(model.catalog);
            this.arn(model.arn);
            this.id(model.id);
            this.taskId(model.taskId);
            this.taskDetails(model.taskDetails);
            this.startedAt(model.startedAt);
            this.status(model.status);
            this.endedAt(model.endedAt);
            this.errorDetailList(model.errorDetailList);
        }

        public final String getCatalog() {
            return this.catalog;
        }

        public final void setCatalog(String catalog) {
            this.catalog = catalog;
        }

        @Override
        public final Builder catalog(String catalog) {
            this.catalog = catalog;
            return this;
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getTaskId() {
            return this.taskId;
        }

        public final void setTaskId(String taskId) {
            this.taskId = taskId;
        }

        @Override
        public final Builder taskId(String taskId) {
            this.taskId = taskId;
            return this;
        }

        public final TaskDetails.Builder getTaskDetails() {
            return this.taskDetails != null ? this.taskDetails.toBuilder() : null;
        }

        public final void setTaskDetails(TaskDetails.BuilderImpl taskDetails) {
            this.taskDetails = taskDetails != null ? taskDetails.build() : null;
        }

        @Override
        public final Builder taskDetails(TaskDetails taskDetails) {
            this.taskDetails = taskDetails;
            return this;
        }

        public final Instant getStartedAt() {
            return this.startedAt;
        }

        public final void setStartedAt(Instant startedAt) {
            this.startedAt = startedAt;
        }

        @Override
        public final Builder startedAt(Instant startedAt) {
            this.startedAt = startedAt;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ProfileTaskStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Instant getEndedAt() {
            return this.endedAt;
        }

        public final void setEndedAt(Instant endedAt) {
            this.endedAt = endedAt;
        }

        @Override
        public final Builder endedAt(Instant endedAt) {
            this.endedAt = endedAt;
            return this;
        }

        public final List<ErrorDetail.Builder> getErrorDetailList() {
            List<ErrorDetail.Builder> result = ErrorDetailListCopier.copyToBuilder(this.errorDetailList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setErrorDetailList(Collection<ErrorDetail.BuilderImpl> errorDetailList) {
            this.errorDetailList = ErrorDetailListCopier.copyFromBuilder(errorDetailList);
        }

        @Override
        public final Builder errorDetailList(Collection<ErrorDetail> errorDetailList) {
            this.errorDetailList = ErrorDetailListCopier.copy(errorDetailList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errorDetailList(ErrorDetail ... errorDetailList) {
            this.errorDetailList(Arrays.asList(errorDetailList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errorDetailList(Consumer<ErrorDetail.Builder> ... errorDetailList) {
            this.errorDetailList(Stream.of(errorDetailList).map(c -> (ErrorDetail)((ErrorDetail.Builder)ErrorDetail.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public GetProfileUpdateTaskResponse build() {
            return new GetProfileUpdateTaskResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends PartnerCentralAccountResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetProfileUpdateTaskResponse> {
        public Builder catalog(String var1);

        public Builder arn(String var1);

        public Builder id(String var1);

        public Builder taskId(String var1);

        public Builder taskDetails(TaskDetails var1);

        default public Builder taskDetails(Consumer<TaskDetails.Builder> taskDetails) {
            return this.taskDetails((TaskDetails)((TaskDetails.Builder)TaskDetails.builder().applyMutation(taskDetails)).build());
        }

        public Builder startedAt(Instant var1);

        public Builder status(String var1);

        public Builder status(ProfileTaskStatus var1);

        public Builder endedAt(Instant var1);

        public Builder errorDetailList(Collection<ErrorDetail> var1);

        public Builder errorDetailList(ErrorDetail ... var1);

        public Builder errorDetailList(Consumer<ErrorDetail.Builder> ... var1);
    }
}

