/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.partnercentralaccount.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.partnercentralaccount.model.AccessType;
import software.amazon.awssdk.services.partnercentralaccount.model.PartnerCentralAccountRequest;
import software.amazon.awssdk.services.partnercentralaccount.model.UpdateConnectionPreferencesRequestExcludedParticipantIdentifiersListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateConnectionPreferencesRequest
extends PartnerCentralAccountRequest
implements ToCopyableBuilder<Builder, UpdateConnectionPreferencesRequest> {
    private static final SdkField<String> CATALOG_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Catalog").getter(UpdateConnectionPreferencesRequest.getter(UpdateConnectionPreferencesRequest::catalog)).setter(UpdateConnectionPreferencesRequest.setter(Builder::catalog)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Catalog").build()}).build();
    private static final SdkField<Long> REVISION_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("Revision").getter(UpdateConnectionPreferencesRequest.getter(UpdateConnectionPreferencesRequest::revision)).setter(UpdateConnectionPreferencesRequest.setter(Builder::revision)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Revision").build()}).build();
    private static final SdkField<String> ACCESS_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AccessType").getter(UpdateConnectionPreferencesRequest.getter(UpdateConnectionPreferencesRequest::accessTypeAsString)).setter(UpdateConnectionPreferencesRequest.setter(Builder::accessType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccessType").build()}).build();
    private static final SdkField<List<String>> EXCLUDED_PARTICIPANT_IDENTIFIERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ExcludedParticipantIdentifiers").getter(UpdateConnectionPreferencesRequest.getter(UpdateConnectionPreferencesRequest::excludedParticipantIdentifiers)).setter(UpdateConnectionPreferencesRequest.setter(Builder::excludedParticipantIdentifiers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExcludedParticipantIdentifiers").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CATALOG_FIELD, REVISION_FIELD, ACCESS_TYPE_FIELD, EXCLUDED_PARTICIPANT_IDENTIFIERS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateConnectionPreferencesRequest.memberNameToFieldInitializer();
    private final String catalog;
    private final Long revision;
    private final String accessType;
    private final List<String> excludedParticipantIdentifiers;

    private UpdateConnectionPreferencesRequest(BuilderImpl builder) {
        super(builder);
        this.catalog = builder.catalog;
        this.revision = builder.revision;
        this.accessType = builder.accessType;
        this.excludedParticipantIdentifiers = builder.excludedParticipantIdentifiers;
    }

    public final String catalog() {
        return this.catalog;
    }

    public final Long revision() {
        return this.revision;
    }

    public final AccessType accessType() {
        return AccessType.fromValue(this.accessType);
    }

    public final String accessTypeAsString() {
        return this.accessType;
    }

    public final boolean hasExcludedParticipantIdentifiers() {
        return this.excludedParticipantIdentifiers != null && !(this.excludedParticipantIdentifiers instanceof SdkAutoConstructList);
    }

    public final List<String> excludedParticipantIdentifiers() {
        return this.excludedParticipantIdentifiers;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.catalog());
        hashCode = 31 * hashCode + Objects.hashCode(this.revision());
        hashCode = 31 * hashCode + Objects.hashCode(this.accessTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasExcludedParticipantIdentifiers() ? this.excludedParticipantIdentifiers() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateConnectionPreferencesRequest)) {
            return false;
        }
        UpdateConnectionPreferencesRequest other = (UpdateConnectionPreferencesRequest)((Object)obj);
        return Objects.equals(this.catalog(), other.catalog()) && Objects.equals(this.revision(), other.revision()) && Objects.equals(this.accessTypeAsString(), other.accessTypeAsString()) && this.hasExcludedParticipantIdentifiers() == other.hasExcludedParticipantIdentifiers() && Objects.equals(this.excludedParticipantIdentifiers(), other.excludedParticipantIdentifiers());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateConnectionPreferencesRequest").add("Catalog", (Object)this.catalog()).add("Revision", (Object)this.revision()).add("AccessType", (Object)this.accessTypeAsString()).add("ExcludedParticipantIdentifiers", this.hasExcludedParticipantIdentifiers() ? this.excludedParticipantIdentifiers() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Catalog": {
                return Optional.ofNullable(clazz.cast(this.catalog()));
            }
            case "Revision": {
                return Optional.ofNullable(clazz.cast(this.revision()));
            }
            case "AccessType": {
                return Optional.ofNullable(clazz.cast(this.accessTypeAsString()));
            }
            case "ExcludedParticipantIdentifiers": {
                return Optional.ofNullable(clazz.cast(this.excludedParticipantIdentifiers()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Catalog", CATALOG_FIELD);
        map.put("Revision", REVISION_FIELD);
        map.put("AccessType", ACCESS_TYPE_FIELD);
        map.put("ExcludedParticipantIdentifiers", EXCLUDED_PARTICIPANT_IDENTIFIERS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateConnectionPreferencesRequest, T> g) {
        return obj -> g.apply((UpdateConnectionPreferencesRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends PartnerCentralAccountRequest.BuilderImpl
    implements Builder {
        private String catalog;
        private Long revision;
        private String accessType;
        private List<String> excludedParticipantIdentifiers = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateConnectionPreferencesRequest model) {
            super(model);
            this.catalog(model.catalog);
            this.revision(model.revision);
            this.accessType(model.accessType);
            this.excludedParticipantIdentifiers(model.excludedParticipantIdentifiers);
        }

        public final String getCatalog() {
            return this.catalog;
        }

        public final void setCatalog(String catalog) {
            this.catalog = catalog;
        }

        @Override
        public final Builder catalog(String catalog) {
            this.catalog = catalog;
            return this;
        }

        public final Long getRevision() {
            return this.revision;
        }

        public final void setRevision(Long revision) {
            this.revision = revision;
        }

        @Override
        public final Builder revision(Long revision) {
            this.revision = revision;
            return this;
        }

        public final String getAccessType() {
            return this.accessType;
        }

        public final void setAccessType(String accessType) {
            this.accessType = accessType;
        }

        @Override
        public final Builder accessType(String accessType) {
            this.accessType = accessType;
            return this;
        }

        @Override
        public final Builder accessType(AccessType accessType) {
            this.accessType(accessType == null ? null : accessType.toString());
            return this;
        }

        public final Collection<String> getExcludedParticipantIdentifiers() {
            if (this.excludedParticipantIdentifiers instanceof SdkAutoConstructList) {
                return null;
            }
            return this.excludedParticipantIdentifiers;
        }

        public final void setExcludedParticipantIdentifiers(Collection<String> excludedParticipantIdentifiers) {
            this.excludedParticipantIdentifiers = UpdateConnectionPreferencesRequestExcludedParticipantIdentifiersListCopier.copy(excludedParticipantIdentifiers);
        }

        @Override
        public final Builder excludedParticipantIdentifiers(Collection<String> excludedParticipantIdentifiers) {
            this.excludedParticipantIdentifiers = UpdateConnectionPreferencesRequestExcludedParticipantIdentifiersListCopier.copy(excludedParticipantIdentifiers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder excludedParticipantIdentifiers(String ... excludedParticipantIdentifiers) {
            this.excludedParticipantIdentifiers(Arrays.asList(excludedParticipantIdentifiers));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateConnectionPreferencesRequest build() {
            return new UpdateConnectionPreferencesRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends PartnerCentralAccountRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateConnectionPreferencesRequest> {
        public Builder catalog(String var1);

        public Builder revision(Long var1);

        public Builder accessType(String var1);

        public Builder accessType(AccessType var1);

        public Builder excludedParticipantIdentifiers(Collection<String> var1);

        public Builder excludedParticipantIdentifiers(String ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

