/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.partnercentralaccount.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.partnercentralaccount.PartnerCentralAccountAsyncClient;
import software.amazon.awssdk.services.partnercentralaccount.internal.UserAgentUtils;
import software.amazon.awssdk.services.partnercentralaccount.model.ListPartnersRequest;
import software.amazon.awssdk.services.partnercentralaccount.model.ListPartnersResponse;
import software.amazon.awssdk.services.partnercentralaccount.model.PartnerSummary;

public class ListPartnersPublisher
implements SdkPublisher<ListPartnersResponse> {
    private final PartnerCentralAccountAsyncClient client;
    private final ListPartnersRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListPartnersPublisher(PartnerCentralAccountAsyncClient client, ListPartnersRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListPartnersPublisher(PartnerCentralAccountAsyncClient client, ListPartnersRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListPartnersResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListPartnersResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<PartnerSummary> partnerSummaryList() {
        Function<ListPartnersResponse, Iterator> getIterator = response -> {
            if (response != null && response.partnerSummaryList() != null) {
                return response.partnerSummaryList().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListPartnersResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListPartnersResponseFetcher
    implements AsyncPageFetcher<ListPartnersResponse> {
        private ListPartnersResponseFetcher() {
        }

        public boolean hasNextPage(ListPartnersResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListPartnersResponse> nextPage(ListPartnersResponse previousPage) {
            if (previousPage == null) {
                return ListPartnersPublisher.this.client.listPartners(ListPartnersPublisher.this.firstRequest);
            }
            return ListPartnersPublisher.this.client.listPartners((ListPartnersRequest)((Object)ListPartnersPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

