/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.partnercentralaccount.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.partnercentralaccount.model.AllianceLeadContact;
import software.amazon.awssdk.services.partnercentralaccount.model.PartnerCentralAccountRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PutAllianceLeadContactRequest
extends PartnerCentralAccountRequest
implements ToCopyableBuilder<Builder, PutAllianceLeadContactRequest> {
    private static final SdkField<String> CATALOG_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Catalog").getter(PutAllianceLeadContactRequest.getter(PutAllianceLeadContactRequest::catalog)).setter(PutAllianceLeadContactRequest.setter(Builder::catalog)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Catalog").build()}).build();
    private static final SdkField<String> IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Identifier").getter(PutAllianceLeadContactRequest.getter(PutAllianceLeadContactRequest::identifier)).setter(PutAllianceLeadContactRequest.setter(Builder::identifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Identifier").build()}).build();
    private static final SdkField<AllianceLeadContact> ALLIANCE_LEAD_CONTACT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AllianceLeadContact").getter(PutAllianceLeadContactRequest.getter(PutAllianceLeadContactRequest::allianceLeadContact)).setter(PutAllianceLeadContactRequest.setter(Builder::allianceLeadContact)).constructor(AllianceLeadContact::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllianceLeadContact").build()}).build();
    private static final SdkField<String> EMAIL_VERIFICATION_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EmailVerificationCode").getter(PutAllianceLeadContactRequest.getter(PutAllianceLeadContactRequest::emailVerificationCode)).setter(PutAllianceLeadContactRequest.setter(Builder::emailVerificationCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EmailVerificationCode").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CATALOG_FIELD, IDENTIFIER_FIELD, ALLIANCE_LEAD_CONTACT_FIELD, EMAIL_VERIFICATION_CODE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = PutAllianceLeadContactRequest.memberNameToFieldInitializer();
    private final String catalog;
    private final String identifier;
    private final AllianceLeadContact allianceLeadContact;
    private final String emailVerificationCode;

    private PutAllianceLeadContactRequest(BuilderImpl builder) {
        super(builder);
        this.catalog = builder.catalog;
        this.identifier = builder.identifier;
        this.allianceLeadContact = builder.allianceLeadContact;
        this.emailVerificationCode = builder.emailVerificationCode;
    }

    public final String catalog() {
        return this.catalog;
    }

    public final String identifier() {
        return this.identifier;
    }

    public final AllianceLeadContact allianceLeadContact() {
        return this.allianceLeadContact;
    }

    public final String emailVerificationCode() {
        return this.emailVerificationCode;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.catalog());
        hashCode = 31 * hashCode + Objects.hashCode(this.identifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.allianceLeadContact());
        hashCode = 31 * hashCode + Objects.hashCode(this.emailVerificationCode());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutAllianceLeadContactRequest)) {
            return false;
        }
        PutAllianceLeadContactRequest other = (PutAllianceLeadContactRequest)((Object)obj);
        return Objects.equals(this.catalog(), other.catalog()) && Objects.equals(this.identifier(), other.identifier()) && Objects.equals(this.allianceLeadContact(), other.allianceLeadContact()) && Objects.equals(this.emailVerificationCode(), other.emailVerificationCode());
    }

    public final String toString() {
        return ToString.builder((String)"PutAllianceLeadContactRequest").add("Catalog", (Object)this.catalog()).add("Identifier", (Object)this.identifier()).add("AllianceLeadContact", (Object)this.allianceLeadContact()).add("EmailVerificationCode", (Object)(this.emailVerificationCode() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Catalog": {
                return Optional.ofNullable(clazz.cast(this.catalog()));
            }
            case "Identifier": {
                return Optional.ofNullable(clazz.cast(this.identifier()));
            }
            case "AllianceLeadContact": {
                return Optional.ofNullable(clazz.cast(this.allianceLeadContact()));
            }
            case "EmailVerificationCode": {
                return Optional.ofNullable(clazz.cast(this.emailVerificationCode()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Catalog", CATALOG_FIELD);
        map.put("Identifier", IDENTIFIER_FIELD);
        map.put("AllianceLeadContact", ALLIANCE_LEAD_CONTACT_FIELD);
        map.put("EmailVerificationCode", EMAIL_VERIFICATION_CODE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PutAllianceLeadContactRequest, T> g) {
        return obj -> g.apply((PutAllianceLeadContactRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends PartnerCentralAccountRequest.BuilderImpl
    implements Builder {
        private String catalog;
        private String identifier;
        private AllianceLeadContact allianceLeadContact;
        private String emailVerificationCode;

        private BuilderImpl() {
        }

        private BuilderImpl(PutAllianceLeadContactRequest model) {
            super(model);
            this.catalog(model.catalog);
            this.identifier(model.identifier);
            this.allianceLeadContact(model.allianceLeadContact);
            this.emailVerificationCode(model.emailVerificationCode);
        }

        public final String getCatalog() {
            return this.catalog;
        }

        public final void setCatalog(String catalog) {
            this.catalog = catalog;
        }

        @Override
        public final Builder catalog(String catalog) {
            this.catalog = catalog;
            return this;
        }

        public final String getIdentifier() {
            return this.identifier;
        }

        public final void setIdentifier(String identifier) {
            this.identifier = identifier;
        }

        @Override
        public final Builder identifier(String identifier) {
            this.identifier = identifier;
            return this;
        }

        public final AllianceLeadContact.Builder getAllianceLeadContact() {
            return this.allianceLeadContact != null ? this.allianceLeadContact.toBuilder() : null;
        }

        public final void setAllianceLeadContact(AllianceLeadContact.BuilderImpl allianceLeadContact) {
            this.allianceLeadContact = allianceLeadContact != null ? allianceLeadContact.build() : null;
        }

        @Override
        public final Builder allianceLeadContact(AllianceLeadContact allianceLeadContact) {
            this.allianceLeadContact = allianceLeadContact;
            return this;
        }

        public final String getEmailVerificationCode() {
            return this.emailVerificationCode;
        }

        public final void setEmailVerificationCode(String emailVerificationCode) {
            this.emailVerificationCode = emailVerificationCode;
        }

        @Override
        public final Builder emailVerificationCode(String emailVerificationCode) {
            this.emailVerificationCode = emailVerificationCode;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutAllianceLeadContactRequest build() {
            return new PutAllianceLeadContactRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends PartnerCentralAccountRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, PutAllianceLeadContactRequest> {
        public Builder catalog(String var1);

        public Builder identifier(String var1);

        public Builder allianceLeadContact(AllianceLeadContact var1);

        default public Builder allianceLeadContact(Consumer<AllianceLeadContact.Builder> allianceLeadContact) {
            return this.allianceLeadContact((AllianceLeadContact)((AllianceLeadContact.Builder)AllianceLeadContact.builder().applyMutation(allianceLeadContact)).build());
        }

        public Builder emailVerificationCode(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

