/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.partnercentralaccount.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.partnercentralaccount.model.PartnerCentralAccountResponse;
import software.amazon.awssdk.services.partnercentralaccount.model.ProfileVisibility;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetProfileVisibilityResponse
extends PartnerCentralAccountResponse
implements ToCopyableBuilder<Builder, GetProfileVisibilityResponse> {
    private static final SdkField<String> CATALOG_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Catalog").getter(GetProfileVisibilityResponse.getter(GetProfileVisibilityResponse::catalog)).setter(GetProfileVisibilityResponse.setter(Builder::catalog)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Catalog").build()}).build();
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Arn").getter(GetProfileVisibilityResponse.getter(GetProfileVisibilityResponse::arn)).setter(GetProfileVisibilityResponse.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()}).build();
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Id").getter(GetProfileVisibilityResponse.getter(GetProfileVisibilityResponse::id)).setter(GetProfileVisibilityResponse.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()}).build();
    private static final SdkField<String> VISIBILITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Visibility").getter(GetProfileVisibilityResponse.getter(GetProfileVisibilityResponse::visibilityAsString)).setter(GetProfileVisibilityResponse.setter(Builder::visibility)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Visibility").build()}).build();
    private static final SdkField<String> PROFILE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ProfileId").getter(GetProfileVisibilityResponse.getter(GetProfileVisibilityResponse::profileId)).setter(GetProfileVisibilityResponse.setter(Builder::profileId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProfileId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CATALOG_FIELD, ARN_FIELD, ID_FIELD, VISIBILITY_FIELD, PROFILE_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetProfileVisibilityResponse.memberNameToFieldInitializer();
    private final String catalog;
    private final String arn;
    private final String id;
    private final String visibility;
    private final String profileId;

    private GetProfileVisibilityResponse(BuilderImpl builder) {
        super(builder);
        this.catalog = builder.catalog;
        this.arn = builder.arn;
        this.id = builder.id;
        this.visibility = builder.visibility;
        this.profileId = builder.profileId;
    }

    public final String catalog() {
        return this.catalog;
    }

    public final String arn() {
        return this.arn;
    }

    public final String id() {
        return this.id;
    }

    public final ProfileVisibility visibility() {
        return ProfileVisibility.fromValue(this.visibility);
    }

    public final String visibilityAsString() {
        return this.visibility;
    }

    public final String profileId() {
        return this.profileId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.catalog());
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.visibilityAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.profileId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetProfileVisibilityResponse)) {
            return false;
        }
        GetProfileVisibilityResponse other = (GetProfileVisibilityResponse)((Object)obj);
        return Objects.equals(this.catalog(), other.catalog()) && Objects.equals(this.arn(), other.arn()) && Objects.equals(this.id(), other.id()) && Objects.equals(this.visibilityAsString(), other.visibilityAsString()) && Objects.equals(this.profileId(), other.profileId());
    }

    public final String toString() {
        return ToString.builder((String)"GetProfileVisibilityResponse").add("Catalog", (Object)this.catalog()).add("Arn", (Object)this.arn()).add("Id", (Object)this.id()).add("Visibility", (Object)this.visibilityAsString()).add("ProfileId", (Object)this.profileId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Catalog": {
                return Optional.ofNullable(clazz.cast(this.catalog()));
            }
            case "Arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "Visibility": {
                return Optional.ofNullable(clazz.cast(this.visibilityAsString()));
            }
            case "ProfileId": {
                return Optional.ofNullable(clazz.cast(this.profileId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("Catalog", CATALOG_FIELD);
        map.put("Arn", ARN_FIELD);
        map.put("Id", ID_FIELD);
        map.put("Visibility", VISIBILITY_FIELD);
        map.put("ProfileId", PROFILE_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetProfileVisibilityResponse, T> g) {
        return obj -> g.apply((GetProfileVisibilityResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends PartnerCentralAccountResponse.BuilderImpl
    implements Builder {
        private String catalog;
        private String arn;
        private String id;
        private String visibility;
        private String profileId;

        private BuilderImpl() {
        }

        private BuilderImpl(GetProfileVisibilityResponse model) {
            super(model);
            this.catalog(model.catalog);
            this.arn(model.arn);
            this.id(model.id);
            this.visibility(model.visibility);
            this.profileId(model.profileId);
        }

        public final String getCatalog() {
            return this.catalog;
        }

        public final void setCatalog(String catalog) {
            this.catalog = catalog;
        }

        @Override
        public final Builder catalog(String catalog) {
            this.catalog = catalog;
            return this;
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getVisibility() {
            return this.visibility;
        }

        public final void setVisibility(String visibility) {
            this.visibility = visibility;
        }

        @Override
        public final Builder visibility(String visibility) {
            this.visibility = visibility;
            return this;
        }

        @Override
        public final Builder visibility(ProfileVisibility visibility) {
            this.visibility(visibility == null ? null : visibility.toString());
            return this;
        }

        public final String getProfileId() {
            return this.profileId;
        }

        public final void setProfileId(String profileId) {
            this.profileId = profileId;
        }

        @Override
        public final Builder profileId(String profileId) {
            this.profileId = profileId;
            return this;
        }

        @Override
        public GetProfileVisibilityResponse build() {
            return new GetProfileVisibilityResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends PartnerCentralAccountResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetProfileVisibilityResponse> {
        public Builder catalog(String var1);

        public Builder arn(String var1);

        public Builder id(String var1);

        public Builder visibility(String var1);

        public Builder visibility(ProfileVisibility var1);

        public Builder profileId(String var1);
    }
}

