/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.partnercentralaccount.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.partnercentralaccount.model.ConnectionTypeStatus;
import software.amazon.awssdk.services.partnercentralaccount.model.Participant;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ConnectionTypeSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ConnectionTypeSummary> {
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(ConnectionTypeSummary.getter(ConnectionTypeSummary::statusAsString)).setter(ConnectionTypeSummary.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<Participant> OTHER_PARTICIPANT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("OtherParticipant").getter(ConnectionTypeSummary.getter(ConnectionTypeSummary::otherParticipant)).setter(ConnectionTypeSummary.setter(Builder::otherParticipant)).constructor(Participant::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OtherParticipant").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATUS_FIELD, OTHER_PARTICIPANT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ConnectionTypeSummary.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String status;
    private final Participant otherParticipant;

    private ConnectionTypeSummary(BuilderImpl builder) {
        this.status = builder.status;
        this.otherParticipant = builder.otherParticipant;
    }

    public final ConnectionTypeStatus status() {
        return ConnectionTypeStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final Participant otherParticipant() {
        return this.otherParticipant;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.otherParticipant());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConnectionTypeSummary)) {
            return false;
        }
        ConnectionTypeSummary other = (ConnectionTypeSummary)obj;
        return Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.otherParticipant(), other.otherParticipant());
    }

    public final String toString() {
        return ToString.builder((String)"ConnectionTypeSummary").add("Status", (Object)this.statusAsString()).add("OtherParticipant", (Object)this.otherParticipant()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "OtherParticipant": {
                return Optional.ofNullable(clazz.cast(this.otherParticipant()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Status", STATUS_FIELD);
        map.put("OtherParticipant", OTHER_PARTICIPANT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ConnectionTypeSummary, T> g) {
        return obj -> g.apply((ConnectionTypeSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String status;
        private Participant otherParticipant;

        private BuilderImpl() {
        }

        private BuilderImpl(ConnectionTypeSummary model) {
            this.status(model.status);
            this.otherParticipant(model.otherParticipant);
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ConnectionTypeStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Participant.Builder getOtherParticipant() {
            return this.otherParticipant != null ? this.otherParticipant.toBuilder() : null;
        }

        public final void setOtherParticipant(Participant.BuilderImpl otherParticipant) {
            this.otherParticipant = otherParticipant != null ? otherParticipant.build() : null;
        }

        @Override
        public final Builder otherParticipant(Participant otherParticipant) {
            this.otherParticipant = otherParticipant;
            return this;
        }

        public ConnectionTypeSummary build() {
            return new ConnectionTypeSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ConnectionTypeSummary> {
        public Builder status(String var1);

        public Builder status(ConnectionTypeStatus var1);

        public Builder otherParticipant(Participant var1);

        default public Builder otherParticipant(Consumer<Participant.Builder> otherParticipant) {
            return this.otherParticipant((Participant)((Participant.Builder)Participant.builder().applyMutation(otherParticipant)).build());
        }
    }
}

