/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.partnercentralaccount.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.partnercentralaccount.PartnerCentralAccountClient;
import software.amazon.awssdk.services.partnercentralaccount.internal.UserAgentUtils;
import software.amazon.awssdk.services.partnercentralaccount.model.ListPartnersRequest;
import software.amazon.awssdk.services.partnercentralaccount.model.ListPartnersResponse;
import software.amazon.awssdk.services.partnercentralaccount.model.PartnerSummary;

public class ListPartnersIterable
implements SdkIterable<ListPartnersResponse> {
    private final PartnerCentralAccountClient client;
    private final ListPartnersRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListPartnersIterable(PartnerCentralAccountClient client, ListPartnersRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListPartnersResponseFetcher();
    }

    public Iterator<ListPartnersResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<PartnerSummary> partnerSummaryList() {
        Function<ListPartnersResponse, Iterator> getIterator = response -> {
            if (response != null && response.partnerSummaryList() != null) {
                return response.partnerSummaryList().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListPartnersResponseFetcher
    implements SyncPageFetcher<ListPartnersResponse> {
        private ListPartnersResponseFetcher() {
        }

        public boolean hasNextPage(ListPartnersResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListPartnersResponse nextPage(ListPartnersResponse previousPage) {
            if (previousPage == null) {
                return ListPartnersIterable.this.client.listPartners(ListPartnersIterable.this.firstRequest);
            }
            return ListPartnersIterable.this.client.listPartners((ListPartnersRequest)((Object)ListPartnersIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

