/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.partnercentralaccount.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.partnercentralaccount.model.ParticipantIdentifierListCopier;
import software.amazon.awssdk.services.partnercentralaccount.model.PartnerCentralAccountRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListConnectionsRequest
extends PartnerCentralAccountRequest
implements ToCopyableBuilder<Builder, ListConnectionsRequest> {
    private static final SdkField<String> CATALOG_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Catalog").getter(ListConnectionsRequest.getter(ListConnectionsRequest::catalog)).setter(ListConnectionsRequest.setter(Builder::catalog)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Catalog").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListConnectionsRequest.getter(ListConnectionsRequest::nextToken)).setter(ListConnectionsRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<String> CONNECTION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ConnectionType").getter(ListConnectionsRequest.getter(ListConnectionsRequest::connectionType)).setter(ListConnectionsRequest.setter(Builder::connectionType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectionType").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxResults").getter(ListConnectionsRequest.getter(ListConnectionsRequest::maxResults)).setter(ListConnectionsRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()}).build();
    private static final SdkField<List<String>> OTHER_PARTICIPANT_IDENTIFIERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("OtherParticipantIdentifiers").getter(ListConnectionsRequest.getter(ListConnectionsRequest::otherParticipantIdentifiers)).setter(ListConnectionsRequest.setter(Builder::otherParticipantIdentifiers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OtherParticipantIdentifiers").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CATALOG_FIELD, NEXT_TOKEN_FIELD, CONNECTION_TYPE_FIELD, MAX_RESULTS_FIELD, OTHER_PARTICIPANT_IDENTIFIERS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListConnectionsRequest.memberNameToFieldInitializer();
    private final String catalog;
    private final String nextToken;
    private final String connectionType;
    private final Integer maxResults;
    private final List<String> otherParticipantIdentifiers;

    private ListConnectionsRequest(BuilderImpl builder) {
        super(builder);
        this.catalog = builder.catalog;
        this.nextToken = builder.nextToken;
        this.connectionType = builder.connectionType;
        this.maxResults = builder.maxResults;
        this.otherParticipantIdentifiers = builder.otherParticipantIdentifiers;
    }

    public final String catalog() {
        return this.catalog;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final String connectionType() {
        return this.connectionType;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    public final boolean hasOtherParticipantIdentifiers() {
        return this.otherParticipantIdentifiers != null && !(this.otherParticipantIdentifiers instanceof SdkAutoConstructList);
    }

    public final List<String> otherParticipantIdentifiers() {
        return this.otherParticipantIdentifiers;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.catalog());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.connectionType());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasOtherParticipantIdentifiers() ? this.otherParticipantIdentifiers() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListConnectionsRequest)) {
            return false;
        }
        ListConnectionsRequest other = (ListConnectionsRequest)((Object)obj);
        return Objects.equals(this.catalog(), other.catalog()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.connectionType(), other.connectionType()) && Objects.equals(this.maxResults(), other.maxResults()) && this.hasOtherParticipantIdentifiers() == other.hasOtherParticipantIdentifiers() && Objects.equals(this.otherParticipantIdentifiers(), other.otherParticipantIdentifiers());
    }

    public final String toString() {
        return ToString.builder((String)"ListConnectionsRequest").add("Catalog", (Object)this.catalog()).add("NextToken", (Object)this.nextToken()).add("ConnectionType", (Object)this.connectionType()).add("MaxResults", (Object)this.maxResults()).add("OtherParticipantIdentifiers", this.hasOtherParticipantIdentifiers() ? this.otherParticipantIdentifiers() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Catalog": {
                return Optional.ofNullable(clazz.cast(this.catalog()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "ConnectionType": {
                return Optional.ofNullable(clazz.cast(this.connectionType()));
            }
            case "MaxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "OtherParticipantIdentifiers": {
                return Optional.ofNullable(clazz.cast(this.otherParticipantIdentifiers()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Catalog", CATALOG_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("ConnectionType", CONNECTION_TYPE_FIELD);
        map.put("MaxResults", MAX_RESULTS_FIELD);
        map.put("OtherParticipantIdentifiers", OTHER_PARTICIPANT_IDENTIFIERS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListConnectionsRequest, T> g) {
        return obj -> g.apply((ListConnectionsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends PartnerCentralAccountRequest.BuilderImpl
    implements Builder {
        private String catalog;
        private String nextToken;
        private String connectionType;
        private Integer maxResults;
        private List<String> otherParticipantIdentifiers = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListConnectionsRequest model) {
            super(model);
            this.catalog(model.catalog);
            this.nextToken(model.nextToken);
            this.connectionType(model.connectionType);
            this.maxResults(model.maxResults);
            this.otherParticipantIdentifiers(model.otherParticipantIdentifiers);
        }

        public final String getCatalog() {
            return this.catalog;
        }

        public final void setCatalog(String catalog) {
            this.catalog = catalog;
        }

        @Override
        public final Builder catalog(String catalog) {
            this.catalog = catalog;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final String getConnectionType() {
            return this.connectionType;
        }

        public final void setConnectionType(String connectionType) {
            this.connectionType = connectionType;
        }

        @Override
        public final Builder connectionType(String connectionType) {
            this.connectionType = connectionType;
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final Collection<String> getOtherParticipantIdentifiers() {
            if (this.otherParticipantIdentifiers instanceof SdkAutoConstructList) {
                return null;
            }
            return this.otherParticipantIdentifiers;
        }

        public final void setOtherParticipantIdentifiers(Collection<String> otherParticipantIdentifiers) {
            this.otherParticipantIdentifiers = ParticipantIdentifierListCopier.copy(otherParticipantIdentifiers);
        }

        @Override
        public final Builder otherParticipantIdentifiers(Collection<String> otherParticipantIdentifiers) {
            this.otherParticipantIdentifiers = ParticipantIdentifierListCopier.copy(otherParticipantIdentifiers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder otherParticipantIdentifiers(String ... otherParticipantIdentifiers) {
            this.otherParticipantIdentifiers(Arrays.asList(otherParticipantIdentifiers));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListConnectionsRequest build() {
            return new ListConnectionsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends PartnerCentralAccountRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListConnectionsRequest> {
        public Builder catalog(String var1);

        public Builder nextToken(String var1);

        public Builder connectionType(String var1);

        public Builder maxResults(Integer var1);

        public Builder otherParticipantIdentifiers(Collection<String> var1);

        public Builder otherParticipantIdentifiers(String ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

