/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.partnercentralaccount.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.partnercentralaccount.model.AccountSummary;
import software.amazon.awssdk.services.partnercentralaccount.model.PartnerProfileSummary;
import software.amazon.awssdk.services.partnercentralaccount.model.SellerProfileSummary;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Participant
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Participant> {
    private static final SdkField<PartnerProfileSummary> PARTNER_PROFILE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("PartnerProfile").getter(Participant.getter(Participant::partnerProfile)).setter(Participant.setter(Builder::partnerProfile)).constructor(PartnerProfileSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PartnerProfile").build()}).build();
    private static final SdkField<SellerProfileSummary> SELLER_PROFILE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SellerProfile").getter(Participant.getter(Participant::sellerProfile)).setter(Participant.setter(Builder::sellerProfile)).constructor(SellerProfileSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SellerProfile").build()}).build();
    private static final SdkField<AccountSummary> ACCOUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Account").getter(Participant.getter(Participant::account)).setter(Participant.setter(Builder::account)).constructor(AccountSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Account").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PARTNER_PROFILE_FIELD, SELLER_PROFILE_FIELD, ACCOUNT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Participant.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final PartnerProfileSummary partnerProfile;
    private final SellerProfileSummary sellerProfile;
    private final AccountSummary account;
    private final Type type;

    private Participant(BuilderImpl builder) {
        this.partnerProfile = builder.partnerProfile;
        this.sellerProfile = builder.sellerProfile;
        this.account = builder.account;
        this.type = builder.type;
    }

    public final PartnerProfileSummary partnerProfile() {
        return this.partnerProfile;
    }

    public final SellerProfileSummary sellerProfile() {
        return this.sellerProfile;
    }

    public final AccountSummary account() {
        return this.account;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.partnerProfile());
        hashCode = 31 * hashCode + Objects.hashCode(this.sellerProfile());
        hashCode = 31 * hashCode + Objects.hashCode(this.account());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Participant)) {
            return false;
        }
        Participant other = (Participant)obj;
        return Objects.equals(this.partnerProfile(), other.partnerProfile()) && Objects.equals(this.sellerProfile(), other.sellerProfile()) && Objects.equals(this.account(), other.account());
    }

    public final String toString() {
        return ToString.builder((String)"Participant").add("PartnerProfile", (Object)this.partnerProfile()).add("SellerProfile", (Object)this.sellerProfile()).add("Account", (Object)this.account()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PartnerProfile": {
                return Optional.ofNullable(clazz.cast(this.partnerProfile()));
            }
            case "SellerProfile": {
                return Optional.ofNullable(clazz.cast(this.sellerProfile()));
            }
            case "Account": {
                return Optional.ofNullable(clazz.cast(this.account()));
            }
        }
        return Optional.empty();
    }

    public static Participant fromPartnerProfile(PartnerProfileSummary partnerProfile) {
        return (Participant)Participant.builder().partnerProfile(partnerProfile).build();
    }

    public static Participant fromPartnerProfile(Consumer<PartnerProfileSummary.Builder> partnerProfile) {
        PartnerProfileSummary.Builder builder = PartnerProfileSummary.builder();
        partnerProfile.accept(builder);
        return Participant.fromPartnerProfile((PartnerProfileSummary)builder.build());
    }

    public static Participant fromSellerProfile(SellerProfileSummary sellerProfile) {
        return (Participant)Participant.builder().sellerProfile(sellerProfile).build();
    }

    public static Participant fromSellerProfile(Consumer<SellerProfileSummary.Builder> sellerProfile) {
        SellerProfileSummary.Builder builder = SellerProfileSummary.builder();
        sellerProfile.accept(builder);
        return Participant.fromSellerProfile((SellerProfileSummary)builder.build());
    }

    public static Participant fromAccount(AccountSummary account) {
        return (Participant)Participant.builder().account(account).build();
    }

    public static Participant fromAccount(Consumer<AccountSummary.Builder> account) {
        AccountSummary.Builder builder = AccountSummary.builder();
        account.accept(builder);
        return Participant.fromAccount((AccountSummary)builder.build());
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("PartnerProfile", PARTNER_PROFILE_FIELD);
        map.put("SellerProfile", SELLER_PROFILE_FIELD);
        map.put("Account", ACCOUNT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Participant, T> g) {
        return obj -> g.apply((Participant)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        PARTNER_PROFILE,
        SELLER_PROFILE,
        ACCOUNT,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private PartnerProfileSummary partnerProfile;
        private SellerProfileSummary sellerProfile;
        private AccountSummary account;
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(Participant model) {
            this.partnerProfile(model.partnerProfile);
            this.sellerProfile(model.sellerProfile);
            this.account(model.account);
        }

        public final PartnerProfileSummary.Builder getPartnerProfile() {
            return this.partnerProfile != null ? this.partnerProfile.toBuilder() : null;
        }

        public final void setPartnerProfile(PartnerProfileSummary.BuilderImpl partnerProfile) {
            PartnerProfileSummary oldValue = this.partnerProfile;
            this.partnerProfile = partnerProfile != null ? partnerProfile.build() : null;
            this.handleUnionValueChange(Type.PARTNER_PROFILE, oldValue, this.partnerProfile);
        }

        @Override
        public final Builder partnerProfile(PartnerProfileSummary partnerProfile) {
            PartnerProfileSummary oldValue = this.partnerProfile;
            this.partnerProfile = partnerProfile;
            this.handleUnionValueChange(Type.PARTNER_PROFILE, oldValue, this.partnerProfile);
            return this;
        }

        public final SellerProfileSummary.Builder getSellerProfile() {
            return this.sellerProfile != null ? this.sellerProfile.toBuilder() : null;
        }

        public final void setSellerProfile(SellerProfileSummary.BuilderImpl sellerProfile) {
            SellerProfileSummary oldValue = this.sellerProfile;
            this.sellerProfile = sellerProfile != null ? sellerProfile.build() : null;
            this.handleUnionValueChange(Type.SELLER_PROFILE, oldValue, this.sellerProfile);
        }

        @Override
        public final Builder sellerProfile(SellerProfileSummary sellerProfile) {
            SellerProfileSummary oldValue = this.sellerProfile;
            this.sellerProfile = sellerProfile;
            this.handleUnionValueChange(Type.SELLER_PROFILE, oldValue, this.sellerProfile);
            return this;
        }

        public final AccountSummary.Builder getAccount() {
            return this.account != null ? this.account.toBuilder() : null;
        }

        public final void setAccount(AccountSummary.BuilderImpl account) {
            AccountSummary oldValue = this.account;
            this.account = account != null ? account.build() : null;
            this.handleUnionValueChange(Type.ACCOUNT, oldValue, this.account);
        }

        @Override
        public final Builder account(AccountSummary account) {
            AccountSummary oldValue = this.account;
            this.account = account;
            this.handleUnionValueChange(Type.ACCOUNT, oldValue, this.account);
            return this;
        }

        public Participant build() {
            return new Participant(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Participant> {
        public Builder partnerProfile(PartnerProfileSummary var1);

        default public Builder partnerProfile(Consumer<PartnerProfileSummary.Builder> partnerProfile) {
            return this.partnerProfile((PartnerProfileSummary)((PartnerProfileSummary.Builder)PartnerProfileSummary.builder().applyMutation(partnerProfile)).build());
        }

        public Builder sellerProfile(SellerProfileSummary var1);

        default public Builder sellerProfile(Consumer<SellerProfileSummary.Builder> sellerProfile) {
            return this.sellerProfile((SellerProfileSummary)((SellerProfileSummary.Builder)SellerProfileSummary.builder().applyMutation(sellerProfile)).build());
        }

        public Builder account(AccountSummary var1);

        default public Builder account(Consumer<AccountSummary.Builder> account) {
            return this.account((AccountSummary)((AccountSummary.Builder)AccountSummary.builder().applyMutation(account)).build());
        }
    }
}

