/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.partnercentralaccount.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.partnercentralaccount.model.ConnectionTypeStatus;
import software.amazon.awssdk.services.partnercentralaccount.model.Participant;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ConnectionTypeDetail
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ConnectionTypeDetail> {
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreatedAt").getter(ConnectionTypeDetail.getter(ConnectionTypeDetail::createdAt)).setter(ConnectionTypeDetail.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> INVITER_EMAIL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InviterEmail").getter(ConnectionTypeDetail.getter(ConnectionTypeDetail::inviterEmail)).setter(ConnectionTypeDetail.setter(Builder::inviterEmail)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InviterEmail").build()}).build();
    private static final SdkField<String> INVITER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InviterName").getter(ConnectionTypeDetail.getter(ConnectionTypeDetail::inviterName)).setter(ConnectionTypeDetail.setter(Builder::inviterName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InviterName").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(ConnectionTypeDetail.getter(ConnectionTypeDetail::statusAsString)).setter(ConnectionTypeDetail.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<Instant> CANCELED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CanceledAt").getter(ConnectionTypeDetail.getter(ConnectionTypeDetail::canceledAt)).setter(ConnectionTypeDetail.setter(Builder::canceledAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CanceledAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> CANCELED_BY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CanceledBy").getter(ConnectionTypeDetail.getter(ConnectionTypeDetail::canceledBy)).setter(ConnectionTypeDetail.setter(Builder::canceledBy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CanceledBy").build()}).build();
    private static final SdkField<Participant> OTHER_PARTICIPANT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("OtherParticipant").getter(ConnectionTypeDetail.getter(ConnectionTypeDetail::otherParticipant)).setter(ConnectionTypeDetail.setter(Builder::otherParticipant)).constructor(Participant::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OtherParticipant").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREATED_AT_FIELD, INVITER_EMAIL_FIELD, INVITER_NAME_FIELD, STATUS_FIELD, CANCELED_AT_FIELD, CANCELED_BY_FIELD, OTHER_PARTICIPANT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ConnectionTypeDetail.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Instant createdAt;
    private final String inviterEmail;
    private final String inviterName;
    private final String status;
    private final Instant canceledAt;
    private final String canceledBy;
    private final Participant otherParticipant;

    private ConnectionTypeDetail(BuilderImpl builder) {
        this.createdAt = builder.createdAt;
        this.inviterEmail = builder.inviterEmail;
        this.inviterName = builder.inviterName;
        this.status = builder.status;
        this.canceledAt = builder.canceledAt;
        this.canceledBy = builder.canceledBy;
        this.otherParticipant = builder.otherParticipant;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final String inviterEmail() {
        return this.inviterEmail;
    }

    public final String inviterName() {
        return this.inviterName;
    }

    public final ConnectionTypeStatus status() {
        return ConnectionTypeStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final Instant canceledAt() {
        return this.canceledAt;
    }

    public final String canceledBy() {
        return this.canceledBy;
    }

    public final Participant otherParticipant() {
        return this.otherParticipant;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.inviterEmail());
        hashCode = 31 * hashCode + Objects.hashCode(this.inviterName());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.canceledAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.canceledBy());
        hashCode = 31 * hashCode + Objects.hashCode(this.otherParticipant());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConnectionTypeDetail)) {
            return false;
        }
        ConnectionTypeDetail other = (ConnectionTypeDetail)obj;
        return Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.inviterEmail(), other.inviterEmail()) && Objects.equals(this.inviterName(), other.inviterName()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.canceledAt(), other.canceledAt()) && Objects.equals(this.canceledBy(), other.canceledBy()) && Objects.equals(this.otherParticipant(), other.otherParticipant());
    }

    public final String toString() {
        return ToString.builder((String)"ConnectionTypeDetail").add("CreatedAt", (Object)this.createdAt()).add("InviterEmail", (Object)this.inviterEmail()).add("InviterName", (Object)(this.inviterName() == null ? null : "*** Sensitive Data Redacted ***")).add("Status", (Object)this.statusAsString()).add("CanceledAt", (Object)this.canceledAt()).add("CanceledBy", (Object)this.canceledBy()).add("OtherParticipant", (Object)this.otherParticipant()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CreatedAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "InviterEmail": {
                return Optional.ofNullable(clazz.cast(this.inviterEmail()));
            }
            case "InviterName": {
                return Optional.ofNullable(clazz.cast(this.inviterName()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "CanceledAt": {
                return Optional.ofNullable(clazz.cast(this.canceledAt()));
            }
            case "CanceledBy": {
                return Optional.ofNullable(clazz.cast(this.canceledBy()));
            }
            case "OtherParticipant": {
                return Optional.ofNullable(clazz.cast(this.otherParticipant()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("CreatedAt", CREATED_AT_FIELD);
        map.put("InviterEmail", INVITER_EMAIL_FIELD);
        map.put("InviterName", INVITER_NAME_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("CanceledAt", CANCELED_AT_FIELD);
        map.put("CanceledBy", CANCELED_BY_FIELD);
        map.put("OtherParticipant", OTHER_PARTICIPANT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ConnectionTypeDetail, T> g) {
        return obj -> g.apply((ConnectionTypeDetail)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Instant createdAt;
        private String inviterEmail;
        private String inviterName;
        private String status;
        private Instant canceledAt;
        private String canceledBy;
        private Participant otherParticipant;

        private BuilderImpl() {
        }

        private BuilderImpl(ConnectionTypeDetail model) {
            this.createdAt(model.createdAt);
            this.inviterEmail(model.inviterEmail);
            this.inviterName(model.inviterName);
            this.status(model.status);
            this.canceledAt(model.canceledAt);
            this.canceledBy(model.canceledBy);
            this.otherParticipant(model.otherParticipant);
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final String getInviterEmail() {
            return this.inviterEmail;
        }

        public final void setInviterEmail(String inviterEmail) {
            this.inviterEmail = inviterEmail;
        }

        @Override
        public final Builder inviterEmail(String inviterEmail) {
            this.inviterEmail = inviterEmail;
            return this;
        }

        public final String getInviterName() {
            return this.inviterName;
        }

        public final void setInviterName(String inviterName) {
            this.inviterName = inviterName;
        }

        @Override
        public final Builder inviterName(String inviterName) {
            this.inviterName = inviterName;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ConnectionTypeStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Instant getCanceledAt() {
            return this.canceledAt;
        }

        public final void setCanceledAt(Instant canceledAt) {
            this.canceledAt = canceledAt;
        }

        @Override
        public final Builder canceledAt(Instant canceledAt) {
            this.canceledAt = canceledAt;
            return this;
        }

        public final String getCanceledBy() {
            return this.canceledBy;
        }

        public final void setCanceledBy(String canceledBy) {
            this.canceledBy = canceledBy;
        }

        @Override
        public final Builder canceledBy(String canceledBy) {
            this.canceledBy = canceledBy;
            return this;
        }

        public final Participant.Builder getOtherParticipant() {
            return this.otherParticipant != null ? this.otherParticipant.toBuilder() : null;
        }

        public final void setOtherParticipant(Participant.BuilderImpl otherParticipant) {
            this.otherParticipant = otherParticipant != null ? otherParticipant.build() : null;
        }

        @Override
        public final Builder otherParticipant(Participant otherParticipant) {
            this.otherParticipant = otherParticipant;
            return this;
        }

        public ConnectionTypeDetail build() {
            return new ConnectionTypeDetail(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ConnectionTypeDetail> {
        public Builder createdAt(Instant var1);

        public Builder inviterEmail(String var1);

        public Builder inviterName(String var1);

        public Builder status(String var1);

        public Builder status(ConnectionTypeStatus var1);

        public Builder canceledAt(Instant var1);

        public Builder canceledBy(String var1);

        public Builder otherParticipant(Participant var1);

        default public Builder otherParticipant(Consumer<Participant.Builder> otherParticipant) {
            return this.otherParticipant((Participant)((Participant.Builder)Participant.builder().applyMutation(otherParticipant)).build());
        }
    }
}

