/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.partnercentralaccount.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ConflictExceptionReason {
    CONFLICT_CLIENT_TOKEN("CONFLICT_CLIENT_TOKEN"),
    DUPLICATE_PARTNER("DUPLICATE_PARTNER"),
    INCOMPATIBLE_PROFILE_STATE("INCOMPATIBLE_PROFILE_STATE"),
    INCOMPATIBLE_PARTNER_PROFILE_TASK_STATE("INCOMPATIBLE_PARTNER_PROFILE_TASK_STATE"),
    DUPLICATE_CONNECTION_INVITATION("DUPLICATE_CONNECTION_INVITATION"),
    INCOMPATIBLE_CONNECTION_INVITATION_STATE("INCOMPATIBLE_CONNECTION_INVITATION_STATE"),
    INCOMPATIBLE_CONNECTION_INVITATION_RECEIVER("INCOMPATIBLE_CONNECTION_INVITATION_RECEIVER"),
    DUPLICATE_CONNECTION("DUPLICATE_CONNECTION"),
    INCOMPATIBLE_CONNECTION_STATE("INCOMPATIBLE_CONNECTION_STATE"),
    INCOMPATIBLE_CONNECTION_PREFERENCES_REVISION("INCOMPATIBLE_CONNECTION_PREFERENCES_REVISION"),
    ACCOUNT_ALREADY_VERIFIED("ACCOUNT_ALREADY_VERIFIED"),
    VERIFICATION_ALREADY_IN_PROGRESS("VERIFICATION_ALREADY_IN_PROGRESS"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ConflictExceptionReason> VALUE_MAP;
    private final String value;

    private ConflictExceptionReason(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ConflictExceptionReason fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ConflictExceptionReason> knownValues() {
        EnumSet<ConflictExceptionReason> knownValues = EnumSet.allOf(ConflictExceptionReason.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ConflictExceptionReason.class, ConflictExceptionReason::toString);
    }
}

