/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.partnercentralaccount.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.partnercentralaccount.model.AccessType;
import software.amazon.awssdk.services.partnercentralaccount.model.ParticipantIdentifierListCopier;
import software.amazon.awssdk.services.partnercentralaccount.model.PartnerCentralAccountResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetConnectionPreferencesResponse
extends PartnerCentralAccountResponse
implements ToCopyableBuilder<Builder, GetConnectionPreferencesResponse> {
    private static final SdkField<String> CATALOG_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Catalog").getter(GetConnectionPreferencesResponse.getter(GetConnectionPreferencesResponse::catalog)).setter(GetConnectionPreferencesResponse.setter(Builder::catalog)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Catalog").build()}).build();
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Arn").getter(GetConnectionPreferencesResponse.getter(GetConnectionPreferencesResponse::arn)).setter(GetConnectionPreferencesResponse.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()}).build();
    private static final SdkField<String> ACCESS_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AccessType").getter(GetConnectionPreferencesResponse.getter(GetConnectionPreferencesResponse::accessTypeAsString)).setter(GetConnectionPreferencesResponse.setter(Builder::accessType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccessType").build()}).build();
    private static final SdkField<List<String>> EXCLUDED_PARTICIPANT_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ExcludedParticipantIds").getter(GetConnectionPreferencesResponse.getter(GetConnectionPreferencesResponse::excludedParticipantIds)).setter(GetConnectionPreferencesResponse.setter(Builder::excludedParticipantIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExcludedParticipantIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("UpdatedAt").getter(GetConnectionPreferencesResponse.getter(GetConnectionPreferencesResponse::updatedAt)).setter(GetConnectionPreferencesResponse.setter(Builder::updatedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdatedAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<Long> REVISION_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("Revision").getter(GetConnectionPreferencesResponse.getter(GetConnectionPreferencesResponse::revision)).setter(GetConnectionPreferencesResponse.setter(Builder::revision)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Revision").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CATALOG_FIELD, ARN_FIELD, ACCESS_TYPE_FIELD, EXCLUDED_PARTICIPANT_IDS_FIELD, UPDATED_AT_FIELD, REVISION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetConnectionPreferencesResponse.memberNameToFieldInitializer();
    private final String catalog;
    private final String arn;
    private final String accessType;
    private final List<String> excludedParticipantIds;
    private final Instant updatedAt;
    private final Long revision;

    private GetConnectionPreferencesResponse(BuilderImpl builder) {
        super(builder);
        this.catalog = builder.catalog;
        this.arn = builder.arn;
        this.accessType = builder.accessType;
        this.excludedParticipantIds = builder.excludedParticipantIds;
        this.updatedAt = builder.updatedAt;
        this.revision = builder.revision;
    }

    public final String catalog() {
        return this.catalog;
    }

    public final String arn() {
        return this.arn;
    }

    public final AccessType accessType() {
        return AccessType.fromValue(this.accessType);
    }

    public final String accessTypeAsString() {
        return this.accessType;
    }

    public final boolean hasExcludedParticipantIds() {
        return this.excludedParticipantIds != null && !(this.excludedParticipantIds instanceof SdkAutoConstructList);
    }

    public final List<String> excludedParticipantIds() {
        return this.excludedParticipantIds;
    }

    public final Instant updatedAt() {
        return this.updatedAt;
    }

    public final Long revision() {
        return this.revision;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.catalog());
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.accessTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasExcludedParticipantIds() ? this.excludedParticipantIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.updatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.revision());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetConnectionPreferencesResponse)) {
            return false;
        }
        GetConnectionPreferencesResponse other = (GetConnectionPreferencesResponse)((Object)obj);
        return Objects.equals(this.catalog(), other.catalog()) && Objects.equals(this.arn(), other.arn()) && Objects.equals(this.accessTypeAsString(), other.accessTypeAsString()) && this.hasExcludedParticipantIds() == other.hasExcludedParticipantIds() && Objects.equals(this.excludedParticipantIds(), other.excludedParticipantIds()) && Objects.equals(this.updatedAt(), other.updatedAt()) && Objects.equals(this.revision(), other.revision());
    }

    public final String toString() {
        return ToString.builder((String)"GetConnectionPreferencesResponse").add("Catalog", (Object)this.catalog()).add("Arn", (Object)this.arn()).add("AccessType", (Object)this.accessTypeAsString()).add("ExcludedParticipantIds", this.hasExcludedParticipantIds() ? this.excludedParticipantIds() : null).add("UpdatedAt", (Object)this.updatedAt()).add("Revision", (Object)this.revision()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Catalog": {
                return Optional.ofNullable(clazz.cast(this.catalog()));
            }
            case "Arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "AccessType": {
                return Optional.ofNullable(clazz.cast(this.accessTypeAsString()));
            }
            case "ExcludedParticipantIds": {
                return Optional.ofNullable(clazz.cast(this.excludedParticipantIds()));
            }
            case "UpdatedAt": {
                return Optional.ofNullable(clazz.cast(this.updatedAt()));
            }
            case "Revision": {
                return Optional.ofNullable(clazz.cast(this.revision()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Catalog", CATALOG_FIELD);
        map.put("Arn", ARN_FIELD);
        map.put("AccessType", ACCESS_TYPE_FIELD);
        map.put("ExcludedParticipantIds", EXCLUDED_PARTICIPANT_IDS_FIELD);
        map.put("UpdatedAt", UPDATED_AT_FIELD);
        map.put("Revision", REVISION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetConnectionPreferencesResponse, T> g) {
        return obj -> g.apply((GetConnectionPreferencesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends PartnerCentralAccountResponse.BuilderImpl
    implements Builder {
        private String catalog;
        private String arn;
        private String accessType;
        private List<String> excludedParticipantIds = DefaultSdkAutoConstructList.getInstance();
        private Instant updatedAt;
        private Long revision;

        private BuilderImpl() {
        }

        private BuilderImpl(GetConnectionPreferencesResponse model) {
            super(model);
            this.catalog(model.catalog);
            this.arn(model.arn);
            this.accessType(model.accessType);
            this.excludedParticipantIds(model.excludedParticipantIds);
            this.updatedAt(model.updatedAt);
            this.revision(model.revision);
        }

        public final String getCatalog() {
            return this.catalog;
        }

        public final void setCatalog(String catalog) {
            this.catalog = catalog;
        }

        @Override
        public final Builder catalog(String catalog) {
            this.catalog = catalog;
            return this;
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getAccessType() {
            return this.accessType;
        }

        public final void setAccessType(String accessType) {
            this.accessType = accessType;
        }

        @Override
        public final Builder accessType(String accessType) {
            this.accessType = accessType;
            return this;
        }

        @Override
        public final Builder accessType(AccessType accessType) {
            this.accessType(accessType == null ? null : accessType.toString());
            return this;
        }

        public final Collection<String> getExcludedParticipantIds() {
            if (this.excludedParticipantIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.excludedParticipantIds;
        }

        public final void setExcludedParticipantIds(Collection<String> excludedParticipantIds) {
            this.excludedParticipantIds = ParticipantIdentifierListCopier.copy(excludedParticipantIds);
        }

        @Override
        public final Builder excludedParticipantIds(Collection<String> excludedParticipantIds) {
            this.excludedParticipantIds = ParticipantIdentifierListCopier.copy(excludedParticipantIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder excludedParticipantIds(String ... excludedParticipantIds) {
            this.excludedParticipantIds(Arrays.asList(excludedParticipantIds));
            return this;
        }

        public final Instant getUpdatedAt() {
            return this.updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public final Long getRevision() {
            return this.revision;
        }

        public final void setRevision(Long revision) {
            this.revision = revision;
        }

        @Override
        public final Builder revision(Long revision) {
            this.revision = revision;
            return this;
        }

        @Override
        public GetConnectionPreferencesResponse build() {
            return new GetConnectionPreferencesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends PartnerCentralAccountResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetConnectionPreferencesResponse> {
        public Builder catalog(String var1);

        public Builder arn(String var1);

        public Builder accessType(String var1);

        public Builder accessType(AccessType var1);

        public Builder excludedParticipantIds(Collection<String> var1);

        public Builder excludedParticipantIds(String ... var1);

        public Builder updatedAt(Instant var1);

        public Builder revision(Long var1);
    }
}

