/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.partnercentralaccount.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.partnercentralaccount.PartnerCentralAccountClient;
import software.amazon.awssdk.services.partnercentralaccount.internal.UserAgentUtils;
import software.amazon.awssdk.services.partnercentralaccount.model.ConnectionInvitationSummary;
import software.amazon.awssdk.services.partnercentralaccount.model.ListConnectionInvitationsRequest;
import software.amazon.awssdk.services.partnercentralaccount.model.ListConnectionInvitationsResponse;

public class ListConnectionInvitationsIterable
implements SdkIterable<ListConnectionInvitationsResponse> {
    private final PartnerCentralAccountClient client;
    private final ListConnectionInvitationsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListConnectionInvitationsIterable(PartnerCentralAccountClient client, ListConnectionInvitationsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListConnectionInvitationsResponseFetcher();
    }

    public Iterator<ListConnectionInvitationsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ConnectionInvitationSummary> connectionInvitationSummaries() {
        Function<ListConnectionInvitationsResponse, Iterator> getIterator = response -> {
            if (response != null && response.connectionInvitationSummaries() != null) {
                return response.connectionInvitationSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListConnectionInvitationsResponseFetcher
    implements SyncPageFetcher<ListConnectionInvitationsResponse> {
        private ListConnectionInvitationsResponseFetcher() {
        }

        public boolean hasNextPage(ListConnectionInvitationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListConnectionInvitationsResponse nextPage(ListConnectionInvitationsResponse previousPage) {
            if (previousPage == null) {
                return ListConnectionInvitationsIterable.this.client.listConnectionInvitations(ListConnectionInvitationsIterable.this.firstRequest);
            }
            return ListConnectionInvitationsIterable.this.client.listConnectionInvitations((ListConnectionInvitationsRequest)((Object)ListConnectionInvitationsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

