/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.panorama.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.panorama.model.PackageVersionStatus;
import software.amazon.awssdk.services.panorama.model.PanoramaResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribePackageVersionResponse
extends PanoramaResponse
implements ToCopyableBuilder<Builder, DescribePackageVersionResponse> {
    private static final SdkField<Boolean> IS_LATEST_PATCH_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("IsLatestPatch").getter(DescribePackageVersionResponse.getter(DescribePackageVersionResponse::isLatestPatch)).setter(DescribePackageVersionResponse.setter(Builder::isLatestPatch)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IsLatestPatch").build()}).build();
    private static final SdkField<String> OWNER_ACCOUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OwnerAccount").getter(DescribePackageVersionResponse.getter(DescribePackageVersionResponse::ownerAccount)).setter(DescribePackageVersionResponse.setter(Builder::ownerAccount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OwnerAccount").build()}).build();
    private static final SdkField<String> PACKAGE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PackageArn").getter(DescribePackageVersionResponse.getter(DescribePackageVersionResponse::packageArn)).setter(DescribePackageVersionResponse.setter(Builder::packageArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PackageArn").build()}).build();
    private static final SdkField<String> PACKAGE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PackageId").getter(DescribePackageVersionResponse.getter(DescribePackageVersionResponse::packageId)).setter(DescribePackageVersionResponse.setter(Builder::packageId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PackageId").build()}).build();
    private static final SdkField<String> PACKAGE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PackageName").getter(DescribePackageVersionResponse.getter(DescribePackageVersionResponse::packageName)).setter(DescribePackageVersionResponse.setter(Builder::packageName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PackageName").build()}).build();
    private static final SdkField<String> PACKAGE_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PackageVersion").getter(DescribePackageVersionResponse.getter(DescribePackageVersionResponse::packageVersion)).setter(DescribePackageVersionResponse.setter(Builder::packageVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PackageVersion").build()}).build();
    private static final SdkField<String> PATCH_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PatchVersion").getter(DescribePackageVersionResponse.getter(DescribePackageVersionResponse::patchVersion)).setter(DescribePackageVersionResponse.setter(Builder::patchVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PatchVersion").build()}).build();
    private static final SdkField<Instant> REGISTERED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("RegisteredTime").getter(DescribePackageVersionResponse.getter(DescribePackageVersionResponse::registeredTime)).setter(DescribePackageVersionResponse.setter(Builder::registeredTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RegisteredTime").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(DescribePackageVersionResponse.getter(DescribePackageVersionResponse::statusAsString)).setter(DescribePackageVersionResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<String> STATUS_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StatusDescription").getter(DescribePackageVersionResponse.getter(DescribePackageVersionResponse::statusDescription)).setter(DescribePackageVersionResponse.setter(Builder::statusDescription)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusDescription").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IS_LATEST_PATCH_FIELD, OWNER_ACCOUNT_FIELD, PACKAGE_ARN_FIELD, PACKAGE_ID_FIELD, PACKAGE_NAME_FIELD, PACKAGE_VERSION_FIELD, PATCH_VERSION_FIELD, REGISTERED_TIME_FIELD, STATUS_FIELD, STATUS_DESCRIPTION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribePackageVersionResponse.memberNameToFieldInitializer();
    private final Boolean isLatestPatch;
    private final String ownerAccount;
    private final String packageArn;
    private final String packageId;
    private final String packageName;
    private final String packageVersion;
    private final String patchVersion;
    private final Instant registeredTime;
    private final String status;
    private final String statusDescription;

    private DescribePackageVersionResponse(BuilderImpl builder) {
        super(builder);
        this.isLatestPatch = builder.isLatestPatch;
        this.ownerAccount = builder.ownerAccount;
        this.packageArn = builder.packageArn;
        this.packageId = builder.packageId;
        this.packageName = builder.packageName;
        this.packageVersion = builder.packageVersion;
        this.patchVersion = builder.patchVersion;
        this.registeredTime = builder.registeredTime;
        this.status = builder.status;
        this.statusDescription = builder.statusDescription;
    }

    public final Boolean isLatestPatch() {
        return this.isLatestPatch;
    }

    public final String ownerAccount() {
        return this.ownerAccount;
    }

    public final String packageArn() {
        return this.packageArn;
    }

    public final String packageId() {
        return this.packageId;
    }

    public final String packageName() {
        return this.packageName;
    }

    public final String packageVersion() {
        return this.packageVersion;
    }

    public final String patchVersion() {
        return this.patchVersion;
    }

    public final Instant registeredTime() {
        return this.registeredTime;
    }

    public final PackageVersionStatus status() {
        return PackageVersionStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String statusDescription() {
        return this.statusDescription;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.isLatestPatch());
        hashCode = 31 * hashCode + Objects.hashCode(this.ownerAccount());
        hashCode = 31 * hashCode + Objects.hashCode(this.packageArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.packageId());
        hashCode = 31 * hashCode + Objects.hashCode(this.packageName());
        hashCode = 31 * hashCode + Objects.hashCode(this.packageVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.patchVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.registeredTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusDescription());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribePackageVersionResponse)) {
            return false;
        }
        DescribePackageVersionResponse other = (DescribePackageVersionResponse)((Object)obj);
        return Objects.equals(this.isLatestPatch(), other.isLatestPatch()) && Objects.equals(this.ownerAccount(), other.ownerAccount()) && Objects.equals(this.packageArn(), other.packageArn()) && Objects.equals(this.packageId(), other.packageId()) && Objects.equals(this.packageName(), other.packageName()) && Objects.equals(this.packageVersion(), other.packageVersion()) && Objects.equals(this.patchVersion(), other.patchVersion()) && Objects.equals(this.registeredTime(), other.registeredTime()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.statusDescription(), other.statusDescription());
    }

    public final String toString() {
        return ToString.builder((String)"DescribePackageVersionResponse").add("IsLatestPatch", (Object)this.isLatestPatch()).add("OwnerAccount", (Object)this.ownerAccount()).add("PackageArn", (Object)this.packageArn()).add("PackageId", (Object)this.packageId()).add("PackageName", (Object)this.packageName()).add("PackageVersion", (Object)this.packageVersion()).add("PatchVersion", (Object)this.patchVersion()).add("RegisteredTime", (Object)this.registeredTime()).add("Status", (Object)this.statusAsString()).add("StatusDescription", (Object)this.statusDescription()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "IsLatestPatch": {
                return Optional.ofNullable(clazz.cast(this.isLatestPatch()));
            }
            case "OwnerAccount": {
                return Optional.ofNullable(clazz.cast(this.ownerAccount()));
            }
            case "PackageArn": {
                return Optional.ofNullable(clazz.cast(this.packageArn()));
            }
            case "PackageId": {
                return Optional.ofNullable(clazz.cast(this.packageId()));
            }
            case "PackageName": {
                return Optional.ofNullable(clazz.cast(this.packageName()));
            }
            case "PackageVersion": {
                return Optional.ofNullable(clazz.cast(this.packageVersion()));
            }
            case "PatchVersion": {
                return Optional.ofNullable(clazz.cast(this.patchVersion()));
            }
            case "RegisteredTime": {
                return Optional.ofNullable(clazz.cast(this.registeredTime()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "StatusDescription": {
                return Optional.ofNullable(clazz.cast(this.statusDescription()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("IsLatestPatch", IS_LATEST_PATCH_FIELD);
        map.put("OwnerAccount", OWNER_ACCOUNT_FIELD);
        map.put("PackageArn", PACKAGE_ARN_FIELD);
        map.put("PackageId", PACKAGE_ID_FIELD);
        map.put("PackageName", PACKAGE_NAME_FIELD);
        map.put("PackageVersion", PACKAGE_VERSION_FIELD);
        map.put("PatchVersion", PATCH_VERSION_FIELD);
        map.put("RegisteredTime", REGISTERED_TIME_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("StatusDescription", STATUS_DESCRIPTION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribePackageVersionResponse, T> g) {
        return obj -> g.apply((DescribePackageVersionResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends PanoramaResponse.BuilderImpl
    implements Builder {
        private Boolean isLatestPatch;
        private String ownerAccount;
        private String packageArn;
        private String packageId;
        private String packageName;
        private String packageVersion;
        private String patchVersion;
        private Instant registeredTime;
        private String status;
        private String statusDescription;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribePackageVersionResponse model) {
            super(model);
            this.isLatestPatch(model.isLatestPatch);
            this.ownerAccount(model.ownerAccount);
            this.packageArn(model.packageArn);
            this.packageId(model.packageId);
            this.packageName(model.packageName);
            this.packageVersion(model.packageVersion);
            this.patchVersion(model.patchVersion);
            this.registeredTime(model.registeredTime);
            this.status(model.status);
            this.statusDescription(model.statusDescription);
        }

        public final Boolean getIsLatestPatch() {
            return this.isLatestPatch;
        }

        public final void setIsLatestPatch(Boolean isLatestPatch) {
            this.isLatestPatch = isLatestPatch;
        }

        @Override
        public final Builder isLatestPatch(Boolean isLatestPatch) {
            this.isLatestPatch = isLatestPatch;
            return this;
        }

        public final String getOwnerAccount() {
            return this.ownerAccount;
        }

        public final void setOwnerAccount(String ownerAccount) {
            this.ownerAccount = ownerAccount;
        }

        @Override
        public final Builder ownerAccount(String ownerAccount) {
            this.ownerAccount = ownerAccount;
            return this;
        }

        public final String getPackageArn() {
            return this.packageArn;
        }

        public final void setPackageArn(String packageArn) {
            this.packageArn = packageArn;
        }

        @Override
        public final Builder packageArn(String packageArn) {
            this.packageArn = packageArn;
            return this;
        }

        public final String getPackageId() {
            return this.packageId;
        }

        public final void setPackageId(String packageId) {
            this.packageId = packageId;
        }

        @Override
        public final Builder packageId(String packageId) {
            this.packageId = packageId;
            return this;
        }

        public final String getPackageName() {
            return this.packageName;
        }

        public final void setPackageName(String packageName) {
            this.packageName = packageName;
        }

        @Override
        public final Builder packageName(String packageName) {
            this.packageName = packageName;
            return this;
        }

        public final String getPackageVersion() {
            return this.packageVersion;
        }

        public final void setPackageVersion(String packageVersion) {
            this.packageVersion = packageVersion;
        }

        @Override
        public final Builder packageVersion(String packageVersion) {
            this.packageVersion = packageVersion;
            return this;
        }

        public final String getPatchVersion() {
            return this.patchVersion;
        }

        public final void setPatchVersion(String patchVersion) {
            this.patchVersion = patchVersion;
        }

        @Override
        public final Builder patchVersion(String patchVersion) {
            this.patchVersion = patchVersion;
            return this;
        }

        public final Instant getRegisteredTime() {
            return this.registeredTime;
        }

        public final void setRegisteredTime(Instant registeredTime) {
            this.registeredTime = registeredTime;
        }

        @Override
        public final Builder registeredTime(Instant registeredTime) {
            this.registeredTime = registeredTime;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(PackageVersionStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getStatusDescription() {
            return this.statusDescription;
        }

        public final void setStatusDescription(String statusDescription) {
            this.statusDescription = statusDescription;
        }

        @Override
        public final Builder statusDescription(String statusDescription) {
            this.statusDescription = statusDescription;
            return this;
        }

        @Override
        public DescribePackageVersionResponse build() {
            return new DescribePackageVersionResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends PanoramaResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribePackageVersionResponse> {
        public Builder isLatestPatch(Boolean var1);

        public Builder ownerAccount(String var1);

        public Builder packageArn(String var1);

        public Builder packageId(String var1);

        public Builder packageName(String var1);

        public Builder packageVersion(String var1);

        public Builder patchVersion(String var1);

        public Builder registeredTime(Instant var1);

        public Builder status(String var1);

        public Builder status(PackageVersionStatus var1);

        public Builder statusDescription(String var1);
    }
}

