/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.panorama.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.panorama.model.AlternateSoftwareMetadata;
import software.amazon.awssdk.services.panorama.model.AlternateSoftwaresCopier;
import software.amazon.awssdk.services.panorama.model.DeviceAggregatedStatus;
import software.amazon.awssdk.services.panorama.model.DeviceBrand;
import software.amazon.awssdk.services.panorama.model.DeviceConnectionStatus;
import software.amazon.awssdk.services.panorama.model.DeviceStatus;
import software.amazon.awssdk.services.panorama.model.DeviceType;
import software.amazon.awssdk.services.panorama.model.LatestDeviceJob;
import software.amazon.awssdk.services.panorama.model.NetworkPayload;
import software.amazon.awssdk.services.panorama.model.NetworkStatus;
import software.amazon.awssdk.services.panorama.model.PanoramaResponse;
import software.amazon.awssdk.services.panorama.model.TagMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeDeviceResponse
extends PanoramaResponse
implements ToCopyableBuilder<Builder, DescribeDeviceResponse> {
    private static final SdkField<List<AlternateSoftwareMetadata>> ALTERNATE_SOFTWARES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AlternateSoftwares").getter(DescribeDeviceResponse.getter(DescribeDeviceResponse::alternateSoftwares)).setter(DescribeDeviceResponse.setter(Builder::alternateSoftwares)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AlternateSoftwares").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AlternateSoftwareMetadata::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Arn").getter(DescribeDeviceResponse.getter(DescribeDeviceResponse::arn)).setter(DescribeDeviceResponse.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()}).build();
    private static final SdkField<String> BRAND_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Brand").getter(DescribeDeviceResponse.getter(DescribeDeviceResponse::brandAsString)).setter(DescribeDeviceResponse.setter(Builder::brand)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Brand").build()}).build();
    private static final SdkField<Instant> CREATED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreatedTime").getter(DescribeDeviceResponse.getter(DescribeDeviceResponse::createdTime)).setter(DescribeDeviceResponse.setter(Builder::createdTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedTime").build()}).build();
    private static final SdkField<NetworkStatus> CURRENT_NETWORKING_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("CurrentNetworkingStatus").getter(DescribeDeviceResponse.getter(DescribeDeviceResponse::currentNetworkingStatus)).setter(DescribeDeviceResponse.setter(Builder::currentNetworkingStatus)).constructor(NetworkStatus::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CurrentNetworkingStatus").build()}).build();
    private static final SdkField<String> CURRENT_SOFTWARE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CurrentSoftware").getter(DescribeDeviceResponse.getter(DescribeDeviceResponse::currentSoftware)).setter(DescribeDeviceResponse.setter(Builder::currentSoftware)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CurrentSoftware").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(DescribeDeviceResponse.getter(DescribeDeviceResponse::description)).setter(DescribeDeviceResponse.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<String> DEVICE_AGGREGATED_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DeviceAggregatedStatus").getter(DescribeDeviceResponse.getter(DescribeDeviceResponse::deviceAggregatedStatusAsString)).setter(DescribeDeviceResponse.setter(Builder::deviceAggregatedStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeviceAggregatedStatus").build()}).build();
    private static final SdkField<String> DEVICE_CONNECTION_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DeviceConnectionStatus").getter(DescribeDeviceResponse.getter(DescribeDeviceResponse::deviceConnectionStatusAsString)).setter(DescribeDeviceResponse.setter(Builder::deviceConnectionStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeviceConnectionStatus").build()}).build();
    private static final SdkField<String> DEVICE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DeviceId").getter(DescribeDeviceResponse.getter(DescribeDeviceResponse::deviceId)).setter(DescribeDeviceResponse.setter(Builder::deviceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeviceId").build()}).build();
    private static final SdkField<String> LATEST_ALTERNATE_SOFTWARE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LatestAlternateSoftware").getter(DescribeDeviceResponse.getter(DescribeDeviceResponse::latestAlternateSoftware)).setter(DescribeDeviceResponse.setter(Builder::latestAlternateSoftware)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LatestAlternateSoftware").build()}).build();
    private static final SdkField<LatestDeviceJob> LATEST_DEVICE_JOB_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("LatestDeviceJob").getter(DescribeDeviceResponse.getter(DescribeDeviceResponse::latestDeviceJob)).setter(DescribeDeviceResponse.setter(Builder::latestDeviceJob)).constructor(LatestDeviceJob::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LatestDeviceJob").build()}).build();
    private static final SdkField<String> LATEST_SOFTWARE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LatestSoftware").getter(DescribeDeviceResponse.getter(DescribeDeviceResponse::latestSoftware)).setter(DescribeDeviceResponse.setter(Builder::latestSoftware)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LatestSoftware").build()}).build();
    private static final SdkField<Instant> LEASE_EXPIRATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LeaseExpirationTime").getter(DescribeDeviceResponse.getter(DescribeDeviceResponse::leaseExpirationTime)).setter(DescribeDeviceResponse.setter(Builder::leaseExpirationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LeaseExpirationTime").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(DescribeDeviceResponse.getter(DescribeDeviceResponse::name)).setter(DescribeDeviceResponse.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<NetworkPayload> NETWORKING_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("NetworkingConfiguration").getter(DescribeDeviceResponse.getter(DescribeDeviceResponse::networkingConfiguration)).setter(DescribeDeviceResponse.setter(Builder::networkingConfiguration)).constructor(NetworkPayload::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkingConfiguration").build()}).build();
    private static final SdkField<String> PROVISIONING_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ProvisioningStatus").getter(DescribeDeviceResponse.getter(DescribeDeviceResponse::provisioningStatusAsString)).setter(DescribeDeviceResponse.setter(Builder::provisioningStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProvisioningStatus").build()}).build();
    private static final SdkField<String> SERIAL_NUMBER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SerialNumber").getter(DescribeDeviceResponse.getter(DescribeDeviceResponse::serialNumber)).setter(DescribeDeviceResponse.setter(Builder::serialNumber)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SerialNumber").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Tags").getter(DescribeDeviceResponse.getter(DescribeDeviceResponse::tags)).setter(DescribeDeviceResponse.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Type").getter(DescribeDeviceResponse.getter(DescribeDeviceResponse::typeAsString)).setter(DescribeDeviceResponse.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ALTERNATE_SOFTWARES_FIELD, ARN_FIELD, BRAND_FIELD, CREATED_TIME_FIELD, CURRENT_NETWORKING_STATUS_FIELD, CURRENT_SOFTWARE_FIELD, DESCRIPTION_FIELD, DEVICE_AGGREGATED_STATUS_FIELD, DEVICE_CONNECTION_STATUS_FIELD, DEVICE_ID_FIELD, LATEST_ALTERNATE_SOFTWARE_FIELD, LATEST_DEVICE_JOB_FIELD, LATEST_SOFTWARE_FIELD, LEASE_EXPIRATION_TIME_FIELD, NAME_FIELD, NETWORKING_CONFIGURATION_FIELD, PROVISIONING_STATUS_FIELD, SERIAL_NUMBER_FIELD, TAGS_FIELD, TYPE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeDeviceResponse.memberNameToFieldInitializer();
    private final List<AlternateSoftwareMetadata> alternateSoftwares;
    private final String arn;
    private final String brand;
    private final Instant createdTime;
    private final NetworkStatus currentNetworkingStatus;
    private final String currentSoftware;
    private final String description;
    private final String deviceAggregatedStatus;
    private final String deviceConnectionStatus;
    private final String deviceId;
    private final String latestAlternateSoftware;
    private final LatestDeviceJob latestDeviceJob;
    private final String latestSoftware;
    private final Instant leaseExpirationTime;
    private final String name;
    private final NetworkPayload networkingConfiguration;
    private final String provisioningStatus;
    private final String serialNumber;
    private final Map<String, String> tags;
    private final String type;

    private DescribeDeviceResponse(BuilderImpl builder) {
        super(builder);
        this.alternateSoftwares = builder.alternateSoftwares;
        this.arn = builder.arn;
        this.brand = builder.brand;
        this.createdTime = builder.createdTime;
        this.currentNetworkingStatus = builder.currentNetworkingStatus;
        this.currentSoftware = builder.currentSoftware;
        this.description = builder.description;
        this.deviceAggregatedStatus = builder.deviceAggregatedStatus;
        this.deviceConnectionStatus = builder.deviceConnectionStatus;
        this.deviceId = builder.deviceId;
        this.latestAlternateSoftware = builder.latestAlternateSoftware;
        this.latestDeviceJob = builder.latestDeviceJob;
        this.latestSoftware = builder.latestSoftware;
        this.leaseExpirationTime = builder.leaseExpirationTime;
        this.name = builder.name;
        this.networkingConfiguration = builder.networkingConfiguration;
        this.provisioningStatus = builder.provisioningStatus;
        this.serialNumber = builder.serialNumber;
        this.tags = builder.tags;
        this.type = builder.type;
    }

    public final boolean hasAlternateSoftwares() {
        return this.alternateSoftwares != null && !(this.alternateSoftwares instanceof SdkAutoConstructList);
    }

    public final List<AlternateSoftwareMetadata> alternateSoftwares() {
        return this.alternateSoftwares;
    }

    public final String arn() {
        return this.arn;
    }

    public final DeviceBrand brand() {
        return DeviceBrand.fromValue(this.brand);
    }

    public final String brandAsString() {
        return this.brand;
    }

    public final Instant createdTime() {
        return this.createdTime;
    }

    public final NetworkStatus currentNetworkingStatus() {
        return this.currentNetworkingStatus;
    }

    public final String currentSoftware() {
        return this.currentSoftware;
    }

    public final String description() {
        return this.description;
    }

    public final DeviceAggregatedStatus deviceAggregatedStatus() {
        return DeviceAggregatedStatus.fromValue(this.deviceAggregatedStatus);
    }

    public final String deviceAggregatedStatusAsString() {
        return this.deviceAggregatedStatus;
    }

    public final DeviceConnectionStatus deviceConnectionStatus() {
        return DeviceConnectionStatus.fromValue(this.deviceConnectionStatus);
    }

    public final String deviceConnectionStatusAsString() {
        return this.deviceConnectionStatus;
    }

    public final String deviceId() {
        return this.deviceId;
    }

    public final String latestAlternateSoftware() {
        return this.latestAlternateSoftware;
    }

    public final LatestDeviceJob latestDeviceJob() {
        return this.latestDeviceJob;
    }

    public final String latestSoftware() {
        return this.latestSoftware;
    }

    public final Instant leaseExpirationTime() {
        return this.leaseExpirationTime;
    }

    public final String name() {
        return this.name;
    }

    public final NetworkPayload networkingConfiguration() {
        return this.networkingConfiguration;
    }

    public final DeviceStatus provisioningStatus() {
        return DeviceStatus.fromValue(this.provisioningStatus);
    }

    public final String provisioningStatusAsString() {
        return this.provisioningStatus;
    }

    public final String serialNumber() {
        return this.serialNumber;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public final DeviceType type() {
        return DeviceType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAlternateSoftwares() ? this.alternateSoftwares() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.brandAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.currentNetworkingStatus());
        hashCode = 31 * hashCode + Objects.hashCode(this.currentSoftware());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.deviceAggregatedStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.deviceConnectionStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.deviceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.latestAlternateSoftware());
        hashCode = 31 * hashCode + Objects.hashCode(this.latestDeviceJob());
        hashCode = 31 * hashCode + Objects.hashCode(this.latestSoftware());
        hashCode = 31 * hashCode + Objects.hashCode(this.leaseExpirationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.networkingConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.provisioningStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.serialNumber());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeDeviceResponse)) {
            return false;
        }
        DescribeDeviceResponse other = (DescribeDeviceResponse)((Object)obj);
        return this.hasAlternateSoftwares() == other.hasAlternateSoftwares() && Objects.equals(this.alternateSoftwares(), other.alternateSoftwares()) && Objects.equals(this.arn(), other.arn()) && Objects.equals(this.brandAsString(), other.brandAsString()) && Objects.equals(this.createdTime(), other.createdTime()) && Objects.equals(this.currentNetworkingStatus(), other.currentNetworkingStatus()) && Objects.equals(this.currentSoftware(), other.currentSoftware()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.deviceAggregatedStatusAsString(), other.deviceAggregatedStatusAsString()) && Objects.equals(this.deviceConnectionStatusAsString(), other.deviceConnectionStatusAsString()) && Objects.equals(this.deviceId(), other.deviceId()) && Objects.equals(this.latestAlternateSoftware(), other.latestAlternateSoftware()) && Objects.equals(this.latestDeviceJob(), other.latestDeviceJob()) && Objects.equals(this.latestSoftware(), other.latestSoftware()) && Objects.equals(this.leaseExpirationTime(), other.leaseExpirationTime()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.networkingConfiguration(), other.networkingConfiguration()) && Objects.equals(this.provisioningStatusAsString(), other.provisioningStatusAsString()) && Objects.equals(this.serialNumber(), other.serialNumber()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.typeAsString(), other.typeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeDeviceResponse").add("AlternateSoftwares", this.hasAlternateSoftwares() ? this.alternateSoftwares() : null).add("Arn", (Object)this.arn()).add("Brand", (Object)this.brandAsString()).add("CreatedTime", (Object)this.createdTime()).add("CurrentNetworkingStatus", (Object)this.currentNetworkingStatus()).add("CurrentSoftware", (Object)this.currentSoftware()).add("Description", (Object)this.description()).add("DeviceAggregatedStatus", (Object)this.deviceAggregatedStatusAsString()).add("DeviceConnectionStatus", (Object)this.deviceConnectionStatusAsString()).add("DeviceId", (Object)this.deviceId()).add("LatestAlternateSoftware", (Object)this.latestAlternateSoftware()).add("LatestDeviceJob", (Object)this.latestDeviceJob()).add("LatestSoftware", (Object)this.latestSoftware()).add("LeaseExpirationTime", (Object)this.leaseExpirationTime()).add("Name", (Object)this.name()).add("NetworkingConfiguration", (Object)this.networkingConfiguration()).add("ProvisioningStatus", (Object)this.provisioningStatusAsString()).add("SerialNumber", (Object)this.serialNumber()).add("Tags", this.hasTags() ? this.tags() : null).add("Type", (Object)this.typeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AlternateSoftwares": {
                return Optional.ofNullable(clazz.cast(this.alternateSoftwares()));
            }
            case "Arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "Brand": {
                return Optional.ofNullable(clazz.cast(this.brandAsString()));
            }
            case "CreatedTime": {
                return Optional.ofNullable(clazz.cast(this.createdTime()));
            }
            case "CurrentNetworkingStatus": {
                return Optional.ofNullable(clazz.cast(this.currentNetworkingStatus()));
            }
            case "CurrentSoftware": {
                return Optional.ofNullable(clazz.cast(this.currentSoftware()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "DeviceAggregatedStatus": {
                return Optional.ofNullable(clazz.cast(this.deviceAggregatedStatusAsString()));
            }
            case "DeviceConnectionStatus": {
                return Optional.ofNullable(clazz.cast(this.deviceConnectionStatusAsString()));
            }
            case "DeviceId": {
                return Optional.ofNullable(clazz.cast(this.deviceId()));
            }
            case "LatestAlternateSoftware": {
                return Optional.ofNullable(clazz.cast(this.latestAlternateSoftware()));
            }
            case "LatestDeviceJob": {
                return Optional.ofNullable(clazz.cast(this.latestDeviceJob()));
            }
            case "LatestSoftware": {
                return Optional.ofNullable(clazz.cast(this.latestSoftware()));
            }
            case "LeaseExpirationTime": {
                return Optional.ofNullable(clazz.cast(this.leaseExpirationTime()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "NetworkingConfiguration": {
                return Optional.ofNullable(clazz.cast(this.networkingConfiguration()));
            }
            case "ProvisioningStatus": {
                return Optional.ofNullable(clazz.cast(this.provisioningStatusAsString()));
            }
            case "SerialNumber": {
                return Optional.ofNullable(clazz.cast(this.serialNumber()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("AlternateSoftwares", ALTERNATE_SOFTWARES_FIELD);
        map.put("Arn", ARN_FIELD);
        map.put("Brand", BRAND_FIELD);
        map.put("CreatedTime", CREATED_TIME_FIELD);
        map.put("CurrentNetworkingStatus", CURRENT_NETWORKING_STATUS_FIELD);
        map.put("CurrentSoftware", CURRENT_SOFTWARE_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("DeviceAggregatedStatus", DEVICE_AGGREGATED_STATUS_FIELD);
        map.put("DeviceConnectionStatus", DEVICE_CONNECTION_STATUS_FIELD);
        map.put("DeviceId", DEVICE_ID_FIELD);
        map.put("LatestAlternateSoftware", LATEST_ALTERNATE_SOFTWARE_FIELD);
        map.put("LatestDeviceJob", LATEST_DEVICE_JOB_FIELD);
        map.put("LatestSoftware", LATEST_SOFTWARE_FIELD);
        map.put("LeaseExpirationTime", LEASE_EXPIRATION_TIME_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("NetworkingConfiguration", NETWORKING_CONFIGURATION_FIELD);
        map.put("ProvisioningStatus", PROVISIONING_STATUS_FIELD);
        map.put("SerialNumber", SERIAL_NUMBER_FIELD);
        map.put("Tags", TAGS_FIELD);
        map.put("Type", TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeDeviceResponse, T> g) {
        return obj -> g.apply((DescribeDeviceResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends PanoramaResponse.BuilderImpl
    implements Builder {
        private List<AlternateSoftwareMetadata> alternateSoftwares = DefaultSdkAutoConstructList.getInstance();
        private String arn;
        private String brand;
        private Instant createdTime;
        private NetworkStatus currentNetworkingStatus;
        private String currentSoftware;
        private String description;
        private String deviceAggregatedStatus;
        private String deviceConnectionStatus;
        private String deviceId;
        private String latestAlternateSoftware;
        private LatestDeviceJob latestDeviceJob;
        private String latestSoftware;
        private Instant leaseExpirationTime;
        private String name;
        private NetworkPayload networkingConfiguration;
        private String provisioningStatus;
        private String serialNumber;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();
        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeDeviceResponse model) {
            super(model);
            this.alternateSoftwares(model.alternateSoftwares);
            this.arn(model.arn);
            this.brand(model.brand);
            this.createdTime(model.createdTime);
            this.currentNetworkingStatus(model.currentNetworkingStatus);
            this.currentSoftware(model.currentSoftware);
            this.description(model.description);
            this.deviceAggregatedStatus(model.deviceAggregatedStatus);
            this.deviceConnectionStatus(model.deviceConnectionStatus);
            this.deviceId(model.deviceId);
            this.latestAlternateSoftware(model.latestAlternateSoftware);
            this.latestDeviceJob(model.latestDeviceJob);
            this.latestSoftware(model.latestSoftware);
            this.leaseExpirationTime(model.leaseExpirationTime);
            this.name(model.name);
            this.networkingConfiguration(model.networkingConfiguration);
            this.provisioningStatus(model.provisioningStatus);
            this.serialNumber(model.serialNumber);
            this.tags(model.tags);
            this.type(model.type);
        }

        public final List<AlternateSoftwareMetadata.Builder> getAlternateSoftwares() {
            List<AlternateSoftwareMetadata.Builder> result = AlternateSoftwaresCopier.copyToBuilder(this.alternateSoftwares);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAlternateSoftwares(Collection<AlternateSoftwareMetadata.BuilderImpl> alternateSoftwares) {
            this.alternateSoftwares = AlternateSoftwaresCopier.copyFromBuilder(alternateSoftwares);
        }

        @Override
        public final Builder alternateSoftwares(Collection<AlternateSoftwareMetadata> alternateSoftwares) {
            this.alternateSoftwares = AlternateSoftwaresCopier.copy(alternateSoftwares);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder alternateSoftwares(AlternateSoftwareMetadata ... alternateSoftwares) {
            this.alternateSoftwares(Arrays.asList(alternateSoftwares));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder alternateSoftwares(Consumer<AlternateSoftwareMetadata.Builder> ... alternateSoftwares) {
            this.alternateSoftwares(Stream.of(alternateSoftwares).map(c -> (AlternateSoftwareMetadata)((AlternateSoftwareMetadata.Builder)AlternateSoftwareMetadata.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getBrand() {
            return this.brand;
        }

        public final void setBrand(String brand) {
            this.brand = brand;
        }

        @Override
        public final Builder brand(String brand) {
            this.brand = brand;
            return this;
        }

        @Override
        public final Builder brand(DeviceBrand brand) {
            this.brand(brand == null ? null : brand.toString());
            return this;
        }

        public final Instant getCreatedTime() {
            return this.createdTime;
        }

        public final void setCreatedTime(Instant createdTime) {
            this.createdTime = createdTime;
        }

        @Override
        public final Builder createdTime(Instant createdTime) {
            this.createdTime = createdTime;
            return this;
        }

        public final NetworkStatus.Builder getCurrentNetworkingStatus() {
            return this.currentNetworkingStatus != null ? this.currentNetworkingStatus.toBuilder() : null;
        }

        public final void setCurrentNetworkingStatus(NetworkStatus.BuilderImpl currentNetworkingStatus) {
            this.currentNetworkingStatus = currentNetworkingStatus != null ? currentNetworkingStatus.build() : null;
        }

        @Override
        public final Builder currentNetworkingStatus(NetworkStatus currentNetworkingStatus) {
            this.currentNetworkingStatus = currentNetworkingStatus;
            return this;
        }

        public final String getCurrentSoftware() {
            return this.currentSoftware;
        }

        public final void setCurrentSoftware(String currentSoftware) {
            this.currentSoftware = currentSoftware;
        }

        @Override
        public final Builder currentSoftware(String currentSoftware) {
            this.currentSoftware = currentSoftware;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getDeviceAggregatedStatus() {
            return this.deviceAggregatedStatus;
        }

        public final void setDeviceAggregatedStatus(String deviceAggregatedStatus) {
            this.deviceAggregatedStatus = deviceAggregatedStatus;
        }

        @Override
        public final Builder deviceAggregatedStatus(String deviceAggregatedStatus) {
            this.deviceAggregatedStatus = deviceAggregatedStatus;
            return this;
        }

        @Override
        public final Builder deviceAggregatedStatus(DeviceAggregatedStatus deviceAggregatedStatus) {
            this.deviceAggregatedStatus(deviceAggregatedStatus == null ? null : deviceAggregatedStatus.toString());
            return this;
        }

        public final String getDeviceConnectionStatus() {
            return this.deviceConnectionStatus;
        }

        public final void setDeviceConnectionStatus(String deviceConnectionStatus) {
            this.deviceConnectionStatus = deviceConnectionStatus;
        }

        @Override
        public final Builder deviceConnectionStatus(String deviceConnectionStatus) {
            this.deviceConnectionStatus = deviceConnectionStatus;
            return this;
        }

        @Override
        public final Builder deviceConnectionStatus(DeviceConnectionStatus deviceConnectionStatus) {
            this.deviceConnectionStatus(deviceConnectionStatus == null ? null : deviceConnectionStatus.toString());
            return this;
        }

        public final String getDeviceId() {
            return this.deviceId;
        }

        public final void setDeviceId(String deviceId) {
            this.deviceId = deviceId;
        }

        @Override
        public final Builder deviceId(String deviceId) {
            this.deviceId = deviceId;
            return this;
        }

        public final String getLatestAlternateSoftware() {
            return this.latestAlternateSoftware;
        }

        public final void setLatestAlternateSoftware(String latestAlternateSoftware) {
            this.latestAlternateSoftware = latestAlternateSoftware;
        }

        @Override
        public final Builder latestAlternateSoftware(String latestAlternateSoftware) {
            this.latestAlternateSoftware = latestAlternateSoftware;
            return this;
        }

        public final LatestDeviceJob.Builder getLatestDeviceJob() {
            return this.latestDeviceJob != null ? this.latestDeviceJob.toBuilder() : null;
        }

        public final void setLatestDeviceJob(LatestDeviceJob.BuilderImpl latestDeviceJob) {
            this.latestDeviceJob = latestDeviceJob != null ? latestDeviceJob.build() : null;
        }

        @Override
        public final Builder latestDeviceJob(LatestDeviceJob latestDeviceJob) {
            this.latestDeviceJob = latestDeviceJob;
            return this;
        }

        public final String getLatestSoftware() {
            return this.latestSoftware;
        }

        public final void setLatestSoftware(String latestSoftware) {
            this.latestSoftware = latestSoftware;
        }

        @Override
        public final Builder latestSoftware(String latestSoftware) {
            this.latestSoftware = latestSoftware;
            return this;
        }

        public final Instant getLeaseExpirationTime() {
            return this.leaseExpirationTime;
        }

        public final void setLeaseExpirationTime(Instant leaseExpirationTime) {
            this.leaseExpirationTime = leaseExpirationTime;
        }

        @Override
        public final Builder leaseExpirationTime(Instant leaseExpirationTime) {
            this.leaseExpirationTime = leaseExpirationTime;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final NetworkPayload.Builder getNetworkingConfiguration() {
            return this.networkingConfiguration != null ? this.networkingConfiguration.toBuilder() : null;
        }

        public final void setNetworkingConfiguration(NetworkPayload.BuilderImpl networkingConfiguration) {
            this.networkingConfiguration = networkingConfiguration != null ? networkingConfiguration.build() : null;
        }

        @Override
        public final Builder networkingConfiguration(NetworkPayload networkingConfiguration) {
            this.networkingConfiguration = networkingConfiguration;
            return this;
        }

        public final String getProvisioningStatus() {
            return this.provisioningStatus;
        }

        public final void setProvisioningStatus(String provisioningStatus) {
            this.provisioningStatus = provisioningStatus;
        }

        @Override
        public final Builder provisioningStatus(String provisioningStatus) {
            this.provisioningStatus = provisioningStatus;
            return this;
        }

        @Override
        public final Builder provisioningStatus(DeviceStatus provisioningStatus) {
            this.provisioningStatus(provisioningStatus == null ? null : provisioningStatus.toString());
            return this;
        }

        public final String getSerialNumber() {
            return this.serialNumber;
        }

        public final void setSerialNumber(String serialNumber) {
            this.serialNumber = serialNumber;
        }

        @Override
        public final Builder serialNumber(String serialNumber) {
            this.serialNumber = serialNumber;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(DeviceType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        @Override
        public DescribeDeviceResponse build() {
            return new DescribeDeviceResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends PanoramaResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeDeviceResponse> {
        public Builder alternateSoftwares(Collection<AlternateSoftwareMetadata> var1);

        public Builder alternateSoftwares(AlternateSoftwareMetadata ... var1);

        public Builder alternateSoftwares(Consumer<AlternateSoftwareMetadata.Builder> ... var1);

        public Builder arn(String var1);

        public Builder brand(String var1);

        public Builder brand(DeviceBrand var1);

        public Builder createdTime(Instant var1);

        public Builder currentNetworkingStatus(NetworkStatus var1);

        default public Builder currentNetworkingStatus(Consumer<NetworkStatus.Builder> currentNetworkingStatus) {
            return this.currentNetworkingStatus((NetworkStatus)((NetworkStatus.Builder)NetworkStatus.builder().applyMutation(currentNetworkingStatus)).build());
        }

        public Builder currentSoftware(String var1);

        public Builder description(String var1);

        public Builder deviceAggregatedStatus(String var1);

        public Builder deviceAggregatedStatus(DeviceAggregatedStatus var1);

        public Builder deviceConnectionStatus(String var1);

        public Builder deviceConnectionStatus(DeviceConnectionStatus var1);

        public Builder deviceId(String var1);

        public Builder latestAlternateSoftware(String var1);

        public Builder latestDeviceJob(LatestDeviceJob var1);

        default public Builder latestDeviceJob(Consumer<LatestDeviceJob.Builder> latestDeviceJob) {
            return this.latestDeviceJob((LatestDeviceJob)((LatestDeviceJob.Builder)LatestDeviceJob.builder().applyMutation(latestDeviceJob)).build());
        }

        public Builder latestSoftware(String var1);

        public Builder leaseExpirationTime(Instant var1);

        public Builder name(String var1);

        public Builder networkingConfiguration(NetworkPayload var1);

        default public Builder networkingConfiguration(Consumer<NetworkPayload.Builder> networkingConfiguration) {
            return this.networkingConfiguration((NetworkPayload)((NetworkPayload.Builder)NetworkPayload.builder().applyMutation(networkingConfiguration)).build());
        }

        public Builder provisioningStatus(String var1);

        public Builder provisioningStatus(DeviceStatus var1);

        public Builder serialNumber(String var1);

        public Builder tags(Map<String, String> var1);

        public Builder type(String var1);

        public Builder type(DeviceType var1);
    }
}

