/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.panorama.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.panorama.model.ManifestOverridesPayload;
import software.amazon.awssdk.services.panorama.model.ManifestPayload;
import software.amazon.awssdk.services.panorama.model.PanoramaRequest;
import software.amazon.awssdk.services.panorama.model.TagMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateApplicationInstanceRequest
extends PanoramaRequest
implements ToCopyableBuilder<Builder, CreateApplicationInstanceRequest> {
    private static final SdkField<String> APPLICATION_INSTANCE_ID_TO_REPLACE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ApplicationInstanceIdToReplace").getter(CreateApplicationInstanceRequest.getter(CreateApplicationInstanceRequest::applicationInstanceIdToReplace)).setter(CreateApplicationInstanceRequest.setter(Builder::applicationInstanceIdToReplace)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationInstanceIdToReplace").build()}).build();
    private static final SdkField<String> DEFAULT_RUNTIME_CONTEXT_DEVICE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DefaultRuntimeContextDevice").getter(CreateApplicationInstanceRequest.getter(CreateApplicationInstanceRequest::defaultRuntimeContextDevice)).setter(CreateApplicationInstanceRequest.setter(Builder::defaultRuntimeContextDevice)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultRuntimeContextDevice").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(CreateApplicationInstanceRequest.getter(CreateApplicationInstanceRequest::description)).setter(CreateApplicationInstanceRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<ManifestOverridesPayload> MANIFEST_OVERRIDES_PAYLOAD_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ManifestOverridesPayload").getter(CreateApplicationInstanceRequest.getter(CreateApplicationInstanceRequest::manifestOverridesPayload)).setter(CreateApplicationInstanceRequest.setter(Builder::manifestOverridesPayload)).constructor(ManifestOverridesPayload::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ManifestOverridesPayload").build()}).build();
    private static final SdkField<ManifestPayload> MANIFEST_PAYLOAD_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ManifestPayload").getter(CreateApplicationInstanceRequest.getter(CreateApplicationInstanceRequest::manifestPayload)).setter(CreateApplicationInstanceRequest.setter(Builder::manifestPayload)).constructor(ManifestPayload::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ManifestPayload").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(CreateApplicationInstanceRequest.getter(CreateApplicationInstanceRequest::name)).setter(CreateApplicationInstanceRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> RUNTIME_ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RuntimeRoleArn").getter(CreateApplicationInstanceRequest.getter(CreateApplicationInstanceRequest::runtimeRoleArn)).setter(CreateApplicationInstanceRequest.setter(Builder::runtimeRoleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuntimeRoleArn").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Tags").getter(CreateApplicationInstanceRequest.getter(CreateApplicationInstanceRequest::tags)).setter(CreateApplicationInstanceRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_INSTANCE_ID_TO_REPLACE_FIELD, DEFAULT_RUNTIME_CONTEXT_DEVICE_FIELD, DESCRIPTION_FIELD, MANIFEST_OVERRIDES_PAYLOAD_FIELD, MANIFEST_PAYLOAD_FIELD, NAME_FIELD, RUNTIME_ROLE_ARN_FIELD, TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateApplicationInstanceRequest.memberNameToFieldInitializer();
    private final String applicationInstanceIdToReplace;
    private final String defaultRuntimeContextDevice;
    private final String description;
    private final ManifestOverridesPayload manifestOverridesPayload;
    private final ManifestPayload manifestPayload;
    private final String name;
    private final String runtimeRoleArn;
    private final Map<String, String> tags;

    private CreateApplicationInstanceRequest(BuilderImpl builder) {
        super(builder);
        this.applicationInstanceIdToReplace = builder.applicationInstanceIdToReplace;
        this.defaultRuntimeContextDevice = builder.defaultRuntimeContextDevice;
        this.description = builder.description;
        this.manifestOverridesPayload = builder.manifestOverridesPayload;
        this.manifestPayload = builder.manifestPayload;
        this.name = builder.name;
        this.runtimeRoleArn = builder.runtimeRoleArn;
        this.tags = builder.tags;
    }

    public final String applicationInstanceIdToReplace() {
        return this.applicationInstanceIdToReplace;
    }

    public final String defaultRuntimeContextDevice() {
        return this.defaultRuntimeContextDevice;
    }

    public final String description() {
        return this.description;
    }

    public final ManifestOverridesPayload manifestOverridesPayload() {
        return this.manifestOverridesPayload;
    }

    public final ManifestPayload manifestPayload() {
        return this.manifestPayload;
    }

    public final String name() {
        return this.name;
    }

    public final String runtimeRoleArn() {
        return this.runtimeRoleArn;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationInstanceIdToReplace());
        hashCode = 31 * hashCode + Objects.hashCode(this.defaultRuntimeContextDevice());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.manifestOverridesPayload());
        hashCode = 31 * hashCode + Objects.hashCode(this.manifestPayload());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.runtimeRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateApplicationInstanceRequest)) {
            return false;
        }
        CreateApplicationInstanceRequest other = (CreateApplicationInstanceRequest)((Object)obj);
        return Objects.equals(this.applicationInstanceIdToReplace(), other.applicationInstanceIdToReplace()) && Objects.equals(this.defaultRuntimeContextDevice(), other.defaultRuntimeContextDevice()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.manifestOverridesPayload(), other.manifestOverridesPayload()) && Objects.equals(this.manifestPayload(), other.manifestPayload()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.runtimeRoleArn(), other.runtimeRoleArn()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"CreateApplicationInstanceRequest").add("ApplicationInstanceIdToReplace", (Object)this.applicationInstanceIdToReplace()).add("DefaultRuntimeContextDevice", (Object)this.defaultRuntimeContextDevice()).add("Description", (Object)this.description()).add("ManifestOverridesPayload", (Object)this.manifestOverridesPayload()).add("ManifestPayload", (Object)this.manifestPayload()).add("Name", (Object)this.name()).add("RuntimeRoleArn", (Object)this.runtimeRoleArn()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ApplicationInstanceIdToReplace": {
                return Optional.ofNullable(clazz.cast(this.applicationInstanceIdToReplace()));
            }
            case "DefaultRuntimeContextDevice": {
                return Optional.ofNullable(clazz.cast(this.defaultRuntimeContextDevice()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "ManifestOverridesPayload": {
                return Optional.ofNullable(clazz.cast(this.manifestOverridesPayload()));
            }
            case "ManifestPayload": {
                return Optional.ofNullable(clazz.cast(this.manifestPayload()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "RuntimeRoleArn": {
                return Optional.ofNullable(clazz.cast(this.runtimeRoleArn()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ApplicationInstanceIdToReplace", APPLICATION_INSTANCE_ID_TO_REPLACE_FIELD);
        map.put("DefaultRuntimeContextDevice", DEFAULT_RUNTIME_CONTEXT_DEVICE_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("ManifestOverridesPayload", MANIFEST_OVERRIDES_PAYLOAD_FIELD);
        map.put("ManifestPayload", MANIFEST_PAYLOAD_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("RuntimeRoleArn", RUNTIME_ROLE_ARN_FIELD);
        map.put("Tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateApplicationInstanceRequest, T> g) {
        return obj -> g.apply((CreateApplicationInstanceRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends PanoramaRequest.BuilderImpl
    implements Builder {
        private String applicationInstanceIdToReplace;
        private String defaultRuntimeContextDevice;
        private String description;
        private ManifestOverridesPayload manifestOverridesPayload;
        private ManifestPayload manifestPayload;
        private String name;
        private String runtimeRoleArn;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateApplicationInstanceRequest model) {
            super(model);
            this.applicationInstanceIdToReplace(model.applicationInstanceIdToReplace);
            this.defaultRuntimeContextDevice(model.defaultRuntimeContextDevice);
            this.description(model.description);
            this.manifestOverridesPayload(model.manifestOverridesPayload);
            this.manifestPayload(model.manifestPayload);
            this.name(model.name);
            this.runtimeRoleArn(model.runtimeRoleArn);
            this.tags(model.tags);
        }

        public final String getApplicationInstanceIdToReplace() {
            return this.applicationInstanceIdToReplace;
        }

        public final void setApplicationInstanceIdToReplace(String applicationInstanceIdToReplace) {
            this.applicationInstanceIdToReplace = applicationInstanceIdToReplace;
        }

        @Override
        public final Builder applicationInstanceIdToReplace(String applicationInstanceIdToReplace) {
            this.applicationInstanceIdToReplace = applicationInstanceIdToReplace;
            return this;
        }

        public final String getDefaultRuntimeContextDevice() {
            return this.defaultRuntimeContextDevice;
        }

        public final void setDefaultRuntimeContextDevice(String defaultRuntimeContextDevice) {
            this.defaultRuntimeContextDevice = defaultRuntimeContextDevice;
        }

        @Override
        public final Builder defaultRuntimeContextDevice(String defaultRuntimeContextDevice) {
            this.defaultRuntimeContextDevice = defaultRuntimeContextDevice;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final ManifestOverridesPayload.Builder getManifestOverridesPayload() {
            return this.manifestOverridesPayload != null ? this.manifestOverridesPayload.toBuilder() : null;
        }

        public final void setManifestOverridesPayload(ManifestOverridesPayload.BuilderImpl manifestOverridesPayload) {
            this.manifestOverridesPayload = manifestOverridesPayload != null ? manifestOverridesPayload.build() : null;
        }

        @Override
        public final Builder manifestOverridesPayload(ManifestOverridesPayload manifestOverridesPayload) {
            this.manifestOverridesPayload = manifestOverridesPayload;
            return this;
        }

        public final ManifestPayload.Builder getManifestPayload() {
            return this.manifestPayload != null ? this.manifestPayload.toBuilder() : null;
        }

        public final void setManifestPayload(ManifestPayload.BuilderImpl manifestPayload) {
            this.manifestPayload = manifestPayload != null ? manifestPayload.build() : null;
        }

        @Override
        public final Builder manifestPayload(ManifestPayload manifestPayload) {
            this.manifestPayload = manifestPayload;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getRuntimeRoleArn() {
            return this.runtimeRoleArn;
        }

        public final void setRuntimeRoleArn(String runtimeRoleArn) {
            this.runtimeRoleArn = runtimeRoleArn;
        }

        @Override
        public final Builder runtimeRoleArn(String runtimeRoleArn) {
            this.runtimeRoleArn = runtimeRoleArn;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateApplicationInstanceRequest build() {
            return new CreateApplicationInstanceRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends PanoramaRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateApplicationInstanceRequest> {
        public Builder applicationInstanceIdToReplace(String var1);

        public Builder defaultRuntimeContextDevice(String var1);

        public Builder description(String var1);

        public Builder manifestOverridesPayload(ManifestOverridesPayload var1);

        default public Builder manifestOverridesPayload(Consumer<ManifestOverridesPayload.Builder> manifestOverridesPayload) {
            return this.manifestOverridesPayload((ManifestOverridesPayload)((ManifestOverridesPayload.Builder)ManifestOverridesPayload.builder().applyMutation(manifestOverridesPayload)).build());
        }

        public Builder manifestPayload(ManifestPayload var1);

        default public Builder manifestPayload(Consumer<ManifestPayload.Builder> manifestPayload) {
            return this.manifestPayload((ManifestPayload)((ManifestPayload.Builder)ManifestPayload.builder().applyMutation(manifestPayload)).build());
        }

        public Builder name(String var1);

        public Builder runtimeRoleArn(String var1);

        public Builder tags(Map<String, String> var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

